/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.ui.tree;

import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class UiModelTreeContentProvider
implements ITreeContentProvider {
    private ElementDescriptor[] mDescriptorFilters;
    private final UiElementNode mUiRootNode;

    public UiModelTreeContentProvider(UiElementNode uiElementNode, ElementDescriptor[] elementDescriptorArray) {
        this.mUiRootNode = uiElementNode;
        this.mDescriptorFilters = elementDescriptorArray;
    }

    public Object[] getChildren(Object object) {
        if (object instanceof UiElementNode) {
            UiElementNode uiElementNode = (UiElementNode)object;
            return uiElementNode.getUiChildren().toArray();
        }
        return null;
    }

    public Object getParent(Object object) {
        if (object instanceof UiElementNode) {
            UiElementNode uiElementNode = (UiElementNode)object;
            return uiElementNode.getUiParent();
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        if (object instanceof UiElementNode) {
            UiElementNode uiElementNode = (UiElementNode)object;
            return uiElementNode.getUiChildren().size() > 0;
        }
        return false;
    }

    public Object[] getElements(Object object) {
        ArrayList<UiElementNode> arrayList = new ArrayList<UiElementNode>();
        if (this.mUiRootNode != null) {
            for (UiElementNode uiElementNode : this.mUiRootNode.getUiChildren()) {
                if (this.mDescriptorFilters == null || this.mDescriptorFilters.length == 0) {
                    arrayList.add(uiElementNode);
                    continue;
                }
                ElementDescriptor[] elementDescriptorArray = this.mDescriptorFilters;
                int n = this.mDescriptorFilters.length;
                int n2 = 0;
                while (n2 < n) {
                    ElementDescriptor elementDescriptor = elementDescriptorArray[n2];
                    if (uiElementNode.getDescriptor() == elementDescriptor) {
                        arrayList.add(uiElementNode);
                    }
                    ++n2;
                }
            }
        }
        return arrayList.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }
}

