/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.ui.tree;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.AndroidEditor;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.ICommitXml;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.document.NodeContainer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyCutAction
extends Action {
    private List<UiElementNode> mUiNodes;
    private boolean mPerformCut;
    private final AndroidEditor mEditor;
    private final Clipboard mClipboard;
    private final ICommitXml mXmlCommit;

    public CopyCutAction(AndroidEditor androidEditor, Clipboard clipboard, ICommitXml iCommitXml, UiElementNode uiElementNode, boolean bl) {
        this(androidEditor, clipboard, iCommitXml, CopyCutAction.toList(uiElementNode), bl);
    }

    public CopyCutAction(AndroidEditor androidEditor, Clipboard clipboard, ICommitXml iCommitXml, List<UiElementNode> list, boolean bl) {
        super(bl ? "Cut" : "Copy");
        this.mEditor = androidEditor;
        this.mClipboard = clipboard;
        this.mXmlCommit = iCommitXml;
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        if (bl) {
            this.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_CUT"));
            this.setHoverImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_CUT"));
            this.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        } else {
            this.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            this.setHoverImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            this.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        }
        this.mUiNodes = list;
        this.mPerformCut = bl;
    }

    public void run() {
        super.run();
        if (this.mUiNodes == null || this.mUiNodes.size() < 1) {
            return;
        }
        if (this.mXmlCommit != null) {
            this.mXmlCommit.commitPendingXmlChanges();
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<UiElementNode> arrayList = this.mPerformCut ? new ArrayList<UiElementNode>() : null;
        for (UiElementNode uiElementNode : this.mUiNodes) {
            try {
                Node node = uiElementNode.getXmlNode();
                if (node == null) {
                    return;
                }
                String string = this.getXmlTextFromEditor(node);
                if (string == null) {
                    string = this.getXmlTextFromSerialization(node);
                }
                if (string == null) continue;
                stringBuilder.append(string);
                if (!this.mPerformCut) continue;
                arrayList.add(uiElementNode);
            }
            catch (Exception exception) {
                AdtPlugin.log(exception, "CopyCutAction failed for UI node %1$s", uiElementNode.getBreadcrumbTrailDescription(true));
            }
        }
        if (stringBuilder != null && stringBuilder.length() > 0) {
            this.mClipboard.setContents(new Object[]{stringBuilder.toString()}, new Transfer[]{TextTransfer.getInstance()});
            if (this.mPerformCut) {
                for (UiElementNode uiElementNode : arrayList) {
                    uiElementNode.deleteXmlNode();
                }
            }
        }
    }

    private String getXmlTextFromEditor(Node node) {
        String string = null;
        IStructuredModel iStructuredModel = this.mEditor.getModelForRead();
        try {
            try {
                IStructuredDocument iStructuredDocument = this.mEditor.getStructuredDocument();
                if (node instanceof NodeContainer) {
                    string = ((NodeContainer)node).getSource();
                } else if (node instanceof IndexedRegion && iStructuredDocument != null) {
                    IndexedRegion indexedRegion = (IndexedRegion)node;
                    int n = indexedRegion.getStartOffset();
                    int n2 = indexedRegion.getEndOffset();
                    if (n2 > n) {
                        string = iStructuredDocument.get(n, n2 - n);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                iStructuredModel.releaseFromRead();
            }
        }
        finally {
            iStructuredModel.releaseFromRead();
        }
        return string;
    }

    private String getXmlTextFromSerialization(Node node) throws IOException {
        StringWriter stringWriter = new StringWriter();
        XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, new OutputFormat("xml", "UTF-8", true));
        xMLSerializer.serialize((Element)node);
        String string = stringWriter.toString();
        return string;
    }

    private static ArrayList<UiElementNode> toList(UiElementNode uiElementNode) {
        ArrayList<UiElementNode> arrayList = null;
        if (uiElementNode != null) {
            arrayList = new ArrayList<UiElementNode>(1);
            arrayList.add(uiElementNode);
        }
        return arrayList;
    }
}

