/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.resources;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.AndroidEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.resources.ResourcesTreePage;
import com.android.ide.eclipse.adt.internal.editors.resources.descriptors.ResourcesDescriptors;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.sdklib.xml.AndroidXPathFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ResourcesEditor
extends AndroidEditor {
    public static final String ID = "com.android.ide.eclipse.editors.resources.ResourcesEditor";
    private UiElementNode mUiResourcesNode;

    public UiElementNode getUiRootNode() {
        return this.mUiResourcesNode;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void createFormPages() {
        try {
            this.addPage((IFormPage)new ResourcesTreePage(this));
        }
        catch (PartInitException partInitException) {
            AdtPlugin.log(4, "Error creating nested page", new Object[0]);
            AdtPlugin.getDefault().getLog().log(partInitException.getStatus());
        }
    }

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        if (iEditorInput instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)iEditorInput;
            IFile iFile = fileEditorInput.getFile();
            this.setPartName(String.format("%1$s", iFile.getName()));
        }
    }

    protected void xmlModelChanged(Document document) {
        this.initUiRootNode(false);
        this.mUiResourcesNode.setXmlDocument(document);
        if (document != null) {
            ElementDescriptor elementDescriptor = ResourcesDescriptors.getInstance().getElementDescriptor();
            try {
                XPath xPath = AndroidXPathFactory.newXPath();
                Node node = (Node)xPath.evaluate("/" + elementDescriptor.getXmlName(), document, XPathConstants.NODE);
                assert (node != null && node.getNodeName().equals(elementDescriptor.getXmlName()));
                this.mUiResourcesNode.loadFromXmlNode(node);
            }
            catch (XPathExpressionException xPathExpressionException) {
                AdtPlugin.log(xPathExpressionException, "XPath error when trying to find '%s' element in XML.", elementDescriptor.getXmlName());
            }
        }
        super.xmlModelChanged(document);
    }

    protected void initUiRootNode(boolean bl) {
        if (this.mUiResourcesNode == null || bl) {
            ElementDescriptor elementDescriptor = ResourcesDescriptors.getInstance().getElementDescriptor();
            this.mUiResourcesNode = elementDescriptor.createUiNode();
            this.mUiResourcesNode.setEditor(this);
            this.onDescriptorsChanged();
        }
    }

    private void onDescriptorsChanged() {
    }
}

