/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.manifest.pages;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.XmlnsAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.manifest.ManifestEditor;
import com.android.ide.eclipse.adt.internal.editors.ui.UiElementPart;
import com.android.ide.eclipse.adt.internal.editors.uimodel.IUiUpdateListener;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiAttributeNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

final class ApplicationAttributesPart
extends UiElementPart {
    private AppNodeUpdateListener mAppNodeUpdateListener;
    private IManagedForm mManagedForm;

    public ApplicationAttributesPart(Composite composite, FormToolkit formToolkit, ManifestEditor manifestEditor, UiElementNode uiElementNode) {
        super(composite, formToolkit, manifestEditor, uiElementNode, "Application Attributes", "Defines the attributes specific to the application.", 66);
    }

    public void setUiElementNode(UiElementNode uiElementNode) {
        super.setUiElementNode(uiElementNode);
        this.createUiAttributes(this.mManagedForm);
    }

    protected void createFormControls(IManagedForm iManagedForm) {
        this.mManagedForm = iManagedForm;
        this.setTable(this.createTableLayout(iManagedForm.getToolkit(), 4));
        this.mAppNodeUpdateListener = new AppNodeUpdateListener();
        this.getUiElementNode().addUpdateListener(this.mAppNodeUpdateListener);
        this.createUiAttributes(this.mManagedForm);
    }

    public void dispose() {
        super.dispose();
        if (this.getUiElementNode() != null && this.mAppNodeUpdateListener != null) {
            this.getUiElementNode().removeUpdateListener(this.mAppNodeUpdateListener);
            this.mAppNodeUpdateListener = null;
        }
    }

    protected void createUiAttributes(IManagedForm iManagedForm) {
        UiElementNode uiElementNode;
        Composite composite = this.getTable();
        if (composite == null || iManagedForm == null) {
            return;
        }
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            uiElementNode = controlArray[n2];
            uiElementNode.dispose();
            ++n2;
        }
        uiElementNode = this.getUiElementNode();
        AttributeDescriptor[] attributeDescriptorArray = uiElementNode.getAttributeDescriptors();
        n = attributeDescriptorArray.length;
        int n3 = (int)Math.ceil((double)n / 2.0);
        int n4 = 0;
        while (n4 < n) {
            AttributeDescriptor attributeDescriptor = attributeDescriptorArray[n4 / 2 + (n4 & 1) * n3];
            if (!(attributeDescriptor instanceof XmlnsAttributeDescriptor)) {
                UiAttributeNode uiAttributeNode = uiElementNode.findUiAttribute(attributeDescriptor);
                if (uiAttributeNode != null) {
                    uiAttributeNode.createUiControl(composite, iManagedForm);
                } else {
                    AdtPlugin.log(2, "Attribute %1$s not declared in node %2$s, ignored.", attributeDescriptor.getXmlLocalName(), uiElementNode.getDescriptor().getXmlName());
                }
            }
            ++n4;
        }
        if (n == 0) {
            this.createLabel(composite, iManagedForm.getToolkit(), "No attributes to display, waiting for SDK to finish loading...", null);
        }
        if (this.mAppNodeUpdateListener != null) {
            this.mAppNodeUpdateListener.uiElementNodeUpdated(uiElementNode, null);
        }
        this.layoutChanged();
    }

    private class AppNodeUpdateListener
    implements IUiUpdateListener {
        private AppNodeUpdateListener() {
        }

        public void uiElementNodeUpdated(UiElementNode uiElementNode, IUiUpdateListener.UiUpdateState uiUpdateState) {
            boolean bl;
            Composite composite = ApplicationAttributesPart.this.getTable();
            boolean bl2 = bl = uiElementNode.getXmlNode() != null;
            if (composite != null && composite.getEnabled() != bl) {
                composite.setEnabled(bl);
                Control[] controlArray = composite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray[n2];
                    control.setEnabled(bl);
                    ++n2;
                }
            }
        }
    }
}

