/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.manifest.model;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.TextAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.ui.SectionHelper;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiTextAttributeNode;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestParser;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.wizards.actions.NewProjectAction;
import com.android.ide.eclipse.adt.internal.wizards.newproject.NewProjectWizard;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.part.FileEditorInput;

public class UiManifestPkgAttrNode
extends UiTextAttributeNode {
    public UiManifestPkgAttrNode(AttributeDescriptor attributeDescriptor, UiElementNode uiElementNode) {
        super(attributeDescriptor, uiElementNode);
    }

    public void createUiControl(Composite composite, IManagedForm iManagedForm) {
        this.setManagedForm(iManagedForm);
        FormToolkit formToolkit = iManagedForm.getToolkit();
        TextAttributeDescriptor textAttributeDescriptor = (TextAttributeDescriptor)this.getDescriptor();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<form><p><a href='unused'>");
        stringBuilder.append(textAttributeDescriptor.getUiName());
        stringBuilder.append("</a></p></form>");
        FormText formText = SectionHelper.createFormText(composite, formToolkit, true, stringBuilder.toString(), true);
        formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                super.linkActivated(hyperlinkEvent);
                UiManifestPkgAttrNode.this.doLabelClick();
            }
        });
        formText.setLayoutData((Object)new TableWrapData(2, 32));
        SectionHelper.addControlTooltip((Control)formText, textAttributeDescriptor.getTooltip());
        Composite composite2 = formToolkit.createComposite(composite);
        composite2.setLayoutData((Object)new TableWrapData(256, 32));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        formToolkit.paintBordersFor(composite2);
        Text text = formToolkit.createText(composite2, this.getCurrentValue());
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 1;
        text.setLayoutData((Object)gridData);
        this.setTextWidget(text);
        Button button = formToolkit.createButton(composite2, "Browse...", 8);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                UiManifestPkgAttrNode.this.doBrowseClick();
            }
        });
    }

    protected void onAddValidators(final Text text) {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = text.getText();
                if (string.indexOf(46) < 1) {
                    UiManifestPkgAttrNode.this.getManagedForm().getMessageManager().addMessage((Object)text, "Package name should contain at least two identifiers.", null, 3, (Control)text);
                } else {
                    UiManifestPkgAttrNode.this.getManagedForm().getMessageManager().removeMessage((Object)text, (Control)text);
                }
            }
        };
        text.addModifyListener(modifyListener);
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                UiManifestPkgAttrNode.this.getManagedForm().getMessageManager().removeMessage((Object)text, (Control)text);
            }
        });
        modifyListener.modifyText(null);
    }

    private void doBrowseClick() {
        String string;
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getTextWidget().getShell(), new ILabelProvider(){

            public Image getImage(Object object) {
                return null;
            }

            public String getText(Object object) {
                return object.toString();
            }

            public void addListener(ILabelProviderListener iLabelProviderListener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object object, String string) {
                return false;
            }

            public void removeListener(ILabelProviderListener iLabelProviderListener) {
            }
        });
        elementListSelectionDialog.setTitle("Android Manifest Package Selection");
        elementListSelectionDialog.setMessage("Select the Android Manifest package to target.");
        elementListSelectionDialog.setElements((Object[])this.getPossibleValues(null));
        if (elementListSelectionDialog.open() == 0 && (string = (String)elementListSelectionDialog.getFirstResult()) != null && string.length() > 0) {
            this.getTextWidget().setText(string);
        }
    }

    private void doLabelClick() {
        String string = this.getTextWidget().getText().trim();
        if (string.length() == 0) {
            this.createNewProject();
        } else {
            this.displayExistingManifest(string);
        }
    }

    private void displayExistingManifest(String string) {
        IJavaProject[] iJavaProjectArray = BaseProjectHelper.getAndroidProjects();
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject iJavaProject = iJavaProjectArray[n2];
            IFile iFile = AndroidManifestParser.getManifest(iJavaProject.getProject());
            if (iFile != null) {
                AndroidManifestParser androidManifestParser = null;
                try {
                    androidManifestParser = AndroidManifestParser.parseForData(iFile);
                }
                catch (CoreException coreException) {}
                if (androidManifestParser != null && string.equals(androidManifestParser.getPackage())) {
                    IWorkbenchPage iWorkbenchPage;
                    IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
                        try {
                            iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), "com.android.ide.eclipse.editors.manifest.ManifestEditor", true, 1);
                        }
                        catch (PartInitException partInitException) {
                            AdtPlugin.log(partInitException, "Opening editor failed for %s", iFile.getFullPath());
                        }
                    }
                    return;
                }
            }
            ++n2;
        }
    }

    private void createNewProject() {
        NewProjectWizard newProjectWizard;
        String string;
        NewProjectAction newProjectAction = new NewProjectAction();
        newProjectAction.run(null);
        if (newProjectAction.getDialogResult() == 0 && (string = (newProjectWizard = (NewProjectWizard)newProjectAction.getWizard()).getPackageName()) != null && string.length() > 0) {
            this.getTextWidget().setText(string);
        }
    }

    public String[] getPossibleValues(String string) {
        TreeSet<String> treeSet = new TreeSet<String>();
        IJavaProject[] iJavaProjectArray = BaseProjectHelper.getAndroidProjects();
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject iJavaProject = iJavaProjectArray[n2];
            IFile iFile = AndroidManifestParser.getManifest(iJavaProject.getProject());
            if (iFile != null) {
                AndroidManifestParser androidManifestParser = null;
                try {
                    androidManifestParser = AndroidManifestParser.parseForData(iFile);
                }
                catch (CoreException coreException) {}
                if (androidManifestParser != null) {
                    treeSet.add(androidManifestParser.getPackage());
                }
            }
            ++n2;
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }
}

