/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.parts;

import com.android.ide.eclipse.adt.internal.editors.AndroidEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutEditor;
import com.android.ide.eclipse.adt.internal.editors.layout.parts.DropFeedback;
import com.android.ide.eclipse.adt.internal.editors.layout.parts.UiElementEditPart;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;

public class ElementCreateCommand
extends Command {
    private final ElementDescriptor mDescriptor;
    private final UiElementEditPart mParentPart;
    private final Point mTargetPoint;

    public ElementCreateCommand(ElementDescriptor elementDescriptor, UiElementEditPart uiElementEditPart, Point point) {
        this.mDescriptor = elementDescriptor;
        this.mParentPart = uiElementEditPart;
        this.mTargetPoint = point;
    }

    public boolean canExecute() {
        return this.mDescriptor != null && this.mParentPart != null && this.mParentPart.getUiNode() != null && this.mParentPart.getUiNode().getEditor() instanceof LayoutEditor;
    }

    public void execute() {
        AndroidEditor androidEditor;
        super.execute();
        UiElementNode uiElementNode = this.mParentPart.getUiNode();
        if (uiElementNode != null && (androidEditor = uiElementNode.getEditor()) instanceof LayoutEditor) {
            ((LayoutEditor)androidEditor).wrapUndoRecording(String.format("Create %1$s", this.mDescriptor.getXmlLocalName()), new Runnable(){

                public void run() {
                    LayoutEditor.UiEditorActions uiEditorActions = ((LayoutEditor)androidEditor).getUiEditorActions();
                    if (uiEditorActions != null) {
                        DropFeedback.addElementToXml(ElementCreateCommand.this.mParentPart, ElementCreateCommand.this.mDescriptor, ElementCreateCommand.this.mTargetPoint, uiEditorActions);
                    }
                }
            });
        }
    }

    public void redo() {
        throw new UnsupportedOperationException("redo not supported by this command");
    }

    public void undo() {
        throw new UnsupportedOperationException("undo not supported by this command");
    }
}

