/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout.parts;

import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.layout.LayoutEditor;
import com.android.ide.eclipse.adt.internal.editors.layout.parts.UiElementEditPart;
import com.android.ide.eclipse.adt.internal.editors.layout.parts.UiLayoutEditPart;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

class DropFeedback {
    private static final int TOP = 0;
    private static final int LEFT = 1;
    private static final int BOTTOM = 2;
    private static final int RIGHT = 3;
    private static final int MAX_DIR = 3;
    private static final int[] sOppositeDirection;
    private static final UiElementEditPart[] sTempClosests;
    private static final int[] sTempMinDists;
    private static final RelativeInfo sRelativeInfo;
    private static final UiElementEditPart[] sTempTwoParts;

    static {
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[1] = 3;
        nArray[3] = 1;
        sOppositeDirection = nArray;
        sTempClosests = new UiElementEditPart[4];
        sTempMinDists = new int[4];
        sRelativeInfo = new RelativeInfo();
        sTempTwoParts = new UiElementEditPart[2];
    }

    private DropFeedback() {
    }

    static void addElementToXml(UiElementEditPart uiElementEditPart, ElementDescriptor elementDescriptor, Point point, LayoutEditor.UiEditorActions uiEditorActions) {
        String string = DropFeedback.getXmlLocalName(uiElementEditPart);
        RelativeInfo relativeInfo = null;
        UiElementEditPart uiElementEditPart2 = null;
        if ("LinearLayout".equals(string)) {
            uiElementEditPart2 = DropFeedback.findLinearTarget(uiElementEditPart, point)[1];
        } else if ("RelativeLayout".equals(string) && (relativeInfo = DropFeedback.findRelativeTarget(uiElementEditPart, point, sRelativeInfo)) != null) {
            uiElementEditPart2 = relativeInfo.targetParts[relativeInfo.anchorIndex];
            uiElementEditPart2 = DropFeedback.getNextUiSibling(uiElementEditPart2);
        }
        if (uiEditorActions != null) {
            UiElementNode uiElementNode = uiElementEditPart2 != null ? uiElementEditPart2.getUiNode() : null;
            UiElementNode uiElementNode2 = uiElementEditPart.getUiNode();
            UiElementNode uiElementNode3 = uiEditorActions.addElement(uiElementNode2, uiElementNode, elementDescriptor, false);
            if ("AbsoluteLayout".equals(string)) {
                DropFeedback.adjustAbsoluteAttributes(uiElementNode3, point);
            } else if ("RelativeLayout".equals(string)) {
                DropFeedback.adustRelativeAttributes(uiElementNode3, relativeInfo);
            }
        }
    }

    static UiLayoutEditPart.HighlightInfo computeDropFeedback(UiLayoutEditPart uiLayoutEditPart, UiLayoutEditPart.HighlightInfo highlightInfo, Point point) {
        RelativeInfo relativeInfo;
        String string = DropFeedback.getXmlLocalName(uiLayoutEditPart);
        if ("AbsoluteLayout".equals(string)) {
            highlightInfo.anchorPoint = point;
        } else if ("LinearLayout".equals(string)) {
            boolean bl = DropFeedback.isVertical(uiLayoutEditPart);
            highlightInfo.childParts = DropFeedback.findLinearTarget(uiLayoutEditPart, point);
            DropFeedback.computeLinearLine(uiLayoutEditPart, bl, highlightInfo);
        } else if ("RelativeLayout".equals(string) && (relativeInfo = DropFeedback.findRelativeTarget(uiLayoutEditPart, point, sRelativeInfo)) != null) {
            highlightInfo.childParts = DropFeedback.sRelativeInfo.targetParts;
            DropFeedback.computeRelativeLine(uiLayoutEditPart, relativeInfo, highlightInfo);
        }
        return highlightInfo;
    }

    private static UiElementEditPart getNextUiSibling(UiElementEditPart uiElementEditPart) {
        if (uiElementEditPart != null) {
            UiElementNode uiElementNode = uiElementEditPart.getUiNode();
            if (uiElementNode != null) {
                uiElementNode = uiElementNode.getUiNextSibling();
            }
            if (uiElementNode != null) {
                for (Object e : uiElementEditPart.getParent().getChildren()) {
                    if (!(e instanceof UiElementEditPart) || ((UiElementEditPart)e).getUiNode() != uiElementNode) continue;
                    return (UiElementEditPart)e;
                }
            }
        }
        return null;
    }

    private static String getXmlLocalName(UiElementEditPart uiElementEditPart) {
        ElementDescriptor elementDescriptor;
        UiElementNode uiElementNode = uiElementEditPart.getUiNode();
        if (uiElementNode != null && (elementDescriptor = uiElementNode.getDescriptor()) != null) {
            return elementDescriptor.getXmlLocalName();
        }
        return null;
    }

    private static void adjustAbsoluteAttributes(final UiElementNode uiElementNode, final Point point) {
        if (point == null) {
            return;
        }
        uiElementNode.getEditor().editXmlModel(new Runnable(){

            public void run() {
                uiElementNode.setAttributeValue("layout_x", String.format("%ddip", point.x), false);
                uiElementNode.setAttributeValue("layout_y", String.format("%ddip", point.y), false);
                uiElementNode.commitDirtyAttributesToXml();
            }
        });
    }

    private static void adustRelativeAttributes(final UiElementNode uiElementNode, RelativeInfo relativeInfo) {
        if (uiElementNode == null || relativeInfo == null) {
            return;
        }
        final UiElementEditPart uiElementEditPart = relativeInfo.targetParts[relativeInfo.anchorIndex];
        final int n = relativeInfo.direction;
        uiElementNode.getEditor().editXmlModel(new Runnable(){

            public void run() {
                String string;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                UiElementNode uiElementNode2 = uiElementEditPart != null ? uiElementEditPart.getUiNode() : null;
                String string2 = string = uiElementNode2 != null ? uiElementNode2.getAttributeValue("id") : null;
                if (string == null) {
                    string = DescriptorsUtils.getFreeWidgetId(uiElementNode2);
                    uiElementNode2.setAttributeValue("id", string, true);
                }
                if (string != null) {
                    switch (n) {
                        case 0: {
                            hashMap.put("layout_above", string);
                            break;
                        }
                        case 2: {
                            hashMap.put("layout_below", string);
                            break;
                        }
                        case 1: {
                            hashMap.put("layout_toLeftOf", string);
                            break;
                        }
                        case 3: {
                            hashMap.put("layout_toRightOf", string);
                        }
                    }
                    switch (n) {
                        case 0: 
                        case 2: {
                            hashMap.put("layout_centerHorizontal", uiElementNode2.getAttributeValue("layout_centerHorizontal"));
                            hashMap.put("layout_toLeftOf", uiElementNode2.getAttributeValue("layout_toLeftOf"));
                            hashMap.put("layout_toRightOf", uiElementNode2.getAttributeValue("layout_toRightOf"));
                            break;
                        }
                        case 1: 
                        case 3: {
                            hashMap.put("layout_centerVertical", uiElementNode2.getAttributeValue("layout_centerVertical"));
                            hashMap.put("layout_alignBaseline", uiElementNode2.getAttributeValue("layout_alignBaseline"));
                            hashMap.put("layout_above", uiElementNode2.getAttributeValue("layout_above"));
                            hashMap.put("layout_below", uiElementNode2.getAttributeValue("layout_below"));
                        }
                    }
                } else {
                    switch (n) {
                        case 0: {
                            hashMap.put("layout_alignParentTop", "true");
                            break;
                        }
                        case 2: {
                            hashMap.put("layout_alignParentBottom", "true");
                            break;
                        }
                        case 1: {
                            hashMap.put("layout_alignParentLeft", "true");
                            break;
                        }
                        case 3: {
                            hashMap.put("layout_alignParentRight", "true");
                        }
                    }
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    uiElementNode.setAttributeValue((String)entry.getKey(), (String)entry.getValue(), true);
                }
                uiElementNode.commitDirtyAttributesToXml();
            }
        });
    }

    private static UiElementEditPart[] findLinearTarget(UiElementEditPart uiElementEditPart, Point point) {
        boolean bl = DropFeedback.isVertical(uiElementEditPart);
        int n = bl ? point.y : point.x;
        UiElementEditPart uiElementEditPart2 = null;
        UiElementEditPart uiElementEditPart3 = null;
        for (Object e : uiElementEditPart.getChildren()) {
            int n2;
            if (!(e instanceof UiElementEditPart)) continue;
            UiElementEditPart uiElementEditPart4 = (UiElementEditPart)e;
            Point point2 = uiElementEditPart4.getBounds().getCenter();
            int n3 = n2 = bl ? point2.y : point2.x;
            if (n < n2) {
                uiElementEditPart3 = uiElementEditPart4;
                break;
            }
            uiElementEditPart2 = uiElementEditPart4;
        }
        DropFeedback.sTempTwoParts[0] = uiElementEditPart2;
        DropFeedback.sTempTwoParts[1] = uiElementEditPart3;
        return sTempTwoParts;
    }

    private static void computeLinearLine(UiLayoutEditPart uiLayoutEditPart, boolean bl, UiLayoutEditPart.HighlightInfo highlightInfo) {
        Rectangle rectangle = uiLayoutEditPart.getBounds();
        if (bl) {
            Point point = null;
            UiElementEditPart uiElementEditPart = highlightInfo.childParts[0];
            if (uiElementEditPart != null) {
                point = uiElementEditPart.getBounds().getBottom();
            } else {
                uiElementEditPart = highlightInfo.childParts[1];
                if (uiElementEditPart != null) {
                    point = uiElementEditPart.getBounds().getTop();
                }
            }
            if (point != null) {
                highlightInfo.tempPoints[0].setLocation(0, point.y);
                highlightInfo.tempPoints[1].setLocation(rectangle.width, point.y);
                highlightInfo.linePoints = highlightInfo.tempPoints;
                highlightInfo.anchorPoint = point.setLocation(rectangle.width / 2, point.y);
            }
        } else {
            Point point = null;
            UiElementEditPart uiElementEditPart = highlightInfo.childParts[0];
            if (uiElementEditPart != null) {
                point = uiElementEditPart.getBounds().getRight();
            } else {
                uiElementEditPart = highlightInfo.childParts[1];
                if (uiElementEditPart != null) {
                    point = uiElementEditPart.getBounds().getLeft();
                }
            }
            if (point != null) {
                highlightInfo.tempPoints[0].setLocation(point.x, 0);
                highlightInfo.tempPoints[1].setLocation(point.x, rectangle.height);
                highlightInfo.linePoints = highlightInfo.tempPoints;
                highlightInfo.anchorPoint = point.setLocation(point.x, rectangle.height / 2);
            }
        }
    }

    private static boolean isVertical(UiElementEditPart uiElementEditPart) {
        String string = uiElementEditPart.getStringAttr("orientation");
        boolean bl = "vertical".equals(string) || "1".equals(string);
        return bl;
    }

    private static RelativeInfo findRelativeTarget(UiElementEditPart uiElementEditPart, Point point, RelativeInfo relativeInfo) {
        int n = 0;
        while (n < 4) {
            DropFeedback.sTempMinDists[n] = Integer.MAX_VALUE;
            DropFeedback.sTempClosests[n] = null;
            ++n;
        }
        for (Object e : uiElementEditPart.getChildren()) {
            if (!(e instanceof UiElementEditPart)) continue;
            UiElementEditPart uiElementEditPart2 = (UiElementEditPart)e;
            Rectangle rectangle = uiElementEditPart2.getBounds();
            if (rectangle.contains(point)) {
                float f = (float)(point.x - rectangle.x) / (float)rectangle.width - 0.5f;
                float f2 = (float)(point.y - rectangle.y) / (float)rectangle.height - 0.5f;
                int n2 = 0;
                if (Math.abs(f) >= Math.abs(f2)) {
                    if (f < 0.0f) {
                        relativeInfo.direction = 1;
                        n2 = 1;
                    } else {
                        relativeInfo.direction = 3;
                    }
                } else if (f2 < 0.0f) {
                    relativeInfo.direction = 0;
                    n2 = 1;
                } else {
                    relativeInfo.direction = 2;
                }
                relativeInfo.anchorIndex = n2;
                relativeInfo.targetParts[n2] = uiElementEditPart2;
                relativeInfo.targetParts[1 - n2] = DropFeedback.findClosestPart(uiElementEditPart2, relativeInfo.direction);
                return relativeInfo;
            }
            DropFeedback.computeClosest(point, uiElementEditPart2, sTempClosests, sTempMinDists, 0);
            DropFeedback.computeClosest(point, uiElementEditPart2, sTempClosests, sTempMinDists, 1);
            DropFeedback.computeClosest(point, uiElementEditPart2, sTempClosests, sTempMinDists, 2);
            DropFeedback.computeClosest(point, uiElementEditPart2, sTempClosests, sTempMinDists, 3);
        }
        UiElementEditPart uiElementEditPart3 = null;
        int n3 = Integer.MAX_VALUE;
        int n4 = -1;
        int n5 = 0;
        while (n5 <= 3) {
            if (sTempClosests[n5] != null && sTempMinDists[n5] < n3) {
                uiElementEditPart3 = sTempClosests[n5];
                n3 = sTempMinDists[n5];
                n4 = n5;
            }
            ++n5;
        }
        if (uiElementEditPart3 != null) {
            n5 = 0;
            switch (n4) {
                case 0: 
                case 1: {
                    n5 = 0;
                    break;
                }
                case 2: 
                case 3: {
                    n5 = 1;
                }
            }
            relativeInfo.anchorIndex = n5;
            relativeInfo.targetParts[n5] = uiElementEditPart3;
            relativeInfo.targetParts[1 - n5] = DropFeedback.findClosestPart(uiElementEditPart3, sOppositeDirection[n4]);
            relativeInfo.direction = sOppositeDirection[n4];
            return relativeInfo;
        }
        return null;
    }

    private static void computeRelativeLine(UiLayoutEditPart uiLayoutEditPart, RelativeInfo relativeInfo, UiLayoutEditPart.HighlightInfo highlightInfo) {
        UiElementEditPart[] uiElementEditPartArray = relativeInfo.targetParts;
        int n = relativeInfo.direction;
        int n2 = relativeInfo.anchorIndex;
        UiElementEditPart uiElementEditPart = uiElementEditPartArray[n2];
        if (uiElementEditPart == null) {
            n = sOppositeDirection[n];
            uiElementEditPart = uiElementEditPartArray[1 - n2];
        }
        if (uiElementEditPart == null) {
            return;
        }
        Rectangle rectangle = uiElementEditPart.getBounds();
        Point point = null;
        switch (n) {
            case 0: {
                point = rectangle.getTop();
                break;
            }
            case 2: {
                point = rectangle.getBottom();
                break;
            }
            case 1: {
                point = rectangle.getLeft();
                break;
            }
            case 3: {
                point = rectangle.getRight();
            }
        }
        highlightInfo.anchorPoint = point;
        rectangle = uiLayoutEditPart.getBounds();
        switch (n) {
            case 0: 
            case 2: {
                highlightInfo.tempPoints[0].setLocation(0, point.y);
                highlightInfo.tempPoints[1].setLocation(rectangle.width, point.y);
                highlightInfo.linePoints = highlightInfo.tempPoints;
                highlightInfo.anchorPoint = point;
                break;
            }
            case 1: 
            case 3: {
                highlightInfo.tempPoints[0].setLocation(point.x, 0);
                highlightInfo.tempPoints[1].setLocation(point.x, rectangle.height);
                highlightInfo.linePoints = highlightInfo.tempPoints;
                highlightInfo.anchorPoint = point;
            }
        }
    }

    private static void computeClosest(Point point, UiElementEditPart uiElementEditPart, UiElementEditPart[] uiElementEditPartArray, int[] nArray, int n) {
        int n2;
        Rectangle rectangle = uiElementEditPart.getBounds();
        Point point2 = null;
        boolean bl = false;
        switch (n) {
            case 0: {
                point2 = rectangle.getBottom();
                bl = point2.y <= point.y;
                break;
            }
            case 2: {
                point2 = rectangle.getTop();
                bl = point2.y >= point.y;
                break;
            }
            case 1: {
                point2 = rectangle.getRight();
                bl = point2.x <= point.x;
                break;
            }
            case 3: {
                point2 = rectangle.getLeft();
                boolean bl2 = bl = point2.x >= point.x;
            }
        }
        if (bl && (n2 = point2.getDistance2(point)) < nArray[n]) {
            nArray[n] = n2;
            uiElementEditPartArray[n] = uiElementEditPart;
        }
    }

    private static UiElementEditPart findClosestPart(UiElementEditPart uiElementEditPart, int n) {
        if (uiElementEditPart == null || uiElementEditPart.getParent() == null) {
            return null;
        }
        Rectangle rectangle = uiElementEditPart.getBounds();
        Point point = null;
        switch (n) {
            case 0: {
                point = rectangle.getTop();
                break;
            }
            case 2: {
                point = rectangle.getBottom();
                break;
            }
            case 1: {
                point = rectangle.getLeft();
                break;
            }
            case 3: {
                point = rectangle.getRight();
            }
        }
        int n2 = Integer.MAX_VALUE;
        UiElementEditPart uiElementEditPart2 = null;
        for (Object e : uiElementEditPart.getParent().getChildren()) {
            int n3;
            if (e == uiElementEditPart || !(e instanceof UiElementEditPart)) continue;
            rectangle = ((UiElementEditPart)e).getBounds();
            Point point2 = null;
            boolean bl = false;
            switch (n) {
                case 0: {
                    point2 = rectangle.getBottom();
                    bl = point2.y <= point.y;
                    break;
                }
                case 2: {
                    point2 = rectangle.getTop();
                    bl = point2.y >= point.y;
                    break;
                }
                case 1: {
                    point2 = rectangle.getRight();
                    bl = point2.x <= point.x;
                    break;
                }
                case 3: {
                    point2 = rectangle.getLeft();
                    boolean bl2 = bl = point2.x >= point.x;
                }
            }
            if (!bl || (n3 = point2.getDistance2(point)) >= n2) continue;
            n2 = n3;
            uiElementEditPart2 = (UiElementEditPart)e;
        }
        return uiElementEditPart2;
    }

    private static class RelativeInfo {
        final UiElementEditPart[] targetParts = new UiElementEditPart[2];
        int direction;
        int anchorIndex;

        private RelativeInfo() {
        }
    }
}

