/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout;

import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFolder;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFolderType;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceManager;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;

public final class LayoutReloadMonitor
implements ResourceMonitor.IFileListener,
ResourceMonitor.IResourceEventListener {
    private static final LayoutReloadMonitor sThis = new LayoutReloadMonitor();
    private final Map<IProject, List<ILayoutReloadListener>> mListenerMap = new HashMap<IProject, List<ILayoutReloadListener>>();
    private static final int CHANGE_CODE = 0;
    private static final int CHANGE_RESOURCES = 1;
    private static final int CHANGE_R = 2;
    private static final int CHANGE_COUNT = 3;
    private final Map<IProject, boolean[]> mChangedProjects = new HashMap<IProject, boolean[]>();

    public static LayoutReloadMonitor getMonitor() {
        return sThis;
    }

    private LayoutReloadMonitor() {
        ResourceMonitor resourceMonitor = ResourceMonitor.getMonitor();
        resourceMonitor.addFileListener(this, 5);
        resourceMonitor.addResourceEventListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IProject iProject, ILayoutReloadListener iLayoutReloadListener) {
        Map<IProject, List<ILayoutReloadListener>> map = this.mListenerMap;
        synchronized (map) {
            List<ILayoutReloadListener> list = this.mListenerMap.get(iProject);
            if (list == null) {
                list = new ArrayList<ILayoutReloadListener>();
                this.mListenerMap.put(iProject, list);
            }
            list.add(iLayoutReloadListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IProject iProject, ILayoutReloadListener iLayoutReloadListener) {
        Map<IProject, List<ILayoutReloadListener>> map = this.mListenerMap;
        synchronized (map) {
            List<ILayoutReloadListener> list = this.mListenerMap.get(iProject);
            if (list != null) {
                list.remove(iLayoutReloadListener);
            }
        }
    }

    public void fileChanged(IFile iFile, IMarkerDelta[] iMarkerDeltaArray, int n) {
        IProject iProject = iFile.getProject();
        boolean[] blArray = this.mChangedProjects.get(iProject);
        if (blArray != null && blArray[0] && blArray[1] && blArray[2]) {
            return;
        }
        ResourceFolder resourceFolder = ResourceManager.getInstance().getResourceFolder(iFile);
        if (resourceFolder != null) {
            if (resourceFolder.getType() != ResourceFolderType.LAYOUT) {
                if (blArray == null) {
                    blArray = new boolean[3];
                    this.mChangedProjects.put(iProject, blArray);
                }
                blArray[1] = true;
            }
        } else if ("class".equals(iFile.getFileExtension())) {
            if (iFile.getName().matches("R[\\$\\.](.*)")) {
                if (blArray == null) {
                    blArray = new boolean[3];
                    this.mChangedProjects.put(iProject, blArray);
                }
                blArray[2] = true;
            } else {
                if (blArray == null) {
                    blArray = new boolean[3];
                    this.mChangedProjects.put(iProject, blArray);
                }
                blArray[0] = true;
            }
        }
    }

    public void resourceChangeEventStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChangeEventEnd() {
        Map<IProject, List<ILayoutReloadListener>> map = this.mListenerMap;
        synchronized (map) {
            for (Map.Entry<IProject, boolean[]> entry : this.mChangedProjects.entrySet()) {
                List<ILayoutReloadListener> list = this.mListenerMap.get(entry.getKey());
                boolean[] blArray = entry.getValue();
                if (list == null) continue;
                for (ILayoutReloadListener iLayoutReloadListener : list) {
                    iLayoutReloadListener.reloadLayout(blArray[0], blArray[2], blArray[1]);
                }
            }
        }
        this.mChangedProjects.clear();
    }

    public static interface ILayoutReloadListener {
        public void reloadLayout(boolean var1, boolean var2, boolean var3);
    }
}

