/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.sdklib.IAndroidTarget;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

public abstract class AndroidEditor
extends FormEditor
implements IResourceChangeListener {
    private static final String PREF_CURRENT_PAGE = "_current_page";
    private static String BROWSER_ID = "android";
    public static final String TEXT_EDITOR_ID = "editor_part";
    public static final int TEXT_WIDTH_HINT = 50;
    private int mTextPageIndex;
    private StructuredTextEditor mTextEditor;
    private XmlModelStateListener mXmlModelStateListener;
    private Sdk.ITargetChangeListener mTargetListener;

    public AndroidEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.mTargetListener = new Sdk.ITargetChangeListener(){

            public void onProjectTargetChange(IProject iProject) {
                if (iProject == AndroidEditor.this.getProject()) {
                    this.onTargetsLoaded();
                }
            }

            public void onTargetsLoaded() {
                AndroidEditor.this.commitPages(false);
                AndroidEditor.this.initUiRootNode(true);
            }
        };
        AdtPlugin.getDefault().addTargetListener(this.mTargetListener);
    }

    public abstract UiElementNode getUiRootNode();

    protected abstract void createFormPages();

    protected abstract void initUiRootNode(boolean var1);

    protected void xmlModelChanged(Document document) {
    }

    protected void addPages() {
        this.createAndroidPages();
        this.selectDefaultPage(null);
    }

    protected void createAndroidPages() {
        this.createFormPages();
        this.createTextEditor();
        this.createUndoRedoActions();
    }

    private void createUndoRedoActions() {
        IActionBars iActionBars = this.getEditorSite().getActionBars();
        if (iActionBars != null) {
            IAction iAction = this.mTextEditor.getAction(ActionFactory.UNDO.getId());
            iActionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), iAction);
            iAction = this.mTextEditor.getAction(ActionFactory.REDO.getId());
            iActionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), iAction);
            iActionBars.updateActionBars();
        }
    }

    protected void selectDefaultPage(String string) {
        if (string == null && this.getEditorInput() instanceof IFileEditorInput) {
            IFile iFile = ((IFileEditorInput)this.getEditorInput()).getFile();
            QualifiedName qualifiedName = new QualifiedName("com.android.ide.eclipse.adt", String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + PREF_CURRENT_PAGE);
            try {
                String string2 = iFile.getPersistentProperty(qualifiedName);
                if (string2 != null) {
                    string = string2;
                }
            }
            catch (CoreException coreException) {}
        }
        if (string != null) {
            try {
                this.setActivePage(Integer.parseInt(string));
            }
            catch (Exception exception) {
                AdtPlugin.log(exception, "Selecting page '%s' in AndroidEditor failed", string);
            }
        }
    }

    protected void removePages() {
        int n = this.getPageCount();
        int n2 = n - 1;
        while (n2 >= 0) {
            this.removePage(n2);
            --n2;
        }
    }

    public IFormPage setActivePage(String string) {
        if (string.equals(TEXT_EDITOR_ID)) {
            super.setActivePage(this.mTextPageIndex);
            return null;
        }
        return super.setActivePage(string);
    }

    protected void pageChange(int n) {
        super.pageChange(n);
        if (this.getEditorInput() instanceof IFileEditorInput) {
            IFile iFile = ((IFileEditorInput)this.getEditorInput()).getFile();
            QualifiedName qualifiedName = new QualifiedName("com.android.ide.eclipse.adt", String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + PREF_CURRENT_PAGE);
            try {
                iFile.setPersistentProperty(qualifiedName, Integer.toString(n));
            }
            catch (CoreException coreException) {}
        }
    }

    public void resourceChanged(final IResourceChangeEvent iResourceChangeEvent) {
        if (iResourceChangeEvent.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] iWorkbenchPageArray = AndroidEditor.this.getSite().getWorkbenchWindow().getPages();
                    int n = 0;
                    while (n < iWorkbenchPageArray.length) {
                        if (((FileEditorInput)AndroidEditor.this.mTextEditor.getEditorInput()).getFile().getProject().equals((Object)iResourceChangeEvent.getResource())) {
                            IEditorPart iEditorPart = iWorkbenchPageArray[n].findEditor(AndroidEditor.this.mTextEditor.getEditorInput());
                            iWorkbenchPageArray[n].closeEditor(iEditorPart, true);
                        }
                        ++n;
                    }
                }
            });
        }
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        if (!(iEditorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(iEditorSite, iEditorInput);
    }

    public void dispose() {
        IStructuredModel iStructuredModel = this.getModelForRead();
        if (iStructuredModel != null) {
            try {
                if (this.mXmlModelStateListener != null) {
                    iStructuredModel.removeModelStateListener((IModelStateListener)this.mXmlModelStateListener);
                }
            }
            finally {
                iStructuredModel.releaseFromRead();
            }
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (this.mTargetListener != null) {
            AdtPlugin.getDefault().removeTargetListener(this.mTargetListener);
            this.mTargetListener = null;
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        this.commitPages(true);
        this.getEditor(this.mTextPageIndex).doSave(iProgressMonitor);
    }

    public void doSaveAs() {
        this.commitPages(true);
        IEditorPart iEditorPart = this.getEditor(this.mTextPageIndex);
        iEditorPart.doSaveAs();
        this.setPageText(this.mTextPageIndex, iEditorPart.getTitle());
        this.setInput(iEditorPart.getEditorInput());
    }

    public void commitPages(boolean bl) {
        if (this.pages != null) {
            int n = 0;
            while (n < this.pages.size()) {
                IFormPage iFormPage;
                IManagedForm iManagedForm;
                Object e = this.pages.get(n);
                if (e != null && e instanceof IFormPage && (iManagedForm = (iFormPage = (IFormPage)e).getManagedForm()) != null && iManagedForm.isDirty()) {
                    iManagedForm.commit(bl);
                }
                ++n;
            }
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public final IHyperlinkListener createHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                super.linkActivated(hyperlinkEvent);
                String string = hyperlinkEvent.data.toString();
                if (string.startsWith("http") || string.startsWith("file:/")) {
                    AndroidEditor.this.openLinkInBrowser(string);
                } else if (string.startsWith("page:")) {
                    AndroidEditor.this.setActivePage(string.substring(5));
                }
            }
        };
    }

    private void openLinkInBrowser(String string) {
        try {
            IWorkbenchBrowserSupport iWorkbenchBrowserSupport = WorkbenchBrowserSupport.getInstance();
            iWorkbenchBrowserSupport.createBrowser(BROWSER_ID).openURL(new URL(string));
        }
        catch (PartInitException partInitException) {
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private void createTextEditor() {
        block8: {
            try {
                int n;
                this.mTextEditor = new StructuredTextEditor();
                this.mTextPageIndex = n = this.addPage((IEditorPart)this.mTextEditor, this.getEditorInput());
                this.setPageText(n, this.mTextEditor.getTitle());
                if (!(this.mTextEditor.getTextViewer().getDocument() instanceof IStructuredDocument)) {
                    Status status = new Status(4, "com.android.ide.eclipse.adt", "Error opening the Android XML editor. Is the document an XML file?");
                    throw new RuntimeException("Android XML Editor Error", new CoreException((IStatus)status));
                }
                IStructuredModel iStructuredModel = this.getModelForRead();
                if (iStructuredModel == null) break block8;
                try {
                    try {
                        this.mXmlModelStateListener = new XmlModelStateListener();
                        iStructuredModel.addModelStateListener((IModelStateListener)this.mXmlModelStateListener);
                        this.mXmlModelStateListener.modelChanged(iStructuredModel);
                    }
                    catch (Exception exception) {
                        AdtPlugin.log(exception, "Error while loading editor", new Object[0]);
                        iStructuredModel.releaseFromRead();
                    }
                }
                finally {
                    iStructuredModel.releaseFromRead();
                }
            }
            catch (PartInitException partInitException) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Android XML Editor Error", null, (IStatus)partInitException.getStatus());
            }
        }
    }

    public final ISourceViewer getStructuredSourceViewer() {
        if (this.mTextEditor != null) {
            return this.mTextEditor.getTextViewer();
        }
        return null;
    }

    public final IStructuredDocument getStructuredDocument() {
        if (this.mTextEditor != null && this.mTextEditor.getTextViewer() != null) {
            return (IStructuredDocument)this.mTextEditor.getTextViewer().getDocument();
        }
        return null;
    }

    public final IStructuredModel getModelForRead() {
        IModelManager iModelManager;
        IStructuredDocument iStructuredDocument = this.getStructuredDocument();
        if (iStructuredDocument != null && (iModelManager = StructuredModelManager.getModelManager()) != null) {
            return iModelManager.getModelForRead(iStructuredDocument);
        }
        return null;
    }

    public final IStructuredModel getModelForEdit() {
        IModelManager iModelManager;
        IStructuredDocument iStructuredDocument = this.getStructuredDocument();
        if (iStructuredDocument != null && (iModelManager = StructuredModelManager.getModelManager()) != null) {
            return iModelManager.getModelForEdit(iStructuredDocument);
        }
        return null;
    }

    public final void editXmlModel(Runnable runnable) {
        IStructuredModel iStructuredModel = this.getModelForEdit();
        try {
            iStructuredModel.aboutToChangeModel();
            runnable.run();
        }
        finally {
            iStructuredModel.changedModel();
            iStructuredModel.releaseFromEdit();
        }
    }

    private final boolean beginUndoRecording(String string) {
        IStructuredModel iStructuredModel;
        IModelManager iModelManager;
        IStructuredDocument iStructuredDocument = this.getStructuredDocument();
        if (iStructuredDocument != null && (iModelManager = StructuredModelManager.getModelManager()) != null && (iStructuredModel = iModelManager.getModelForEdit(iStructuredDocument)) != null) {
            iStructuredModel.beginRecording((Object)this, string);
            return true;
        }
        return false;
    }

    private final void endUndoRecording() {
        IStructuredModel iStructuredModel;
        IModelManager iModelManager;
        IStructuredDocument iStructuredDocument = this.getStructuredDocument();
        if (iStructuredDocument != null && (iModelManager = StructuredModelManager.getModelManager()) != null && (iStructuredModel = iModelManager.getModelForEdit(iStructuredDocument)) != null) {
            iStructuredModel.endRecording((Object)this);
        }
    }

    public void wrapUndoRecording(String string, Runnable runnable) {
        boolean bl = false;
        try {
            bl = this.beginUndoRecording(string);
            runnable.run();
        }
        finally {
            if (bl) {
                this.endUndoRecording();
            }
        }
    }

    protected final Document getXmlDocument(IStructuredModel iStructuredModel) {
        if (iStructuredModel == null) {
            AdtPlugin.log(2, "Android Editor: No XML model for root node.", new Object[0]);
            return null;
        }
        if (iStructuredModel instanceof IDOMModel) {
            IDOMModel iDOMModel = (IDOMModel)iStructuredModel;
            return iDOMModel.getDocument();
        }
        return null;
    }

    public IProject getProject() {
        FileEditorInput fileEditorInput;
        IFile iFile;
        IEditorInput iEditorInput;
        if (this.mTextEditor != null && (iEditorInput = this.mTextEditor.getEditorInput()) instanceof FileEditorInput && (iFile = (fileEditorInput = (FileEditorInput)iEditorInput).getFile()) != null) {
            return iFile.getProject();
        }
        return null;
    }

    public AndroidTargetData getTargetData() {
        IAndroidTarget iAndroidTarget;
        Sdk sdk;
        IProject iProject = this.getProject();
        if (iProject != null && (sdk = Sdk.getCurrent()) != null && (iAndroidTarget = sdk.getTarget(iProject)) != null) {
            return sdk.getTargetData(iAndroidTarget);
        }
        return null;
    }

    private class XmlModelStateListener
    implements IModelStateListener {
        private XmlModelStateListener() {
        }

        public void modelAboutToBeChanged(IStructuredModel iStructuredModel) {
        }

        public void modelChanged(IStructuredModel iStructuredModel) {
            AndroidEditor.this.xmlModelChanged(AndroidEditor.this.getXmlDocument(iStructuredModel));
        }

        public void modelDirtyStateChanged(IStructuredModel iStructuredModel, boolean bl) {
        }

        public void modelResourceDeleted(IStructuredModel iStructuredModel) {
        }

        public void modelResourceMoved(IStructuredModel iStructuredModel, IStructuredModel iStructuredModel2) {
        }

        public void modelAboutToBeReinitialized(IStructuredModel iStructuredModel) {
        }

        public void modelReinitialized(IStructuredModel iStructuredModel) {
        }
    }
}

