/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.build;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.build.BaseBuilder;
import com.android.ide.eclipse.adt.internal.build.Messages;
import com.android.ide.eclipse.adt.internal.build.PreCompilerDeltaVisitor;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestParser;
import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import com.android.ide.eclipse.adt.internal.project.FixLaunchConfig;
import com.android.ide.eclipse.adt.internal.project.XmlErrorHandler;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.sdklib.IAndroidTarget;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreCompilerBuilder
extends BaseBuilder {
    public static final String ID = "com.android.ide.eclipse.adt.PreCompilerBuilder";
    private static final String PROPERTY_PACKAGE = "manifestPackage";
    private static final String PROPERTY_COMPILE_RESOURCES = "compileResources";
    private static final String PROPERTY_COMPILE_AIDL = "compileAidl";
    private static Pattern sAidlPattern1 = Pattern.compile("^(.+?):(\\d+):?\\s(.+)$");
    private boolean mMustCompileResources = false;
    private final ArrayList<AidlData> mAidlToCompile = new ArrayList();
    private final ArrayList<AidlData> mAidlToRemove = new ArrayList();
    private String mManifestPackage;
    private IFolder mGenFolder;
    private DerivedProgressMonitor mDerivedProgressMonitor;

    protected IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            boolean bl;
            String string;
            String string2;
            Object object;
            Object object2;
            IResourceDelta iResourceDelta;
            this.mDerivedProgressMonitor.reset();
            IProject iProject = this.getProject();
            this.abortOnBadSetup(iProject);
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            IAndroidTarget iAndroidTarget = Sdk.getCurrent().getTarget(iProject);
            ArrayList<IPath> arrayList = BaseProjectHelper.getSourceClasspaths(iJavaProject);
            PreCompilerDeltaVisitor preCompilerDeltaVisitor = null;
            String string3 = null;
            String string4 = null;
            if (n == 6) {
                AdtPlugin.printBuildToConsole(2, iProject, Messages.Start_Full_Pre_Compiler);
                this.mMustCompileResources = true;
                this.buildAidlCompilationList(iProject, arrayList);
            } else {
                AdtPlugin.printBuildToConsole(2, iProject, Messages.Start_Inc_Pre_Compiler);
                iResourceDelta = this.getDelta(iProject);
                if (iResourceDelta == null) {
                    this.mMustCompileResources = true;
                    this.buildAidlCompilationList(iProject, arrayList);
                } else {
                    preCompilerDeltaVisitor = new PreCompilerDeltaVisitor(this, arrayList);
                    iResourceDelta.accept((IResourceDeltaVisitor)preCompilerDeltaVisitor);
                    this.mMustCompileResources |= preCompilerDeltaVisitor.getCompileResources();
                    if (preCompilerDeltaVisitor.getForceAidlCompile()) {
                        this.buildAidlCompilationList(iProject, arrayList);
                    } else {
                        this.mergeAidlFileModifications(preCompilerDeltaVisitor.getAidlToCompile(), preCompilerDeltaVisitor.getAidlToRemove());
                    }
                    string3 = preCompilerDeltaVisitor.getManifestPackage();
                    string4 = preCompilerDeltaVisitor.getMinSdkVersion();
                }
            }
            this.saveProjectBooleanProperty(PROPERTY_COMPILE_RESOURCES, this.mMustCompileResources);
            if (preCompilerDeltaVisitor != null && preCompilerDeltaVisitor.mXmlError) {
                AdtPlugin.printErrorToConsole(iProject, new Object[]{Messages.Xml_Error});
                this.stopBuild(Messages.Xml_Error, new Object[0]);
            }
            if ((iResourceDelta = AndroidManifestParser.getManifest(iProject)) == null) {
                object2 = String.format(Messages.s_File_Missing, "AndroidManifest.xml");
                AdtPlugin.printErrorToConsole(iProject, object2);
                this.markProject("com.android.ide.eclipse.adt.adtProblem", (String)object2, 2);
                this.stopBuild((String)object2, new Object[0]);
            }
            if (preCompilerDeltaVisitor == null || !preCompilerDeltaVisitor.getCheckedManifestXml()) {
                object2 = new XmlErrorHandler.BasicXmlErrorListener();
                object = BaseProjectHelper.parseManifestForError((IFile)iResourceDelta, (XmlErrorHandler.XmlErrorListener)object2);
                if (((XmlErrorHandler.BasicXmlErrorListener)object2).mHasXmlError) {
                    string2 = String.format(Messages.s_Contains_Xml_Error, "AndroidManifest.xml");
                    AdtPlugin.printBuildToConsole(2, iProject, string2);
                    this.stopBuild(string2, new Object[0]);
                }
                string3 = ((AndroidManifestParser)object).getPackage();
                string4 = ((AndroidManifestParser)object).getApiLevelRequirement();
            }
            if (string4 != null) {
                int n2 = -1;
                try {
                    n2 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {}
                object = iAndroidTarget.getVersion();
                if (n2 != -1) {
                    string2 = object.getCodename();
                    if (string2 != null) {
                        string = String.format("Platform %1$s is a preview and requires appication manifests to set %2$s to '%1$s'", string2, "minSdkVersion");
                        AdtPlugin.printErrorToConsole(iProject, new Object[]{string});
                        BaseProjectHelper.addMarker((IResource)iResourceDelta, "com.android.ide.eclipse.adt.adtProblem", string, 2);
                        this.stopBuild(string, new Object[0]);
                    } else if (n2 < object.getApiLevel()) {
                        string = String.format("Manifest min SDK version (%1$s) is lower than project target API level (%2$d)", string4, object.getApiLevel());
                        AdtPlugin.printBuildToConsole(2, iProject, string);
                        BaseProjectHelper.addMarker((IResource)iResourceDelta, "com.android.ide.eclipse.adt.adtProblem", string, 1);
                    }
                } else {
                    string2 = object.getCodename();
                    if (string2 == null) {
                        string = String.format("Manifest attribute '%1$s' is set to '%2$s'. Integer is expected.", "minSdkVersion", string4);
                        AdtPlugin.printErrorToConsole(iProject, new Object[]{string});
                        BaseProjectHelper.addMarker((IResource)iResourceDelta, "com.android.ide.eclipse.adt.adtProblem", string, 2);
                        this.stopBuild(string, new Object[0]);
                    } else if (!string2.equals(string4)) {
                        string = String.format("Value of manifest attribute '%1$s' does not match platform codename '%2$s'", "minSdkVersion", string2);
                        AdtPlugin.printErrorToConsole(iProject, new Object[]{string});
                        BaseProjectHelper.addMarker((IResource)iResourceDelta, "com.android.ide.eclipse.adt.adtProblem", string, 2);
                        this.stopBuild(string, new Object[0]);
                    }
                }
            } else if (iAndroidTarget.getVersion().isPreview()) {
                object2 = iAndroidTarget.getVersion().getCodename();
                object = String.format("Platform %1$s is a preview and requires appication manifests to set %2$s to '%1$s'", object2, "minSdkVersion");
                AdtPlugin.printErrorToConsole(iProject, object);
                BaseProjectHelper.addMarker((IResource)iResourceDelta, "com.android.ide.eclipse.adt.adtProblem", (String)object, 2);
                this.stopBuild((String)object, new Object[0]);
            }
            if (string3 == null || string3.length() == 0) {
                String string5 = String.format(Messages.s_Doesnt_Declare_Package_Error, "AndroidManifest.xml");
                AdtPlugin.printErrorToConsole(iProject, new Object[]{string5});
                this.markProject("com.android.ide.eclipse.adt.adtProblem", string5, 2);
                this.stopBuild(string5, new Object[0]);
            }
            if (string3 != null && !string3.equals(this.mManifestPackage)) {
                if (this.mManifestPackage != null) {
                    AdtPlugin.printBuildToConsole(2, iProject, Messages.Checking_Package_Change);
                    FixLaunchConfig fixLaunchConfig = new FixLaunchConfig(iProject, this.mManifestPackage, string3);
                    fixLaunchConfig.start();
                }
                this.deleteObsoleteGeneratedClass("R.java", this.mManifestPackage);
                this.deleteObsoleteGeneratedClass("Manifest.java", this.mManifestPackage);
                this.mManifestPackage = string3;
                this.saveProjectStringProperty(PROPERTY_PACKAGE, this.mManifestPackage);
            }
            if (this.mMustCompileResources) {
                IPath iPath;
                IFolder iFolder = this.getGenManifestPackageFolder(iProject);
                object = iProject.getFolder("/res");
                string2 = this.mGenFolder.getLocation();
                string = object.getLocation();
                IPath iPath2 = iPath = iResourceDelta == null ? null : iResourceDelta.getLocation();
                if (string2 != null && string != null && iPath != null) {
                    String string6 = string2.toOSString();
                    String string7 = string.toOSString();
                    String string8 = iPath.toOSString();
                    this.removeMarkersFromFile((IFile)iResourceDelta, "com.android.ide.eclipse.common.aaptProblem");
                    this.removeMarkersFromContainer((IContainer)object, "com.android.ide.eclipse.common.aaptProblem");
                    AdtPlugin.printBuildToConsole(2, iProject, Messages.Preparing_Generated_Files);
                    IFile iFile = iFolder.getFile("R.java");
                    IFile iFile2 = iFolder.getFile("Manifest.java");
                    iFile2.delete(true, null);
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    arrayList2.add(iAndroidTarget.getPath(20));
                    arrayList2.add("package");
                    arrayList2.add("-m");
                    if (AdtPlugin.getBuildVerbosity() == 2) {
                        arrayList2.add("-v");
                    }
                    arrayList2.add("-J");
                    arrayList2.add(string6);
                    arrayList2.add("-M");
                    arrayList2.add(string8);
                    arrayList2.add("-S");
                    arrayList2.add(string7);
                    arrayList2.add("-I");
                    arrayList2.add(iAndroidTarget.getPath(1));
                    if (AdtPlugin.getBuildVerbosity() == 2) {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (String object32 : arrayList2) {
                            stringBuilder.append(object32);
                            stringBuilder.append(' ');
                        }
                        String string5 = stringBuilder.toString();
                        AdtPlugin.printToConsole(iProject, string5);
                    }
                    int n3 = 1;
                    try {
                        Process process = Runtime.getRuntime().exec(arrayList2.toArray(new String[arrayList2.size()]));
                        ArrayList arrayList3 = new ArrayList();
                        n3 = this.grabProcessOutput(process, arrayList3);
                        boolean bl2 = this.parseAaptOutput(arrayList3, iProject);
                        if (bl2) {
                            if (n3 != 0) {
                                AdtPlugin.printErrorToConsole(iProject, arrayList3.toArray());
                            } else {
                                AdtPlugin.printBuildToConsole(1, iProject, arrayList3.toArray());
                            }
                        }
                        if (n3 != 0) {
                            if (bl2) {
                                this.markProject("com.android.ide.eclipse.adt.adtProblem", Messages.Unparsed_AAPT_Errors, 2);
                            }
                            AdtPlugin.printBuildToConsole(2, iProject, Messages.AAPT_Error);
                            this.stopBuild(Messages.AAPT_Error, new Object[0]);
                        }
                    }
                    catch (IOException iOException) {
                        String string9 = String.format(Messages.AAPT_Exec_Error, arrayList2.get(0));
                        this.markProject("com.android.ide.eclipse.adt.adtProblem", string9, 2);
                        this.stopBuild(string9, new Object[0]);
                    }
                    catch (InterruptedException interruptedException) {
                        String string10 = String.format(Messages.AAPT_Exec_Error, arrayList2.get(0));
                        this.markProject("com.android.ide.eclipse.adt.adtProblem", string10, 2);
                        this.stopBuild(string10, new Object[0]);
                    }
                    if (n3 == 0) {
                        this.mDerivedProgressMonitor.addFile(iFile);
                        this.mDerivedProgressMonitor.addFile(iFile2);
                        this.mMustCompileResources = false;
                        this.saveProjectBooleanProperty(PROPERTY_COMPILE_RESOURCES, this.mMustCompileResources);
                    }
                }
            }
            if (!(bl = this.handleAidl(iAndroidTarget, arrayList, iProgressMonitor)) && !this.mMustCompileResources) {
                AdtPlugin.printBuildToConsole(2, iProject, Messages.Nothing_To_Compile);
            }
        }
        finally {
            this.mGenFolder.refreshLocal(2, (IProgressMonitor)this.mDerivedProgressMonitor);
        }
        return null;
    }

    protected void clean(IProgressMonitor iProgressMonitor) throws CoreException {
        super.clean(iProgressMonitor);
        AdtPlugin.printBuildToConsole(2, this.getProject(), Messages.Removing_Generated_Classes);
        this.removeDerivedResources((IResource)this.mGenFolder, iProgressMonitor);
    }

    protected void startupOnInitialize() {
        super.startupOnInitialize();
        this.mDerivedProgressMonitor = new DerivedProgressMonitor();
        IProject iProject = this.getProject();
        this.mManifestPackage = this.loadProjectStringProperty(PROPERTY_PACKAGE);
        this.mGenFolder = iProject.getFolder("gen");
        this.mMustCompileResources = this.loadProjectBooleanProperty(PROPERTY_COMPILE_RESOURCES, true);
        boolean bl = this.loadProjectBooleanProperty(PROPERTY_COMPILE_AIDL, true);
        if (bl) {
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            ArrayList<IPath> arrayList = BaseProjectHelper.getSourceClasspaths(iJavaProject);
            this.buildAidlCompilationList(iProject, arrayList);
        }
    }

    private void deleteObsoleteGeneratedClass(String string, String string2) {
        if (string2 == null) {
            return;
        }
        IPath iPath = this.getJavaPackagePath(string2);
        IPath iPath2 = iPath.append(string);
        IResource iResource = this.mGenFolder.findMember(iPath2);
        if (iResource != null && iResource.exists() && iResource.getType() == 1) {
            try {
                iResource.delete(true, null);
                iResource.getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                String string3 = String.format(Messages.Delete_Obsolete_Error, iResource.getFullPath());
                IProject iProject = this.getProject();
                AdtPlugin.printErrorToConsole(iProject, new Object[]{string3});
                AdtPlugin.printErrorToConsole(iProject, new Object[]{coreException.getMessage()});
            }
        }
    }

    private IPath getJavaPackagePath(String string) {
        String[] stringArray = string.split("\\.");
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            stringBuilder.append('/');
            stringBuilder.append(string2);
            ++n2;
        }
        return new Path(stringBuilder.toString());
    }

    private IFolder getGenManifestPackageFolder(IProject iProject) throws CoreException {
        IPath iPath = this.getJavaPackagePath(this.mManifestPackage);
        return this.mGenFolder.getFolder(iPath);
    }

    private boolean handleAidl(IAndroidTarget iAndroidTarget, ArrayList<IPath> arrayList, IProgressMonitor iProgressMonitor) throws CoreException {
        IPath iPath2;
        if (this.mAidlToCompile.size() == 0 && this.mAidlToRemove.size() == 0) {
            return false;
        }
        String[] stringArray = new String[4 + arrayList.size()];
        int n = 0;
        stringArray[n++] = iAndroidTarget.getPath(21);
        stringArray[n++] = "-p" + Sdk.getCurrent().getTarget(this.getProject()).getPath(2);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        for (IPath iPath2 : arrayList) {
            IFolder iFolder = iWorkspaceRoot.getFolder(iPath2);
            stringArray[n++] = "-I" + iFolder.getLocation().toOSString();
        }
        iPath2 = new ArrayList();
        for (AidlData aidlData : this.mAidlToRemove) {
            int n2 = this.mAidlToCompile.indexOf(aidlData);
            if (n2 == -1) continue;
            this.mAidlToCompile.remove(n2);
        }
        for (AidlData aidlData : this.mAidlToCompile) {
            this.removeMarkersFromFile(aidlData.aidlFile, "com.android.ide.eclipse.common.aidlProblem");
            IPath iPath3 = aidlData.aidlFile.getLocation();
            String string = iPath3.toOSString();
            IFile iFile = this.getGenDestinationFile(aidlData, true, iProgressMonitor);
            stringArray[n] = string;
            stringArray[n + 1] = iFile.getLocation().toOSString();
            if (!this.execAidl(stringArray, aidlData.aidlFile)) {
                iPath2.add(aidlData);
                continue;
            }
            this.mDerivedProgressMonitor.addFile(iFile);
        }
        this.mAidlToCompile.clear();
        this.mAidlToCompile.addAll((Collection<AidlData>)iPath2);
        for (AidlData aidlData : this.mAidlToRemove) {
            IFile iFile = this.getGenDestinationFile(aidlData, false, iProgressMonitor);
            if (!iFile.exists()) continue;
            iFile.delete(true, null);
            iFile.getParent().refreshLocal(1, iProgressMonitor);
        }
        this.mAidlToRemove.clear();
        this.saveProjectBooleanProperty(PROPERTY_COMPILE_AIDL, this.mAidlToCompile.size() > 0);
        return true;
    }

    private IFile getGenDestinationFile(AidlData aidlData, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        int n = aidlData.sourceFolder.getFullPath().segmentCount();
        IPath iPath = aidlData.aidlFile.getFullPath().removeFirstSegments(n).removeLastSegments(1);
        Path path = new Path(iPath.toString());
        IFolder iFolder = this.mGenFolder.getFolder((IPath)path);
        if (!iFolder.exists() && bl) {
            this.createFolder(iFolder, iProgressMonitor);
        }
        String string = aidlData.aidlFile.getName().replaceAll("\\.aidl$", ".java");
        IFile iFile = iFolder.getFile(string);
        return iFile;
    }

    private void createFolder(IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException {
        IContainer iContainer = iFolder.getParent();
        if (iContainer.getType() == 2 && !iContainer.exists()) {
            this.createFolder((IFolder)iContainer, iProgressMonitor);
        }
        iFolder.create(true, true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
    }

    private boolean execAidl(String[] stringArray, IFile iFile) {
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = this.grabProcessOutput(process, arrayList);
            boolean bl = this.parseAidlOutput(arrayList, iFile);
            if (n != 0 && bl) {
                AdtPlugin.printErrorToConsole(this.getProject(), arrayList.toArray());
                this.markProject("com.android.ide.eclipse.adt.adtProblem", Messages.Unparsed_AIDL_Errors, 2);
                return false;
            }
        }
        catch (IOException iOException) {
            String string = String.format(Messages.AIDL_Exec_Error, stringArray[0]);
            this.markProject("com.android.ide.eclipse.adt.adtProblem", string, 2);
            return false;
        }
        catch (InterruptedException interruptedException) {
            String string = String.format(Messages.AIDL_Exec_Error, stringArray[0]);
            this.markProject("com.android.ide.eclipse.adt.adtProblem", string, 2);
            return false;
        }
        return true;
    }

    private void buildAidlCompilationList(IProject iProject, ArrayList<IPath> arrayList) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        for (IPath iPath : arrayList) {
            IFolder iFolder = iWorkspaceRoot.getFolder(iPath);
            if (!iFolder.exists() || iFolder.equals((Object)this.mGenFolder)) continue;
            this.scanFolderForAidl(iFolder, iFolder);
        }
    }

    private void scanFolderForAidl(IFolder iFolder, IFolder iFolder2) {
        try {
            IResource[] iResourceArray;
            IResource[] iResourceArray2 = iResourceArray = iFolder2.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray2[n2];
                switch (iResource.getType()) {
                    case 1: {
                        if (!iResource.exists() || !"aidl".equalsIgnoreCase(iResource.getFileExtension())) break;
                        this.mAidlToCompile.add(new AidlData(iFolder, (IFile)iResource));
                        break;
                    }
                    case 2: {
                        this.scanFolderForAidl(iFolder, (IFolder)iResource);
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
    }

    private boolean parseAidlOutput(ArrayList<String> arrayList, IFile iFile) {
        if (arrayList.size() == 0) {
            return false;
        }
        int n = 0;
        while (n < arrayList.size()) {
            int n2;
            String string;
            String string2 = arrayList.get(n);
            Matcher matcher = sAidlPattern1.matcher(string2);
            if (matcher.matches()) {
                String string3 = matcher.group(2);
                string = matcher.group(3);
                n2 = 0;
                try {
                    n2 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    return true;
                }
            } else {
                return true;
            }
            BaseProjectHelper.addMarker((IResource)iFile, "com.android.ide.eclipse.common.aidlProblem", string, n2, 2);
            ++n;
        }
        return false;
    }

    private void mergeAidlFileModifications(ArrayList<AidlData> arrayList, ArrayList<AidlData> arrayList2) {
        int n;
        for (AidlData aidlData : arrayList2) {
            if (this.mAidlToRemove.indexOf(aidlData) == -1) {
                this.mAidlToRemove.add(aidlData);
            }
            if ((n = this.mAidlToCompile.indexOf(aidlData)) == -1) continue;
            this.mAidlToCompile.remove(n);
        }
        for (AidlData aidlData : arrayList) {
            if (this.mAidlToCompile.indexOf(aidlData) == -1) {
                this.mAidlToCompile.add(aidlData);
            }
            if ((n = this.mAidlToRemove.indexOf(aidlData)) == -1) continue;
            this.mAidlToRemove.remove(n);
        }
    }

    static class AidlData {
        IFile aidlFile;
        IFolder sourceFolder;

        AidlData(IFolder iFolder, IFile iFile) {
            this.sourceFolder = iFolder;
            this.aidlFile = iFile;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof AidlData) {
                AidlData aidlData = (AidlData)object;
                return this.aidlFile.equals((Object)aidlData.aidlFile) && this.sourceFolder.equals((Object)aidlData.sourceFolder);
            }
            return false;
        }
    }

    private static class DerivedProgressMonitor
    implements IProgressMonitor {
        private boolean mCancelled = false;
        private final ArrayList<IFile> mFileList = new ArrayList();
        private boolean mDone = false;

        void addFile(IFile iFile) {
            this.mFileList.add(iFile);
        }

        void reset() {
            this.mFileList.clear();
            this.mDone = false;
        }

        public void beginTask(String string, int n) {
        }

        public void done() {
            if (!this.mDone) {
                this.mDone = true;
                for (IFile iFile : this.mFileList) {
                    if (!iFile.exists()) continue;
                    try {
                        iFile.setDerived(true);
                    }
                    catch (CoreException coreException) {}
                }
            }
        }

        public void internalWorked(double d) {
        }

        public boolean isCanceled() {
            return this.mCancelled;
        }

        public void setCanceled(boolean bl) {
            this.mCancelled = bl;
        }

        public void setTaskName(String string) {
        }

        public void subTask(String string) {
        }

        public void worked(int n) {
        }
    }
}

