/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.build;

import com.android.ide.eclipse.adt.AndroidConstants;
import com.android.ide.eclipse.adt.internal.build.ApkBuilder;
import com.android.ide.eclipse.adt.internal.build.BaseBuilder;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApkDeltaVisitor
extends BaseBuilder.BaseDeltaVisitor
implements IResourceDeltaVisitor {
    private boolean mConvertToDex = false;
    private boolean mPackageResources = false;
    private boolean mMakeFinalPackage = false;
    private ArrayList<IPath> mSourceFolders;
    private IPath mOutputPath;
    private IPath mAssetPath;
    private IPath mResPath;
    private IPath mLibFolder;

    public ApkDeltaVisitor(BaseBuilder baseBuilder, ArrayList<IPath> arrayList, IFolder iFolder) {
        super(baseBuilder);
        IResource iResource;
        IResource iResource2;
        IResource iResource3;
        this.mSourceFolders = arrayList;
        if (iFolder != null) {
            this.mOutputPath = iFolder.getFullPath();
        }
        if ((iResource3 = baseBuilder.getProject().findMember("assets")) != null) {
            this.mAssetPath = iResource3.getFullPath();
        }
        if ((iResource2 = baseBuilder.getProject().findMember("res")) != null) {
            this.mResPath = iResource2.getFullPath();
        }
        if ((iResource = baseBuilder.getProject().findMember("libs")) != null) {
            this.mLibFolder = iResource.getFullPath();
        }
    }

    public boolean getConvertToDex() {
        return this.mConvertToDex;
    }

    public boolean getPackageResources() {
        return this.mPackageResources;
    }

    public boolean getMakeFinalPackage() {
        return this.mMakeFinalPackage;
    }

    public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
        if (this.mConvertToDex && this.mPackageResources && this.mMakeFinalPackage) {
            return false;
        }
        IResource iResource = iResourceDelta.getResource();
        IPath iPath = iResource.getFullPath();
        String[] stringArray = iPath.segments();
        int n = iResource.getType();
        if (stringArray.length == 1) {
            return true;
        }
        if (stringArray.length == 2 && "AndroidManifest.xml".equalsIgnoreCase(stringArray[1])) {
            this.mPackageResources = true;
            this.mMakeFinalPackage = true;
            return false;
        }
        if (this.mOutputPath != null && this.mOutputPath.isPrefixOf(iPath)) {
            if (n == 1) {
                IPath iPath2;
                String string = iResource.getFileExtension();
                if ("class".equalsIgnoreCase(string)) {
                    this.mConvertToDex = true;
                    this.mMakeFinalPackage = true;
                    return false;
                }
                if (iResourceDelta.getKind() == 2 && this.mOutputPath.equals((Object)(iPath2 = iPath.removeLastSegments(1)))) {
                    String string2 = iResource.getName();
                    if (string2.equalsIgnoreCase("classes.dex")) {
                        this.mConvertToDex = true;
                        this.mMakeFinalPackage = true;
                    } else if (string2.equalsIgnoreCase("resources.ap_") || AndroidConstants.PATTERN_RESOURCES_S_AP_.matcher(string2).matches()) {
                        this.mPackageResources = true;
                        this.mMakeFinalPackage = true;
                    }
                }
            }
            return !this.mConvertToDex;
        }
        if (this.mResPath != null && this.mResPath.isPrefixOf(iPath)) {
            if (n == 1) {
                this.mPackageResources = true;
                this.mMakeFinalPackage = true;
                return false;
            }
            return !this.mPackageResources;
        }
        if (this.mAssetPath != null && this.mAssetPath.isPrefixOf(iPath)) {
            this.mPackageResources = true;
            this.mMakeFinalPackage = true;
            return false;
        }
        if (this.mLibFolder != null && this.mLibFolder.isPrefixOf(iPath)) {
            if (n == 1 && iPath.getFileExtension().equalsIgnoreCase("so")) {
                this.mMakeFinalPackage = true;
                return false;
            }
            return !this.mMakeFinalPackage;
        }
        if (!this.mMakeFinalPackage) {
            for (IPath iPath3 : this.mSourceFolders) {
                if (!iPath3.isPrefixOf(iPath)) continue;
                if (n == 2) {
                    return ApkBuilder.checkFolderForPackaging((IFolder)iResource);
                }
                if (n != 1) continue;
                if (ApkBuilder.checkFileForPackaging((IFile)iResource)) {
                    this.mMakeFinalPackage = true;
                }
                return false;
            }
        }
        return true;
    }
}

