/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms.views;

import com.android.ddmuilib.ITableFocusListener;
import com.android.ddmuilib.TablePanel;
import com.android.ide.eclipse.ddms.views.SelectionDependentViewPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;

public abstract class TableView
extends SelectionDependentViewPart {
    ITableFocusListener.IFocusedTableActivator mActivator = null;
    private Clipboard mClipboard;
    private Action mCopyAction;
    private Action mSelectAllAction;

    void setupTableFocusListener(TablePanel tablePanel, Composite composite) {
        tablePanel.setTableFocusListener(new ITableFocusListener(){

            public void focusGained(ITableFocusListener.IFocusedTableActivator iFocusedTableActivator) {
                TableView.this.mActivator = iFocusedTableActivator;
                TableView.this.mCopyAction.setEnabled(true);
                TableView.this.mSelectAllAction.setEnabled(true);
            }

            public void focusLost(ITableFocusListener.IFocusedTableActivator iFocusedTableActivator) {
                if (iFocusedTableActivator == TableView.this.mActivator) {
                    TableView.this.mActivator = null;
                    TableView.this.mCopyAction.setEnabled(false);
                    TableView.this.mSelectAllAction.setEnabled(false);
                }
            }
        });
        this.mClipboard = new Clipboard(composite.getDisplay());
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.mCopyAction = new Action("Copy"){

            public void run() {
                if (TableView.this.mActivator != null) {
                    TableView.this.mActivator.copy(TableView.this.mClipboard);
                }
            }
        };
        iActionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.mCopyAction);
        this.mSelectAllAction = new Action("Select All"){

            public void run() {
                if (TableView.this.mActivator != null) {
                    TableView.this.mActivator.selectAll();
                }
            }
        };
        iActionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.mSelectAllAction);
    }

    public void dispose() {
        super.dispose();
        this.mClipboard.dispose();
    }
}

