/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.testrunner;

import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;

public class InstrumentationResultParser
extends MultiLineReceiver {
    private final ITestRunListener mTestListener;
    private TestResult mCurrentTestResult = null;
    private String mCurrentKey = null;
    private StringBuilder mCurrentValue = null;
    private boolean mTestStartReported = false;
    private long mTestTime = 0L;
    private boolean mIsCancelled = false;
    private static final String LOG_TAG = "InstrumentationResultParser";

    public InstrumentationResultParser(ITestRunListener iTestRunListener) {
        this.mTestListener = iTestRunListener;
    }

    public void processNewLines(String[] stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            this.parse(string);
            Log.v(LOG_TAG, string);
            ++n2;
        }
    }

    private void parse(String string) {
        if (string.startsWith("INSTRUMENTATION_STATUS_CODE: ")) {
            this.submitCurrentKeyValue();
            this.parseStatusCode(string);
        } else if (string.startsWith("INSTRUMENTATION_STATUS: ")) {
            this.submitCurrentKeyValue();
            this.parseKey(string, "INSTRUMENTATION_STATUS: ".length());
        } else if (string.startsWith("INSTRUMENTATION_RESULT: ")) {
            this.submitCurrentKeyValue();
            this.parseKey(string, "INSTRUMENTATION_RESULT: ".length());
        } else if (string.startsWith("INSTRUMENTATION_FAILED: ") || string.startsWith("INSTRUMENTATION_CODE: ")) {
            this.submitCurrentKeyValue();
        } else if (string.startsWith("Time: ")) {
            this.parseTime(string, "Time: ".length());
        } else if (this.mCurrentValue != null) {
            this.mCurrentValue.append("\r\n");
            this.mCurrentValue.append(string);
        } else {
            Log.w(LOG_TAG, "unrecognized line " + string);
        }
    }

    private void submitCurrentKeyValue() {
        if (this.mCurrentKey != null && this.mCurrentValue != null) {
            TestResult testResult = this.getCurrentTestInfo();
            String string = this.mCurrentValue.toString();
            if (this.mCurrentKey.equals("class")) {
                testResult.mTestClass = string.trim();
            } else if (this.mCurrentKey.equals("test")) {
                testResult.mTestName = string.trim();
            } else if (this.mCurrentKey.equals("numtests")) {
                try {
                    testResult.mNumTests = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    Log.e(LOG_TAG, "Unexpected integer number of tests, received " + string);
                }
            } else if (this.mCurrentKey.equals("Error") || this.mCurrentKey.equals("shortMsg")) {
                this.handleTestRunFailed(string);
            } else if (this.mCurrentKey.equals("stack")) {
                testResult.mStackTrace = string;
            }
            this.mCurrentKey = null;
            this.mCurrentValue = null;
        }
    }

    private TestResult getCurrentTestInfo() {
        if (this.mCurrentTestResult == null) {
            this.mCurrentTestResult = new TestResult();
        }
        return this.mCurrentTestResult;
    }

    private void clearCurrentTestInfo() {
        this.mCurrentTestResult = null;
    }

    private void parseKey(String string, int n) {
        int n2 = string.indexOf(61, n);
        if (n2 != -1) {
            this.mCurrentKey = string.substring(n, n2).trim();
            this.parseValue(string, n2 + 1);
        }
    }

    private void parseValue(String string, int n) {
        this.mCurrentValue = new StringBuilder();
        this.mCurrentValue.append(string.substring(n));
    }

    private void parseStatusCode(String string) {
        String string2 = string.substring("INSTRUMENTATION_STATUS_CODE: ".length()).trim();
        TestResult testResult = this.getCurrentTestInfo();
        try {
            testResult.mCode = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Log.e(LOG_TAG, "Expected integer status code, received: " + string2);
        }
        this.reportResult(testResult);
        this.clearCurrentTestInfo();
    }

    public boolean isCancelled() {
        return this.mIsCancelled;
    }

    public void cancel() {
        this.mIsCancelled = true;
    }

    private void reportResult(TestResult testResult) {
        if (!testResult.isComplete()) {
            Log.w(LOG_TAG, "invalid instrumentation status bundle " + testResult.toString());
            return;
        }
        this.reportTestRunStarted(testResult);
        TestIdentifier testIdentifier = new TestIdentifier(testResult.mTestClass, testResult.mTestName);
        switch (testResult.mCode) {
            case 1: {
                this.mTestListener.testStarted(testIdentifier);
                break;
            }
            case -2: {
                this.mTestListener.testFailed(ITestRunListener.TestFailure.FAILURE, testIdentifier, this.getTrace(testResult));
                this.mTestListener.testEnded(testIdentifier);
                break;
            }
            case -1: {
                this.mTestListener.testFailed(ITestRunListener.TestFailure.ERROR, testIdentifier, this.getTrace(testResult));
                this.mTestListener.testEnded(testIdentifier);
                break;
            }
            case 0: {
                this.mTestListener.testEnded(testIdentifier);
                break;
            }
            default: {
                Log.e(LOG_TAG, "Unknown status code received: " + testResult.mCode);
                this.mTestListener.testEnded(testIdentifier);
            }
        }
    }

    private void reportTestRunStarted(TestResult testResult) {
        if (!this.mTestStartReported && testResult.mNumTests != null) {
            this.mTestListener.testRunStarted(testResult.mNumTests);
            this.mTestStartReported = true;
        }
    }

    private String getTrace(TestResult testResult) {
        if (testResult.mStackTrace != null) {
            return testResult.mStackTrace;
        }
        Log.e(LOG_TAG, "Could not find stack trace for failed test ");
        return new Throwable("Unknown failure").toString();
    }

    private void parseTime(String string, int n) {
        String string2 = string.substring(n);
        try {
            float f = Float.parseFloat(string2);
            this.mTestTime = (long)(f * 1000.0f);
        }
        catch (NumberFormatException numberFormatException) {
            Log.e(LOG_TAG, "Unexpected time format " + string2);
        }
    }

    private void handleTestRunFailed(String string) {
        this.mTestListener.testRunFailed(string == null ? "Unknown error" : string);
    }

    public void done() {
        super.done();
        this.mTestListener.testRunEnded(this.mTestTime);
    }

    private static class Prefixes {
        private static final String STATUS = "INSTRUMENTATION_STATUS: ";
        private static final String STATUS_CODE = "INSTRUMENTATION_STATUS_CODE: ";
        private static final String STATUS_FAILED = "INSTRUMENTATION_FAILED: ";
        private static final String CODE = "INSTRUMENTATION_CODE: ";
        private static final String RESULT = "INSTRUMENTATION_RESULT: ";
        private static final String TIME_REPORT = "Time: ";

        private Prefixes() {
        }
    }

    private static class StatusCodes {
        private static final int FAILURE = -2;
        private static final int START = 1;
        private static final int ERROR = -1;
        private static final int OK = 0;

        private StatusCodes() {
        }
    }

    private static class StatusKeys {
        private static final String TEST = "test";
        private static final String CLASS = "class";
        private static final String STACK = "stack";
        private static final String NUMTESTS = "numtests";
        private static final String ERROR = "Error";
        private static final String SHORTMSG = "shortMsg";

        private StatusKeys() {
        }
    }

    private static class TestResult {
        private Integer mCode = null;
        private String mTestName = null;
        private String mTestClass = null;
        private String mStackTrace = null;
        private Integer mNumTests = null;

        private TestResult() {
        }

        boolean isComplete() {
            return this.mCode != null && this.mTestName != null && this.mTestClass != null;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.mTestClass != null) {
                stringBuilder.append(this.mTestClass);
                stringBuilder.append('#');
            }
            if (this.mTestName != null) {
                stringBuilder.append(this.mTestName);
            }
            if (stringBuilder.length() > 0) {
                return stringBuilder.toString();
            }
            return "unknown result";
        }
    }
}

