/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.DdmPreferences;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class Log {
    private static LogLevel mLevel = DdmPreferences.getLogLevel();
    private static ILogOutput sLogOutput;
    private static final char[] mSpaceLine;
    private static final char[] mHexDigit;

    static {
        mSpaceLine = new char[72];
        mHexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int n = mSpaceLine.length - 1;
        while (n >= 0) {
            Log.mSpaceLine[n--] = 32;
        }
        Log.mSpaceLine[3] = 48;
        Log.mSpaceLine[2] = 48;
        Log.mSpaceLine[1] = 48;
        Log.mSpaceLine[0] = 48;
        Log.mSpaceLine[4] = 45;
    }

    private Log() {
    }

    public static void v(String string, String string2) {
        Log.println(LogLevel.VERBOSE, string, string2);
    }

    public static void d(String string, String string2) {
        Log.println(LogLevel.DEBUG, string, string2);
    }

    public static void i(String string, String string2) {
        Log.println(LogLevel.INFO, string, string2);
    }

    public static void w(String string, String string2) {
        Log.println(LogLevel.WARN, string, string2);
    }

    public static void e(String string, String string2) {
        Log.println(LogLevel.ERROR, string, string2);
    }

    public static void logAndDisplay(LogLevel logLevel, String string, String string2) {
        if (sLogOutput != null) {
            sLogOutput.printAndPromptLog(logLevel, string, string2);
        } else {
            Log.println(logLevel, string, string2);
        }
    }

    public static void e(String string, Throwable throwable) {
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            Log.println(LogLevel.ERROR, string, String.valueOf(throwable.getMessage()) + '\n' + stringWriter.toString());
        }
    }

    static void setLevel(LogLevel logLevel) {
        mLevel = logLevel;
    }

    public static void setLogOutput(ILogOutput iLogOutput) {
        sLogOutput = iLogOutput;
    }

    static void hexDump(String string, LogLevel logLevel, byte[] byArray, int n, int n2) {
        int n3 = 6;
        int n4 = 55;
        char[] cArray = new char[mSpaceLine.length];
        boolean bl = true;
        int n5 = 0;
        while (n2 != 0) {
            int n6;
            if (n2 > 16) {
                n6 = 16;
            } else {
                n6 = n2;
                bl = true;
            }
            if (bl) {
                System.arraycopy(mSpaceLine, 0, cArray, 0, mSpaceLine.length);
                bl = false;
            }
            int n7 = n5;
            n7 &= 0xFFFF;
            int n8 = 3;
            while (n7 != 0) {
                cArray[n8] = mHexDigit[n7 & 0xF];
                --n8;
                n7 >>>= 4;
            }
            n8 = n3;
            int n9 = 0;
            while (n9 < n6) {
                byte by = byArray[n + n9];
                cArray[n8++] = mHexDigit[by >>> 4 & 0xF];
                cArray[n8++] = mHexDigit[by & 0xF];
                ++n8;
                cArray[n4 + n9] = by >= 32 && by < 127 ? (int)by : 46;
                ++n9;
            }
            Log.println(logLevel, string, new String(cArray));
            n2 -= n6;
            n += n6;
            n5 += n6;
        }
    }

    static void hexDump(byte[] byArray) {
        Log.hexDump("ddms", LogLevel.DEBUG, byArray, 0, byArray.length);
    }

    private static void println(LogLevel logLevel, String string, String string2) {
        if (logLevel.getPriority() >= mLevel.getPriority()) {
            if (sLogOutput != null) {
                sLogOutput.printLog(logLevel, string, string2);
            } else {
                Log.printLog(logLevel, string, string2);
            }
        }
    }

    public static void printLog(LogLevel logLevel, String string, String string2) {
        long l = System.currentTimeMillis();
        String string3 = String.format("%02d:%02d %c/%s: %s\n", l / 60000L % 60L, l / 1000L % 60L, Character.valueOf(logLevel.getPriorityLetter()), string, string2);
        System.out.print(string3);
    }

    static final class Config {
        static final boolean LOGV = true;
        static final boolean LOGD = true;

        Config() {
        }
    }

    public static interface ILogOutput {
        public void printLog(LogLevel var1, String var2, String var3);

        public void printAndPromptLog(LogLevel var1, String var2, String var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LogLevel {
        VERBOSE(2, "verbose", 'V'),
        DEBUG(3, "debug", 'D'),
        INFO(4, "info", 'I'),
        WARN(5, "warn", 'W'),
        ERROR(6, "error", 'E'),
        ASSERT(7, "assert", 'A');

        private int mPriorityLevel;
        private String mStringValue;
        private char mPriorityLetter;

        private LogLevel(int n2, String string2, char c) {
            this.mPriorityLevel = n2;
            this.mStringValue = string2;
            this.mPriorityLetter = c;
        }

        public static LogLevel getByString(String string) {
            LogLevel[] logLevelArray = LogLevel.values();
            int n = logLevelArray.length;
            int n2 = 0;
            while (n2 < n) {
                LogLevel logLevel = logLevelArray[n2];
                if (logLevel.mStringValue.equals(string)) {
                    return logLevel;
                }
                ++n2;
            }
            return null;
        }

        public static LogLevel getByLetter(char c) {
            LogLevel[] logLevelArray = LogLevel.values();
            int n = logLevelArray.length;
            int n2 = 0;
            while (n2 < n) {
                LogLevel logLevel = logLevelArray[n2];
                if (logLevel.mPriorityLetter == c) {
                    return logLevel;
                }
                ++n2;
            }
            return null;
        }

        public static LogLevel getByLetterString(String string) {
            if (string.length() > 0) {
                return LogLevel.getByLetter(string.charAt(0));
            }
            return null;
        }

        public char getPriorityLetter() {
            return this.mPriorityLetter;
        }

        public int getPriority() {
            return this.mPriorityLevel;
        }

        public String getStringValue() {
            return this.mStringValue;
        }
    }
}

