/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.ChunkHandler;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.JdwpPacket;
import com.android.ddmlib.Log;
import com.android.ddmlib.MonitorThread;
import java.io.IOException;
import java.nio.ByteBuffer;

final class HandleHello
extends ChunkHandler {
    public static final int CHUNK_HELO = ChunkHandler.type("HELO");
    public static final int CHUNK_FEAT = ChunkHandler.type("FEAT");
    private static final HandleHello mInst = new HandleHello();

    private HandleHello() {
    }

    public static void register(MonitorThread monitorThread) {
        monitorThread.registerChunkHandler(CHUNK_HELO, mInst);
    }

    public void clientReady(Client client) throws IOException {
        Log.d("ddm-hello", "Now ready: " + client);
    }

    public void clientDisconnected(Client client) {
        Log.d("ddm-hello", "Now disconnected: " + client);
    }

    public void handleChunk(Client client, int n, ByteBuffer byteBuffer, boolean bl, int n2) {
        Log.d("ddm-hello", "handling " + ChunkHandler.name(n));
        if (n == CHUNK_HELO) {
            assert (bl);
            HandleHello.handleHELO(client, byteBuffer);
        } else if (n == CHUNK_FEAT) {
            HandleHello.handleFEAT(client, byteBuffer);
        } else {
            this.handleUnknownChunk(client, n, byteBuffer, bl, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleHELO(Client client, ByteBuffer byteBuffer) {
        ClientData clientData;
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        int n4 = byteBuffer.getInt();
        String string = HandleHello.getString(byteBuffer, n3);
        String string2 = HandleHello.getString(byteBuffer, n4);
        Log.d("ddm-hello", "HELO: v=" + n + ", pid=" + n2 + ", vm='" + string + "', app='" + string2 + "'");
        ClientData clientData2 = clientData = client.getClientData();
        synchronized (clientData2) {
            if (clientData.getPid() == n2) {
                clientData.setVmIdentifier(string);
                clientData.setClientDescription(string2);
                clientData.isDdmAware(true);
            } else {
                Log.e("ddm-hello", "Received pid (" + n2 + ") does not match client pid (" + clientData.getPid() + ")");
            }
        }
        client = HandleHello.checkDebuggerPortForAppName(client, string2);
        if (client != null) {
            client.update(1);
        }
    }

    public static void sendHELO(Client client, int n) throws IOException {
        ByteBuffer byteBuffer = HandleHello.allocBuffer(4);
        JdwpPacket jdwpPacket = new JdwpPacket(byteBuffer);
        ByteBuffer byteBuffer2 = HandleHello.getChunkDataBuf(byteBuffer);
        byteBuffer2.putInt(n);
        HandleHello.finishChunkPacket(jdwpPacket, CHUNK_HELO, byteBuffer2.position());
        Log.d("ddm-hello", "Sending " + HandleHello.name(CHUNK_HELO) + " ID=0x" + Integer.toHexString(jdwpPacket.getId()));
        client.sendAndConsume(jdwpPacket, mInst);
    }

    private static void handleFEAT(Client client, ByteBuffer byteBuffer) {
        int n = byteBuffer.getInt();
        int n2 = 0;
        while (n2 < n) {
            int n3 = byteBuffer.getInt();
            String string = HandleHello.getString(byteBuffer, n3);
            Log.d("ddm-hello", "Feature: " + string);
            ++n2;
        }
    }

    public static void sendFEAT(Client client) throws IOException {
        ByteBuffer byteBuffer = HandleHello.allocBuffer(0);
        JdwpPacket jdwpPacket = new JdwpPacket(byteBuffer);
        ByteBuffer byteBuffer2 = HandleHello.getChunkDataBuf(byteBuffer);
        HandleHello.finishChunkPacket(jdwpPacket, CHUNK_FEAT, byteBuffer2.position());
        Log.d("ddm-heap", "Sending " + HandleHello.name(CHUNK_FEAT));
        client.sendAndConsume(jdwpPacket, mInst);
    }
}

