/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Device;
import com.android.ddmlib.EmulatorConsole;
import com.android.ddmlib.GetPropReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.MonitorThread;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DeviceMonitor {
    private byte[] mLengthBuffer = new byte[4];
    private byte[] mLengthBuffer2 = new byte[4];
    private boolean mQuit = false;
    private AndroidDebugBridge mServer;
    private SocketChannel mMainAdbConnection = null;
    private boolean mMonitoring = false;
    private int mConnectionAttempt = 0;
    private int mRestartAttemptCount = 0;
    private boolean mInitialDeviceListDone = false;
    private Selector mSelector;
    private final ArrayList<Device> mDevices = new ArrayList();
    private final ArrayList<Integer> mDebuggerPorts = new ArrayList();
    private final HashMap<Client, Integer> mClientsToReopen = new HashMap();

    DeviceMonitor(AndroidDebugBridge androidDebugBridge) {
        this.mServer = androidDebugBridge;
        this.mDebuggerPorts.add(DdmPreferences.getDebugPortBase());
    }

    void start() {
        new Thread("Device List Monitor"){

            public void run() {
                DeviceMonitor.this.deviceMonitorLoop();
            }
        }.start();
    }

    void stop() {
        this.mQuit = true;
        try {
            if (this.mMainAdbConnection != null) {
                this.mMainAdbConnection.close();
            }
        }
        catch (IOException iOException) {}
        if (this.mSelector != null) {
            this.mSelector.wakeup();
        }
    }

    boolean isMonitoring() {
        return this.mMonitoring;
    }

    int getConnectionAttemptCount() {
        return this.mConnectionAttempt;
    }

    int getRestartAttemptCount() {
        return this.mRestartAttemptCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Device[] getDevices() {
        ArrayList<Device> arrayList = this.mDevices;
        synchronized (arrayList) {
            return this.mDevices.toArray(new Device[this.mDevices.size()]);
        }
    }

    boolean hasInitialDeviceList() {
        return this.mInitialDeviceListDone;
    }

    AndroidDebugBridge getServer() {
        return this.mServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClientToDropAndReopen(Client client, int n) {
        HashMap<Client, Integer> hashMap = this.mClientsToReopen;
        synchronized (hashMap) {
            Log.d("DeviceMonitor", "Adding " + client + " to list of client to reopen (" + n + ").");
            if (this.mClientsToReopen.get(client) == null) {
                this.mClientsToReopen.put(client, n);
            }
        }
        this.mSelector.wakeup();
    }

    private void deviceMonitorLoop() {
        do {
            try {
                int n;
                if (this.mMainAdbConnection == null) {
                    Log.d("DeviceMonitor", "Opening adb connection");
                    this.mMainAdbConnection = this.openAdbConnection();
                    if (this.mMainAdbConnection == null) {
                        ++this.mConnectionAttempt;
                        Log.e("DeviceMonitor", "Connection attempts: " + this.mConnectionAttempt);
                        if (this.mConnectionAttempt > 10) {
                            if (!this.mServer.startAdb()) {
                                ++this.mRestartAttemptCount;
                                Log.e("DeviceMonitor", "adb restart attempts: " + this.mRestartAttemptCount);
                            } else {
                                this.mRestartAttemptCount = 0;
                            }
                        }
                        this.waitABit();
                    } else {
                        Log.d("DeviceMonitor", "Connected to adb for device monitoring");
                        this.mConnectionAttempt = 0;
                    }
                }
                if (this.mMainAdbConnection != null && !this.mMonitoring) {
                    this.mMonitoring = this.sendDeviceListMonitoringRequest();
                }
                if (!this.mMonitoring || (n = this.readLength(this.mMainAdbConnection, this.mLengthBuffer)) < 0) continue;
                this.processIncomingDeviceData(n);
                this.mInitialDeviceListDone = true;
            }
            catch (AsynchronousCloseException asynchronousCloseException) {
            }
            catch (IOException iOException) {
                if (this.mQuit) continue;
                Log.e("DeviceMonitor", "Adb connection Error:" + iOException.getMessage());
                this.mMonitoring = false;
                if (this.mMainAdbConnection == null) continue;
                try {
                    this.mMainAdbConnection.close();
                }
                catch (IOException iOException2) {}
                this.mMainAdbConnection = null;
            }
        } while (!this.mQuit);
    }

    private void waitABit() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    private SocketChannel openAdbConnection() {
        Log.d("DeviceMonitor", "Connecting to adb for Device List Monitoring...");
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open(AndroidDebugBridge.sSocketAddr);
            socketChannel.socket().setTcpNoDelay(true);
        }
        catch (IOException iOException) {}
        return socketChannel;
    }

    private boolean sendDeviceListMonitoringRequest() throws IOException {
        byte[] byArray = AdbHelper.formAdbRequest("host:track-devices");
        if (!AdbHelper.write(this.mMainAdbConnection, byArray)) {
            Log.e("DeviceMonitor", "Sending Tracking request failed!");
            this.mMainAdbConnection.close();
            throw new IOException("Sending Tracking request failed!");
        }
        AdbHelper.AdbResponse adbResponse = AdbHelper.readAdbResponse(this.mMainAdbConnection, false);
        if (!adbResponse.ioSuccess) {
            Log.e("DeviceMonitor", "Failed to read the adb response!");
            this.mMainAdbConnection.close();
            throw new IOException("Failed to read the adb response!");
        }
        if (!adbResponse.okay) {
            Log.e("DeviceMonitor", "adb refused request: " + adbResponse.message);
        }
        return adbResponse.okay;
    }

    private void processIncomingDeviceData(int n) throws IOException {
        ArrayList<Device> arrayList = new ArrayList<Device>();
        if (n > 0) {
            String[] stringArray;
            byte[] byArray = new byte[n];
            String string = this.read(this.mMainAdbConnection, byArray);
            String[] stringArray2 = stringArray = string.split("\n");
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringArray2[n3];
                String[] stringArray3 = string2.split("\t");
                if (stringArray3.length == 2) {
                    Device device = new Device(this, stringArray3[0], IDevice.DeviceState.getState(stringArray3[1]));
                    arrayList.add(device);
                }
                ++n3;
            }
        }
        this.updateDevices(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDevices(ArrayList<Device> arrayList) {
        Object object = AndroidDebugBridge.getLock();
        synchronized (object) {
            ArrayList<Device> arrayList2 = this.mDevices;
            synchronized (arrayList2) {
                int n = 0;
                while (n < this.mDevices.size()) {
                    Device device = this.mDevices.get(n);
                    int n2 = arrayList.size();
                    boolean bl = false;
                    int n3 = 0;
                    while (n3 < n2) {
                        Device device2 = arrayList.get(n3);
                        if (device2.getSerialNumber().equals(device.getSerialNumber())) {
                            bl = true;
                            if (device.getState() != device2.getState()) {
                                device.setState(device2.getState());
                                device.update(1);
                                if (device.isOnline()) {
                                    if (AndroidDebugBridge.getClientSupport() && !this.startMonitoringDevice(device)) {
                                        Log.e("DeviceMonitor", "Failed to start monitoring " + device.getSerialNumber());
                                    }
                                    if (device.getPropertyCount() == 0) {
                                        this.queryNewDeviceForInfo(device);
                                    }
                                }
                            }
                            arrayList.remove(n3);
                            break;
                        }
                        ++n3;
                    }
                    if (!bl) {
                        this.removeDevice(device);
                        this.mServer.deviceDisconnected(device);
                        continue;
                    }
                    ++n;
                }
                for (Device device : arrayList) {
                    this.mDevices.add(device);
                    this.mServer.deviceConnected(device);
                    if (AndroidDebugBridge.getClientSupport() && device.isOnline()) {
                        this.startMonitoringDevice(device);
                    }
                    if (!device.isOnline()) continue;
                    this.queryNewDeviceForInfo(device);
                }
            }
        }
        arrayList.clear();
    }

    private void removeDevice(Device device) {
        device.clearClientList();
        this.mDevices.remove(device);
        SocketChannel socketChannel = device.getClientMonitoringSocket();
        if (socketChannel != null) {
            try {
                socketChannel.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void queryNewDeviceForInfo(Device device) {
        try {
            EmulatorConsole emulatorConsole;
            device.executeShellCommand("getprop", new GetPropReceiver(device));
            if (device.isEmulator() && (emulatorConsole = EmulatorConsole.getConsole(device)) != null) {
                device.setAvdName(emulatorConsole.getAvdName());
            }
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startMonitoringDevice(Device device) {
        block9: {
            SocketChannel socketChannel = this.openAdbConnection();
            if (socketChannel != null) {
                try {
                    boolean bl = this.sendDeviceMonitoringRequest(socketChannel, device);
                    if (!bl) break block9;
                    if (this.mSelector == null) {
                        this.startDeviceMonitorThread();
                    }
                    device.setClientMonitoringSocket(socketChannel);
                    ArrayList<Device> arrayList = this.mDevices;
                    synchronized (arrayList) {
                        this.mSelector.wakeup();
                        socketChannel.configureBlocking(false);
                        socketChannel.register(this.mSelector, 1, device);
                    }
                    return true;
                }
                catch (IOException iOException) {
                    try {
                        socketChannel.close();
                    }
                    catch (IOException iOException2) {}
                    Log.d("DeviceMonitor", "Connection Failure when starting to monitor device '" + device + "' : " + iOException.getMessage());
                }
            }
        }
        return false;
    }

    private void startDeviceMonitorThread() throws IOException {
        this.mSelector = Selector.open();
        new Thread("Device Client Monitor"){

            public void run() {
                DeviceMonitor.this.deviceClientMonitorLoop();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void deviceClientMonitorLoop() {
        do {
            try {
                v0 = this.mDevices;
                ** synchronized (v0)
lbl5:
                // 1 sources

                var1_1 = this.mSelector.select();
                if (this.mQuit) {
                    return;
                }
                var2_2 = this.mClientsToReopen;
                synchronized (var2_2) {
                    if (this.mClientsToReopen.size() > 0) {
                        var3_3 = this.mClientsToReopen.keySet();
                        var4_4 = MonitorThread.getInstance();
                        var6_6 = var3_3.iterator();
                        while (var6_6.hasNext()) {
                            var5_5 = var6_6.next();
                            var7_7 = var5_5.getDeviceImpl();
                            var8_8 = var5_5.getClientData().getPid();
                            var4_4.dropClient((Client)var5_5, false);
                            this.waitABit();
                            var9_10 = this.mClientsToReopen.get(var5_5);
                            if (var9_10 == -1) {
                                var9_10 = this.getNextDebuggerPort();
                            }
                            Log.d("DeviceMonitor", "Reopening " + var5_5);
                            this.openClient((Device)var7_7, var8_8, var9_10, (MonitorThread)var4_4);
                            var7_7.update(2);
                        }
                        this.mClientsToReopen.clear();
                    }
                }
                if (var1_1 == 0) continue;
                var2_2 = this.mSelector.selectedKeys();
                var3_3 = var2_2.iterator();
                while (var3_3.hasNext()) {
                    var4_4 = (SelectionKey)var3_3.next();
                    var3_3.remove();
                    if (!var4_4.isValid() || !var4_4.isReadable() || !((var5_5 = var4_4.attachment()) instanceof Device) || (var7_7 = (var6_6 = (Device)var5_5).getClientMonitoringSocket()) == null) continue;
                    try {
                        var8_8 = this.readLength((SocketChannel)var7_7, this.mLengthBuffer2);
                        this.processIncomingJdwpData((Device)var6_6, (SocketChannel)var7_7, var8_8);
                    }
                    catch (IOException var8_9) {
                        Log.d("DeviceMonitor", "Error reading jdwp list: " + var8_9.getMessage());
                        var7_7.close();
                        var9_11 = this.mDevices;
                        synchronized (var9_11) {
                            if (this.mDevices.contains(var6_6)) {
                                Log.d("DeviceMonitor", "Restarting monitoring service for " + var6_6);
                                this.startMonitoringDevice((Device)var6_6);
                            }
                        }
                    }
                }
            }
            catch (IOException v3) {}
        } while (!this.mQuit);
    }

    private boolean sendDeviceMonitoringRequest(SocketChannel socketChannel, Device device) throws IOException {
        AdbHelper.setDevice(socketChannel, device);
        byte[] byArray = AdbHelper.formAdbRequest("track-jdwp");
        if (!AdbHelper.write(socketChannel, byArray)) {
            Log.e("DeviceMonitor", "Sending jdwp tracking request failed!");
            socketChannel.close();
            throw new IOException();
        }
        AdbHelper.AdbResponse adbResponse = AdbHelper.readAdbResponse(socketChannel, false);
        if (!adbResponse.ioSuccess) {
            Log.e("DeviceMonitor", "Failed to read the adb response!");
            socketChannel.close();
            throw new IOException();
        }
        if (!adbResponse.okay) {
            Log.e("DeviceMonitor", "adb refused request: " + adbResponse.message);
        }
        return adbResponse.okay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIncomingJdwpData(Device device, SocketChannel socketChannel, int n) throws IOException {
        if (n >= 0) {
            Iterator iterator;
            Object object;
            int n2;
            Object object2;
            Iterator iterator2;
            Object object3;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            if (n > 0) {
                object3 = new byte[n];
                iterator2 = this.read(socketChannel, (byte[])object3);
                String[] stringArray = ((String)((Object)iterator2)).split("\n");
                object2 = stringArray;
                n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    object = object2[n3];
                    try {
                        arrayList.add(Integer.valueOf((String)object));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    ++n3;
                }
            }
            object3 = MonitorThread.getInstance();
            iterator2 = device.getClientList();
            boolean bl = false;
            object = object3;
            synchronized (object) {
                iterator = iterator2;
                synchronized (iterator) {
                    n2 = 0;
                    while (n2 < iterator2.size()) {
                        object2 = (Client)iterator2.get(n2);
                        int n4 = ((Client)object2).getClientData().getPid();
                        Integer n5 = null;
                        for (Integer n6 : arrayList) {
                            if (n4 != n6) continue;
                            n5 = n6;
                            break;
                        }
                        if (n5 != null) {
                            arrayList.remove(n5);
                            ++n2;
                            continue;
                        }
                        ((MonitorThread)object3).dropClient((Client)object2, false);
                        bl = true;
                    }
                }
            }
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n7 = (Integer)iterator.next();
                this.openClient(device, n7, this.getNextDebuggerPort(), (MonitorThread)object3);
                bl = true;
            }
            if (bl) {
                this.mServer.deviceChanged(device, 2);
            }
        }
    }

    private void openClient(Device device, int n, int n2, MonitorThread monitorThread) {
        SocketChannel socketChannel;
        try {
            socketChannel = AdbHelper.createPassThroughConnection(AndroidDebugBridge.sSocketAddr, device, n);
            socketChannel.configureBlocking(false);
        }
        catch (UnknownHostException unknownHostException) {
            Log.d("DeviceMonitor", "Unknown Jdwp pid: " + n);
            return;
        }
        catch (IOException iOException) {
            Log.w("DeviceMonitor", "Failed to connect to client '" + n + "': " + iOException.getMessage());
            return;
        }
        this.createClient(device, n, socketChannel, n2, monitorThread);
    }

    private void createClient(Device device, int n, SocketChannel socketChannel, int n2, MonitorThread monitorThread) {
        Client client = new Client(device, socketChannel, n);
        if (client.sendHandshake()) {
            try {
                if (AndroidDebugBridge.getClientSupport()) {
                    client.listenForDebugger(n2);
                }
            }
            catch (IOException iOException) {
                client.getClientData().setDebuggerConnectionStatus(4);
                Log.e("ddms", "Can't bind to local " + n2 + " for debugger");
            }
            client.requestAllocationStatus();
        } else {
            Log.e("ddms", "Handshake with " + client + " failed!");
        }
        if (client.isValid()) {
            device.addClient(client);
            monitorThread.addClient(client);
        } else {
            client = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextDebuggerPort() {
        ArrayList<Integer> arrayList = this.mDebuggerPorts;
        synchronized (arrayList) {
            if (this.mDebuggerPorts.size() > 0) {
                int n = this.mDebuggerPorts.get(0);
                this.mDebuggerPorts.remove(0);
                if (this.mDebuggerPorts.size() == 0) {
                    this.mDebuggerPorts.add(n + 1);
                }
                return n;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPortToAvailableList(int n) {
        if (n > 0) {
            ArrayList<Integer> arrayList = this.mDebuggerPorts;
            synchronized (arrayList) {
                if (this.mDebuggerPorts.indexOf(n) == -1) {
                    int n2 = this.mDebuggerPorts.size();
                    int n3 = 0;
                    while (n3 < n2) {
                        if (n < this.mDebuggerPorts.get(n3)) {
                            this.mDebuggerPorts.add(n3, n);
                            break;
                        }
                        ++n3;
                    }
                }
            }
        }
    }

    private int readLength(SocketChannel socketChannel, byte[] byArray) throws IOException {
        String string = this.read(socketChannel, byArray);
        if (string != null) {
            try {
                return Integer.parseInt(string, 16);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new IOException("Unable to read length");
    }

    private String read(SocketChannel socketChannel, byte[] byArray) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, byArray.length);
        while (byteBuffer.position() != byteBuffer.limit()) {
            int n = socketChannel.read(byteBuffer);
            if (n >= 0) continue;
            throw new IOException("EOF");
        }
        try {
            return new String(byArray, 0, byteBuffer.position(), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

