/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.JdwpPacket;
import com.android.ddmlib.Log;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

class Debugger {
    private static final int INITIAL_BUF_SIZE = 1024;
    private static final int MAX_BUF_SIZE = 32768;
    private ByteBuffer mReadBuffer;
    private static final int PRE_DATA_BUF_SIZE = 256;
    private ByteBuffer mPreDataBuffer;
    private int mConnState;
    private static final int ST_NOT_CONNECTED = 1;
    private static final int ST_AWAIT_SHAKE = 2;
    private static final int ST_READY = 3;
    private Client mClient;
    private int mListenPort;
    private ServerSocketChannel mListenChannel;
    private SocketChannel mChannel;

    Debugger(Client client, int n) throws IOException {
        this.mClient = client;
        this.mListenPort = n;
        this.mListenChannel = ServerSocketChannel.open();
        this.mListenChannel.configureBlocking(false);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(InetAddress.getByName("localhost"), n);
        this.mListenChannel.socket().setReuseAddress(true);
        this.mListenChannel.socket().bind(inetSocketAddress);
        this.mReadBuffer = ByteBuffer.allocate(1024);
        this.mPreDataBuffer = ByteBuffer.allocate(256);
        this.mConnState = 1;
        Log.i("ddms", "Created: " + this.toString());
    }

    boolean isDebuggerAttached() {
        return this.mChannel != null;
    }

    public String toString() {
        return "[Debugger " + this.mListenPort + "-->" + this.mClient.getClientData().getPid() + (this.mConnState != 3 ? " inactive]" : " active]");
    }

    void registerListener(Selector selector) throws IOException {
        this.mListenChannel.register(selector, 16, this);
    }

    Client getClient() {
        return this.mClient;
    }

    synchronized SocketChannel accept() throws IOException {
        return this.accept(this.mListenChannel);
    }

    synchronized SocketChannel accept(ServerSocketChannel serverSocketChannel) throws IOException {
        if (serverSocketChannel != null) {
            SocketChannel socketChannel = serverSocketChannel.accept();
            if (this.mChannel != null) {
                Log.w("ddms", "debugger already talking to " + this.mClient + " on " + this.mListenPort);
                socketChannel.close();
                return null;
            }
            this.mChannel = socketChannel;
            this.mChannel.configureBlocking(false);
            this.mConnState = 2;
            return this.mChannel;
        }
        return null;
    }

    synchronized void closeData() {
        try {
            if (this.mChannel != null) {
                this.mChannel.close();
                this.mChannel = null;
                this.mConnState = 1;
                ClientData clientData = this.mClient.getClientData();
                clientData.setDebuggerConnectionStatus(1);
                this.mClient.update(2);
            }
        }
        catch (IOException iOException) {
            Log.w("ddms", "Failed to close data " + this);
        }
    }

    synchronized void close() {
        try {
            if (this.mListenChannel != null) {
                this.mListenChannel.close();
            }
            this.mListenChannel = null;
            this.closeData();
        }
        catch (IOException iOException) {
            Log.w("ddms", "Failed to close listener " + this);
        }
    }

    void read() throws IOException {
        if (this.mReadBuffer.position() == this.mReadBuffer.capacity()) {
            if (this.mReadBuffer.capacity() * 2 > 32768) {
                throw new BufferOverflowException();
            }
            Log.d("ddms", "Expanding read buffer to " + this.mReadBuffer.capacity() * 2);
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.mReadBuffer.capacity() * 2);
            this.mReadBuffer.position(0);
            byteBuffer.put(this.mReadBuffer);
            this.mReadBuffer = byteBuffer;
        }
        int n = this.mChannel.read(this.mReadBuffer);
        Log.v("ddms", "Read " + n + " bytes from " + this);
        if (n < 0) {
            throw new IOException("read failed");
        }
    }

    JdwpPacket getJdwpPacket() throws IOException {
        if (this.mConnState == 2) {
            int n = JdwpPacket.findHandshake(this.mReadBuffer);
            switch (n) {
                case 1: {
                    Log.i("ddms", "Good handshake from debugger");
                    JdwpPacket.consumeHandshake(this.mReadBuffer);
                    this.sendHandshake();
                    this.mConnState = 3;
                    ClientData clientData = this.mClient.getClientData();
                    clientData.setDebuggerConnectionStatus(3);
                    this.mClient.update(2);
                    return this.getJdwpPacket();
                }
                case 3: {
                    Log.i("ddms", "Bad handshake from debugger");
                    throw new IOException("bad handshake");
                }
                case 2: {
                    break;
                }
                default: {
                    Log.e("ddms", "Unknown packet while waiting for client handshake");
                }
            }
            return null;
        }
        if (this.mConnState == 3) {
            if (this.mReadBuffer.position() != 0) {
                Log.v("ddms", "Checking " + this.mReadBuffer.position() + " bytes");
            }
            return JdwpPacket.findPacket(this.mReadBuffer);
        }
        Log.e("ddms", "Receiving data in state = " + this.mConnState);
        return null;
    }

    void forwardPacketToClient(JdwpPacket jdwpPacket) throws IOException {
        this.mClient.sendAndConsume(jdwpPacket);
    }

    private synchronized void sendHandshake() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(JdwpPacket.HANDSHAKE_LEN);
        JdwpPacket.putHandshake(byteBuffer);
        int n = byteBuffer.position();
        byteBuffer.flip();
        if (this.mChannel.write(byteBuffer) != n) {
            throw new IOException("partial handshake write");
        }
        n = this.mPreDataBuffer.position();
        if (n > 0) {
            Log.d("ddms", "Sending " + this.mPreDataBuffer.position() + " bytes of saved data");
            this.mPreDataBuffer.flip();
            if (this.mChannel.write(this.mPreDataBuffer) != n) {
                throw new IOException("partial pre-data write");
            }
            this.mPreDataBuffer.clear();
        }
    }

    synchronized void sendAndConsume(JdwpPacket jdwpPacket) throws IOException {
        if (this.mChannel == null) {
            Log.d("ddms", "Saving packet 0x" + Integer.toHexString(jdwpPacket.getId()));
            jdwpPacket.movePacket(this.mPreDataBuffer);
        } else {
            jdwpPacket.writeAndConsume(this.mChannel);
        }
    }
}

