/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms.views;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmuilib.explorer.DeviceExplorer;
import com.android.ide.eclipse.ddms.CommonAction;
import com.android.ide.eclipse.ddms.DdmsPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class FileExplorerView
extends ViewPart
implements DdmsPlugin.ISelectionListener {
    public static final String ID = "com.android.ide.eclipse.ddms.views.FileExplorerView";
    private static final String COLUMN_NAME = "com.android.ide.eclipse.ddms.explorer.name";
    private static final String COLUMN_SIZE = "com.android.ide.eclipse.ddms.explorer.size";
    private static final String COLUMN_DATE = "com.android.ide.eclipse.ddms.explorer.data";
    private static final String COLUMN_TIME = "com.android.ide.eclipse.ddms.explorer.time";
    private static final String COLUMN_PERMISSIONS = "com.android.ide.eclipse.ddms.explorer.permissions";
    private static final String COLUMN_INFO = "com.android.ide.eclipse.ddms.explorer.info";
    private DeviceExplorer mExplorer;

    public void createPartControl(Composite composite) {
        DeviceExplorer.COLUMN_NAME = COLUMN_NAME;
        DeviceExplorer.COLUMN_SIZE = COLUMN_SIZE;
        DeviceExplorer.COLUMN_DATE = COLUMN_DATE;
        DeviceExplorer.COLUMN_TIME = COLUMN_TIME;
        DeviceExplorer.COLUMN_PERMISSIONS = COLUMN_PERMISSIONS;
        DeviceExplorer.COLUMN_INFO = COLUMN_INFO;
        this.mExplorer = new DeviceExplorer();
        this.mExplorer.setImages(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE"), PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"), DdmsPlugin.getImageLoader().loadDescriptor("android.png").createImage(), PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS"));
        CommonAction commonAction = new CommonAction("Push File..."){

            public void run() {
                FileExplorerView.this.mExplorer.pushIntoSelection();
            }
        };
        commonAction.setToolTipText("Push a file onto the device");
        commonAction.setImageDescriptor(DdmsPlugin.getImageLoader().loadDescriptor("push.png"));
        commonAction.setEnabled(false);
        CommonAction commonAction2 = new CommonAction("Pull File..."){

            public void run() {
                FileExplorerView.this.mExplorer.pullSelection();
            }
        };
        commonAction2.setToolTipText("Pull a file from the device");
        commonAction2.setImageDescriptor(DdmsPlugin.getImageLoader().loadDescriptor("pull.png"));
        commonAction2.setEnabled(false);
        CommonAction commonAction3 = new CommonAction("Delete"){

            public void run() {
                FileExplorerView.this.mExplorer.deleteSelection();
            }
        };
        commonAction3.setToolTipText("Delete the selection");
        commonAction3.setImageDescriptor(DdmsPlugin.getImageLoader().loadDescriptor("delete.png"));
        commonAction3.setEnabled(false);
        this.mExplorer.setActions(commonAction, commonAction2, commonAction3);
        IActionBars iActionBars = this.getViewSite().getActionBars();
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        iMenuManager.add((IAction)commonAction2);
        iMenuManager.add((IAction)commonAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)commonAction3);
        iToolBarManager.add((IAction)commonAction2);
        iToolBarManager.add((IAction)commonAction);
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)commonAction3);
        this.mExplorer.createPanel(composite);
        DdmsPlugin.getDefault().addSelectionListener(this);
    }

    public void setFocus() {
        this.mExplorer.setFocus();
    }

    public void selectionChanged(Client client) {
    }

    public void selectionChanged(IDevice iDevice) {
        this.mExplorer.switchDevice(iDevice);
    }

    public void selectionRemoved() {
    }
}

