/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.logcat;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.IImageLoader;
import com.android.ddmuilib.ITableFocusListener;
import com.android.ddmuilib.SelectionDependentPanel;
import com.android.ddmuilib.TableHelper;
import com.android.ddmuilib.actions.ICommonAction;
import com.android.ddmuilib.logcat.EditFilterDialog;
import com.android.ddmuilib.logcat.LogColors;
import com.android.ddmuilib.logcat.LogFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class LogPanel
extends SelectionDependentPanel {
    private static final int STRING_BUFFER_LENGTH = 10000;
    public static final int FILTER_NONE = 0;
    public static final int FILTER_MANUAL = 1;
    public static final int FILTER_AUTO_PID = 2;
    public static final int FILTER_AUTO_TAG = 3;
    public static final int FILTER_DEBUG = 4;
    public static final int COLUMN_MODE_MANUAL = 0;
    public static final int COLUMN_MODE_AUTO = 1;
    public static String PREFS_TIME;
    public static String PREFS_LEVEL;
    public static String PREFS_PID;
    public static String PREFS_TAG;
    public static String PREFS_MESSAGE;
    private static Pattern sLogPattern;
    private Composite mParent;
    private IPreferenceStore mStore;
    private TabFolder mFolders;
    private LogColors mColors;
    private ILogFilterStorageManager mFilterStorage;
    private LogCatOuputReceiver mCurrentLogCat;
    private LogMessage[] mBuffer = new LogMessage[10000];
    private int mBufferStart = -1;
    private int mBufferEnd = -1;
    private LogFilter[] mFilters;
    private LogFilter mDefaultFilter;
    private LogFilter mCurrentFilter;
    private int mFilterMode = 0;
    private IDevice mCurrentLoggedDevice = null;
    private ICommonAction mDeleteFilterAction;
    private ICommonAction mEditFilterAction;
    private ICommonAction[] mLogLevelActions;
    private LogMessageInfo mLastMessageInfo = null;
    private boolean mPendingAsyncRefresh = false;
    private IImageLoader mImageLoader;
    private String mDefaultLogSave;
    private int mColumnMode = 0;
    private Font mDisplayFont;
    private ITableFocusListener mGlobalListener;

    static {
        sLogPattern = Pattern.compile("^\\[\\s(\\d\\d-\\d\\d\\s\\d\\d:\\d\\d:\\d\\d\\.\\d+)\\s+(\\d*):(0x[0-9a-fA-F]+)\\s([VDIWE])/(.*)\\]$");
    }

    public LogPanel(IImageLoader iImageLoader, LogColors logColors, ILogFilterStorageManager iLogFilterStorageManager, int n) {
        this.mImageLoader = iImageLoader;
        this.mColors = logColors;
        this.mFilterMode = n;
        this.mFilterStorage = iLogFilterStorageManager;
        this.mStore = DdmUiPreferences.getStore();
    }

    public void setActions(ICommonAction iCommonAction, ICommonAction iCommonAction2, ICommonAction[] iCommonActionArray) {
        this.mDeleteFilterAction = iCommonAction;
        this.mEditFilterAction = iCommonAction2;
        this.mLogLevelActions = iCommonActionArray;
    }

    public void setColumnMode(int n) {
        this.mColumnMode = n;
    }

    public void setFont(Font font) {
        Object object;
        this.mDisplayFont = font;
        if (this.mFilters != null) {
            LogFilter[] logFilterArray = this.mFilters;
            int n = this.mFilters.length;
            int n2 = 0;
            while (n2 < n) {
                object = logFilterArray[n2];
                Table table = ((LogFilter)object).getTable();
                if (table != null) {
                    table.setFont(font);
                }
                ++n2;
            }
        }
        if (this.mDefaultFilter != null && (object = this.mDefaultFilter.getTable()) != null) {
            object.setFont(font);
        }
    }

    public void deviceSelected() {
        this.startLogCat(this.getCurrentDevice());
    }

    public void clientSelected() {
    }

    protected Control createControl(Composite composite) {
        this.mParent = composite;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setLayout((Layout)new GridLayout(1, false));
        this.mFolders = new TabFolder(composite2, 0);
        this.mFolders.setLayoutData((Object)new GridData(1808));
        this.mFolders.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (LogPanel.this.mCurrentFilter != null) {
                    LogPanel.this.mCurrentFilter.setSelectedState(false);
                }
                LogPanel.this.mCurrentFilter = LogPanel.this.getCurrentFilter();
                LogPanel.this.mCurrentFilter.setSelectedState(true);
                LogPanel.this.updateColumns(LogPanel.this.mCurrentFilter.getTable());
                if (LogPanel.this.mCurrentFilter.getTempFilterStatus()) {
                    LogPanel.this.initFilter(LogPanel.this.mCurrentFilter);
                }
                LogPanel.this.selectionChanged(LogPanel.this.mCurrentFilter);
            }
        });
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(768));
        composite3.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite3, 0);
        label.setText("Filter:");
        final Text text = new Text(composite3, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                LogPanel.this.updateFilteringWith(text.getText());
            }
        });
        this.createFilters();
        int n = 0;
        if (this.mDefaultFilter != null) {
            this.createTab(this.mDefaultFilter, n++, false);
        }
        if (this.mFilters != null) {
            LogFilter[] logFilterArray = this.mFilters;
            int n2 = this.mFilters.length;
            int n3 = 0;
            while (n3 < n2) {
                LogFilter logFilter = logFilterArray[n3];
                this.createTab(logFilter, n++, false);
                ++n3;
            }
        }
        return composite2;
    }

    protected void postCreation() {
    }

    public void setFocus() {
        this.mFolders.setFocus();
    }

    public void startLogCat(final IDevice iDevice) {
        if (iDevice == this.mCurrentLoggedDevice) {
            return;
        }
        if (this.mCurrentLoggedDevice != null) {
            this.stopLogCat(false);
            this.mCurrentLoggedDevice = null;
        }
        this.resetUI(false);
        if (iDevice != null) {
            this.mCurrentLogCat = new LogCatOuputReceiver();
            new Thread("Logcat"){

                public void run() {
                    while (!iDevice.isOnline() && LogPanel.this.mCurrentLogCat != null && !((LogPanel)LogPanel.this).mCurrentLogCat.isCancelled) {
                        try {
                            3.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    if (LogPanel.this.mCurrentLogCat == null || ((LogPanel)LogPanel.this).mCurrentLogCat.isCancelled) {
                        return;
                    }
                    try {
                        try {
                            LogPanel.this.mCurrentLoggedDevice = iDevice;
                            iDevice.executeShellCommand("logcat -v long", LogPanel.this.mCurrentLogCat);
                        }
                        catch (Exception exception) {
                            Log.e("Logcat", exception);
                            LogPanel.this.mCurrentLogCat = null;
                            LogPanel.this.mCurrentLoggedDevice = null;
                        }
                    }
                    finally {
                        LogPanel.this.mCurrentLogCat = null;
                        LogPanel.this.mCurrentLoggedDevice = null;
                    }
                }
            }.start();
        }
    }

    public void stopLogCat(boolean bl) {
        if (this.mCurrentLogCat != null) {
            this.mCurrentLogCat.isCancelled = true;
            this.mCurrentLogCat = null;
            int n = 0;
            while (n < 10000) {
                this.mBuffer[n] = null;
                ++n;
            }
            this.mBufferStart = -1;
            this.mBufferEnd = -1;
            this.resetFilters();
            this.resetUI(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addFilter() {
        EditFilterDialog editFilterDialog = new EditFilterDialog(this.mImageLoader, this.mFolders.getShell());
        if (!editFilterDialog.open()) return;
        LogMessage[] logMessageArray = this.mBuffer;
        synchronized (this.mBuffer) {
            LogFilter logFilter = editFilterDialog.getFilter();
            this.addFilterToArray(logFilter);
            int n = this.mFilters.length - 1;
            if (this.mDefaultFilter != null) {
                ++n;
            }
            this.createTab(logFilter, n, true);
            if (this.mDefaultFilter != null) {
                this.initDefaultFilter();
            }
            if (this.mCurrentFilter != null) {
                this.mCurrentFilter.setSelectedState(false);
            }
            this.mFolders.setSelection(n);
            logFilter.setSelectedState(true);
            this.mCurrentFilter = logFilter;
            this.selectionChanged(logFilter);
            if (this.mFilterMode == 0) {
                this.mFilterMode = 1;
            }
            this.mFilterStorage.saveFilters(this.mFilters);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void editFilter() {
        EditFilterDialog editFilterDialog;
        if (this.mCurrentFilter == null || this.mCurrentFilter == this.mDefaultFilter || !(editFilterDialog = new EditFilterDialog(this.mImageLoader, this.mFolders.getShell(), this.mCurrentFilter)).open()) return;
        LogMessage[] logMessageArray = this.mBuffer;
        synchronized (this.mBuffer) {
            this.initFilter(this.mCurrentFilter);
            if (this.mDefaultFilter != null) {
                this.initDefaultFilter();
            }
            this.mFilterStorage.saveFilters(this.mFilters);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFilter() {
        LogMessage[] logMessageArray = this.mBuffer;
        synchronized (this.mBuffer) {
            if (this.mCurrentFilter != null && this.mCurrentFilter != this.mDefaultFilter) {
                this.removeFilterFromArray(this.mCurrentFilter);
                this.mCurrentFilter.dispose();
                this.mFolders.setSelection(0);
                this.mCurrentFilter = this.mFilters.length > 0 ? this.mFilters[0] : this.mDefaultFilter;
                this.selectionChanged(this.mCurrentFilter);
                if (this.mDefaultFilter != null) {
                    this.initDefaultFilter();
                }
                this.mFilterStorage.saveFilters(this.mFilters);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        LogMessage[] logMessageArray = this.mBuffer;
        synchronized (this.mBuffer) {
            block8: {
                FileDialog fileDialog = new FileDialog(this.mParent.getShell(), 8192);
                fileDialog.setText("Save log...");
                fileDialog.setFileName("log.txt");
                String string = this.mDefaultLogSave;
                if (string == null) {
                    string = System.getProperty("user.home");
                }
                fileDialog.setFilterPath(string);
                fileDialog.setFilterNames(new String[]{"Text Files (*.txt)"});
                fileDialog.setFilterExtensions(new String[]{"*.txt"});
                String string2 = fileDialog.open();
                if (string2 == null) break block8;
                this.mDefaultLogSave = fileDialog.getFilterPath();
                Table table = this.mCurrentFilter.getTable();
                int[] nArray = table.getSelectionIndices();
                Arrays.sort(nArray);
                try {
                    FileWriter fileWriter = new FileWriter(string2);
                    int[] nArray2 = nArray;
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int n3 = nArray2[n2];
                        TableItem tableItem = table.getItem(n3);
                        LogMessage logMessage = (LogMessage)tableItem.getData();
                        String string3 = logMessage.toString();
                        fileWriter.write(string3);
                        fileWriter.write(10);
                        ++n2;
                    }
                    fileWriter.flush();
                }
                catch (IOException iOException) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LogMessage[] logMessageArray = this.mBuffer;
        synchronized (this.mBuffer) {
            int n = 0;
            while (n < 10000) {
                this.mBuffer[n] = null;
                ++n;
            }
            this.mBufferStart = -1;
            this.mBufferEnd = -1;
            LogFilter[] logFilterArray = this.mFilters;
            int n2 = this.mFilters.length;
            int n3 = 0;
            while (n3 < n2) {
                LogFilter logFilter = logFilterArray[n3];
                logFilter.clear();
                ++n3;
            }
            if (this.mDefaultFilter != null) {
                this.mDefaultFilter.clear();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void copy(Clipboard clipboard) {
        Table table = this.mCurrentFilter.getTable();
        LogPanel.copyTable(clipboard, table);
    }

    public void selectAll() {
        Table table = this.mCurrentFilter.getTable();
        table.selectAll();
    }

    public void setTableFocusListener(ITableFocusListener iTableFocusListener) {
        this.mGlobalListener = iTableFocusListener;
        LogFilter[] logFilterArray = this.mFilters;
        int n = this.mFilters.length;
        int n2 = 0;
        while (n2 < n) {
            LogFilter logFilter = logFilterArray[n2];
            Table table = logFilter.getTable();
            this.addTableToFocusListener(table);
            ++n2;
        }
        if (this.mDefaultFilter != null) {
            this.addTableToFocusListener(this.mDefaultFilter.getTable());
        }
    }

    private void addTableToFocusListener(final Table table) {
        final ITableFocusListener.IFocusedTableActivator iFocusedTableActivator = new ITableFocusListener.IFocusedTableActivator(){

            public void copy(Clipboard clipboard) {
                LogPanel.copyTable(clipboard, table);
            }

            public void selectAll() {
                table.selectAll();
            }
        };
        table.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                LogPanel.this.mGlobalListener.focusGained(iFocusedTableActivator);
            }

            public void focusLost(FocusEvent focusEvent) {
                LogPanel.this.mGlobalListener.focusLost(iFocusedTableActivator);
            }
        });
    }

    private static void copyTable(Clipboard clipboard, Table table) {
        int[] nArray = table.getSelectionIndices();
        Arrays.sort(nArray);
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            TableItem tableItem = table.getItem(n3);
            LogMessage logMessage = (LogMessage)tableItem.getData();
            String string = logMessage.toString();
            stringBuilder.append(string);
            stringBuilder.append('\n');
            ++n2;
        }
        clipboard.setContents(new Object[]{stringBuilder.toString()}, new Transfer[]{TextTransfer.getInstance()});
    }

    public void setCurrentFilterLogLevel(int n) {
        LogFilter logFilter = this.getCurrentFilter();
        logFilter.setLogLevel(n);
        this.initFilter(logFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TabItem createTab(LogFilter logFilter, int n, boolean bl) {
        LogMessage[] logMessageArray = this.mBuffer;
        synchronized (this.mBuffer) {
            TabItem tabItem = null;
            tabItem = n != -1 ? new TabItem(this.mFolders, 0, n) : new TabItem(this.mFolders, 0);
            tabItem.setText(logFilter.getName());
            Composite composite = new Composite((Composite)this.mFolders, 0);
            tabItem.setControl((Control)composite);
            composite.setLayout((Layout)new FillLayout());
            final Table table = new Table(composite, 65538);
            if (this.mDisplayFont != null) {
                table.setFont(this.mDisplayFont);
            }
            logFilter.setWidgets(tabItem, table);
            table.setHeaderVisible(true);
            table.setLinesVisible(false);
            if (this.mGlobalListener != null) {
                this.addTableToFocusListener(table);
            }
            ControlListener controlListener = null;
            if (this.mColumnMode == 1) {
                controlListener = new ControlListener(){

                    public void controlMoved(ControlEvent controlEvent) {
                    }

                    public void controlResized(ControlEvent controlEvent) {
                        Rectangle rectangle = table.getClientArea();
                        int n = table.getColumn(0).getWidth();
                        n += table.getColumn(1).getWidth();
                        n += table.getColumn(2).getWidth();
                        if (rectangle.width > (n += table.getColumn(3).getWidth())) {
                            table.getColumn(4).setWidth(rectangle.width - n);
                        }
                    }
                };
                table.addControlListener(controlListener);
            }
            TableColumn tableColumn = TableHelper.createTableColumn(table, "Time", 16384, "00-00 00:00:00", PREFS_TIME, this.mStore);
            if (this.mColumnMode == 1) {
                tableColumn.addControlListener(controlListener);
            }
            tableColumn = TableHelper.createTableColumn(table, "", 0x1000000, "D", PREFS_LEVEL, this.mStore);
            if (this.mColumnMode == 1) {
                tableColumn.addControlListener(controlListener);
            }
            tableColumn = TableHelper.createTableColumn(table, "pid", 16384, "9999", PREFS_PID, this.mStore);
            if (this.mColumnMode == 1) {
                tableColumn.addControlListener(controlListener);
            }
            tableColumn = TableHelper.createTableColumn(table, "tag", 16384, "abcdefgh", PREFS_TAG, this.mStore);
            if (this.mColumnMode == 1) {
                tableColumn.addControlListener(controlListener);
            }
            tableColumn = TableHelper.createTableColumn(table, "Message", 16384, "abcdefghijklmnopqrstuvwxyz0123456789", PREFS_MESSAGE, this.mStore);
            if (this.mColumnMode == 1) {
                tableColumn.setResizable(false);
            }
            if (bl) {
                this.initFilter(logFilter);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return tabItem;
        }
    }

    protected void updateColumns(Table table) {
        if (table != null) {
            int n = 0;
            TableColumn tableColumn = table.getColumn(n++);
            tableColumn.setWidth(this.mStore.getInt(PREFS_TIME));
            tableColumn = table.getColumn(n++);
            tableColumn.setWidth(this.mStore.getInt(PREFS_LEVEL));
            tableColumn = table.getColumn(n++);
            tableColumn.setWidth(this.mStore.getInt(PREFS_PID));
            tableColumn = table.getColumn(n++);
            tableColumn.setWidth(this.mStore.getInt(PREFS_TAG));
            tableColumn = table.getColumn(n++);
            tableColumn.setWidth(this.mStore.getInt(PREFS_MESSAGE));
        }
    }

    public void resetUI(boolean bl) {
        if (this.mFilterMode == 2 || this.mFilterMode == 3) {
            if (bl) {
                this.mFolders.dispose();
                this.mParent.pack(true);
                this.createControl(this.mParent);
            } else {
                Display display = this.mFolders.getDisplay();
                display.syncExec(new Runnable(){

                    public void run() {
                        LogPanel.this.mFolders.dispose();
                        LogPanel.this.mParent.pack(true);
                        LogPanel.this.createControl(LogPanel.this.mParent);
                    }
                });
            }
        } else if (!this.mFolders.isDisposed()) {
            if (bl) {
                this.emptyTables();
            } else {
                Display display = this.mFolders.getDisplay();
                display.syncExec(new Runnable(){

                    public void run() {
                        if (!LogPanel.this.mFolders.isDisposed()) {
                            LogPanel.this.emptyTables();
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processLogLines(String[] stringArray) {
        if (stringArray.length > 10000) {
            Log.e("LogCat", "Receiving more lines than STRING_BUFFER_LENGTH");
        }
        ArrayList<LogMessage> arrayList = new ArrayList<LogMessage>();
        LogMessage[] logMessageArray = this.mBuffer;
        synchronized (this.mBuffer) {
            String string;
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                string = stringArray2[n2];
                if (string.length() > 0) {
                    Matcher matcher = sLogPattern.matcher(string);
                    if (matcher.matches()) {
                        this.mLastMessageInfo = new LogMessageInfo();
                        this.mLastMessageInfo.time = matcher.group(1);
                        this.mLastMessageInfo.pidString = matcher.group(2);
                        this.mLastMessageInfo.pid = Integer.valueOf(this.mLastMessageInfo.pidString);
                        this.mLastMessageInfo.logLevel = Log.LogLevel.getByLetterString(matcher.group(4));
                        this.mLastMessageInfo.tag = matcher.group(5).trim();
                    } else {
                        LogMessage logMessage = new LogMessage();
                        if (this.mLastMessageInfo == null) {
                            this.mLastMessageInfo = new LogMessageInfo();
                            this.mLastMessageInfo.time = "??-?? ??:??:??.???";
                            this.mLastMessageInfo.pidString = "<unknown>";
                            this.mLastMessageInfo.pid = 0;
                            this.mLastMessageInfo.logLevel = Log.LogLevel.INFO;
                            this.mLastMessageInfo.tag = "<unknown>";
                        }
                        logMessage.data = this.mLastMessageInfo;
                        logMessage.msg = string.replaceAll("\t", "    ");
                        this.processNewMessage(logMessage);
                        arrayList.add(logMessage);
                    }
                }
                ++n2;
            }
            if (!this.mPendingAsyncRefresh) {
                this.mPendingAsyncRefresh = true;
                try {
                    string = this.mFolders.getDisplay();
                    string.asyncExec(new Runnable(){

                        public void run() {
                            LogPanel.this.asyncRefresh();
                        }
                    });
                }
                catch (SWTException sWTException) {
                    this.stopLogCat(false);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncRefresh() {
        if (!this.mFolders.isDisposed()) {
            LogMessage[] logMessageArray = this.mBuffer;
            synchronized (this.mBuffer) {
                try {
                    if (this.mFilters != null) {
                        LogFilter[] logFilterArray = this.mFilters;
                        int n = this.mFilters.length;
                        int n2 = 0;
                        while (n2 < n) {
                            LogFilter logFilter = logFilterArray[n2];
                            logFilter.flush();
                            ++n2;
                        }
                    }
                    if (this.mDefaultFilter != null) {
                        this.mDefaultFilter.flush();
                    }
                }
                finally {
                    this.mPendingAsyncRefresh = false;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        this.stopLogCat(true);
    }

    private void processNewMessage(LogMessage logMessage) {
        if (this.mFilterMode == 2 || this.mFilterMode == 3) {
            this.checkFilter(logMessage.data);
        }
        int n = -1;
        if (this.mBufferStart == -1) {
            this.mBufferStart = 0;
            n = 0;
            this.mBufferEnd = 1;
        } else {
            n = this.mBufferEnd;
            if (this.mBufferEnd == this.mBufferStart) {
                this.mBufferStart = (this.mBufferStart + 1) % 10000;
            }
            this.mBufferEnd = (this.mBufferEnd + 1) % 10000;
        }
        LogMessage logMessage2 = null;
        if (this.mBuffer[n] != null) {
            logMessage2 = this.mBuffer[n];
        }
        this.mBuffer[n] = logMessage;
        boolean bl = false;
        if (this.mFilters != null) {
            LogFilter[] logFilterArray = this.mFilters;
            int n2 = this.mFilters.length;
            int n3 = 0;
            while (n3 < n2) {
                LogFilter logFilter = logFilterArray[n3];
                bl |= logFilter.addMessage(logMessage, logMessage2);
                ++n3;
            }
        }
        if (!bl && this.mDefaultFilter != null) {
            this.mDefaultFilter.addMessage(logMessage, logMessage2);
        }
    }

    private void createFilters() {
        if (this.mFilterMode == 4 || this.mFilterMode == 1) {
            this.mFilters = this.mFilterStorage.getFilterFromStore();
            if (this.mFilters != null) {
                LogFilter[] logFilterArray = this.mFilters;
                int n = this.mFilters.length;
                int n2 = 0;
                while (n2 < n) {
                    LogFilter logFilter = logFilterArray[n2];
                    logFilter.setColors(this.mColors);
                    ++n2;
                }
            }
            if (this.mFilterStorage.requiresDefaultFilter()) {
                this.mDefaultFilter = new LogFilter("Log");
                this.mDefaultFilter.setColors(this.mColors);
                this.mDefaultFilter.setSupportsDelete(false);
                this.mDefaultFilter.setSupportsEdit(false);
            }
        } else if (this.mFilterMode == 0) {
            this.mDefaultFilter = new LogFilter("Log");
            this.mDefaultFilter.setColors(this.mColors);
            this.mDefaultFilter.setSupportsDelete(false);
            this.mDefaultFilter.setSupportsEdit(false);
        }
    }

    private boolean checkFilter(LogMessageInfo logMessageInfo) {
        return true;
    }

    private void addFilterToArray(LogFilter logFilter) {
        logFilter.setColors(this.mColors);
        if (this.mFilters != null && this.mFilters.length > 0) {
            LogFilter[] logFilterArray = new LogFilter[this.mFilters.length + 1];
            System.arraycopy(this.mFilters, 0, logFilterArray, 0, this.mFilters.length);
            logFilterArray[this.mFilters.length] = logFilter;
            this.mFilters = logFilterArray;
        } else {
            this.mFilters = new LogFilter[1];
            this.mFilters[0] = logFilter;
        }
    }

    private void removeFilterFromArray(LogFilter logFilter) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.mFilters.length) {
            if (this.mFilters[n2] == logFilter) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n != -1) {
            LogFilter[] logFilterArray = new LogFilter[this.mFilters.length - 1];
            System.arraycopy(this.mFilters, 0, logFilterArray, 0, n);
            System.arraycopy(this.mFilters, n + 1, logFilterArray, n, logFilterArray.length - n);
            this.mFilters = logFilterArray;
        }
    }

    private void initFilter(LogFilter logFilter) {
        if (!logFilter.uiReady()) {
            return;
        }
        if (logFilter == this.mDefaultFilter) {
            this.initDefaultFilter();
            return;
        }
        logFilter.clear();
        if (this.mBufferStart != -1) {
            int n = this.mBufferEnd;
            if (this.mBufferEnd < this.mBufferStart) {
                n += 10000;
            }
            int n2 = this.mBufferStart;
            while (n2 < n) {
                int n3 = n2 % 10000;
                logFilter.addMessage(this.mBuffer[n3], null);
                ++n2;
            }
        }
        logFilter.flush();
        logFilter.resetTempFilteringStatus();
    }

    private void initDefaultFilter() {
        this.mDefaultFilter.clear();
        if (this.mBufferStart != -1) {
            int n = this.mBufferEnd;
            if (this.mBufferEnd < this.mBufferStart) {
                n += 10000;
            }
            int n2 = this.mBufferStart;
            while (n2 < n) {
                int n3 = n2 % 10000;
                LogMessage logMessage = this.mBuffer[n3];
                boolean bl = false;
                LogFilter[] logFilterArray = this.mFilters;
                int n4 = this.mFilters.length;
                int n5 = 0;
                while (n5 < n4) {
                    LogFilter logFilter = logFilterArray[n5];
                    bl |= logFilter.accept(logMessage);
                    ++n5;
                }
                if (!bl) {
                    this.mDefaultFilter.addMessage(logMessage, null);
                }
                ++n2;
            }
        }
        this.mDefaultFilter.flush();
        this.mDefaultFilter.resetTempFilteringStatus();
    }

    private void resetFilters() {
        if (this.mFilterMode == 2 || this.mFilterMode == 3) {
            this.mFilters = null;
            this.createFilters();
        }
    }

    private LogFilter getCurrentFilter() {
        int n = this.mFolders.getSelectionIndex();
        if (n == 0 || this.mFilters == null) {
            return this.mDefaultFilter;
        }
        return this.mFilters[n - 1];
    }

    private void emptyTables() {
        LogFilter[] logFilterArray = this.mFilters;
        int n = this.mFilters.length;
        int n2 = 0;
        while (n2 < n) {
            LogFilter logFilter = logFilterArray[n2];
            logFilter.getTable().removeAll();
            ++n2;
        }
        if (this.mDefaultFilter != null) {
            this.mDefaultFilter.getTable().removeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFilteringWith(String string) {
        LogMessage[] logMessageArray = this.mBuffer;
        synchronized (this.mBuffer) {
            Object object;
            String[] stringArray;
            Object object2 = this.mFilters;
            int n = this.mFilters.length;
            int n2 = 0;
            while (n2 < n) {
                stringArray = object2[n2];
                stringArray.resetTempFiltering();
                ++n2;
            }
            if (this.mDefaultFilter != null) {
                this.mDefaultFilter.resetTempFiltering();
            }
            stringArray = string.split(" ");
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            n = -1;
            object2 = null;
            int n3 = 0;
            while (n3 < stringArray.length) {
                String[] stringArray2;
                object = stringArray[n3];
                if (n == -1 && ((String)object).startsWith("pid:")) {
                    stringArray2 = ((String)object).split(":");
                    if (stringArray2.length == 2 && stringArray2[1].matches("^[0-9]*$")) {
                        n = Integer.valueOf(stringArray2[1]);
                    }
                } else if (object2 == null && ((String)object).startsWith("tag:")) {
                    stringArray2 = stringArray[n3].split(":");
                    if (stringArray2.length == 2) {
                        object2 = stringArray2[1];
                    }
                } else {
                    arrayList.add((String)object);
                }
                ++n3;
            }
            if (n != -1 || object2 != null || arrayList.size() > 0) {
                String[] stringArray3 = arrayList.toArray(new String[arrayList.size()]);
                LogFilter[] logFilterArray = this.mFilters;
                int n4 = this.mFilters.length;
                int n5 = 0;
                while (n5 < n4) {
                    object = logFilterArray[n5];
                    if (n != -1) {
                        ((LogFilter)object).setTempPidFiltering(n);
                    }
                    if (object2 != null) {
                        ((LogFilter)object).setTempTagFiltering((String)object2);
                    }
                    ((LogFilter)object).setTempKeywordFiltering(stringArray3);
                    ++n5;
                }
                if (this.mDefaultFilter != null) {
                    if (n != -1) {
                        this.mDefaultFilter.setTempPidFiltering(n);
                    }
                    if (object2 != null) {
                        this.mDefaultFilter.setTempTagFiltering((String)object2);
                    }
                    this.mDefaultFilter.setTempKeywordFiltering(stringArray3);
                }
            }
            this.initFilter(this.mCurrentFilter);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void selectionChanged(LogFilter logFilter) {
        if (this.mLogLevelActions != null) {
            int n = logFilter.getLogLevel();
            int n2 = 0;
            while (n2 < this.mLogLevelActions.length) {
                ICommonAction iCommonAction = this.mLogLevelActions[n2];
                if (n2 == n - 2) {
                    iCommonAction.setChecked(true);
                } else {
                    iCommonAction.setChecked(false);
                }
                ++n2;
            }
        }
        if (this.mDeleteFilterAction != null) {
            this.mDeleteFilterAction.setEnabled(logFilter.supportsDelete());
        }
        if (this.mEditFilterAction != null) {
            this.mEditFilterAction.setEnabled(logFilter.supportsEdit());
        }
    }

    public static interface ILogFilterStorageManager {
        public LogFilter[] getFilterFromStore();

        public void saveFilters(LogFilter[] var1);

        public boolean requiresDefaultFilter();
    }

    private final class LogCatOuputReceiver
    extends MultiLineReceiver {
        public boolean isCancelled = false;

        public LogCatOuputReceiver() {
            this.setTrimLine(false);
        }

        public void processNewLines(String[] stringArray) {
            if (!this.isCancelled) {
                LogPanel.this.processLogLines(stringArray);
            }
        }

        public boolean isCancelled() {
            return this.isCancelled;
        }
    }

    protected static class LogMessage {
        public LogMessageInfo data;
        public String msg;

        protected LogMessage() {
        }

        public String toString() {
            return String.valueOf(this.data.time) + ": " + (Object)((Object)this.data.logLevel) + "/" + this.data.tag + "(" + this.data.pidString + "): " + this.msg;
        }
    }

    protected static class LogMessageInfo {
        public Log.LogLevel logLevel;
        public int pid;
        public String pidString;
        public String tag;
        public String time;

        protected LogMessageInfo() {
        }
    }

    private class PsOutputReceiver
    extends MultiLineReceiver {
        private LogFilter mFilter;
        private TabItem mTabItem;
        private int mPid;
        private boolean mDone = false;

        PsOutputReceiver(int n, LogFilter logFilter, TabItem tabItem) {
            this.mPid = n;
            this.mFilter = logFilter;
            this.mTabItem = tabItem;
        }

        public boolean isCancelled() {
            return this.mDone;
        }

        public void processNewLines(String[] stringArray) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3;
                String string = stringArray2[n2];
                if (!string.startsWith("USER") && (n3 = string.indexOf(32)) != -1) {
                    ++n3;
                    while (string.charAt(n3) == ' ') {
                        ++n3;
                    }
                    int n4 = string.indexOf(32, n3);
                    String string2 = string.substring(n3, n4);
                    int n5 = Integer.parseInt(string2);
                    if (n5 == this.mPid) {
                        n3 = string.lastIndexOf(32);
                        final String string3 = string.substring(n3 + 1);
                        this.mFilter.setName(string3);
                        Display display = LogPanel.this.mFolders.getDisplay();
                        display.asyncExec(new Runnable(){

                            public void run() {
                                PsOutputReceiver.this.mTabItem.setText(string3);
                            }
                        });
                        this.mDone = true;
                        return;
                    }
                }
                ++n2;
            }
        }
    }
}

