/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib.log.event;

import com.android.ddmlib.log.EventContainer;
import com.android.ddmlib.log.EventLogParser;
import com.android.ddmlib.log.InvalidTypeException;
import com.android.ddmuilib.log.event.EventDisplay;
import com.android.ddmuilib.log.event.SyncCommon;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jfree.chart.labels.CustomXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodValues;
import org.jfree.data.time.TimePeriodValuesCollection;
import org.jfree.data.xy.XYDataset;

public class DisplaySyncPerf
extends SyncCommon {
    CustomXYToolTipGenerator mTooltipGenerator;
    List[] mTooltips;
    private static final int DB_QUERY = 4;
    private static final int DB_WRITE = 5;
    private static final int HTTP_NETWORK = 6;
    private static final int HTTP_PROCESSING = 7;
    private static final int NUM_SERIES = 8;
    private static final String[] SERIES_NAMES = new String[]{"Calendar", "Gmail", "Feeds", "Contacts", "DB Query", "DB Write", "HTTP Response", "HTTP Processing"};
    private static final Color[] SERIES_COLORS = new Color[]{Color.MAGENTA, Color.GREEN, Color.BLUE, Color.ORANGE, Color.RED, Color.CYAN, Color.PINK, Color.DARK_GRAY};
    private static final double[] SERIES_YCOORD = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 2.0, 2.0};
    private static final int EVENT_DB_OPERATION = 52000;
    private static final int EVENT_HTTP_STATS = 52001;
    final int EVENT_DB_QUERY = 0;
    final int EVENT_DB_WRITE = 1;
    private TimePeriodValues[] mDatasets;

    public DisplaySyncPerf(String string) {
        super(string);
    }

    public Control createComposite(Composite composite, EventLogParser eventLogParser, EventDisplay.ILogColumnListener iLogColumnListener) {
        Control control = this.createCompositeChart(composite, eventLogParser, "Sync Performance");
        this.resetUI();
        return control;
    }

    void resetUI() {
        super.resetUI();
        XYPlot xYPlot = this.mChart.getXYPlot();
        xYPlot.getRangeAxis().setVisible(false);
        this.mTooltipGenerator = new CustomXYToolTipGenerator();
        this.mTooltips = new List[8];
        XYBarRenderer xYBarRenderer = new XYBarRenderer();
        xYBarRenderer.setUseYInterval(true);
        this.mDatasets = new TimePeriodValues[8];
        YIntervalTimePeriodValuesCollection yIntervalTimePeriodValuesCollection = new YIntervalTimePeriodValuesCollection(1.0);
        xYPlot.setDataset((XYDataset)yIntervalTimePeriodValuesCollection);
        xYPlot.setRenderer((XYItemRenderer)xYBarRenderer);
        int n = 0;
        while (n < 8) {
            xYBarRenderer.setSeriesPaint(n, (Paint)SERIES_COLORS[n]);
            this.mDatasets[n] = new TimePeriodValues(SERIES_NAMES[n]);
            yIntervalTimePeriodValuesCollection.addSeries(this.mDatasets[n]);
            this.mTooltips[n] = new ArrayList();
            this.mTooltipGenerator.addToolTipSeries(this.mTooltips[n]);
            xYBarRenderer.setSeriesToolTipGenerator(n, (XYToolTipGenerator)this.mTooltipGenerator);
            ++n;
        }
    }

    void newEvent(EventContainer eventContainer, EventLogParser eventLogParser) {
        super.newEvent(eventContainer, eventLogParser);
        try {
            if (eventContainer.mTag == 52000) {
                String string = eventContainer.getValueAsString(0);
                long l = (long)eventContainer.sec * 1000L + (long)eventContainer.nsec / 1000000L;
                int n = Integer.parseInt(eventContainer.getValueAsString(1));
                long l2 = Long.parseLong(eventContainer.getValueAsString(2));
                if (n == 0) {
                    this.mDatasets[4].add((TimePeriod)new SimpleTimePeriod(l - l2, l), SERIES_YCOORD[4]);
                    this.mTooltips[4].add(string);
                } else if (n == 1) {
                    this.mDatasets[5].add((TimePeriod)new SimpleTimePeriod(l - l2, l), SERIES_YCOORD[5]);
                    this.mTooltips[5].add(string);
                }
            } else if (eventContainer.mTag == 52001) {
                String string = String.valueOf(eventContainer.getValueAsString(0)) + ", tx:" + eventContainer.getValueAsString(3) + ", rx: " + eventContainer.getValueAsString(4);
                long l = (long)eventContainer.sec * 1000L + (long)eventContainer.nsec / 1000000L;
                long l3 = l - Long.parseLong(eventContainer.getValueAsString(2));
                long l4 = l3 - Long.parseLong(eventContainer.getValueAsString(1));
                this.mDatasets[6].add((TimePeriod)new SimpleTimePeriod(l4, l3), SERIES_YCOORD[6]);
                this.mDatasets[7].add((TimePeriod)new SimpleTimePeriod(l3, l), SERIES_YCOORD[7]);
                this.mTooltips[6].add(string);
                this.mTooltips[7].add(string);
            }
        }
        catch (InvalidTypeException invalidTypeException) {}
    }

    void processSyncEvent(EventContainer eventContainer, int n, long l, long l2, String string, boolean bl, int n2) {
        if (bl) {
            this.mDatasets[n].add((TimePeriod)new SimpleTimePeriod(l, l2), SERIES_YCOORD[n]);
        }
    }

    int getDisplayType() {
        return 5;
    }

    class YIntervalTimePeriodValuesCollection
    extends TimePeriodValuesCollection {
        private static final long serialVersionUID = 1L;
        private double yheight;

        YIntervalTimePeriodValuesCollection(double d) {
            this.yheight = d;
        }

        public Number getEndY(int n, int n2) {
            return this.getY(n, n2).doubleValue() + this.yheight;
        }
    }
}

