/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.Client;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmuilib.TablePanel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.experimental.chart.swt.ChartComposite;

public class SysinfoPanel
extends TablePanel
implements IShellOutputReceiver {
    private Label mLabel;
    private Button mFetchButton;
    private Combo mDisplayMode;
    private DefaultPieDataset mDataset;
    private File mDataFile;
    private FileOutputStream mTempStream;
    private int mMode = 0;
    private static final int MODE_CPU = 0;
    private static final int MODE_ALARM = 1;
    private static final int MODE_WAKELOCK = 2;
    private static final int MODE_MEMINFO = 3;
    private static final int MODE_SYNC = 4;
    private static final String[] BUGREPORT_SECTION = new String[]{"cpuinfo", "alarm", "batteryinfo", "MEMORY INFO", "content"};
    private static final String[] DUMP_COMMAND = new String[]{"dumpsys cpuinfo", "dumpsys alarm", "dumpsys batteryinfo", "cat /proc/meminfo ; procrank", "dumpsys content"};
    private static final String[] CAPTIONS = new String[]{"CPU load", "Alarms", "Wakelocks", "Memory usage", "Sync"};

    public void generateDataset(File file) {
        this.mDataset.clear();
        this.mLabel.setText("");
        if (file == null) {
            return;
        }
        try {
            BufferedReader bufferedReader = this.getBugreportReader(file);
            if (this.mMode == 0) {
                this.readCpuDataset(bufferedReader);
            } else if (this.mMode == 1) {
                this.readAlarmDataset(bufferedReader);
            } else if (this.mMode == 2) {
                this.readWakelockDataset(bufferedReader);
            } else if (this.mMode == 3) {
                this.readMeminfoDataset(bufferedReader);
            } else if (this.mMode == 4) {
                this.readSyncDataset(bufferedReader);
            }
        }
        catch (IOException iOException) {
            Log.e("DDMS", iOException);
        }
    }

    public void deviceSelected() {
        if (this.getCurrentDevice() != null) {
            this.mFetchButton.setEnabled(true);
            this.loadFromDevice();
        } else {
            this.mFetchButton.setEnabled(false);
        }
    }

    public void clientSelected() {
    }

    public void setFocus() {
        this.mDisplayMode.setFocus();
    }

    private void loadFromDevice() {
        try {
            this.initShellOutputBuffer();
            if (this.mMode == 3) {
                this.mTempStream.write("------ MEMORY INFO ------\n".getBytes());
            }
            this.getCurrentDevice().executeShellCommand(DUMP_COMMAND[this.mMode], this);
        }
        catch (IOException iOException) {
            Log.e("DDMS", iOException);
        }
    }

    void initShellOutputBuffer() throws IOException {
        this.mDataFile = File.createTempFile("ddmsfile", ".txt");
        this.mDataFile.deleteOnExit();
        this.mTempStream = new FileOutputStream(this.mDataFile);
    }

    public void addOutput(byte[] byArray, int n, int n2) {
        try {
            this.mTempStream.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            Log.e("DDMS", iOException);
        }
    }

    public void flush() {
        if (this.mTempStream != null) {
            try {
                this.mTempStream.close();
                this.generateDataset(this.mDataFile);
                this.mTempStream = null;
                this.mDataFile = null;
            }
            catch (IOException iOException) {
                Log.e("DDMS", iOException);
            }
        }
    }

    public boolean isCancelled() {
        return false;
    }

    protected Control createControl(Composite composite) {
        String string;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(1808));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new RowLayout());
        this.mDisplayMode = new Combo(composite3, 8);
        String[] stringArray = CAPTIONS;
        int n = CAPTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            this.mDisplayMode.add(string);
            ++n2;
        }
        this.mDisplayMode.select(this.mMode);
        this.mDisplayMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SysinfoPanel.this.mMode = SysinfoPanel.this.mDisplayMode.getSelectionIndex();
                if (SysinfoPanel.this.mDataFile != null) {
                    SysinfoPanel.this.generateDataset(SysinfoPanel.this.mDataFile);
                } else if (SysinfoPanel.this.getCurrentDevice() != null) {
                    SysinfoPanel.this.loadFromDevice();
                }
            }
        });
        string = new Button(composite3, 8);
        string.setText("Load from File");
        string.addSelectionListener((SelectionListener)new SelectionAdapter((Button)string){
            private final /* synthetic */ Button val$loadButton;
            {
                this.val$loadButton = button;
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(this.val$loadButton.getShell(), 4096);
                fileDialog.setText("Load bugreport");
                String string = fileDialog.open();
                if (string != null) {
                    SysinfoPanel.this.mDataFile = new File(string);
                    SysinfoPanel.this.generateDataset(SysinfoPanel.this.mDataFile);
                }
            }
        });
        this.mFetchButton = new Button(composite3, 8);
        this.mFetchButton.setText("Update from Device");
        this.mFetchButton.setEnabled(false);
        this.mFetchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SysinfoPanel.this.loadFromDevice();
            }
        });
        this.mLabel = new Label(composite2, 0);
        this.mLabel.setLayoutData((Object)new GridData(768));
        this.mDataset = new DefaultPieDataset();
        JFreeChart jFreeChart = ChartFactory.createPieChart((String)"", (PieDataset)this.mDataset, (boolean)false, (boolean)true, (boolean)false);
        ChartComposite chartComposite = new ChartComposite(composite2, 2048, jFreeChart, 420, 420, 300, 200, 3000, 3000, true, true, true, true, false, true);
        chartComposite.setLayoutData((Object)new GridData(1808));
        return composite2;
    }

    public void clientChanged(Client client, int n) {
    }

    private BufferedReader getBugreportReader(File file) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        do {
            if ((string = bufferedReader.readLine()) != null) continue;
            Log.d("DDMS", "Service not found " + string);
            break;
        } while (!string.startsWith("DUMP OF SERVICE ") && !string.startsWith("-----") || string.indexOf(BUGREPORT_SECTION[this.mMode]) <= 0);
        return bufferedReader;
    }

    private static long parseTimeMs(String string) {
        long l = 0L;
        Pattern pattern = Pattern.compile("([\\d\\.]+)\\s*([a-z]+)");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(2);
            if ("sec".equals(string2)) {
                l += (long)(Double.parseDouble(matcher.group(1)) * 1000.0);
                continue;
            }
            long l2 = Integer.parseInt(matcher.group(1));
            if ("d".equals(string2)) {
                l += l2 * 24L * 60L * 60L * 1000L;
                continue;
            }
            if ("h".equals(string2)) {
                l += l2 * 60L * 60L * 1000L;
                continue;
            }
            if ("m".equals(string2)) {
                l += l2 * 60L * 1000L;
                continue;
            }
            if ("s".equals(string2)) {
                l += l2 * 1000L;
                continue;
            }
            if (!"ms".equals(string2)) continue;
            l += l2;
        }
        return l;
    }

    void readWakelockDataset(BufferedReader bufferedReader) throws IOException {
        String string;
        Pattern pattern = Pattern.compile("Wake lock (\\S+): (.+) partial");
        Pattern pattern2 = Pattern.compile("Total: (.+) uptime");
        double d = 0.0;
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null && !string.startsWith("DUMP OF SERVICE")) {
            if (string.startsWith("Current Battery Usage Statistics")) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                double d2 = (double)SysinfoPanel.parseTimeMs(matcher.group(2)) / 1000.0;
                this.mDataset.setValue((Comparable)((Object)matcher.group(1)), d2);
                d -= d2;
                continue;
            }
            matcher = pattern2.matcher(string);
            if (!matcher.find()) continue;
            d += (double)SysinfoPanel.parseTimeMs(matcher.group(1)) / 1000.0;
        }
        if (d > 0.0) {
            this.mDataset.setValue((Comparable)((Object)"Unlocked"), d);
        }
    }

    void readAlarmDataset(BufferedReader bufferedReader) throws IOException {
        String string;
        Pattern pattern = Pattern.compile("(\\d+) alarms: Intent .*\\.([^. ]+) flags");
        while ((string = bufferedReader.readLine()) != null && !string.startsWith("DUMP OF SERVICE")) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            long l = Long.parseLong(matcher.group(1));
            String string2 = matcher.group(2);
            this.mDataset.setValue((Comparable)((Object)string2), (double)l);
        }
    }

    void readCpuDataset(BufferedReader bufferedReader) throws IOException {
        String string;
        Pattern pattern = Pattern.compile("(\\S+): (\\S+)% = (.+)% user . (.+)% kernel");
        while ((string = bufferedReader.readLine()) != null && !string.startsWith("DUMP OF SERVICE")) {
            if (string.startsWith("Load:")) {
                this.mLabel.setText(string);
                continue;
            }
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            String string2 = matcher.group(1);
            long l = Long.parseLong(matcher.group(2));
            long l2 = Long.parseLong(matcher.group(3));
            long l3 = Long.parseLong(matcher.group(4));
            if ("TOTAL".equals(string2)) {
                if (l >= 100L) continue;
                this.mDataset.setValue((Comparable)((Object)"Idle"), (double)(100L - l));
                continue;
            }
            if (l2 > 0L) {
                this.mDataset.setValue((Comparable)((Object)(String.valueOf(string2) + " (user)")), (double)l2);
            }
            if (l3 > 0L) {
                this.mDataset.setValue((Comparable)((Object)(String.valueOf(string2) + " (kernel)")), (double)(l - l2));
            }
            if (l2 != 0L || l3 != 0L || l <= 0L) continue;
            this.mDataset.setValue((Comparable)((Object)string2), (double)l);
        }
    }

    void readMeminfoDataset(BufferedReader bufferedReader) throws IOException {
        Matcher matcher;
        String string;
        Pattern pattern = Pattern.compile("(\\d+) kB");
        long l = 0L;
        long l2 = 0L;
        this.mLabel.setText("PSS in kB");
        while ((string = bufferedReader.readLine()) != null && (matcher = pattern.matcher(string)).find()) {
            long l3 = Long.parseLong(matcher.group(1));
            if (string.startsWith("MemTotal")) {
                l = l3;
                continue;
            }
            if (string.startsWith("MemFree")) {
                this.mDataset.setValue((Comparable)((Object)"Free"), (double)l3);
                l -= l3;
                continue;
            }
            if (string.startsWith("Slab")) {
                this.mDataset.setValue((Comparable)((Object)"Slab"), (double)l3);
                l -= l3;
                continue;
            }
            if (string.startsWith("PageTables")) {
                this.mDataset.setValue((Comparable)((Object)"PageTables"), (double)l3);
                l -= l3;
                continue;
            }
            if (string.startsWith("Buffers") && l3 > 0L) {
                this.mDataset.setValue((Comparable)((Object)"Buffers"), (double)l3);
                l -= l3;
                continue;
            }
            if (string.startsWith("Inactive")) {
                this.mDataset.setValue((Comparable)((Object)"Inactive"), (double)l3);
                l -= l3;
                continue;
            }
            if (!string.startsWith("MemFree")) continue;
            this.mDataset.setValue((Comparable)((Object)"Free"), (double)l3);
            l -= l3;
        }
        while ((string = bufferedReader.readLine()) != null) {
            if (string.indexOf("PROCRANK") >= 0 || string.indexOf("PID") >= 0) continue;
            if (string.indexOf("----") >= 0) break;
            long l4 = Long.parseLong(string.substring(23, 31).trim());
            String string2 = string.substring(43).trim().replace("/system/bin/", "");
            if (l4 > 2000L) {
                this.mDataset.setValue((Comparable)((Object)string2), (double)l4);
            } else {
                l2 += l4;
            }
            l -= l4;
        }
        this.mDataset.setValue((Comparable)((Object)"Other"), (double)l2);
        this.mDataset.setValue((Comparable)((Object)"Unknown"), (double)l);
    }

    void readSyncDataset(BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null && !string.startsWith("DUMP OF SERVICE")) {
            long l;
            if (!string.startsWith(" |") || string.length() <= 70) continue;
            String string2 = string.substring(3, 18).trim();
            String string3 = string.substring(61, 70).trim();
            String[] stringArray = string3.split(":");
            if (stringArray.length == 2) {
                l = Long.parseLong(stringArray[0]) * 60L + Long.parseLong(stringArray[1]);
                this.mDataset.setValue((Comparable)((Object)string2), (double)l);
                continue;
            }
            if (string3.length() != 3) continue;
            l = Long.parseLong(stringArray[0]) * 3600L + Long.parseLong(stringArray[1]) * 60L + Long.parseLong(stringArray[2]);
            this.mDataset.setValue((Comparable)((Object)string2), (double)l);
        }
    }
}

