/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.AllocationInfo;
import com.android.ddmlib.Client;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ddmuilib.StackTracePanel;
import com.android.ddmuilib.TableHelper;
import com.android.ddmuilib.TablePanel;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Table;

public class AllocationPanel
extends TablePanel {
    private static final String PREFS_ALLOC_COL_SIZE = "allocPanel.Col0";
    private static final String PREFS_ALLOC_COL_CLASS = "allocPanel.Col1";
    private static final String PREFS_ALLOC_COL_THREAD = "allocPanel.Col2";
    private static final String PREFS_ALLOC_COL_TRACE_CLASS = "allocPanel.Col3";
    private static final String PREFS_ALLOC_COL_TRACE_METHOD = "allocPanel.Col4";
    private static final String PREFS_ALLOC_SASH = "allocPanel.sash";
    private static final String PREFS_STACK_COL_CLASS = "allocPanel.stack.col0";
    private static final String PREFS_STACK_COL_METHOD = "allocPanel.stack.col1";
    private static final String PREFS_STACK_COL_FILE = "allocPanel.stack.col2";
    private static final String PREFS_STACK_COL_LINE = "allocPanel.stack.col3";
    private static final String PREFS_STACK_COL_NATIVE = "allocPanel.stack.col4";
    private Composite mAllocationBase;
    private Table mAllocationTable;
    private TableViewer mAllocationViewer;
    private StackTracePanel mStackTracePanel;
    private Table mStackTraceTable;
    private Button mEnableButton;
    private Button mRequestButton;

    protected Control createControl(Composite composite) {
        final IPreferenceStore iPreferenceStore = DdmUiPreferences.getStore();
        this.mAllocationBase = new Composite(composite, 0);
        this.mAllocationBase.setLayout((Layout)new FormLayout());
        Composite composite2 = new Composite(this.mAllocationBase, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        this.mEnableButton = new Button(composite2, 8);
        this.mEnableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Client client = AllocationPanel.this.getCurrentClient();
                int n = client.getClientData().getAllocationStatus();
                if (n == 1) {
                    client.enableAllocationTracker(false);
                } else {
                    client.enableAllocationTracker(true);
                }
                client.requestAllocationStatus();
            }
        });
        this.mRequestButton = new Button(composite2, 8);
        this.mRequestButton.setText("Get Allocations");
        this.mRequestButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AllocationPanel.this.getCurrentClient().requestAllocationDetails();
            }
        });
        this.setUpButtons(false, 0);
        this.mAllocationTable = new Table(composite2, 65538);
        GridData gridData = new GridData(1808);
        this.mAllocationTable.setLayoutData((Object)gridData);
        gridData.horizontalSpan = 2;
        this.mAllocationTable.setHeaderVisible(true);
        this.mAllocationTable.setLinesVisible(true);
        TableHelper.createTableColumn(this.mAllocationTable, "Allocation Size", 131072, "888", PREFS_ALLOC_COL_SIZE, iPreferenceStore);
        TableHelper.createTableColumn(this.mAllocationTable, "Allocated Class", 16384, "Allocated Class", PREFS_ALLOC_COL_CLASS, iPreferenceStore);
        TableHelper.createTableColumn(this.mAllocationTable, "Thread Id", 16384, "999", PREFS_ALLOC_COL_THREAD, iPreferenceStore);
        TableHelper.createTableColumn(this.mAllocationTable, "Allocated in", 16384, "utime", PREFS_ALLOC_COL_TRACE_CLASS, iPreferenceStore);
        TableHelper.createTableColumn(this.mAllocationTable, "Allocated in", 16384, "utime", PREFS_ALLOC_COL_TRACE_METHOD, iPreferenceStore);
        this.mAllocationViewer = new TableViewer(this.mAllocationTable);
        this.mAllocationViewer.setContentProvider((IContentProvider)new AllocationContentProvider());
        this.mAllocationViewer.setLabelProvider((IBaseLabelProvider)new AllocationLabelProvider());
        this.mAllocationViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                AllocationInfo allocationInfo = AllocationPanel.this.getAllocationSelection(selectionChangedEvent.getSelection());
                AllocationPanel.this.updateAllocationStackTrace(allocationInfo);
            }
        });
        final Sash sash = new Sash(this.mAllocationBase, 256);
        Color color = composite.getDisplay().getSystemColor(16);
        sash.setBackground(color);
        this.mStackTracePanel = new StackTracePanel();
        this.mStackTraceTable = this.mStackTracePanel.createPanel(this.mAllocationBase, PREFS_STACK_COL_CLASS, PREFS_STACK_COL_METHOD, PREFS_STACK_COL_FILE, PREFS_STACK_COL_LINE, PREFS_STACK_COL_NATIVE, iPreferenceStore);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment((Control)sash, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        composite2.setLayoutData((Object)formData);
        final FormData formData2 = new FormData();
        formData2.top = iPreferenceStore != null && iPreferenceStore.contains(PREFS_ALLOC_SASH) ? new FormAttachment(0, iPreferenceStore.getInt(PREFS_ALLOC_SASH)) : new FormAttachment(50, 0);
        formData2.left = new FormAttachment(0, 0);
        formData2.right = new FormAttachment(100, 0);
        sash.setLayoutData((Object)formData2);
        formData = new FormData();
        formData.top = new FormAttachment((Control)sash, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.mStackTraceTable.setLayoutData((Object)formData);
        sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rectangle = sash.getBounds();
                Rectangle rectangle2 = AllocationPanel.this.mAllocationBase.getClientArea();
                int n = rectangle2.height - rectangle.height - 100;
                event.y = Math.max(Math.min(event.y, n), 100);
                if (event.y != rectangle.y) {
                    formData2.top = new FormAttachment(0, event.y);
                    iPreferenceStore.setValue(AllocationPanel.PREFS_ALLOC_SASH, event.y);
                    AllocationPanel.this.mAllocationBase.layout();
                }
            }
        });
        return this.mAllocationBase;
    }

    public void setFocus() {
        this.mAllocationTable.setFocus();
    }

    public void clientChanged(final Client client, int n) {
        if (client == this.getCurrentClient()) {
            if ((n & 0x200) != 0) {
                try {
                    this.mAllocationTable.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            AllocationPanel.this.mAllocationViewer.refresh();
                            AllocationPanel.this.updateAllocationStackCall();
                        }
                    });
                }
                catch (SWTException sWTException) {}
            } else if ((n & 0x400) != 0) {
                try {
                    this.mAllocationTable.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            AllocationPanel.this.setUpButtons(true, client.getClientData().getAllocationStatus());
                        }
                    });
                }
                catch (SWTException sWTException) {}
            }
        }
    }

    public void deviceSelected() {
    }

    public void clientSelected() {
        if (this.mAllocationTable.isDisposed()) {
            return;
        }
        Client client = this.getCurrentClient();
        this.mStackTracePanel.setCurrentClient(client);
        this.mStackTracePanel.setViewerInput(null);
        if (client != null) {
            this.setUpButtons(true, client.getClientData().getAllocationStatus());
        } else {
            this.setUpButtons(false, 0);
        }
        this.mAllocationViewer.setInput((Object)client);
    }

    private void updateAllocationStackCall() {
        Client client = this.getCurrentClient();
        if (client != null) {
            AllocationInfo allocationInfo = this.getAllocationSelection(null);
            if (allocationInfo != null) {
                this.updateAllocationStackTrace(allocationInfo);
            } else {
                this.updateAllocationStackTrace(null);
            }
        }
    }

    private void updateAllocationStackTrace(AllocationInfo allocationInfo) {
        this.mStackTracePanel.setViewerInput(allocationInfo);
    }

    protected void setTableFocusListener() {
        this.addTableToFocusListener(this.mAllocationTable);
        this.addTableToFocusListener(this.mStackTraceTable);
    }

    private AllocationInfo getAllocationSelection(ISelection iSelection) {
        IStructuredSelection iStructuredSelection;
        Object object;
        if (iSelection == null) {
            iSelection = this.mAllocationViewer.getSelection();
        }
        if (iSelection instanceof IStructuredSelection && (object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement()) instanceof AllocationInfo) {
            return (AllocationInfo)object;
        }
        return null;
    }

    private void setUpButtons(boolean bl, int n) {
        if (bl) {
            switch (n) {
                case -1: {
                    this.mEnableButton.setText("?");
                    this.mEnableButton.setEnabled(false);
                    this.mRequestButton.setEnabled(false);
                    break;
                }
                case 0: {
                    this.mEnableButton.setText("Start Tracking");
                    this.mEnableButton.setEnabled(true);
                    this.mRequestButton.setEnabled(false);
                    break;
                }
                case 1: {
                    this.mEnableButton.setText("Stop Tracking");
                    this.mEnableButton.setEnabled(true);
                    this.mRequestButton.setEnabled(true);
                }
            }
        } else {
            this.mEnableButton.setEnabled(false);
            this.mRequestButton.setEnabled(false);
            this.mEnableButton.setText("Start Tracking");
        }
    }

    private static class AllocationContentProvider
    implements IStructuredContentProvider {
        private AllocationContentProvider() {
        }

        public Object[] getElements(Object object) {
            Object[] objectArray;
            if (object instanceof Client && (objectArray = ((Client)object).getClientData().getAllocations()) != null) {
                return objectArray;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private static class AllocationLabelProvider
    implements ITableLabelProvider {
        private AllocationLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof AllocationInfo) {
                AllocationInfo allocationInfo = (AllocationInfo)object;
                switch (n) {
                    case 0: {
                        return Integer.toString(allocationInfo.getSize());
                    }
                    case 1: {
                        return allocationInfo.getAllocatedClass();
                    }
                    case 2: {
                        return Short.toString(allocationInfo.getThreadId());
                    }
                    case 3: {
                        StackTraceElement[] stackTraceElementArray = allocationInfo.getStackTrace();
                        if (stackTraceElementArray.length <= 0) break;
                        return stackTraceElementArray[0].getClassName();
                    }
                    case 4: {
                        StackTraceElement[] stackTraceElementArray = allocationInfo.getStackTrace();
                        if (stackTraceElementArray.length <= 0) break;
                        return stackTraceElementArray[0].getMethodName();
                    }
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }
}

