/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.testrunner;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.InstrumentationResultParser;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;

public class RemoteAndroidTestRunner {
    private final String mPackageName;
    private final String mRunnerName;
    private IDevice mRemoteDevice;
    private Map<String, String> mArgMap;
    private InstrumentationResultParser mParser;
    private static final String LOG_TAG = "RemoteAndroidTest";
    private static final String DEFAULT_RUNNER_NAME = "android.test.InstrumentationTestRunner";
    private static final char CLASS_SEPARATOR = ',';
    private static final char METHOD_SEPARATOR = '#';
    private static final char RUNNER_SEPARATOR = '/';
    private static final String CLASS_ARG_NAME = "class";
    private static final String LOG_ARG_NAME = "log";
    private static final String DEBUG_ARG_NAME = "debug";
    private static final String COVERAGE_ARG_NAME = "coverage";
    private static final String PACKAGE_ARG_NAME = "package";

    public RemoteAndroidTestRunner(String string, String string2, IDevice iDevice) {
        this.mPackageName = string;
        this.mRunnerName = string2;
        this.mRemoteDevice = iDevice;
        this.mArgMap = new Hashtable<String, String>();
    }

    public RemoteAndroidTestRunner(String string, IDevice iDevice) {
        this(string, null, iDevice);
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getRunnerName() {
        if (this.mRunnerName == null) {
            return DEFAULT_RUNNER_NAME;
        }
        return this.mRunnerName;
    }

    private String getRunnerPath() {
        return String.valueOf(this.getPackageName()) + '/' + this.getRunnerName();
    }

    public void setClassName(String string) {
        this.addInstrumentationArg(CLASS_ARG_NAME, string);
    }

    public void setClassNames(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < stringArray.length) {
            if (n != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(stringArray[n]);
            ++n;
        }
        this.setClassName(stringBuilder.toString());
    }

    public void setMethodName(String string, String string2) {
        this.setClassName(String.valueOf(string) + '#' + string2);
    }

    public void setTestPackageName(String string) {
        this.addInstrumentationArg(PACKAGE_ARG_NAME, string);
    }

    public void addInstrumentationArg(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("name or value arguments cannot be null");
        }
        this.mArgMap.put(string, string2);
    }

    public void addBooleanArg(String string, boolean bl) {
        this.addInstrumentationArg(string, Boolean.toString(bl));
    }

    public void setLogOnly(boolean bl) {
        this.addBooleanArg(LOG_ARG_NAME, bl);
    }

    public void setDebug(boolean bl) {
        this.addBooleanArg(DEBUG_ARG_NAME, bl);
    }

    public void setCoverage(boolean bl) {
        this.addBooleanArg(COVERAGE_ARG_NAME, bl);
    }

    public void run(ITestRunListener iTestRunListener) {
        String string = String.format("am instrument -w -r %s %s", this.getArgsCommand(), this.getRunnerPath());
        Log.d(LOG_TAG, string);
        this.mParser = new InstrumentationResultParser(iTestRunListener);
        try {
            this.mRemoteDevice.executeShellCommand(string, this.mParser);
        }
        catch (IOException iOException) {
            Log.e(LOG_TAG, iOException);
            iTestRunListener.testRunFailed(iOException.toString());
        }
    }

    public void cancel() {
        if (this.mParser != null) {
            this.mParser.cancel();
        }
    }

    private String getArgsCommand() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.mArgMap.entrySet()) {
            String string = String.format(" -e %s %s", entry.getKey(), entry.getValue());
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

