/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.NativeStackCallInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeAllocationInfo {
    private static final int FLAG_ZYGOTE_CHILD = Integer.MIN_VALUE;
    private static final int FLAG_MASK = Integer.MIN_VALUE;
    private static ArrayList<String> sAllocFunctionFilter = new ArrayList();
    private final int mSize;
    private final boolean mIsZygoteChild;
    private final int mAllocations;
    private final ArrayList<Long> mStackCallAddresses = new ArrayList();
    private ArrayList<NativeStackCallInfo> mResolvedStackCall = null;
    private boolean mIsStackCallResolved = false;

    static {
        sAllocFunctionFilter.add("malloc");
        sAllocFunctionFilter.add("calloc");
        sAllocFunctionFilter.add("realloc");
        sAllocFunctionFilter.add("get_backtrace");
        sAllocFunctionFilter.add("get_hash");
        sAllocFunctionFilter.add("??");
        sAllocFunctionFilter.add("internal_free");
        sAllocFunctionFilter.add("operator new");
        sAllocFunctionFilter.add("leak_free");
        sAllocFunctionFilter.add("chk_free");
        sAllocFunctionFilter.add("chk_memalign");
        sAllocFunctionFilter.add("Malloc");
    }

    NativeAllocationInfo(int n, int n2) {
        this.mSize = n & Integer.MAX_VALUE;
        this.mIsZygoteChild = (n & Integer.MIN_VALUE) != 0;
        this.mAllocations = n2;
    }

    void addStackCallAddress(long l) {
        this.mStackCallAddresses.add(l);
    }

    public int getSize() {
        return this.mSize;
    }

    public boolean isZygoteChild() {
        return this.mIsZygoteChild;
    }

    public int getAllocationCount() {
        return this.mAllocations;
    }

    public boolean isStackCallResolved() {
        return this.mIsStackCallResolved;
    }

    public Long[] getStackCallAddresses() {
        return this.mStackCallAddresses.toArray(new Long[this.mStackCallAddresses.size()]);
    }

    public synchronized void setResolvedStackCall(List<NativeStackCallInfo> list) {
        if (this.mResolvedStackCall == null) {
            this.mResolvedStackCall = new ArrayList();
        } else {
            this.mResolvedStackCall.clear();
        }
        this.mResolvedStackCall.addAll(list);
        this.mIsStackCallResolved = this.mResolvedStackCall.size() != 0;
    }

    public synchronized NativeStackCallInfo[] getResolvedStackCall() {
        if (this.mIsStackCallResolved) {
            return this.mResolvedStackCall.toArray(new NativeStackCallInfo[this.mResolvedStackCall.size()]);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof NativeAllocationInfo) {
            NativeAllocationInfo nativeAllocationInfo = (NativeAllocationInfo)object;
            if (this.mSize != nativeAllocationInfo.mSize || this.mAllocations != nativeAllocationInfo.mAllocations || this.mStackCallAddresses.size() != nativeAllocationInfo.mStackCallAddresses.size()) {
                return false;
            }
            int n = this.mStackCallAddresses.size();
            int n2 = 0;
            while (n2 < n) {
                long l;
                long l2 = this.mStackCallAddresses.get(n2);
                if (l2 != (l = nativeAllocationInfo.mStackCallAddresses.get(n2).longValue())) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Allocations: ");
        stringBuffer.append(this.mAllocations);
        stringBuffer.append("\n");
        stringBuffer.append("Size: ");
        stringBuffer.append(this.mSize);
        stringBuffer.append("\n");
        stringBuffer.append("Total Size: ");
        stringBuffer.append(this.mSize * this.mAllocations);
        stringBuffer.append("\n");
        Iterator<Long> iterator = this.mStackCallAddresses.iterator();
        Iterator<NativeStackCallInfo> iterator2 = this.mResolvedStackCall.iterator();
        while (iterator2.hasNext()) {
            long l = iterator.next();
            NativeStackCallInfo nativeStackCallInfo = iterator2.next();
            if (l == 0L) continue;
            if (nativeStackCallInfo.getLineNumber() != -1) {
                stringBuffer.append(String.format("\t%1$08x\t%2$s --- %3$s --- %4$s:%5$d\n", l, nativeStackCallInfo.getLibraryName(), nativeStackCallInfo.getMethodName(), nativeStackCallInfo.getSourceFile(), nativeStackCallInfo.getLineNumber()));
                continue;
            }
            stringBuffer.append(String.format("\t%1$08x\t%2$s --- %3$s --- %4$s\n", l, nativeStackCallInfo.getLibraryName(), nativeStackCallInfo.getMethodName(), nativeStackCallInfo.getSourceFile()));
        }
        return stringBuffer.toString();
    }

    public synchronized NativeStackCallInfo getRelevantStackCallInfo() {
        if (this.mIsStackCallResolved && this.mResolvedStackCall != null) {
            Iterator<NativeStackCallInfo> iterator = this.mResolvedStackCall.iterator();
            Iterator<Long> iterator2 = this.mStackCallAddresses.iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                long l = iterator2.next();
                NativeStackCallInfo nativeStackCallInfo = iterator.next();
                if (l == 0L || nativeStackCallInfo == null || !this.isRelevant(nativeStackCallInfo.getMethodName())) continue;
                return nativeStackCallInfo;
            }
            if (this.mResolvedStackCall.size() > 0) {
                return this.mResolvedStackCall.get(0);
            }
        }
        return null;
    }

    private boolean isRelevant(String string) {
        for (String string2 : sAllocFunctionFilter) {
            if (!string.contains(string2)) continue;
            return false;
        }
        return true;
    }
}

