/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.ChunkHandler;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.JdwpPacket;
import com.android.ddmlib.Log;
import com.android.ddmlib.MonitorThread;
import com.android.ddmlib.ThreadInfo;
import java.io.IOException;
import java.nio.ByteBuffer;

final class HandleThread
extends ChunkHandler {
    public static final int CHUNK_THEN = HandleThread.type("THEN");
    public static final int CHUNK_THCR = HandleThread.type("THCR");
    public static final int CHUNK_THDE = HandleThread.type("THDE");
    public static final int CHUNK_THST = HandleThread.type("THST");
    public static final int CHUNK_THNM = HandleThread.type("THNM");
    public static final int CHUNK_STKL = HandleThread.type("STKL");
    private static final HandleThread mInst = new HandleThread();
    private static volatile boolean mThreadStatusReqRunning = false;
    private static volatile boolean mThreadStackTraceReqRunning = false;

    private HandleThread() {
    }

    public static void register(MonitorThread monitorThread) {
        monitorThread.registerChunkHandler(CHUNK_THCR, mInst);
        monitorThread.registerChunkHandler(CHUNK_THDE, mInst);
        monitorThread.registerChunkHandler(CHUNK_THST, mInst);
        monitorThread.registerChunkHandler(CHUNK_THNM, mInst);
        monitorThread.registerChunkHandler(CHUNK_STKL, mInst);
    }

    public void clientReady(Client client) throws IOException {
        Log.d("ddm-thread", "Now ready: " + client);
        if (client.isThreadUpdateEnabled()) {
            HandleThread.sendTHEN(client, true);
        }
    }

    public void clientDisconnected(Client client) {
    }

    public void handleChunk(Client client, int n, ByteBuffer byteBuffer, boolean bl, int n2) {
        Log.d("ddm-thread", "handling " + ChunkHandler.name(n));
        if (n == CHUNK_THCR) {
            this.handleTHCR(client, byteBuffer);
        } else if (n == CHUNK_THDE) {
            this.handleTHDE(client, byteBuffer);
        } else if (n == CHUNK_THST) {
            this.handleTHST(client, byteBuffer);
        } else if (n == CHUNK_THNM) {
            this.handleTHNM(client, byteBuffer);
        } else if (n == CHUNK_STKL) {
            this.handleSTKL(client, byteBuffer);
        } else {
            this.handleUnknownChunk(client, n, byteBuffer, bl, n2);
        }
    }

    private void handleTHCR(Client client, ByteBuffer byteBuffer) {
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        String string = HandleThread.getString(byteBuffer, n2);
        Log.v("ddm-thread", "THCR: " + n + " '" + string + "'");
        client.getClientData().addThread(n, string);
        client.update(16);
    }

    private void handleTHDE(Client client, ByteBuffer byteBuffer) {
        int n = byteBuffer.getInt();
        Log.v("ddm-thread", "THDE: " + n);
        client.getClientData().removeThread(n);
        client.update(16);
    }

    private void handleTHST(Client client, ByteBuffer byteBuffer) {
        int n = byteBuffer.get() & 0xFF;
        int n2 = byteBuffer.get() & 0xFF;
        int n3 = byteBuffer.getShort();
        n -= 4;
        while (n-- > 0) {
            byteBuffer.get();
        }
        int n4 = n2 - 18;
        Log.v("ddm-thread", "THST: threadCount=" + n3);
        int n5 = 0;
        while (n5 < n3) {
            boolean bl = false;
            int n6 = byteBuffer.getInt();
            byte by = byteBuffer.get();
            int n7 = byteBuffer.getInt();
            int n8 = byteBuffer.getInt();
            int n9 = byteBuffer.getInt();
            if (n2 >= 18) {
                bl = byteBuffer.get() != 0;
            }
            Log.v("ddm-thread", "  id=" + n6 + ", status=" + by + ", tid=" + n7 + ", utime=" + n8 + ", stime=" + n9);
            ClientData clientData = client.getClientData();
            ThreadInfo threadInfo = clientData.getThread(n6);
            if (threadInfo != null) {
                threadInfo.updateThread(by, n7, n8, n9, bl);
            } else {
                Log.i("ddms", "Thread with id=" + n6 + " not found");
            }
            int n10 = n4;
            while (n10 > 0) {
                byteBuffer.get();
                --n10;
            }
            ++n5;
        }
        client.update(16);
    }

    private void handleTHNM(Client client, ByteBuffer byteBuffer) {
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        String string = HandleThread.getString(byteBuffer, n2);
        Log.v("ddm-thread", "THNM: " + n + " '" + string + "'");
        ThreadInfo threadInfo = client.getClientData().getThread(n);
        if (threadInfo != null) {
            threadInfo.setThreadName(string);
            client.update(16);
        } else {
            Log.i("ddms", "Thread with id=" + n + " not found");
        }
    }

    private void handleSTKL(Client client, ByteBuffer byteBuffer) {
        Object object;
        byteBuffer.getInt();
        int n = byteBuffer.getInt();
        Log.v("ddms", "STKL: " + n);
        int n2 = byteBuffer.getInt();
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = byteBuffer.getInt();
            object = HandleThread.getString(byteBuffer, n4);
            n4 = byteBuffer.getInt();
            String string = HandleThread.getString(byteBuffer, n4);
            n4 = byteBuffer.getInt();
            String string2 = n4 == 0 ? null : HandleThread.getString(byteBuffer, n4);
            int n5 = byteBuffer.getInt();
            stackTraceElementArray[n3] = new StackTraceElement((String)object, string, string2, n5);
            ++n3;
        }
        object = client.getClientData().getThread(n);
        if (object != null) {
            ((ThreadInfo)object).setStackCall(stackTraceElementArray);
            client.update(256);
        } else {
            Log.d("STKL", String.format("Got stackcall for thread %1$d, which does not exists (anymore?).", n));
        }
    }

    public static void sendTHEN(Client client, boolean bl) throws IOException {
        ByteBuffer byteBuffer = HandleThread.allocBuffer(1);
        JdwpPacket jdwpPacket = new JdwpPacket(byteBuffer);
        ByteBuffer byteBuffer2 = HandleThread.getChunkDataBuf(byteBuffer);
        if (bl) {
            byteBuffer2.put((byte)1);
        } else {
            byteBuffer2.put((byte)0);
        }
        HandleThread.finishChunkPacket(jdwpPacket, CHUNK_THEN, byteBuffer2.position());
        Log.d("ddm-thread", "Sending " + HandleThread.name(CHUNK_THEN) + ": " + bl);
        client.sendAndConsume(jdwpPacket, mInst);
    }

    public static void sendSTKL(Client client, int n) throws IOException {
        ByteBuffer byteBuffer = HandleThread.allocBuffer(4);
        JdwpPacket jdwpPacket = new JdwpPacket(byteBuffer);
        ByteBuffer byteBuffer2 = HandleThread.getChunkDataBuf(byteBuffer);
        byteBuffer2.putInt(n);
        HandleThread.finishChunkPacket(jdwpPacket, CHUNK_STKL, byteBuffer2.position());
        Log.d("ddm-thread", "Sending " + HandleThread.name(CHUNK_STKL) + ": " + n);
        client.sendAndConsume(jdwpPacket, mInst);
    }

    static void requestThreadUpdate(final Client client) {
        if (client.isDdmAware() && client.isThreadUpdateEnabled()) {
            if (mThreadStatusReqRunning) {
                Log.w("ddms", "Waiting for previous thread update req to finish");
                return;
            }
            new Thread("Thread Status Req"){

                public void run() {
                    mThreadStatusReqRunning = true;
                    try {
                        try {
                            HandleThread.sendTHST(client);
                        }
                        catch (IOException iOException) {
                            Log.i("ddms", "Unable to request thread updates from " + client + ": " + iOException.getMessage());
                            mThreadStatusReqRunning = false;
                        }
                    }
                    finally {
                        mThreadStatusReqRunning = false;
                    }
                }
            }.start();
        }
    }

    static void requestThreadStackCallRefresh(final Client client, final int n) {
        if (client.isDdmAware() && client.isThreadUpdateEnabled()) {
            if (mThreadStackTraceReqRunning) {
                Log.w("ddms", "Waiting for previous thread stack call req to finish");
                return;
            }
            new Thread("Thread Status Req"){

                public void run() {
                    mThreadStackTraceReqRunning = true;
                    try {
                        try {
                            HandleThread.sendSTKL(client, n);
                        }
                        catch (IOException iOException) {
                            Log.i("ddms", "Unable to request thread stack call updates from " + client + ": " + iOException.getMessage());
                            mThreadStackTraceReqRunning = false;
                        }
                    }
                    finally {
                        mThreadStackTraceReqRunning = false;
                    }
                }
            }.start();
        }
    }

    private static void sendTHST(Client client) throws IOException {
        ByteBuffer byteBuffer = HandleThread.allocBuffer(0);
        JdwpPacket jdwpPacket = new JdwpPacket(byteBuffer);
        ByteBuffer byteBuffer2 = HandleThread.getChunkDataBuf(byteBuffer);
        HandleThread.finishChunkPacket(jdwpPacket, CHUNK_THST, byteBuffer2.position());
        Log.d("ddm-thread", "Sending " + HandleThread.name(CHUNK_THST));
        client.sendAndConsume(jdwpPacket, mInst);
    }
}

