/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.ChunkHandler;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.JdwpPacket;
import com.android.ddmlib.Log;
import com.android.ddmlib.MonitorThread;
import com.android.ddmlib.NativeAllocationInfo;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class HandleNativeHeap
extends ChunkHandler {
    public static final int CHUNK_NHGT = HandleNativeHeap.type("NHGT");
    public static final int CHUNK_NHSG = HandleNativeHeap.type("NHSG");
    public static final int CHUNK_NHST = HandleNativeHeap.type("NHST");
    public static final int CHUNK_NHEN = HandleNativeHeap.type("NHEN");
    private static final HandleNativeHeap mInst = new HandleNativeHeap();

    private HandleNativeHeap() {
    }

    public static void register(MonitorThread monitorThread) {
        monitorThread.registerChunkHandler(CHUNK_NHGT, mInst);
        monitorThread.registerChunkHandler(CHUNK_NHSG, mInst);
        monitorThread.registerChunkHandler(CHUNK_NHST, mInst);
        monitorThread.registerChunkHandler(CHUNK_NHEN, mInst);
    }

    public void clientReady(Client client) throws IOException {
    }

    public void clientDisconnected(Client client) {
    }

    public void handleChunk(Client client, int n, ByteBuffer byteBuffer, boolean bl, int n2) {
        Log.d("ddm-nativeheap", "handling " + ChunkHandler.name(n));
        if (n == CHUNK_NHGT) {
            this.handleNHGT(client, byteBuffer);
        } else if (n == CHUNK_NHST) {
            client.getClientData().getNativeHeapData().clearHeapData();
        } else if (n == CHUNK_NHEN) {
            client.getClientData().getNativeHeapData().sealHeapData();
        } else if (n == CHUNK_NHSG) {
            this.handleNHSG(client, byteBuffer);
        } else {
            this.handleUnknownChunk(client, n, byteBuffer, bl, n2);
        }
        client.update(128);
    }

    public static void sendNHGT(Client client) throws IOException {
        ByteBuffer byteBuffer = HandleNativeHeap.allocBuffer(0);
        JdwpPacket jdwpPacket = new JdwpPacket(byteBuffer);
        ByteBuffer byteBuffer2 = HandleNativeHeap.getChunkDataBuf(byteBuffer);
        HandleNativeHeap.finishChunkPacket(jdwpPacket, CHUNK_NHGT, byteBuffer2.position());
        Log.d("ddm-nativeheap", "Sending " + HandleNativeHeap.name(CHUNK_NHGT));
        client.sendAndConsume(jdwpPacket, mInst);
        byteBuffer = HandleNativeHeap.allocBuffer(2);
        jdwpPacket = new JdwpPacket(byteBuffer);
        byteBuffer2 = HandleNativeHeap.getChunkDataBuf(byteBuffer);
        byteBuffer2.put((byte)1);
        byteBuffer2.put((byte)1);
        HandleNativeHeap.finishChunkPacket(jdwpPacket, CHUNK_NHSG, byteBuffer2.position());
        Log.d("ddm-nativeheap", "Sending " + HandleNativeHeap.name(CHUNK_NHSG));
        client.sendAndConsume(jdwpPacket, mInst);
    }

    private void handleNHGT(Client client, ByteBuffer byteBuffer) {
        ClientData clientData = client.getClientData();
        Log.d("ddm-nativeheap", "NHGT: " + byteBuffer.limit() + " bytes");
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        clientData.clearNativeAllocationInfo();
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        int n = byteBuffer2.getInt();
        int n2 = byteBuffer2.getInt();
        int n3 = byteBuffer2.getInt();
        int n4 = byteBuffer2.getInt();
        int n5 = byteBuffer2.getInt();
        Log.d("ddms", "mapSize: " + n);
        Log.d("ddms", "allocSize: " + n2);
        Log.d("ddms", "allocInfoSize: " + n3);
        Log.d("ddms", "totalMemory: " + n4);
        clientData.setTotalNativeMemory(n4);
        if (n3 == 0) {
            return;
        }
        if (n > 0) {
            byte[] byArray2 = new byte[n];
            byteBuffer2.get(byArray2, 0, n);
            this.parseMaps(clientData, byArray2);
        }
        int n6 = n2 / n3;
        int n7 = 0;
        while (n7 < n6) {
            NativeAllocationInfo nativeAllocationInfo = new NativeAllocationInfo(byteBuffer2.getInt(), byteBuffer2.getInt());
            int n8 = 0;
            while (n8 < n5) {
                long l = (long)byteBuffer2.getInt() & 0xFFFFFFFFL;
                nativeAllocationInfo.addStackCallAddress(l);
                ++n8;
            }
            clientData.addNativeAllocation(nativeAllocationInfo);
            ++n7;
        }
    }

    private void handleNHSG(Client client, ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.rewind();
        byteBuffer.get(byArray);
        byteBuffer = ByteBuffer.wrap(byArray);
        client.getClientData().getNativeHeapData().addHeapData(byteBuffer);
    }

    private void parseMaps(ClientData clientData, byte[] byArray) {
        InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream(byArray));
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        try {
            String string;
            long l = 0L;
            long l2 = 0L;
            String string2 = null;
            while ((string = bufferedReader.readLine()) != null) {
                Log.d("ddms", "line: " + string);
                if (string.length() < 16) continue;
                try {
                    int n;
                    long l3 = Long.parseLong(string.substring(0, 8), 16);
                    long l4 = Long.parseLong(string.substring(9, 17), 16);
                    if (l3 < 0x80000000L || l3 > 0xBFFFFFFFL || (n = string.indexOf(47)) == -1) continue;
                    String string3 = string.substring(n);
                    if (string2 == null || string2 != null && !string3.equals(string2)) {
                        if (string2 != null) {
                            clientData.addNativeLibraryMapInfo(l, l2, string2);
                            Log.d("ddms", String.valueOf(string2) + "(" + Long.toHexString(l) + " - " + Long.toHexString(l2) + ")");
                        }
                        string2 = string3;
                        l = l3;
                        l2 = l4;
                        continue;
                    }
                    l2 = l4;
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
            if (string2 != null) {
                clientData.addNativeLibraryMapInfo(l, l2, string2);
                Log.d("ddms", String.valueOf(string2) + "(" + Long.toHexString(l) + " - " + Long.toHexString(l2) + ")");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

