/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.DeviceMonitor;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.log.LogReceiver;
import java.io.File;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Device
implements IDevice {
    static final String RE_EMULATOR_SN = "emulator-(\\d+)";
    private String mSerialNumber = null;
    private String mAvdName = null;
    private IDevice.DeviceState mState = null;
    private final Map<String, String> mProperties = new HashMap<String, String>();
    private final ArrayList<Client> mClients = new ArrayList();
    private DeviceMonitor mMonitor;
    private static final String LOG_TAG = "Device";
    private SocketChannel mSocketChannel;

    @Override
    public String getSerialNumber() {
        return this.mSerialNumber;
    }

    @Override
    public String getAvdName() {
        return this.mAvdName;
    }

    void setAvdName(String string) {
        if (!this.isEmulator()) {
            throw new IllegalArgumentException("Cannot set the AVD name of the device is not an emulator");
        }
        this.mAvdName = string;
    }

    @Override
    public IDevice.DeviceState getState() {
        return this.mState;
    }

    void setState(IDevice.DeviceState deviceState) {
        this.mState = deviceState;
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.mProperties);
    }

    @Override
    public int getPropertyCount() {
        return this.mProperties.size();
    }

    @Override
    public String getProperty(String string) {
        return this.mProperties.get(string);
    }

    public String toString() {
        return this.mSerialNumber;
    }

    @Override
    public boolean isOnline() {
        return this.mState == IDevice.DeviceState.ONLINE;
    }

    @Override
    public boolean isEmulator() {
        return this.mSerialNumber.matches(RE_EMULATOR_SN);
    }

    @Override
    public boolean isOffline() {
        return this.mState == IDevice.DeviceState.OFFLINE;
    }

    @Override
    public boolean isBootLoader() {
        return this.mState == IDevice.DeviceState.BOOTLOADER;
    }

    @Override
    public boolean hasClients() {
        return this.mClients.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Client[] getClients() {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            return this.mClients.toArray(new Client[this.mClients.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Client getClient(String string) {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            for (Client client : this.mClients) {
                if (!string.equals(client.getClientData().getClientDescription())) continue;
                return client;
            }
        }
        return null;
    }

    @Override
    public SyncService getSyncService() throws IOException {
        SyncService syncService = new SyncService(AndroidDebugBridge.sSocketAddr, this);
        if (syncService.openSync()) {
            return syncService;
        }
        return null;
    }

    @Override
    public FileListingService getFileListingService() {
        return new FileListingService(this);
    }

    @Override
    public RawImage getScreenshot() throws IOException {
        return AdbHelper.getFrameBuffer(AndroidDebugBridge.sSocketAddr, this);
    }

    @Override
    public void executeShellCommand(String string, IShellOutputReceiver iShellOutputReceiver) throws IOException {
        AdbHelper.executeRemoteCommand(AndroidDebugBridge.sSocketAddr, string, this, iShellOutputReceiver);
    }

    @Override
    public void runEventLogService(LogReceiver logReceiver) throws IOException {
        AdbHelper.runEventLogService(AndroidDebugBridge.sSocketAddr, this, logReceiver);
    }

    @Override
    public void runLogService(String string, LogReceiver logReceiver) throws IOException {
        AdbHelper.runLogService(AndroidDebugBridge.sSocketAddr, this, string, logReceiver);
    }

    @Override
    public boolean createForward(int n, int n2) {
        try {
            return AdbHelper.createForward(AndroidDebugBridge.sSocketAddr, this, n, n2);
        }
        catch (IOException iOException) {
            Log.e("adb-forward", iOException);
            return false;
        }
    }

    @Override
    public boolean removeForward(int n, int n2) {
        try {
            return AdbHelper.removeForward(AndroidDebugBridge.sSocketAddr, this, n, n2);
        }
        catch (IOException iOException) {
            Log.e("adb-remove-forward", iOException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClientName(int n) {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            for (Client client : this.mClients) {
                if (client.getClientData().getPid() != n) continue;
                return client.getClientData().getClientDescription();
            }
        }
        return null;
    }

    Device(DeviceMonitor deviceMonitor, String string, IDevice.DeviceState deviceState) {
        this.mMonitor = deviceMonitor;
        this.mSerialNumber = string;
        this.mState = deviceState;
    }

    DeviceMonitor getMonitor() {
        return this.mMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClient(Client client) {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            this.mClients.add(client);
        }
    }

    List<Client> getClientList() {
        return this.mClients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean hasClient(int n) {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            Client client;
            Iterator<Client> iterator = this.mClients.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((client = iterator.next()).getClientData().getPid() != n);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearClientList() {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            this.mClients.clear();
        }
    }

    void setClientMonitoringSocket(SocketChannel socketChannel) {
        this.mSocketChannel = socketChannel;
    }

    SocketChannel getClientMonitoringSocket() {
        return this.mSocketChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeClient(Client client, boolean bl) {
        this.mMonitor.addPortToAvailableList(client.getDebuggerListenPort());
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            this.mClients.remove(client);
        }
        if (bl) {
            this.mMonitor.getServer().deviceChanged(this, 2);
        }
    }

    void update(int n) {
        this.mMonitor.getServer().deviceChanged(this, n);
    }

    void update(Client client, int n) {
        this.mMonitor.getServer().clientChanged(client, n);
    }

    void addProperty(String string, String string2) {
        this.mProperties.put(string, string2);
    }

    @Override
    public String installPackage(String string, boolean bl) throws IOException {
        String string2 = this.syncPackageToDevice(string);
        String string3 = this.installRemotePackage(string2, bl);
        this.removeRemotePackage(string2);
        return string3;
    }

    @Override
    public String syncPackageToDevice(String string) throws IOException {
        try {
            String string2 = this.getFileName(string);
            String string3 = String.format("/data/local/tmp/%1$s", string2);
            Log.i(string2, String.format("Uploading %1$s onto device '%2$s'", string2, this.getSerialNumber()));
            SyncService syncService = this.getSyncService();
            if (syncService != null) {
                String string4 = String.format("Uploading file onto device '%1$s'", this.getSerialNumber());
                Log.i(LOG_TAG, string4);
                SyncService.SyncResult syncResult = syncService.pushFile(string, string3, SyncService.getNullProgressMonitor());
                if (syncResult.getCode() != 0) {
                    throw new IOException(String.format("Unable to upload file: %1$s", syncResult.getMessage()));
                }
            } else {
                throw new IOException("Unable to open sync connection!");
            }
            return string3;
        }
        catch (IOException iOException) {
            Log.e(LOG_TAG, String.format("Unable to open sync connection! reason: %1$s", iOException.getMessage()));
            throw iOException;
        }
    }

    private String getFileName(String string) {
        return new File(string).getName();
    }

    @Override
    public String installRemotePackage(String string, boolean bl) throws IOException {
        InstallReceiver installReceiver = new InstallReceiver();
        String string2 = String.format(bl ? "pm install -r \"%1$s\"" : "pm install \"%1$s\"", string);
        this.executeShellCommand(string2, installReceiver);
        return installReceiver.getErrorMessage();
    }

    @Override
    public void removeRemotePackage(String string) throws IOException {
        try {
            this.executeShellCommand("rm " + string, new NullOutputReceiver());
        }
        catch (IOException iOException) {
            Log.e(LOG_TAG, String.format("Failed to delete temporary package: %1$s", iOException.getMessage()));
            throw iOException;
        }
    }

    @Override
    public String uninstallPackage(String string) throws IOException {
        InstallReceiver installReceiver = new InstallReceiver();
        this.executeShellCommand("pm uninstall " + string, installReceiver);
        return installReceiver.getErrorMessage();
    }

    private static final class InstallReceiver
    extends MultiLineReceiver {
        private static final String SUCCESS_OUTPUT = "Success";
        private static final Pattern FAILURE_PATTERN = Pattern.compile("Failure\\s+\\[(.*)\\]");
        private String mErrorMessage = null;

        public void processNewLines(String[] stringArray) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                if (string.length() > 0) {
                    if (string.startsWith(SUCCESS_OUTPUT)) {
                        this.mErrorMessage = null;
                    } else {
                        Matcher matcher = FAILURE_PATTERN.matcher(string);
                        if (matcher.matches()) {
                            this.mErrorMessage = matcher.group(1);
                        }
                    }
                }
                ++n2;
            }
        }

        public boolean isCancelled() {
            return false;
        }

        public String getErrorMessage() {
            return this.mErrorMessage;
        }
    }
}

