/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AllocationInfo;
import com.android.ddmlib.HeapSegment;
import com.android.ddmlib.NativeAllocationInfo;
import com.android.ddmlib.NativeLibraryMapInfo;
import com.android.ddmlib.ThreadInfo;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientData {
    private static final String PRE_INITIALIZED = "<pre-initialized>";
    public static final int DEBUGGER_DEFAULT = 1;
    public static final int DEBUGGER_WAITING = 2;
    public static final int DEBUGGER_ATTACHED = 3;
    public static final int DEBUGGER_ERROR = 4;
    public static final int ALLOCATION_TRACKING_UNKNOWN = -1;
    public static final int ALLOCATION_TRACKING_OFF = 0;
    public static final int ALLOCATION_TRACKING_ON = 1;
    public static final String HEAP_MAX_SIZE_BYTES = "maxSizeInBytes";
    public static final String HEAP_SIZE_BYTES = "sizeInBytes";
    public static final String HEAP_BYTES_ALLOCATED = "bytesAllocated";
    public static final String HEAP_OBJECTS_ALLOCATED = "objectsAllocated";
    private boolean mIsDdmAware;
    private final int mPid;
    private String mVmIdentifier;
    private String mClientDescription;
    private int mDebuggerInterest;
    private TreeMap<Integer, ThreadInfo> mThreadMap;
    private final HeapData mHeapData = new HeapData();
    private final HeapData mNativeHeapData = new HeapData();
    private HashMap<Integer, HashMap<String, Long>> mHeapInfoMap = new HashMap();
    private ArrayList<NativeLibraryMapInfo> mNativeLibMapInfo = new ArrayList();
    private ArrayList<NativeAllocationInfo> mNativeAllocationList = new ArrayList();
    private int mNativeTotalMemory;
    private AllocationInfo[] mAllocations;
    private int mAllocationStatus = -1;

    ClientData(int n) {
        this.mPid = n;
        this.mDebuggerInterest = 1;
        this.mThreadMap = new TreeMap();
    }

    public boolean isDdmAware() {
        return this.mIsDdmAware;
    }

    void isDdmAware(boolean bl) {
        this.mIsDdmAware = bl;
    }

    public int getPid() {
        return this.mPid;
    }

    public String getVmIdentifier() {
        return this.mVmIdentifier;
    }

    void setVmIdentifier(String string) {
        this.mVmIdentifier = string;
    }

    public String getClientDescription() {
        return this.mClientDescription;
    }

    void setClientDescription(String string) {
        if (this.mClientDescription == null && string.length() > 0 && !PRE_INITIALIZED.equals(string)) {
            this.mClientDescription = string;
        }
    }

    public int getDebuggerConnectionStatus() {
        return this.mDebuggerInterest;
    }

    void setDebuggerConnectionStatus(int n) {
        this.mDebuggerInterest = n;
    }

    synchronized void setHeapInfo(int n, long l, long l2, long l3, long l4) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put(HEAP_MAX_SIZE_BYTES, l);
        hashMap.put(HEAP_SIZE_BYTES, l2);
        hashMap.put(HEAP_BYTES_ALLOCATED, l3);
        hashMap.put(HEAP_OBJECTS_ALLOCATED, l4);
        this.mHeapInfoMap.put(n, hashMap);
    }

    public HeapData getVmHeapData() {
        return this.mHeapData;
    }

    HeapData getNativeHeapData() {
        return this.mNativeHeapData;
    }

    public synchronized Iterator<Integer> getVmHeapIds() {
        return this.mHeapInfoMap.keySet().iterator();
    }

    public synchronized Map<String, Long> getVmHeapInfo(int n) {
        return this.mHeapInfoMap.get(n);
    }

    synchronized void addThread(int n, String string) {
        ThreadInfo threadInfo = new ThreadInfo(n, string);
        this.mThreadMap.put(n, threadInfo);
    }

    synchronized void removeThread(int n) {
        this.mThreadMap.remove(n);
    }

    public synchronized ThreadInfo[] getThreads() {
        Collection<ThreadInfo> collection = this.mThreadMap.values();
        return collection.toArray(new ThreadInfo[collection.size()]);
    }

    synchronized ThreadInfo getThread(int n) {
        return this.mThreadMap.get(n);
    }

    synchronized void clearThreads() {
        this.mThreadMap.clear();
    }

    public synchronized List<NativeAllocationInfo> getNativeAllocationList() {
        return Collections.unmodifiableList(this.mNativeAllocationList);
    }

    synchronized void addNativeAllocation(NativeAllocationInfo nativeAllocationInfo) {
        this.mNativeAllocationList.add(nativeAllocationInfo);
    }

    synchronized void clearNativeAllocationInfo() {
        this.mNativeAllocationList.clear();
    }

    public synchronized int getTotalNativeMemory() {
        return this.mNativeTotalMemory;
    }

    synchronized void setTotalNativeMemory(int n) {
        this.mNativeTotalMemory = n;
    }

    synchronized void addNativeLibraryMapInfo(long l, long l2, String string) {
        this.mNativeLibMapInfo.add(new NativeLibraryMapInfo(l, l2, string));
    }

    public synchronized Iterator<NativeLibraryMapInfo> getNativeLibraryMapInfo() {
        return this.mNativeLibMapInfo.iterator();
    }

    synchronized void setAllocationStatus(boolean bl) {
        this.mAllocationStatus = bl ? 1 : 0;
    }

    public synchronized int getAllocationStatus() {
        return this.mAllocationStatus;
    }

    synchronized void setAllocations(AllocationInfo[] allocationInfoArray) {
        this.mAllocations = allocationInfoArray;
    }

    public synchronized AllocationInfo[] getAllocations() {
        return this.mAllocations;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HeapData {
        private TreeSet<HeapSegment> mHeapSegments = new TreeSet();
        private boolean mHeapDataComplete = false;
        private byte[] mProcessedHeapData;
        private Map<Integer, ArrayList<HeapSegment.HeapSegmentElement>> mProcessedHeapMap;

        public synchronized void clearHeapData() {
            this.mHeapSegments = new TreeSet();
            this.mHeapDataComplete = false;
        }

        synchronized void addHeapData(ByteBuffer byteBuffer) {
            HeapSegment heapSegment;
            if (this.mHeapDataComplete) {
                this.clearHeapData();
            }
            try {
                heapSegment = new HeapSegment(byteBuffer);
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                System.err.println("Discarding short HPSG data (length " + byteBuffer.limit() + ")");
                return;
            }
            this.mHeapSegments.add(heapSegment);
        }

        synchronized void sealHeapData() {
            this.mHeapDataComplete = true;
        }

        public boolean isHeapDataComplete() {
            return this.mHeapDataComplete;
        }

        public Collection<HeapSegment> getHeapSegments() {
            if (this.isHeapDataComplete()) {
                return this.mHeapSegments;
            }
            return null;
        }

        public void setProcessedHeapData(byte[] byArray) {
            this.mProcessedHeapData = byArray;
        }

        public byte[] getProcessedHeapData() {
            return this.mProcessedHeapData;
        }

        public void setProcessedHeapMap(Map<Integer, ArrayList<HeapSegment.HeapSegmentElement>> map) {
            this.mProcessedHeapMap = map;
        }

        public Map<Integer, ArrayList<HeapSegment.HeapSegmentElement>> getProcessedHeapMap() {
            return this.mProcessedHeapMap;
        }
    }
}

