/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.Device;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.log.LogReceiver;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;

final class AdbHelper {
    static final int WAIT_TIME = 5;
    public static final int STD_TIMEOUT = 5000;
    static final String DEFAULT_ENCODING = "ISO-8859-1";

    private AdbHelper() {
    }

    public static SocketChannel open(InetSocketAddress inetSocketAddress, Device device, int n) throws IOException {
        SocketChannel socketChannel = SocketChannel.open(inetSocketAddress);
        try {
            socketChannel.socket().setTcpNoDelay(true);
            socketChannel.configureBlocking(false);
            AdbHelper.setDevice(socketChannel, device);
            byte[] byArray = AdbHelper.createAdbForwardRequest(null, n);
            if (!AdbHelper.write(socketChannel, byArray)) {
                throw new IOException("failed submitting request to ADB");
            }
            AdbResponse adbResponse = AdbHelper.readAdbResponse(socketChannel, false);
            if (!adbResponse.okay) {
                throw new IOException("connection request rejected");
            }
            socketChannel.configureBlocking(true);
        }
        catch (IOException iOException) {
            socketChannel.close();
            throw iOException;
        }
        return socketChannel;
    }

    public static SocketChannel createPassThroughConnection(InetSocketAddress inetSocketAddress, Device device, int n) throws IOException {
        SocketChannel socketChannel = SocketChannel.open(inetSocketAddress);
        try {
            socketChannel.socket().setTcpNoDelay(true);
            socketChannel.configureBlocking(false);
            AdbHelper.setDevice(socketChannel, device);
            byte[] byArray = AdbHelper.createJdwpForwardRequest(n);
            if (!AdbHelper.write(socketChannel, byArray)) {
                throw new IOException("failed submitting request to ADB");
            }
            AdbResponse adbResponse = AdbHelper.readAdbResponse(socketChannel, false);
            if (!adbResponse.okay) {
                throw new IOException("connection request rejected: " + adbResponse.message);
            }
            socketChannel.configureBlocking(true);
        }
        catch (IOException iOException) {
            socketChannel.close();
            throw iOException;
        }
        return socketChannel;
    }

    private static byte[] createAdbForwardRequest(String string, int n) {
        String string2 = string == null ? "tcp:" + n : "tcp:" + n + ":" + string;
        return AdbHelper.formAdbRequest(string2);
    }

    private static byte[] createJdwpForwardRequest(int n) {
        String string = String.format("jdwp:%1$d", n);
        return AdbHelper.formAdbRequest(string);
    }

    static byte[] formAdbRequest(String string) {
        byte[] byArray;
        String string2 = String.format("%04X%s", string.length(), string);
        try {
            byArray = string2.getBytes(DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
        assert (byArray.length == string.length() + 4);
        return byArray;
    }

    static AdbResponse readAdbResponse(SocketChannel socketChannel, boolean bl) throws IOException {
        AdbResponse adbResponse;
        block10: {
            adbResponse = new AdbResponse();
            byte[] byArray = new byte[4];
            if (!AdbHelper.read(socketChannel, byArray)) {
                return adbResponse;
            }
            adbResponse.ioSuccess = true;
            if (AdbHelper.isOkay(byArray)) {
                adbResponse.okay = true;
            } else {
                bl = true;
                adbResponse.okay = false;
            }
            if (bl) {
                byte[] byArray2 = new byte[4];
                if (!AdbHelper.read(socketChannel, byArray2)) {
                    Log.w("ddms", "Expected diagnostic string not found");
                } else {
                    int n;
                    String string = AdbHelper.replyToString(byArray2);
                    try {
                        n = Integer.parseInt(string, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Log.w("ddms", "Expected digits, got '" + string + "': " + byArray2[0] + " " + byArray2[1] + " " + byArray2[2] + " " + byArray2[3]);
                        Log.w("ddms", "reply was " + AdbHelper.replyToString(byArray));
                        break block10;
                    }
                    byte[] byArray3 = new byte[n];
                    if (!AdbHelper.read(socketChannel, byArray3)) {
                        Log.w("ddms", "Failed reading diagnostic string, len=" + n);
                    } else {
                        adbResponse.message = AdbHelper.replyToString(byArray3);
                        Log.v("ddms", "Got reply '" + AdbHelper.replyToString(byArray) + "', diag='" + adbResponse.message + "'");
                    }
                }
            }
        }
        return adbResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RawImage getFrameBuffer(InetSocketAddress inetSocketAddress, Device device) throws IOException {
        RawImage rawImage = new RawImage();
        byte[] byArray = AdbHelper.formAdbRequest("framebuffer:");
        byte[] byArray2 = new byte[1];
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open(inetSocketAddress);
            socketChannel.configureBlocking(false);
            AdbHelper.setDevice(socketChannel, device);
            if (!AdbHelper.write(socketChannel, byArray)) {
                throw new IOException("failed asking for frame buffer");
            }
            AdbResponse adbResponse = AdbHelper.readAdbResponse(socketChannel, false);
            if (!adbResponse.ioSuccess || !adbResponse.okay) {
                Log.w("ddms", "Got timeout or unhappy response from ADB fb req: " + adbResponse.message);
                socketChannel.close();
                return null;
            }
            byte[] byArray3 = new byte[16];
            if (!AdbHelper.read(socketChannel, byArray3)) {
                Log.w("ddms", "got partial reply from ADB fb:");
                Log.hexDump("ddms", Log.LogLevel.WARN, byArray3, 0, byArray3.length);
                socketChannel.close();
                return null;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray3);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            rawImage.bpp = byteBuffer.getInt();
            rawImage.size = byteBuffer.getInt();
            rawImage.width = byteBuffer.getInt();
            rawImage.height = byteBuffer.getInt();
            Log.d("ddms", "image params: bpp=" + rawImage.bpp + ", size=" + rawImage.size + ", width=" + rawImage.width + ", height=" + rawImage.height);
            if (!AdbHelper.write(socketChannel, byArray2)) {
                throw new IOException("failed nudging");
            }
            byArray3 = new byte[rawImage.size];
            if (!AdbHelper.read(socketChannel, byArray3)) {
                Log.w("ddms", "got truncated reply from ADB fb data");
                socketChannel.close();
                return null;
            }
            rawImage.data = byArray3;
            return rawImage;
        }
        finally {
            if (socketChannel != null) {
                socketChannel.close();
            }
        }
    }

    public static void executeRemoteCommand(InetSocketAddress inetSocketAddress, String string, Device device, IShellOutputReceiver iShellOutputReceiver) throws IOException {
        Log.v("ddms", "execute: running " + string);
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open(inetSocketAddress);
            socketChannel.configureBlocking(false);
            AdbHelper.setDevice(socketChannel, device);
            byte[] byArray = AdbHelper.formAdbRequest("shell:" + string);
            if (!AdbHelper.write(socketChannel, byArray)) {
                throw new IOException("failed submitting shell command");
            }
            AdbResponse adbResponse = AdbHelper.readAdbResponse(socketChannel, false);
            if (!adbResponse.ioSuccess || !adbResponse.okay) {
                Log.e("ddms", "ADB rejected shell command (" + string + "): " + adbResponse.message);
                throw new IOException("sad result from adb: " + adbResponse.message);
            }
            byte[] byArray2 = new byte[16384];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
            while (true) {
                if (iShellOutputReceiver != null && iShellOutputReceiver.isCancelled()) {
                    Log.v("ddms", "execute: cancelled");
                    break;
                }
                int n = socketChannel.read(byteBuffer);
                if (n < 0) {
                    iShellOutputReceiver.flush();
                    Log.v("ddms", "execute '" + string + "' on '" + device + "' : EOF hit. Read: " + n);
                    break;
                }
                if (n == 0) {
                    try {
                        Thread.sleep(25L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (iShellOutputReceiver != null) {
                    iShellOutputReceiver.addOutput(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.position());
                }
                byteBuffer.rewind();
            }
        }
        finally {
            if (socketChannel != null) {
                socketChannel.close();
            }
            Log.v("ddms", "execute: returning");
        }
    }

    public static void runEventLogService(InetSocketAddress inetSocketAddress, Device device, LogReceiver logReceiver) throws IOException {
        AdbHelper.runLogService(inetSocketAddress, device, "events", logReceiver);
    }

    public static void runLogService(InetSocketAddress inetSocketAddress, Device device, String string, LogReceiver logReceiver) throws IOException {
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open(inetSocketAddress);
            socketChannel.configureBlocking(false);
            AdbHelper.setDevice(socketChannel, device);
            byte[] byArray = AdbHelper.formAdbRequest("log:" + string);
            if (!AdbHelper.write(socketChannel, byArray)) {
                throw new IOException("failed to submit the log command");
            }
            AdbResponse adbResponse = AdbHelper.readAdbResponse(socketChannel, false);
            if (!adbResponse.ioSuccess || !adbResponse.okay) {
                throw new IOException("Device rejected log command: " + adbResponse.message);
            }
            byte[] byArray2 = new byte[16384];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
            while (logReceiver == null || !logReceiver.isCancelled()) {
                int n = socketChannel.read(byteBuffer);
                if (n < 0) {
                    break;
                }
                if (n == 0) {
                    try {
                        Thread.sleep(25L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (logReceiver != null) {
                    logReceiver.parseNewData(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.position());
                }
                byteBuffer.rewind();
            }
        }
        finally {
            if (socketChannel != null) {
                socketChannel.close();
            }
        }
    }

    public static boolean createForward(InetSocketAddress inetSocketAddress, Device device, int n, int n2) throws IOException {
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open(inetSocketAddress);
            socketChannel.configureBlocking(false);
            byte[] byArray = AdbHelper.formAdbRequest(String.format("host-serial:%1$s:forward:tcp:%2$d;tcp:%3$d", device.getSerialNumber(), n, n2));
            if (!AdbHelper.write(socketChannel, byArray)) {
                throw new IOException("failed to submit the forward command.");
            }
            AdbResponse adbResponse = AdbHelper.readAdbResponse(socketChannel, false);
            if (!adbResponse.ioSuccess || !adbResponse.okay) {
                throw new IOException("Device rejected command: " + adbResponse.message);
            }
        }
        finally {
            if (socketChannel != null) {
                socketChannel.close();
            }
        }
        return true;
    }

    public static boolean removeForward(InetSocketAddress inetSocketAddress, Device device, int n, int n2) throws IOException {
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open(inetSocketAddress);
            socketChannel.configureBlocking(false);
            byte[] byArray = AdbHelper.formAdbRequest(String.format("host-serial:%1$s:killforward:tcp:%2$d;tcp:%3$d", device.getSerialNumber(), n, n2));
            if (!AdbHelper.write(socketChannel, byArray)) {
                throw new IOException("failed to submit the remove forward command.");
            }
            AdbResponse adbResponse = AdbHelper.readAdbResponse(socketChannel, false);
            if (!adbResponse.ioSuccess || !adbResponse.okay) {
                throw new IOException("Device rejected command: " + adbResponse.message);
            }
        }
        finally {
            if (socketChannel != null) {
                socketChannel.close();
            }
        }
        return true;
    }

    static boolean isOkay(byte[] byArray) {
        return byArray[0] == 79 && byArray[1] == 75 && byArray[2] == 65 && byArray[3] == 89;
    }

    static String replyToString(byte[] byArray) {
        String string;
        try {
            string = new String(byArray, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            string = "";
        }
        return string;
    }

    static boolean read(SocketChannel socketChannel, byte[] byArray) {
        try {
            AdbHelper.read(socketChannel, byArray, -1, 5000);
        }
        catch (IOException iOException) {
            Log.d("ddms", "readAll: IOException: " + iOException.getMessage());
            return false;
        }
        return true;
    }

    static void read(SocketChannel socketChannel, byte[] byArray, int n, int n2) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n != -1 ? n : byArray.length);
        int n3 = 0;
        while (byteBuffer.position() != byteBuffer.limit()) {
            int n4 = socketChannel.read(byteBuffer);
            if (n4 < 0) {
                Log.d("ddms", "read: channel EOF");
                throw new IOException("EOF");
            }
            if (n4 == 0) {
                if (n2 != 0 && n3 * 5 > n2) {
                    Log.i("ddms", "read: timeout");
                    throw new IOException("timeout");
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
                ++n3;
                continue;
            }
            n3 = 0;
        }
    }

    static boolean write(SocketChannel socketChannel, byte[] byArray) {
        try {
            AdbHelper.write(socketChannel, byArray, -1, 5000);
        }
        catch (IOException iOException) {
            Log.e("ddms", iOException);
            return false;
        }
        return true;
    }

    static void write(SocketChannel socketChannel, byte[] byArray, int n, int n2) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n != -1 ? n : byArray.length);
        int n3 = 0;
        while (byteBuffer.position() != byteBuffer.limit()) {
            int n4 = socketChannel.write(byteBuffer);
            if (n4 < 0) {
                Log.d("ddms", "write: channel EOF");
                throw new IOException("channel EOF");
            }
            if (n4 == 0) {
                if (n2 != 0 && n3 * 5 > n2) {
                    Log.i("ddms", "write: timeout");
                    throw new IOException("timeout");
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {}
                ++n3;
                continue;
            }
            n3 = 0;
        }
    }

    static void setDevice(SocketChannel socketChannel, Device device) throws IOException {
        if (device != null) {
            String string = "host:transport:" + device.getSerialNumber();
            byte[] byArray = AdbHelper.formAdbRequest(string);
            if (!AdbHelper.write(socketChannel, byArray)) {
                throw new IOException("failed submitting device (" + device + ") request to ADB");
            }
            AdbResponse adbResponse = AdbHelper.readAdbResponse(socketChannel, false);
            if (!adbResponse.okay) {
                throw new IOException("device (" + device + ") request rejected: " + adbResponse.message);
            }
        }
    }

    static class AdbResponse {
        public boolean ioSuccess;
        public boolean okay;
        public boolean timeout;
        public String message = "";
    }
}

