/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.newproject;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestParser;
import com.android.ide.eclipse.adt.internal.project.ProjectChooserHelper;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.internal.wizards.newproject.NewProjectCreationPage;
import com.android.sdklib.IAndroidTarget;
import com.android.sdkuilib.internal.widgets.SdkTargetSelector;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class NewTestProjectCreationPage
extends WizardPage {
    static final String TEST_PAGE_NAME = "newAndroidTestProjectPage";
    private static final String INITIAL_NAME = "";
    private static final boolean INITIAL_USE_DEFAULT_LOCATION = true;
    private static final boolean INITIAL_CREATE_TEST_PROJECT = false;
    private static final Pattern sProjectNamePattern = Pattern.compile("^[\\w][\\w. -]*$");
    private static String sCustomLocationOsPath = "";
    private final int MSG_NONE = 0;
    private final int MSG_WARNING = 1;
    private final int MSG_ERROR = 2;
    private final TestInfo mInfo = new TestInfo();
    private NewProjectCreationPage.IMainInfo mMainInfo;
    private Text mProjectNameField;
    private Text mPackageNameField;
    private Text mApplicationNameField;
    private Button mUseDefaultLocation;
    private Label mLocationLabel;
    private Text mLocationPathField;
    private Button mBrowseButton;
    private Text mMinSdkVersionField;
    private SdkTargetSelector mSdkTargetSelector;
    private Sdk.ITargetChangeListener mSdkTargetChangeListener;
    private Button mCreateTestProjectField;
    private Text mTestedProjectNameField;
    private Button mProjectBrowseButton;
    private ProjectChooserHelper mProjectChooserHelper;
    private Button mTestSelfProjectRadio;
    private Button mTestExistingProjectRadio;
    private ArrayList<Composite> mToggleComposites = new ArrayList();
    private boolean mInternalProjectNameUpdate;
    private boolean mInternalLocationPathUpdate;
    private boolean mInternalPackageNameUpdate;
    private boolean mInternalApplicationNameUpdate;
    private boolean mInternalMinSdkVersionUpdate;
    private boolean mInternalSdkTargetUpdate;
    private IProject mExistingTestedProject;
    private boolean mProjectNameModifiedByUser;
    private boolean mApplicationNameModifiedByUser;
    private boolean mPackageNameModifiedByUser;
    private boolean mMinSdkVersionModifiedByUser;
    private boolean mSdkTargetModifiedByUser;
    private Label mTestTargetPackageLabel;
    private String mLastExistingPackageName;

    public NewTestProjectCreationPage() {
        super(TEST_PAGE_NAME);
        this.setPageComplete(false);
        this.setTitle("New Android Test Project");
        this.setDescription("Creates a new Android Test Project resource.");
    }

    public TestInfo getTestInfo() {
        return this.mInfo;
    }

    public void setMainInfo(NewProjectCreationPage.IMainInfo iMainInfo) {
        this.mMainInfo = iMainInfo;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        this.initializeDialogUnits((Control)composite);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        this.createToggleTestProject(composite2);
        this.createTestProjectGroup(composite2);
        this.createLocationGroup(composite2);
        this.createTestTargetGroup(composite2);
        this.createTargetGroup(composite2);
        this.createPropertiesGroup(composite2);
        this.enableLocationWidgets();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite2);
        this.validatePageComplete();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.mProjectNameField.setFocus();
            this.validatePageComplete();
            this.onCreateTestProjectToggle();
            this.onExistingProjectChanged();
        }
    }

    public void dispose() {
        if (this.mSdkTargetChangeListener != null) {
            AdtPlugin.getDefault().removeTargetListener(this.mSdkTargetChangeListener);
            this.mSdkTargetChangeListener = null;
        }
        super.dispose();
    }

    private final void createToggleTestProject(Composite composite) {
        if (this.mMainInfo != null) {
            this.mCreateTestProjectField = new Button(composite, 32);
            this.mCreateTestProjectField.setText("Create a Test Project");
            this.mCreateTestProjectField.setToolTipText("Select this if you also want to create a Test Project.");
            this.mCreateTestProjectField.setSelection(false);
            this.mCreateTestProjectField.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    NewTestProjectCreationPage.this.onCreateTestProjectToggle();
                }
            });
        }
    }

    private final void createTestProjectGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        this.mToggleComposites.add(composite2);
        String string = "Name of the Eclipse test project to create. It cannot be empty.";
        Label label = new Label(composite2, 0);
        label.setText("Test Project Name:");
        label.setFont(composite.getFont());
        label.setToolTipText(string);
        this.mProjectNameField = new Text(composite2, 2048);
        GridData gridData = new GridData(768);
        this.mProjectNameField.setToolTipText(string);
        this.mProjectNameField.setLayoutData((Object)gridData);
        this.mProjectNameField.setFont(composite.getFont());
        this.mProjectNameField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (!NewTestProjectCreationPage.this.mInternalProjectNameUpdate) {
                    NewTestProjectCreationPage.this.mProjectNameModifiedByUser = true;
                }
                NewTestProjectCreationPage.this.updateLocationPathField(null);
            }
        });
    }

    private final void createLocationGroup(Composite composite) {
        Group group = new Group(composite, 16);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        group.setFont(composite.getFont());
        group.setText("Content");
        this.mToggleComposites.add((Composite)group);
        this.mUseDefaultLocation = new Button((Composite)group, 32);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.mUseDefaultLocation.setLayoutData((Object)gridData);
        this.mUseDefaultLocation.setText("Use default location");
        this.mUseDefaultLocation.setSelection(true);
        this.mUseDefaultLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                NewTestProjectCreationPage.this.enableLocationWidgets();
                NewTestProjectCreationPage.this.validatePageComplete();
            }
        });
        this.mLocationLabel = new Label((Composite)group, 0);
        this.mLocationLabel.setText("Location:");
        this.mLocationPathField = new Text((Composite)group, 2048);
        GridData gridData2 = new GridData(4, 1, true, false, 1, 1);
        this.mLocationPathField.setLayoutData((Object)gridData2);
        this.mLocationPathField.setFont(composite.getFont());
        this.mLocationPathField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewTestProjectCreationPage.this.onLocationPathFieldModified();
            }
        });
        this.mBrowseButton = new Button((Composite)group, 8);
        this.mBrowseButton.setText("Browse...");
        this.setButtonLayoutData(this.mBrowseButton);
        this.mBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewTestProjectCreationPage.this.onOpenDirectoryBrowser();
            }
        });
    }

    private final void createTestTargetGroup(Composite composite) {
        GridData gridData;
        Label label;
        Group group = new Group(composite, 16);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(1808));
        group.setFont(composite.getFont());
        group.setText("Test Target");
        this.mToggleComposites.add((Composite)group);
        if (this.mMainInfo == null) {
            label = new Label((Composite)group, 0);
            label.setText("Select the project to test:");
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            label.setLayoutData((Object)gridData);
            this.mTestSelfProjectRadio = new Button((Composite)group, 16);
            this.mTestSelfProjectRadio.setText("This project");
            this.mTestSelfProjectRadio.setSelection(false);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            this.mTestSelfProjectRadio.setLayoutData((Object)gridData);
            this.mTestExistingProjectRadio = new Button((Composite)group, 16);
            this.mTestExistingProjectRadio.setText("An existing Android project");
            this.mTestExistingProjectRadio.setSelection(this.mMainInfo == null);
            this.mTestExistingProjectRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    NewTestProjectCreationPage.this.onExistingProjectChanged();
                }
            });
            String string = "The existing Android Project that is being tested.";
            this.mTestedProjectNameField = new Text((Composite)group, 2048);
            this.mTestedProjectNameField.setLayoutData((Object)new GridData(768));
            this.mTestedProjectNameField.setToolTipText(string);
            this.mTestedProjectNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    NewTestProjectCreationPage.this.onProjectFieldUpdated();
                }
            });
            this.mProjectBrowseButton = new Button((Composite)group, 0);
            this.mProjectBrowseButton.setText("Browse...");
            this.mProjectBrowseButton.setToolTipText("Allows you to select the Android project to test.");
            this.mProjectBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    NewTestProjectCreationPage.this.onProjectBrowse();
                }
            });
            this.mProjectChooserHelper = new ProjectChooserHelper(composite.getShell());
        }
        label = new Label((Composite)group, 0);
        label.setText("Test Target Package:");
        this.mTestTargetPackageLabel = new Label((Composite)group, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.mTestTargetPackageLabel.setLayoutData((Object)gridData);
    }

    private void createTargetGroup(Composite composite) {
        Group group = new Group(composite, 16);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(1808));
        group.setFont(composite.getFont());
        group.setText("Build Target");
        this.mToggleComposites.add((Composite)group);
        this.mSdkTargetSelector = new SdkTargetSelector((Composite)group, null);
        this.mSdkTargetChangeListener = new Sdk.ITargetChangeListener(){

            public void onProjectTargetChange(IProject iProject) {
            }

            public void onTargetsLoaded() {
                IAndroidTarget[] iAndroidTargetArray = null;
                if (Sdk.getCurrent() != null) {
                    iAndroidTargetArray = Sdk.getCurrent().getTargets();
                }
                NewTestProjectCreationPage.this.mSdkTargetSelector.setTargets(iAndroidTargetArray);
                if (iAndroidTargetArray != null && iAndroidTargetArray.length == 1) {
                    NewTestProjectCreationPage.this.mSdkTargetSelector.setSelection(iAndroidTargetArray[0]);
                }
            }
        };
        AdtPlugin.getDefault().addTargetListener(this.mSdkTargetChangeListener);
        this.mSdkTargetChangeListener.onTargetsLoaded();
        this.mSdkTargetSelector.setSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewTestProjectCreationPage.this.onSdkTargetModified();
                NewTestProjectCreationPage.this.updateLocationPathField(null);
                NewTestProjectCreationPage.this.validatePageComplete();
            }
        });
    }

    private final void createPropertiesGroup(Composite composite) {
        Group group = new Group(composite, 16);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        group.setFont(composite.getFont());
        group.setText("Properties");
        this.mToggleComposites.add((Composite)group);
        Label label = new Label((Composite)group, 0);
        label.setText("Application name:");
        label.setFont(composite.getFont());
        label.setToolTipText("Name of the Application. This is a free string. It can be empty.");
        this.mApplicationNameField = new Text((Composite)group, 2048);
        GridData gridData = new GridData(768);
        this.mApplicationNameField.setToolTipText("Name of the Application. This is a free string. It can be empty.");
        this.mApplicationNameField.setLayoutData((Object)gridData);
        this.mApplicationNameField.setFont(composite.getFont());
        this.mApplicationNameField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (!NewTestProjectCreationPage.this.mInternalApplicationNameUpdate) {
                    NewTestProjectCreationPage.this.mApplicationNameModifiedByUser = true;
                }
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Package name:");
        label.setFont(composite.getFont());
        label.setToolTipText("Namespace of the Package to create. This must be a Java namespace with at least two components.");
        this.mPackageNameField = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        this.mPackageNameField.setToolTipText("Namespace of the Package to create. This must be a Java namespace with at least two components.");
        this.mPackageNameField.setLayoutData((Object)gridData);
        this.mPackageNameField.setFont(composite.getFont());
        this.mPackageNameField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (!NewTestProjectCreationPage.this.mInternalPackageNameUpdate) {
                    NewTestProjectCreationPage.this.mPackageNameModifiedByUser = true;
                }
                NewTestProjectCreationPage.this.onPackageNameFieldModified();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Min SDK Version:");
        label.setFont(composite.getFont());
        label.setToolTipText("The minimum SDK version number that the application requires. Must be an integer > 0. It can be empty.");
        this.mMinSdkVersionField = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        label.setToolTipText("The minimum SDK version number that the application requires. Must be an integer > 0. It can be empty.");
        this.mMinSdkVersionField.setLayoutData((Object)gridData);
        this.mMinSdkVersionField.setFont(composite.getFont());
        this.mMinSdkVersionField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewTestProjectCreationPage.this.onMinSdkVersionFieldModified();
                NewTestProjectCreationPage.this.validatePageComplete();
            }
        });
    }

    private String getLocationPathFieldValue() {
        return this.mLocationPathField == null ? INITIAL_NAME : this.mLocationPathField.getText().trim();
    }

    private String getProjectLocation() {
        if (this.mInfo.useDefaultLocation()) {
            return Platform.getLocation().toString();
        }
        return this.getLocationPathFieldValue();
    }

    private IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.mInfo.getProjectName());
    }

    private void onExistingProjectChanged() {
        if (this.mInfo.isTestingExisting()) {
            boolean bl = this.mTestExistingProjectRadio.getSelection();
            this.mTestedProjectNameField.setEnabled(bl);
            this.mProjectBrowseButton.setEnabled(bl);
            this.setExistingProject(this.mInfo.getExistingTestedProject());
            this.validatePageComplete();
        }
    }

    private void useMainProjectInformation() {
        if (this.mInfo.isTestingMain() && this.mMainInfo != null) {
            String string = String.format("%1$sTest", this.mMainInfo.getProjectName());
            String string2 = String.format("%1$sTest", this.mMainInfo.getApplicationName());
            String string3 = this.mMainInfo.getPackageName();
            if (string3 == null) {
                string3 = INITIAL_NAME;
            }
            this.updateTestTargetPackageField(string3);
            if (!this.mProjectNameModifiedByUser) {
                this.mInternalProjectNameUpdate = true;
                this.mProjectNameField.setText(string);
                this.mInternalProjectNameUpdate = false;
            }
            if (!this.mApplicationNameModifiedByUser) {
                this.mInternalApplicationNameUpdate = true;
                this.mApplicationNameField.setText(string2);
                this.mInternalApplicationNameUpdate = false;
            }
            if (!this.mPackageNameModifiedByUser) {
                this.mInternalPackageNameUpdate = true;
                string3 = String.valueOf(string3) + ".test";
                this.mPackageNameField.setText(string3);
                this.mInternalPackageNameUpdate = false;
            }
            if (!this.mSdkTargetModifiedByUser) {
                this.mInternalSdkTargetUpdate = true;
                this.mSdkTargetSelector.setSelection(this.mMainInfo.getSdkTarget());
                this.mInternalSdkTargetUpdate = false;
            }
            if (!this.mMinSdkVersionModifiedByUser) {
                this.mInternalMinSdkVersionUpdate = true;
                this.mMinSdkVersionField.setText(this.mMainInfo.getMinSdkVersion());
                this.mInternalMinSdkVersionUpdate = false;
            }
        }
    }

    private void onProjectFieldUpdated() {
        IJavaProject[] iJavaProjectArray;
        String string = this.mTestedProjectNameField.getText();
        IJavaProject[] iJavaProjectArray2 = iJavaProjectArray = this.mProjectChooserHelper.getAndroidProjects(null);
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject iJavaProject = iJavaProjectArray2[n2];
            if (iJavaProject.getProject().getName().equals(string)) {
                this.setExistingProject(iJavaProject.getProject());
                return;
            }
            ++n2;
        }
    }

    private void onProjectBrowse() {
        IJavaProject iJavaProject = this.mProjectChooserHelper.chooseJavaProject(this.mTestedProjectNameField.getText());
        if (iJavaProject != null) {
            this.setExistingProject(iJavaProject.getProject());
            this.mTestedProjectNameField.setText(this.mExistingTestedProject.getName());
        }
    }

    private void setExistingProject(IProject iProject) {
        this.mExistingTestedProject = iProject;
        if (!(iProject == null || this.mApplicationNameModifiedByUser && this.mPackageNameModifiedByUser && this.mSdkTargetModifiedByUser && this.mMinSdkVersionModifiedByUser)) {
            IFile iFile = AndroidManifestParser.getManifest(iProject);
            AndroidManifestParser androidManifestParser = null;
            if (iFile != null) {
                try {
                    androidManifestParser = AndroidManifestParser.parseForData(iFile);
                }
                catch (CoreException coreException) {}
            }
            if (androidManifestParser != null) {
                String string = String.format("%1$sTest", iProject.getName());
                String string2 = androidManifestParser.getPackage();
                String string3 = androidManifestParser.getApiLevelRequirement();
                IAndroidTarget iAndroidTarget = null;
                if (Sdk.getCurrent() != null) {
                    iAndroidTarget = Sdk.getCurrent().getTarget(iProject);
                }
                if (string2 == null) {
                    string2 = INITIAL_NAME;
                }
                this.mLastExistingPackageName = string2;
                if (!this.mProjectNameModifiedByUser) {
                    this.mInternalProjectNameUpdate = true;
                    this.mProjectNameField.setText(string);
                    this.mInternalProjectNameUpdate = false;
                }
                if (!this.mApplicationNameModifiedByUser) {
                    this.mInternalApplicationNameUpdate = true;
                    this.mApplicationNameField.setText(string);
                    this.mInternalApplicationNameUpdate = false;
                }
                if (!this.mPackageNameModifiedByUser) {
                    this.mInternalPackageNameUpdate = true;
                    string2 = String.valueOf(string2) + ".test";
                    this.mPackageNameField.setText(string2);
                    this.mInternalPackageNameUpdate = false;
                }
                if (!this.mSdkTargetModifiedByUser && iAndroidTarget != null) {
                    this.mInternalSdkTargetUpdate = true;
                    this.mSdkTargetSelector.setSelection(iAndroidTarget);
                    this.mInternalSdkTargetUpdate = false;
                }
                if (!this.mMinSdkVersionModifiedByUser) {
                    this.mInternalMinSdkVersionUpdate = true;
                    if (string3 != null) {
                        this.mMinSdkVersionField.setText(string3);
                    }
                    if (iAndroidTarget == null) {
                        this.updateSdkSelectorToMatchMinSdkVersion();
                    }
                    this.mInternalMinSdkVersionUpdate = false;
                }
            }
        }
        this.updateTestTargetPackageField(this.mLastExistingPackageName);
        this.validatePageComplete();
    }

    private void onOpenDirectoryBrowser() {
        File file;
        String string = this.getLocationPathFieldValue();
        if (string.length() == 0) {
            string = null;
        } else {
            file = new File(string);
            if (!file.exists()) {
                string = null;
            }
        }
        file = new DirectoryDialog(this.mLocationPathField.getShell());
        file.setMessage("Browse for folder");
        file.setFilterPath(string);
        String string2 = file.open();
        if (string2 != null) {
            this.updateLocationPathField(string2);
            this.validatePageComplete();
        }
    }

    private void onCreateTestProjectToggle() {
        boolean bl = this.mInfo.getCreateTestProject();
        for (Composite composite : this.mToggleComposites) {
            this.enableControl((Control)composite, bl);
        }
        this.mSdkTargetSelector.setEnabled(bl);
        if (bl) {
            this.useMainProjectInformation();
        }
        this.validatePageComplete();
    }

    private void enableControl(Control control, boolean bl) {
        control.setEnabled(bl);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control2 = controlArray[n2];
                this.enableControl(control2, bl);
                ++n2;
            }
        }
    }

    private void enableLocationWidgets() {
        boolean bl = this.mInfo.useDefaultLocation();
        boolean bl2 = !bl;
        this.mLocationLabel.setEnabled(bl2);
        this.mLocationPathField.setEnabled(bl2);
        this.mBrowseButton.setEnabled(bl2);
        this.updateLocationPathField(null);
    }

    private void updateLocationPathField(String string) {
        boolean bl;
        boolean bl2 = this.mInfo.useDefaultLocation();
        boolean bl3 = bl = !bl2;
        if (!this.mInternalLocationPathUpdate) {
            this.mInternalLocationPathUpdate = true;
            if (bl) {
                if (string != null) {
                    sCustomLocationOsPath = TextProcessor.process((String)string);
                }
                if (!this.mLocationPathField.getText().equals(sCustomLocationOsPath)) {
                    this.mLocationPathField.setText(sCustomLocationOsPath);
                }
            } else {
                String string2 = Platform.getLocation().append(this.mInfo.getProjectName()).toString();
                string2 = TextProcessor.process((String)string2);
                if (!this.mLocationPathField.getText().equals(string2)) {
                    this.mLocationPathField.setText(string2);
                }
            }
            this.validatePageComplete();
            this.mInternalLocationPathUpdate = false;
        }
    }

    private void onLocationPathFieldModified() {
        if (!this.mInternalLocationPathUpdate) {
            String string;
            sCustomLocationOsPath = string = this.getLocationPathFieldValue();
            this.validatePageComplete();
        }
    }

    private void onPackageNameFieldModified() {
        this.updateTestTargetPackageField(null);
        this.validatePageComplete();
    }

    private void updateTestTargetPackageField(String string) {
        if (this.mInfo.isTestingSelf()) {
            this.mTestTargetPackageLabel.setText(this.mInfo.getPackageName());
        } else if (string != null) {
            this.mTestTargetPackageLabel.setText(string);
        }
    }

    private void onMinSdkVersionFieldModified() {
        if (this.mInternalMinSdkVersionUpdate || this.mInternalSdkTargetUpdate) {
            return;
        }
        this.updateSdkSelectorToMatchMinSdkVersion();
        this.mMinSdkVersionModifiedByUser = true;
    }

    private void updateSdkSelectorToMatchMinSdkVersion() {
        String string = this.mInfo.getMinSdkVersion();
        IAndroidTarget iAndroidTarget = this.mInfo.getSdkTarget();
        if (iAndroidTarget != null && iAndroidTarget.getVersion().equals((Object)string)) {
            return;
        }
        IAndroidTarget[] iAndroidTargetArray = this.mSdkTargetSelector.getTargets();
        int n = iAndroidTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAndroidTarget iAndroidTarget2 = iAndroidTargetArray[n2];
            if (iAndroidTarget2.getVersion().equals((Object)string)) {
                this.mSdkTargetSelector.setSelection(iAndroidTarget2);
                return;
            }
            ++n2;
        }
    }

    private void onSdkTargetModified() {
        if (this.mInternalMinSdkVersionUpdate || this.mInternalSdkTargetUpdate) {
            return;
        }
        IAndroidTarget iAndroidTarget = this.mInfo.getSdkTarget();
        if (iAndroidTarget != null) {
            this.mInternalMinSdkVersionUpdate = true;
            this.mMinSdkVersionField.setText(iAndroidTarget.getVersion().getApiString());
            this.mInternalMinSdkVersionUpdate = false;
        }
        this.mSdkTargetModifiedByUser = true;
    }

    private boolean validatePage() {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        int n = 0;
        if (this.mInfo.getCreateTestProject()) {
            n = this.validateProjectField(iWorkspace);
            if ((n & 2) == 0) {
                n |= this.validateLocationPath(iWorkspace);
            }
            if ((n & 2) == 0) {
                n |= this.validateTestTarget();
            }
            if ((n & 2) == 0) {
                n |= this.validateSdkTarget();
            }
            if ((n & 2) == 0) {
                n |= this.validatePackageField();
            }
            if ((n & 2) == 0) {
                n |= this.validateMinSdkVersionField();
            }
        }
        if (n == 0) {
            this.setStatus(null, 0);
        }
        return (n & 2) == 0;
    }

    private void validatePageComplete() {
        this.setPageComplete(this.validatePage());
    }

    private int validateTestTarget() {
        if (this.mInfo.isTestingExisting() && this.mInfo.getExistingTestedProject() == null) {
            return this.setStatus("Please select an existing Android project as a test target.", 2);
        }
        return 0;
    }

    private int validateProjectField(IWorkspace iWorkspace) {
        String string = this.mInfo.getProjectName();
        if (string.length() == 0) {
            return this.setStatus("Project name must be specified", 2);
        }
        if (!sProjectNamePattern.matcher(string).matches()) {
            return this.setStatus("The project name must start with an alphanumeric characters, followed by one or more alphanumerics, digits, dots, dashes, underscores or spaces.", 2);
        }
        IStatus iStatus = iWorkspace.validateName(string, 4);
        if (!iStatus.isOK()) {
            return this.setStatus(iStatus.getMessage(), 2);
        }
        if (this.mMainInfo != null && string.equals(this.mMainInfo.getProjectName())) {
            return this.setStatus("The main project name and the test project name must be different.", 2);
        }
        if (this.getProjectHandle().exists()) {
            return this.setStatus("A project with that name already exists in the workspace", 2);
        }
        return 0;
    }

    private int validateLocationPath(IWorkspace iWorkspace) {
        Path path = new Path(this.getProjectLocation());
        if (!this.mInfo.useDefaultLocation()) {
            String[] stringArray;
            URI uRI = URIUtil.toURI((String)path.toOSString());
            IStatus iStatus = iWorkspace.validateProjectLocationURI(this.getProjectHandle(), uRI);
            if (!iStatus.isOK()) {
                return this.setStatus(iStatus.getMessage(), 2);
            }
            File file = path.toFile();
            if (file.exists() && !file.isDirectory()) {
                return this.setStatus("A directory name must be specified.", 2);
            }
            if (file.isDirectory() && (stringArray = file.list()).length != 0) {
                return this.setStatus("The selected output directory is not empty.", 1);
            }
        } else {
            if (this.getProjectLocation().length() == 0) {
                return this.setStatus("A directory name must be specified.", 2);
            }
            File file = path.append(this.mInfo.getProjectName()).toFile();
            if (file.exists()) {
                return this.setStatus(String.format("There is already a file or directory named \"%1$s\" in the selected location.", this.mInfo.getProjectName()), 2);
            }
        }
        return 0;
    }

    private int validateSdkTarget() {
        if (this.mInfo.getSdkTarget() == null) {
            return this.setStatus("An SDK Target must be specified.", 2);
        }
        return 0;
    }

    private int validateMinSdkVersionField() {
        if (this.mInfo.getMinSdkVersion().length() == 0) {
            return 0;
        }
        if (this.mInfo.getSdkTarget() != null && !this.mInfo.getSdkTarget().getVersion().equals((Object)this.mInfo.getMinSdkVersion())) {
            return this.setStatus("The API level for the selected SDK target does not match the Min SDK version.", this.mInfo.getSdkTarget().getVersion().isPreview() ? 2 : 1);
        }
        return 0;
    }

    private int validatePackageField() {
        String string = this.mInfo.getPackageName();
        if (string.length() == 0) {
            return this.setStatus("Project package name must be specified.", 2);
        }
        int n = 0;
        IStatus iStatus = JavaConventions.validatePackageName((String)string, (String)"1.5", (String)"1.5");
        if (!iStatus.isOK()) {
            n = this.setStatus(String.format("Project package: %s", iStatus.getMessage()), iStatus.getSeverity() == 4 ? 2 : 1);
        }
        if (n != 2 && string.indexOf(46) == -1) {
            return this.setStatus("Project package name must have at least two identifiers.", 2);
        }
        string = this.mInfo.getTargetPackageName();
        if (string.length() == 0) {
            return this.setStatus("Target package name must be specified.", 2);
        }
        iStatus = JavaConventions.validatePackageName((String)string, (String)"1.5", (String)"1.5");
        if (!iStatus.isOK()) {
            n = this.setStatus(String.format("Target package: %s", iStatus.getMessage()), iStatus.getSeverity() == 4 ? 2 : 1);
        }
        if (n != 2 && string.indexOf(46) == -1) {
            return this.setStatus("Target name must have at least two identifiers.", 2);
        }
        return n;
    }

    private int setStatus(String string, int n) {
        if (string == null) {
            this.setErrorMessage(null);
            this.setMessage(null);
        } else if (!string.equals(this.getMessage())) {
            this.setMessage(string, n == 1 ? 2 : 3);
        }
        return n;
    }

    public class TestInfo {
        public boolean getCreateTestProject() {
            return NewTestProjectCreationPage.this.mCreateTestProjectField == null ? true : NewTestProjectCreationPage.this.mCreateTestProjectField.getSelection();
        }

        public IPath getLocationPath() {
            return new Path(NewTestProjectCreationPage.this.getProjectLocation());
        }

        public String getProjectName() {
            return NewTestProjectCreationPage.this.mProjectNameField == null ? NewTestProjectCreationPage.INITIAL_NAME : NewTestProjectCreationPage.this.mProjectNameField.getText().trim();
        }

        public String getPackageName() {
            return NewTestProjectCreationPage.this.mPackageNameField == null ? NewTestProjectCreationPage.INITIAL_NAME : NewTestProjectCreationPage.this.mPackageNameField.getText().trim();
        }

        public String getTargetPackageName() {
            return NewTestProjectCreationPage.this.mTestTargetPackageLabel == null ? NewTestProjectCreationPage.INITIAL_NAME : NewTestProjectCreationPage.this.mTestTargetPackageLabel.getText().trim();
        }

        public String getMinSdkVersion() {
            return NewTestProjectCreationPage.this.mMinSdkVersionField == null ? NewTestProjectCreationPage.INITIAL_NAME : NewTestProjectCreationPage.this.mMinSdkVersionField.getText().trim();
        }

        public String getApplicationName() {
            return NewTestProjectCreationPage.this.mApplicationNameField == null ? NewTestProjectCreationPage.INITIAL_NAME : NewTestProjectCreationPage.this.mApplicationNameField.getText().trim();
        }

        public boolean useDefaultLocation() {
            return NewTestProjectCreationPage.this.mUseDefaultLocation == null ? true : NewTestProjectCreationPage.this.mUseDefaultLocation.getSelection();
        }

        public String getSourceFolder() {
            return "src";
        }

        public IAndroidTarget getSdkTarget() {
            return NewTestProjectCreationPage.this.mSdkTargetSelector == null ? null : NewTestProjectCreationPage.this.mSdkTargetSelector.getSelected();
        }

        public boolean isTestingSelf() {
            return NewTestProjectCreationPage.this.mMainInfo == null && NewTestProjectCreationPage.this.mTestSelfProjectRadio != null && NewTestProjectCreationPage.this.mTestSelfProjectRadio.getSelection();
        }

        public boolean isTestingMain() {
            return NewTestProjectCreationPage.this.mMainInfo != null;
        }

        public boolean isTestingExisting() {
            return NewTestProjectCreationPage.this.mMainInfo == null && NewTestProjectCreationPage.this.mTestExistingProjectRadio != null && NewTestProjectCreationPage.this.mTestExistingProjectRadio.getSelection();
        }

        public IProject getExistingTestedProject() {
            return NewTestProjectCreationPage.this.mExistingTestedProject;
        }
    }
}

