/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.ui;

import com.android.ide.eclipse.adt.internal.refactorings.extractstring.ExtractStringRefactoring;
import com.android.ide.eclipse.adt.internal.refactorings.extractstring.ExtractStringWizard;
import com.android.ide.eclipse.adt.internal.resources.IResourceRepository;
import com.android.ide.eclipse.adt.internal.resources.ResourceItem;
import com.android.ide.eclipse.adt.internal.resources.ResourceType;
import com.android.ide.eclipse.adt.internal.ui.ResourceContentProvider;
import com.android.ide.eclipse.adt.internal.ui.ResourceLabelProvider;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class ReferenceChooserDialog
extends SelectionStatusDialog {
    private static Pattern sResourcePattern = Pattern.compile("@(.*)/(.+)");
    private static Pattern sInlineIdResourcePattern = Pattern.compile("@\\+id/(.+)");
    private static IDialogSettings sDialogSettings = new DialogSettings("");
    private IResourceRepository mResources;
    private String mCurrentResource;
    private FilteredTree mFilteredTree;
    private Button mNewResButton;
    private final IProject mProject;
    private TreeViewer mTreeViewer;

    public ReferenceChooserDialog(IProject iProject, IResourceRepository iResourceRepository, Shell shell) {
        super(shell);
        this.mProject = iProject;
        this.mResources = iResourceRepository;
        int n = this.getShellStyle();
        this.setShellStyle(n | 0x400 | 0x10);
        this.setTitle("Reference Chooser");
        this.setMessage(String.format("Choose a resource", new Object[0]));
        this.setDialogBoundsSettings(sDialogSettings, this.getDialogBoundsStrategy());
    }

    public void setCurrentResource(String string) {
        this.mCurrentResource = string;
    }

    public String getCurrentResource() {
        return this.mCurrentResource;
    }

    protected void computeResult() {
        TreePath treePath = this.getSelection();
        if (treePath != null && treePath.getSegmentCount() == 2) {
            ResourceType resourceType = (ResourceType)((Object)treePath.getFirstSegment());
            ResourceItem resourceItem = (ResourceItem)treePath.getLastSegment();
            this.mCurrentResource = resourceType.getXmlString(resourceItem, false);
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createMessageArea(composite2);
        this.createFilteredTree(composite2);
        this.setupInitialSelection();
        this.createNewResButtons(composite2);
        return composite2;
    }

    private void createNewResButtons(Composite composite) {
        this.mNewResButton = new Button(composite, 0);
        this.mNewResButton.addSelectionListener((SelectionListener)new OnNewResButtonSelected());
        this.updateNewResButton();
    }

    private void createFilteredTree(Composite composite) {
        this.mFilteredTree = new FilteredTree(composite, 67588, new PatternFilter());
        GridData gridData = new GridData();
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        gridData.heightHint = this.convertHeightInCharsToPixels(18);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.mFilteredTree.setLayoutData((Object)gridData);
        this.mFilteredTree.setFont(composite.getFont());
        this.mTreeViewer = this.mFilteredTree.getViewer();
        Tree tree = this.mTreeViewer.getTree();
        tree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                ReferenceChooserDialog.this.handleDoubleClick();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                ReferenceChooserDialog.this.handleSelection();
            }
        });
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)new ResourceLabelProvider());
        this.mTreeViewer.setContentProvider((IContentProvider)new ResourceContentProvider(false));
        this.mTreeViewer.setInput((Object)this.mResources);
    }

    protected void handleSelection() {
        this.validateCurrentSelection();
        this.updateNewResButton();
    }

    protected void handleDoubleClick() {
        if (this.validateCurrentSelection()) {
            this.buttonPressed(0);
        }
    }

    private TreePath getSelection() {
        TreeSelection treeSelection;
        TreePath[] treePathArray;
        ISelection iSelection = this.mFilteredTree.getViewer().getSelection();
        if (iSelection instanceof TreeSelection && (treePathArray = (treeSelection = (TreeSelection)iSelection).getPaths()).length > 0) {
            return treePathArray[0];
        }
        return null;
    }

    private boolean validateCurrentSelection() {
        TreePath treePath = this.getSelection();
        Status status = treePath != null ? (treePath.getSegmentCount() == 2 ? new Status(0, "com.android.ide.eclipse.adt", 0, "", null) : new Status(4, "com.android.ide.eclipse.adt", 4, "You must select a Resource Item", null)) : new Status(4, "com.android.ide.eclipse.adt", 4, "", null);
        this.updateStatus((IStatus)status);
        return status.isOK();
    }

    private void updateNewResButton() {
        ResourceType resourceType = this.getSelectedResourceType();
        this.mNewResButton.setEnabled(resourceType == ResourceType.STRING);
        String string = String.format("New %1$s...", resourceType == null ? "Resource" : resourceType.getDisplayName());
        this.mNewResButton.setText(string);
        this.mNewResButton.pack();
    }

    private ResourceType getSelectedResourceType() {
        Object object;
        ResourceType resourceType = null;
        TreePath treePath = this.getSelection();
        if (treePath != null && treePath.getSegmentCount() > 0 && (object = treePath.getFirstSegment()) instanceof ResourceType) {
            resourceType = (ResourceType)((Object)object);
        }
        return resourceType;
    }

    private void setupInitialSelection() {
        Matcher matcher = sInlineIdResourcePattern.matcher(this.mCurrentResource);
        if (matcher.matches()) {
            String string = matcher.group(1);
            this.setupInitialSelection(ResourceType.ID, string);
        } else {
            ResourceType resourceType;
            matcher = sResourcePattern.matcher(this.mCurrentResource);
            if (matcher.matches() && (resourceType = ResourceType.getEnum(matcher.group(1))) != null) {
                String string = matcher.group(2);
                this.setupInitialSelection(resourceType, string);
            }
        }
    }

    private void setupInitialSelection(ResourceType resourceType, String string) {
        ResourceItem resourceItem;
        ResourceItem[] resourceItemArray;
        ResourceItem[] resourceItemArray2 = resourceItemArray = this.mResources.getResources(resourceType);
        int n = resourceItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            resourceItem = resourceItemArray2[n2];
            if (string.equals(resourceItem.getName())) {
                TreePath treePath = new TreePath(new Object[]{resourceType, resourceItem});
                this.mFilteredTree.getViewer().setSelection((ISelection)new TreeSelection(treePath), true);
                return;
            }
            ++n2;
        }
        resourceItem = new TreePath(new Object[]{resourceType});
        this.mFilteredTree.getViewer().setSelection((ISelection)new TreeSelection((TreePath)resourceItem), true);
        this.mFilteredTree.getViewer().setExpandedState((Object)resourceType, true);
    }

    private class OnNewResButtonSelected
    extends SelectionAdapter {
        private OnNewResButtonSelected() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            super.widgetSelected(selectionEvent);
            ResourceType resourceType = ReferenceChooserDialog.this.getSelectedResourceType();
            if (resourceType == ResourceType.STRING) {
                ExtractStringRefactoring extractStringRefactoring = new ExtractStringRefactoring(ReferenceChooserDialog.this.mProject, true);
                ExtractStringWizard extractStringWizard = new ExtractStringWizard(extractStringRefactoring, ReferenceChooserDialog.this.mProject);
                RefactoringWizardOpenOperation refactoringWizardOpenOperation = new RefactoringWizardOpenOperation((RefactoringWizard)extractStringWizard);
                try {
                    IWorkbench iWorkbench = PlatformUI.getWorkbench();
                    if (refactoringWizardOpenOperation.run(iWorkbench.getDisplay().getActiveShell(), extractStringWizard.getDefaultPageTitle()) == 0) {
                        ReferenceChooserDialog.this.mTreeViewer.refresh();
                        ReferenceChooserDialog.this.setupInitialSelection(resourceType, extractStringRefactoring.getXmlStringId());
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

