/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.manager;

import com.android.ide.eclipse.adt.internal.project.BaseProjectHelper;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class ResourceMonitor
implements IResourceChangeListener {
    private static final ResourceMonitor sThis = new ResourceMonitor();
    private final ArrayList<FileListenerBundle> mFileListeners = new ArrayList();
    private final ArrayList<FolderListenerBundle> mFolderListeners = new ArrayList();
    private final ArrayList<IProjectListener> mProjectListeners = new ArrayList();
    private final ArrayList<IResourceEventListener> mEventListeners = new ArrayList();
    private IWorkspace mWorkspace;

    public static ResourceMonitor getMonitor() {
        return sThis;
    }

    public static ResourceMonitor startMonitoring(IWorkspace iWorkspace) {
        if (sThis != null) {
            iWorkspace.addResourceChangeListener((IResourceChangeListener)sThis, 5);
            ResourceMonitor.sThis.mWorkspace = iWorkspace;
        }
        return sThis;
    }

    public static void stopMonitoring(IWorkspace iWorkspace) {
        if (sThis != null) {
            iWorkspace.removeResourceChangeListener((IResourceChangeListener)sThis);
            ResourceMonitor.sThis.mFileListeners.clear();
            ResourceMonitor.sThis.mProjectListeners.clear();
        }
    }

    public synchronized void addFileListener(IFileListener iFileListener, int n) {
        FileListenerBundle fileListenerBundle = new FileListenerBundle();
        fileListenerBundle.listener = iFileListener;
        fileListenerBundle.kindMask = n;
        this.mFileListeners.add(fileListenerBundle);
    }

    public synchronized void removeFileListener(IFileListener iFileListener) {
        int n = 0;
        while (n < this.mFileListeners.size()) {
            FileListenerBundle fileListenerBundle = this.mFileListeners.get(n);
            if (fileListenerBundle.listener == iFileListener) {
                this.mFileListeners.remove(n);
                return;
            }
            ++n;
        }
    }

    public synchronized void addFolderListener(IFolderListener iFolderListener, int n) {
        FolderListenerBundle folderListenerBundle = new FolderListenerBundle();
        folderListenerBundle.listener = iFolderListener;
        folderListenerBundle.kindMask = n;
        this.mFolderListeners.add(folderListenerBundle);
    }

    public synchronized void removeFolderListener(IFolderListener iFolderListener) {
        int n = 0;
        while (n < this.mFolderListeners.size()) {
            FolderListenerBundle folderListenerBundle = this.mFolderListeners.get(n);
            if (folderListenerBundle.listener == iFolderListener) {
                this.mFolderListeners.remove(n);
                return;
            }
            ++n;
        }
    }

    public synchronized void addProjectListener(IProjectListener iProjectListener) {
        IJavaProject[] iJavaProjectArray;
        this.mProjectListeners.add(iProjectListener);
        IWorkspaceRoot iWorkspaceRoot = this.mWorkspace.getRoot();
        IJavaModel iJavaModel = JavaCore.create((IWorkspaceRoot)iWorkspaceRoot);
        IJavaProject[] iJavaProjectArray2 = iJavaProjectArray = BaseProjectHelper.getAndroidProjects(iJavaModel);
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject iJavaProject = iJavaProjectArray2[n2];
            iProjectListener.projectOpenedWithWorkspace(iJavaProject.getProject());
            ++n2;
        }
    }

    public synchronized void removeProjectListener(IProjectListener iProjectListener) {
        this.mProjectListeners.remove(iProjectListener);
    }

    public synchronized void addResourceEventListener(IResourceEventListener iResourceEventListener) {
        this.mEventListeners.add(iResourceEventListener);
    }

    public synchronized void removeResourceEventListener(IResourceEventListener iResourceEventListener) {
        this.mEventListeners.remove(iResourceEventListener);
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        Object object;
        IResourceEventListener iResourceEventListener2;
        for (IResourceEventListener iResourceEventListener2 : this.mEventListeners) {
            iResourceEventListener2.resourceChangeEventStart();
        }
        if (iResourceChangeEvent.getType() == 4) {
            iResourceEventListener2 = iResourceChangeEvent.getResource();
            object = iResourceEventListener2.getProject();
            for (IProjectListener iProjectListener : this.mProjectListeners) {
                iProjectListener.projectDeleted((IProject)object);
            }
        } else {
            iResourceEventListener2 = iResourceChangeEvent.getDelta();
            object = new DeltaVisitor();
            try {
                iResourceEventListener2.accept((IResourceDeltaVisitor)object);
            }
            catch (CoreException coreException) {}
        }
        for (IResourceEventListener iResourceEventListener2 : this.mEventListeners) {
            iResourceEventListener2.resourceChangeEventEnd();
        }
    }

    private final class DeltaVisitor
    implements IResourceDeltaVisitor {
        private DeltaVisitor() {
        }

        public boolean visit(IResourceDelta iResourceDelta) {
            block8: {
                int n;
                IResource iResource = iResourceDelta.getResource();
                int n2 = iResource.getType();
                if (n2 == 1) {
                    int n3 = iResourceDelta.getKind();
                    for (FileListenerBundle fileListenerBundle : ResourceMonitor.this.mFileListeners) {
                        if (fileListenerBundle.kindMask != -1 && (fileListenerBundle.kindMask & n3) == 0) continue;
                        fileListenerBundle.listener.fileChanged((IFile)iResource, iResourceDelta.getMarkerDeltas(), n3);
                    }
                    return false;
                }
                if (n2 == 2) {
                    int n4 = iResourceDelta.getKind();
                    for (FolderListenerBundle folderListenerBundle : ResourceMonitor.this.mFolderListeners) {
                        if (folderListenerBundle.kindMask != -1 && (folderListenerBundle.kindMask & n4) == 0) continue;
                        folderListenerBundle.listener.folderChanged((IFolder)iResource, n4);
                    }
                    return true;
                }
                if (n2 != 4 || (n = iResourceDelta.getFlags()) != 16384) break block8;
                IProject iProject = (IProject)iResource;
                if (iProject.isOpen()) {
                    for (IProjectListener iProjectListener : ResourceMonitor.this.mProjectListeners) {
                        iProjectListener.projectOpened(iProject);
                    }
                } else {
                    for (IProjectListener iProjectListener : ResourceMonitor.this.mProjectListeners) {
                        iProjectListener.projectClosed(iProject);
                    }
                }
            }
            return true;
        }
    }

    private static class FileListenerBundle
    extends ListenerBundle {
        IFileListener listener;

        private FileListenerBundle() {
        }
    }

    private static class FolderListenerBundle
    extends ListenerBundle {
        IFolderListener listener;

        private FolderListenerBundle() {
        }
    }

    public static interface IFileListener {
        public void fileChanged(IFile var1, IMarkerDelta[] var2, int var3);
    }

    public static interface IFolderListener {
        public void folderChanged(IFolder var1, int var2);
    }

    public static interface IProjectListener {
        public void projectOpenedWithWorkspace(IProject var1);

        public void projectOpened(IProject var1);

        public void projectClosed(IProject var1);

        public void projectDeleted(IProject var1);
    }

    public static interface IResourceEventListener {
        public void resourceChangeEventStart();

        public void resourceChangeEventEnd();
    }

    private static class ListenerBundle {
        public static final int MASK_NONE = -1;
        int kindMask;

        private ListenerBundle() {
        }
    }
}

