/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.manager;

import com.android.ide.eclipse.adt.internal.resources.ResourceType;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.manager.FolderTypeRelationship;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResourceItem;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResources;
import com.android.ide.eclipse.adt.internal.resources.manager.Resource;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFile;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFolderType;
import com.android.ide.eclipse.adt.internal.resources.manager.files.IAbstractFile;
import com.android.ide.eclipse.adt.internal.resources.manager.files.IAbstractFolder;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceFolder
extends Resource {
    ResourceFolderType mType;
    FolderConfiguration mConfiguration;
    IAbstractFolder mFolder;
    ArrayList<ResourceFile> mFiles = null;
    private final boolean mIsFramework;

    public ResourceFolder(ResourceFolderType resourceFolderType, FolderConfiguration folderConfiguration, IAbstractFolder iAbstractFolder, boolean bl) {
        this.mType = resourceFolderType;
        this.mConfiguration = folderConfiguration;
        this.mFolder = iAbstractFolder;
        this.mIsFramework = bl;
    }

    public void addFile(ResourceFile resourceFile) {
        if (this.mFiles == null) {
            this.mFiles = new ArrayList();
        }
        this.mFiles.add(resourceFile);
    }

    public void removeFile(IFile iFile) {
        if (this.mFiles != null) {
            int n = this.mFiles.size();
            int n2 = 0;
            while (n2 < n) {
                IFile iFile2;
                ResourceFile resourceFile = this.mFiles.get(n2);
                if (resourceFile != null && (iFile2 = resourceFile.getFile().getIFile()) != null && iFile2.equals((Object)iFile)) {
                    this.mFiles.remove(n2);
                    this.touch();
                }
                ++n2;
            }
        }
    }

    public IAbstractFolder getFolder() {
        return this.mFolder;
    }

    public ResourceFolderType getType() {
        return this.mType;
    }

    public boolean isFramework() {
        return this.mIsFramework;
    }

    public Collection<ResourceType> getResourceTypes() {
        ArrayList<ResourceType> arrayList = new ArrayList<ResourceType>();
        if (this.mFiles != null) {
            for (ResourceFile resourceFile : this.mFiles) {
                ResourceType[] resourceTypeArray = resourceFile.getResourceTypes();
                if (resourceTypeArray == null) continue;
                ResourceType[] resourceTypeArray2 = resourceTypeArray;
                int n = resourceTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ResourceType resourceType = resourceTypeArray2[n2];
                    if (arrayList.indexOf((Object)resourceType) == -1) {
                        arrayList.add(resourceType);
                    }
                    ++n2;
                }
            }
        }
        return arrayList;
    }

    @Override
    public FolderConfiguration getConfiguration() {
        return this.mConfiguration;
    }

    public boolean hasFile(String string) {
        return this.mFolder.hasFile(string);
    }

    public ResourceFile getFile(IAbstractFile iAbstractFile) {
        if (this.mFiles != null) {
            for (ResourceFile resourceFile : this.mFiles) {
                if (!resourceFile.getFile().equals(iAbstractFile)) continue;
                return resourceFile;
            }
        }
        return null;
    }

    public ResourceFile getFile(IFile iFile) {
        if (this.mFiles != null) {
            for (ResourceFile resourceFile : this.mFiles) {
                IFile iFile2 = resourceFile.getFile().getIFile();
                if (iFile2 == null || !iFile2.equals((Object)iFile)) continue;
                return resourceFile;
            }
        }
        return null;
    }

    public ResourceFile getFile(String string) {
        if (this.mFiles != null) {
            for (ResourceFile resourceFile : this.mFiles) {
                if (!resourceFile.getFile().getName().equals(string)) continue;
                return resourceFile;
            }
        }
        return null;
    }

    public boolean hasResources(ResourceType resourceType) {
        ResourceFolderType[] resourceFolderTypeArray = FolderTypeRelationship.getRelatedFolders(resourceType);
        boolean bl = false;
        ResourceFolderType[] resourceFolderTypeArray2 = resourceFolderTypeArray;
        int n = resourceFolderTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceFolderType object = resourceFolderTypeArray2[n2];
            if (object == this.mType) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (bl && this.mFiles != null) {
            for (ResourceFile resourceFile : this.mFiles) {
                if (!resourceFile.hasResources(resourceType)) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<ProjectResourceItem> getResources(ResourceType resourceType, ProjectResources projectResources) {
        ArrayList<ProjectResourceItem> arrayList = new ArrayList<ProjectResourceItem>();
        if (this.mFiles != null) {
            for (ResourceFile resourceFile : this.mFiles) {
                arrayList.addAll(resourceFile.getResources(resourceType, projectResources));
            }
        }
        return arrayList;
    }
}

