/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.manager;

import com.android.ide.eclipse.adt.internal.resources.ResourceItem;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectResourceItem
extends ResourceItem {
    private static final Comparator<ResourceFile> sComparator = new Comparator<ResourceFile>(){

        @Override
        public int compare(ResourceFile resourceFile, ResourceFile resourceFile2) {
            FolderConfiguration folderConfiguration = resourceFile.getFolder().getConfiguration();
            FolderConfiguration folderConfiguration2 = resourceFile2.getFolder().getConfiguration();
            return folderConfiguration.compareTo(folderConfiguration2);
        }
    };
    protected final ArrayList<ResourceFile> mFiles = new ArrayList();

    public ProjectResourceItem(String string) {
        super(string);
    }

    public abstract boolean isEditableDirectly();

    protected void add(ResourceFile resourceFile) {
        this.mFiles.add(resourceFile);
    }

    protected void reset() {
        this.mFiles.clear();
    }

    public ResourceFile[] getSourceFileArray() {
        ArrayList<ResourceFile> arrayList = new ArrayList<ResourceFile>();
        arrayList.addAll(this.mFiles);
        Collections.sort(arrayList, sComparator);
        return arrayList.toArray(new ResourceFile[arrayList.size()]);
    }

    public List<ResourceFile> getSourceFileList() {
        return Collections.unmodifiableList(this.mFiles);
    }

    protected void replaceWith(ProjectResourceItem projectResourceItem) {
        this.mFiles.clear();
        this.mFiles.addAll(projectResourceItem.mFiles);
    }
}

