/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.configurations;

import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.configurations.ResourceQualifier;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import org.eclipse.swt.graphics.Image;

public class ScreenRatioQualifier
extends ResourceQualifier {
    public static final String NAME = "Screen Ratio";
    private ScreenRatio mValue = null;

    public ScreenRatioQualifier() {
    }

    public ScreenRatioQualifier(ScreenRatio screenRatio) {
        this.mValue = screenRatio;
    }

    public ScreenRatio getValue() {
        return this.mValue;
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return "Ratio";
    }

    public Image getIcon() {
        return IconFactory.getInstance().getIcon("ratio");
    }

    public boolean isValid() {
        return this.mValue != null;
    }

    public boolean checkAndSet(String string, FolderConfiguration folderConfiguration) {
        ScreenRatio screenRatio = ScreenRatio.getEnum(string);
        if (screenRatio != null) {
            ScreenRatioQualifier screenRatioQualifier = new ScreenRatioQualifier(screenRatio);
            folderConfiguration.setScreenRatioQualifier(screenRatioQualifier);
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof ScreenRatioQualifier) {
            return this.mValue == ((ScreenRatioQualifier)object).mValue;
        }
        return false;
    }

    public int hashCode() {
        if (this.mValue != null) {
            return this.mValue.hashCode();
        }
        return 0;
    }

    public String getFolderSegment(IAndroidTarget iAndroidTarget) {
        if (this.mValue != null) {
            if (iAndroidTarget == null) {
                return this.mValue.getValue();
            }
            AndroidVersion androidVersion = iAndroidTarget.getVersion();
            if (androidVersion.getApiLevel() >= 4 || androidVersion.getApiLevel() == 3 && "Donut".equals(androidVersion.getCodename())) {
                return this.mValue.getValue();
            }
        }
        return "";
    }

    public String getStringValue() {
        if (this.mValue != null) {
            return this.mValue.getDisplayValue();
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScreenRatio {
        NOTLONG("notlong", "Not Long"),
        LONG("long", "Long");

        private String mValue;
        private String mDisplayValue;

        private ScreenRatio(String string2, String string3) {
            this.mValue = string2;
            this.mDisplayValue = string3;
        }

        static ScreenRatio getEnum(String string) {
            ScreenRatio[] screenRatioArray = ScreenRatio.values();
            int n = screenRatioArray.length;
            int n2 = 0;
            while (n2 < n) {
                ScreenRatio screenRatio = screenRatioArray[n2];
                if (screenRatio.mValue.equals(string)) {
                    return screenRatio;
                }
                ++n2;
            }
            return null;
        }

        public String getValue() {
            return this.mValue;
        }

        public String getDisplayValue() {
            return this.mDisplayValue;
        }

        public static int getIndex(ScreenRatio screenRatio) {
            int n = 0;
            ScreenRatio[] screenRatioArray = ScreenRatio.values();
            int n2 = screenRatioArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ScreenRatio screenRatio2 = screenRatioArray[n3];
                if (screenRatio2 == screenRatio) {
                    return n;
                }
                ++n;
                ++n3;
            }
            return -1;
        }

        public static ScreenRatio getByIndex(int n) {
            int n2 = 0;
            ScreenRatio[] screenRatioArray = ScreenRatio.values();
            int n3 = screenRatioArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ScreenRatio screenRatio = screenRatioArray[n4];
                if (n2 == n) {
                    return screenRatio;
                }
                ++n2;
                ++n4;
            }
            return null;
        }
    }
}

