/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.configurations;

import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.configurations.ResourceQualifier;
import com.android.sdklib.IAndroidTarget;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Image;

public final class LanguageQualifier
extends ResourceQualifier {
    private static final Pattern sLanguagePattern = Pattern.compile("^[a-z]{2}$");
    public static final String NAME = "Language";
    private String mValue;

    public static LanguageQualifier getQualifier(String string) {
        if (sLanguagePattern.matcher(string).matches()) {
            LanguageQualifier languageQualifier = new LanguageQualifier();
            languageQualifier.mValue = string;
            return languageQualifier;
        }
        return null;
    }

    public static String getFolderSegment(String string) {
        String string2 = string.toLowerCase();
        if (sLanguagePattern.matcher(string2).matches()) {
            return string2;
        }
        return null;
    }

    public String getValue() {
        if (this.mValue != null) {
            return this.mValue;
        }
        return "";
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return NAME;
    }

    public Image getIcon() {
        return IconFactory.getInstance().getIcon("language");
    }

    public boolean isValid() {
        return this.mValue != null;
    }

    public boolean checkAndSet(String string, FolderConfiguration folderConfiguration) {
        LanguageQualifier languageQualifier = LanguageQualifier.getQualifier(string);
        if (languageQualifier != null) {
            folderConfiguration.setLanguageQualifier(languageQualifier);
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof LanguageQualifier) {
            if (this.mValue == null) {
                return ((LanguageQualifier)object).mValue == null;
            }
            return this.mValue.equals(((LanguageQualifier)object).mValue);
        }
        return false;
    }

    public int hashCode() {
        if (this.mValue != null) {
            return this.mValue.hashCode();
        }
        return 0;
    }

    public String getFolderSegment(IAndroidTarget iAndroidTarget) {
        if (this.mValue != null) {
            return LanguageQualifier.getFolderSegment(this.mValue);
        }
        return "";
    }

    public String getStringValue() {
        if (this.mValue != null) {
            return this.mValue;
        }
        return "";
    }
}

