/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources.configurations;

import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.resources.configurations.FolderConfiguration;
import com.android.ide.eclipse.adt.internal.resources.configurations.ResourceQualifier;
import com.android.sdklib.IAndroidTarget;
import org.eclipse.swt.graphics.Image;

public final class KeyboardStateQualifier
extends ResourceQualifier {
    public static final String NAME = "Keyboard State";
    private KeyboardState mValue = null;

    public KeyboardStateQualifier() {
    }

    public KeyboardStateQualifier(KeyboardState keyboardState) {
        this.mValue = keyboardState;
    }

    public KeyboardState getValue() {
        return this.mValue;
    }

    public String getName() {
        return NAME;
    }

    public String getShortName() {
        return "Keyboard";
    }

    public Image getIcon() {
        return IconFactory.getInstance().getIcon("keyboard");
    }

    public boolean isValid() {
        return this.mValue != null;
    }

    public boolean checkAndSet(String string, FolderConfiguration folderConfiguration) {
        KeyboardState keyboardState = KeyboardState.getEnum(string);
        if (keyboardState != null) {
            KeyboardStateQualifier keyboardStateQualifier = new KeyboardStateQualifier();
            keyboardStateQualifier.mValue = keyboardState;
            folderConfiguration.setKeyboardStateQualifier(keyboardStateQualifier);
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof KeyboardStateQualifier) {
            return this.mValue == ((KeyboardStateQualifier)object).mValue;
        }
        return false;
    }

    public int hashCode() {
        if (this.mValue != null) {
            return this.mValue.hashCode();
        }
        return 0;
    }

    public String getFolderSegment(IAndroidTarget iAndroidTarget) {
        if (this.mValue != null) {
            return this.mValue.getValue();
        }
        return "";
    }

    public String getStringValue() {
        if (this.mValue != null) {
            return this.mValue.getDisplayValue();
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum KeyboardState {
        EXPOSED("keysexposed", "Exposed"),
        HIDDEN("keyshidden", "Hidden");

        private String mValue;
        private String mDisplayValue;

        private KeyboardState(String string2, String string3) {
            this.mValue = string2;
            this.mDisplayValue = string3;
        }

        static KeyboardState getEnum(String string) {
            KeyboardState[] keyboardStateArray = KeyboardState.values();
            int n = keyboardStateArray.length;
            int n2 = 0;
            while (n2 < n) {
                KeyboardState keyboardState = keyboardStateArray[n2];
                if (keyboardState.mValue.equals(string)) {
                    return keyboardState;
                }
                ++n2;
            }
            return null;
        }

        public String getValue() {
            return this.mValue;
        }

        public String getDisplayValue() {
            return this.mDisplayValue;
        }

        public static int getIndex(KeyboardState keyboardState) {
            int n = 0;
            KeyboardState[] keyboardStateArray = KeyboardState.values();
            int n2 = keyboardStateArray.length;
            int n3 = 0;
            while (n3 < n2) {
                KeyboardState keyboardState2 = keyboardStateArray[n3];
                if (keyboardState == keyboardState2) {
                    return n;
                }
                ++n;
                ++n3;
            }
            return -1;
        }

        public static KeyboardState getByIndex(int n) {
            int n2 = 0;
            KeyboardState[] keyboardStateArray = KeyboardState.values();
            int n3 = keyboardStateArray.length;
            int n4 = 0;
            while (n4 < n3) {
                KeyboardState keyboardState = keyboardStateArray[n4];
                if (n2 == n) {
                    return keyboardState;
                }
                ++n2;
                ++n4;
            }
            return null;
        }
    }
}

