/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.resources;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.resources.DeclareStyleableInfo;
import com.android.ide.eclipse.adt.internal.resources.ViewClassInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttrsXmlParser {
    private Document mDocument;
    private String mOsAttrsXmlPath;
    private HashMap<String, DeclareStyleableInfo.AttributeInfo> mAttributeMap;
    private HashMap<String, DeclareStyleableInfo> mStyleMap;
    private Map<String, Map<String, Integer>> mEnumFlagValues;

    public AttrsXmlParser(String string) {
        this(string, null);
    }

    public AttrsXmlParser(String string, AttrsXmlParser attrsXmlParser) {
        this.mOsAttrsXmlPath = string;
        this.mStyleMap = new HashMap();
        if (attrsXmlParser == null) {
            this.mAttributeMap = new HashMap();
            this.mEnumFlagValues = new HashMap<String, Map<String, Integer>>();
        } else {
            this.mAttributeMap = new HashMap<String, DeclareStyleableInfo.AttributeInfo>(attrsXmlParser.mAttributeMap);
            this.mEnumFlagValues = new HashMap<String, Map<String, Integer>>(attrsXmlParser.mEnumFlagValues);
        }
    }

    public String getOsAttrsXmlPath() {
        return this.mOsAttrsXmlPath;
    }

    public AttrsXmlParser preload() {
        Document document = this.getDocument();
        if (document == null) {
            AdtPlugin.log(2, "Failed to find %1$s", this.mOsAttrsXmlPath);
            return this;
        }
        Node node = document.getFirstChild();
        while (node != null && node.getNodeType() != 1 && !node.getNodeName().equals("resources")) {
            node = node.getNextSibling();
        }
        if (node == null) {
            AdtPlugin.log(2, "Failed to find a <resources> node in %1$s", this.mOsAttrsXmlPath);
            return this;
        }
        this.parseResources(node);
        return this;
    }

    public void loadViewAttributes(ViewClassInfo viewClassInfo) {
        String string;
        DeclareStyleableInfo declareStyleableInfo;
        if (this.getDocument() != null && (declareStyleableInfo = this.mStyleMap.get(string = viewClassInfo.getShortClassName())) != null) {
            viewClassInfo.setAttributes(declareStyleableInfo.getAttributes());
            viewClassInfo.setJavaDoc(declareStyleableInfo.getJavaDoc());
        }
    }

    public void loadLayoutParamsAttributes(ViewClassInfo.LayoutParamsInfo layoutParamsInfo) {
        if (this.getDocument() != null) {
            String string = String.format("%1$s_%2$s", layoutParamsInfo.getViewLayoutClass().getShortClassName(), layoutParamsInfo.getShortClassName());
            DeclareStyleableInfo declareStyleableInfo = this.mStyleMap.get(string = string.replaceFirst("Params$", ""));
            if (declareStyleableInfo != null) {
                layoutParamsInfo.setAttributes(declareStyleableInfo.getAttributes());
            }
        }
    }

    public Map<String, DeclareStyleableInfo> getDeclareStyleableList() {
        return Collections.unmodifiableMap(this.mStyleMap);
    }

    public Map<String, Map<String, Integer>> getEnumFlagValues() {
        return this.mEnumFlagValues;
    }

    private Document getDocument() {
        if (this.mDocument == null) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(false);
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                this.mDocument = documentBuilder.parse(new File(this.mOsAttrsXmlPath));
            }
            catch (ParserConfigurationException parserConfigurationException) {
                AdtPlugin.log(parserConfigurationException, "Failed to create XML document builder for %1$s", this.mOsAttrsXmlPath);
            }
            catch (SAXException sAXException) {
                AdtPlugin.log(sAXException, "Failed to parse XML document %1$s", this.mOsAttrsXmlPath);
            }
            catch (IOException iOException) {
                AdtPlugin.log(iOException, "Failed to read XML document %1$s", this.mOsAttrsXmlPath);
            }
        }
        return this.mDocument;
    }

    private void parseResources(Node node) {
        Node node2 = null;
        Node node3 = node.getFirstChild();
        while (node3 != null) {
            switch (node3.getNodeType()) {
                case 8: {
                    node2 = node3;
                    break;
                }
                case 1: {
                    if (node3.getNodeName().equals("declare-styleable")) {
                        Node node4 = node3.getAttributes().getNamedItem("name");
                        if (node4 != null) {
                            String string;
                            String string2 = node4.getNodeValue();
                            Node node5 = node3.getAttributes().getNamedItem("parent");
                            String string3 = string = node5 == null ? null : node5.getNodeValue();
                            if (string2 != null && !this.mStyleMap.containsKey(string2)) {
                                DeclareStyleableInfo declareStyleableInfo = this.parseDeclaredStyleable(string2, node3);
                                if (string != null) {
                                    declareStyleableInfo.setParents(string.split("[ ,|]"));
                                }
                                this.mStyleMap.put(string2, declareStyleableInfo);
                                if (node2 != null) {
                                    declareStyleableInfo.setJavaDoc(this.parseJavadoc(node2.getNodeValue()));
                                }
                            }
                        }
                    } else if (node3.getNodeName().equals("attr")) {
                        this.parseAttr(node3, node2);
                    }
                    node2 = null;
                }
            }
            node3 = node3.getNextSibling();
        }
    }

    private DeclareStyleableInfo.AttributeInfo parseAttr(Node node, Node node2) {
        String string;
        DeclareStyleableInfo.AttributeInfo attributeInfo = null;
        Node node3 = node.getAttributes().getNamedItem("name");
        if (node3 != null && (string = node3.getNodeValue()) != null) {
            attributeInfo = this.mAttributeMap.get(string);
            if (attributeInfo == null || attributeInfo.getFormats().length == 0) {
                attributeInfo = this.parseAttributeTypes(node, string);
                if (attributeInfo != null) {
                    this.mAttributeMap.put(string, attributeInfo);
                }
            } else if (node2 != null) {
                attributeInfo = new DeclareStyleableInfo.AttributeInfo(attributeInfo);
            }
            if (attributeInfo != null && node2 != null) {
                attributeInfo.setJavaDoc(this.parseJavadoc(node2.getNodeValue()));
                attributeInfo.setDeprecatedDoc(this.parseDeprecatedDoc(node2.getNodeValue()));
            }
        }
        return attributeInfo;
    }

    private DeclareStyleableInfo parseDeclaredStyleable(String string, Node node) {
        ArrayList<DeclareStyleableInfo.AttributeInfo> arrayList = new ArrayList<DeclareStyleableInfo.AttributeInfo>();
        Node node2 = null;
        Node node3 = node.getFirstChild();
        while (node3 != null) {
            switch (node3.getNodeType()) {
                case 8: {
                    node2 = node3;
                    break;
                }
                case 1: {
                    DeclareStyleableInfo.AttributeInfo attributeInfo;
                    if (node3.getNodeName().equals("attr") && (attributeInfo = this.parseAttr(node3, node2)) != null) {
                        arrayList.add(attributeInfo);
                    }
                    node2 = null;
                }
            }
            node3 = node3.getNextSibling();
        }
        return new DeclareStyleableInfo(string, arrayList.toArray(new DeclareStyleableInfo.AttributeInfo[arrayList.size()]));
    }

    private DeclareStyleableInfo.AttributeInfo parseAttributeTypes(Node node, String string) {
        Object object;
        TreeSet<DeclareStyleableInfo.AttributeInfo.Format> treeSet = new TreeSet<DeclareStyleableInfo.AttributeInfo.Format>();
        String[] stringArray = null;
        String[] stringArray2 = null;
        Node node2 = node.getAttributes().getNamedItem("format");
        if (node2 != null) {
            String[] stringArray3 = node2.getNodeValue().split("\\|");
            int n = stringArray3.length;
            int n2 = 0;
            while (n2 < n) {
                object = stringArray3[n2];
                try {
                    DeclareStyleableInfo.AttributeInfo.Format format = DeclareStyleableInfo.AttributeInfo.Format.valueOf(((String)object).toUpperCase());
                    if (format != null && format != DeclareStyleableInfo.AttributeInfo.Format.ENUM && format != DeclareStyleableInfo.AttributeInfo.Format.FLAG) {
                        treeSet.add(format);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    AdtPlugin.log(illegalArgumentException, "Unknown format name '%s' in <attr name=\"%s\">, file '%s'.", object, string, this.getOsAttrsXmlPath());
                }
                ++n2;
            }
        }
        if ((stringArray = this.parseEnumFlagValues(node, "enum", string)) != null) {
            treeSet.add(DeclareStyleableInfo.AttributeInfo.Format.ENUM);
        }
        if ((stringArray2 = this.parseEnumFlagValues(node, "flag", string)) != null) {
            treeSet.add(DeclareStyleableInfo.AttributeInfo.Format.FLAG);
        }
        object = new DeclareStyleableInfo.AttributeInfo(string, treeSet.toArray(new DeclareStyleableInfo.AttributeInfo.Format[treeSet.size()]));
        ((DeclareStyleableInfo.AttributeInfo)object).setEnumValues(stringArray);
        ((DeclareStyleableInfo.AttributeInfo)object).setFlagValues(stringArray2);
        return object;
    }

    private String[] parseEnumFlagValues(Node node, String string, String string2) {
        ArrayList<String> arrayList = null;
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2.getNodeType() == 1 && node2.getNodeName().equals(string)) {
                Node node3 = node2.getAttributes().getNamedItem("name");
                if (node3 == null) {
                    AdtPlugin.log(2, "Missing name attribute in <attr name=\"%s\"><%s></attr>", string2, string);
                } else {
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                    }
                    String string3 = node3.getNodeValue();
                    arrayList.add(string3);
                    Node node4 = node2.getAttributes().getNamedItem("value");
                    if (node4 == null) {
                        AdtPlugin.log(2, "Missing value attribute in <attr name=\"%s\"><%s name=\"%s\"></attr>", string2, string, string3);
                    } else {
                        String string4 = node4.getNodeValue();
                        try {
                            int n = string4.startsWith("0x") ? Integer.parseInt(string4.substring(2), 16) : Integer.parseInt(string4);
                            Map<String, Integer> map = this.mEnumFlagValues.get(string2);
                            if (map == null) {
                                map = new HashMap<String, Integer>();
                                this.mEnumFlagValues.put(string2, map);
                            }
                            map.put(string3, n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            AdtPlugin.log(numberFormatException, "Value in <attr name=\"%s\"><%s name=\"%s\" value=\"%s\"></attr> is not a valid decimal or hexadecimal", string2, string, string3, string4);
                        }
                    }
                }
            }
            node2 = node2.getNextSibling();
        }
        return arrayList == null ? null : arrayList.toArray(new String[arrayList.size()]);
    }

    private String parseJavadoc(String string) {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("\\s+", " ");
        string = string.replaceAll("(?:\\{@deprecated[^}]*\\}|@deprecated[^@}]*)", "");
        string = string.replaceFirst("^\\s*(.*?(?:$|(?<![a-zA-Z]\\.[a-zA-Z])\\.(?=\\s))).*", "$1");
        return string;
    }

    private String parseDeprecatedDoc(String string) {
        if (string == null) {
            return null;
        }
        int n = (string = string.replaceAll("\\s+", " ")).indexOf("{@deprecated");
        if (n >= 0) {
            string = string.substring(n + 12);
            string = string.replaceFirst("^([^}]*).*", "$1");
        } else {
            n = string.indexOf("@deprecated");
            if (n >= 0) {
                string = string.substring(n + 11);
                string = string.replaceFirst("^(.*?)(?:@.*|$)", "$1");
            } else {
                return null;
            }
        }
        return string.trim();
    }
}

