/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.refactorings.extractstring;

import com.android.ide.eclipse.adt.internal.editors.AndroidEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ReferenceAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestParser;
import com.android.ide.eclipse.adt.internal.refactorings.extractstring.ExtractStringDescriptor;
import com.android.ide.eclipse.adt.internal.refactorings.extractstring.XmlStringFileHelper;
import com.android.ide.eclipse.adt.internal.resources.ResourceType;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceFolderType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractStringRefactoring
extends Refactoring {
    private final Mode mMode;
    private String mXmlAttributeName;
    private final IFile mFile;
    private final IEditorPart mEditor;
    private final IProject mProject;
    private final int mSelectionStart;
    private final int mSelectionEnd;
    private ICompilationUnit mUnit;
    private String mTokenString;
    private String mXmlStringId;
    private String mXmlStringValue;
    private String mTargetXmlFileWsPath;
    private ArrayList<Change> mChanges;
    private XmlStringFileHelper mXmlHelper = new XmlStringFileHelper();
    private static final String KEY_MODE = "mode";
    private static final String KEY_FILE = "file";
    private static final String KEY_PROJECT = "proj";
    private static final String KEY_SEL_START = "sel-start";
    private static final String KEY_SEL_END = "sel-end";
    private static final String KEY_TOK_ESC = "tok-esc";
    private static final String KEY_XML_ATTR_NAME = "xml-attr-name";

    public ExtractStringRefactoring(Map<String, String> map) throws NullPointerException {
        this.mMode = Mode.valueOf(map.get(KEY_MODE));
        IPath iPath = Path.fromPortableString((String)map.get(KEY_PROJECT));
        this.mProject = (IProject)ResourcesPlugin.getWorkspace().getRoot().findMember(iPath);
        if (this.mMode == Mode.EDIT_SOURCE) {
            iPath = Path.fromPortableString((String)map.get(KEY_FILE));
            this.mFile = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(iPath);
            this.mSelectionStart = Integer.parseInt(map.get(KEY_SEL_START));
            this.mSelectionEnd = Integer.parseInt(map.get(KEY_SEL_END));
            this.mTokenString = map.get(KEY_TOK_ESC);
            this.mXmlAttributeName = map.get(KEY_XML_ATTR_NAME);
        } else {
            this.mFile = null;
            this.mSelectionEnd = -1;
            this.mSelectionStart = -1;
            this.mTokenString = null;
            this.mXmlAttributeName = null;
        }
        this.mEditor = null;
    }

    private Map<String, String> createArgumentMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(KEY_MODE, this.mMode.name());
        hashMap.put(KEY_PROJECT, this.mProject.getFullPath().toPortableString());
        if (this.mMode == Mode.EDIT_SOURCE) {
            hashMap.put(KEY_FILE, this.mFile.getFullPath().toPortableString());
            hashMap.put(KEY_SEL_START, Integer.toString(this.mSelectionStart));
            hashMap.put(KEY_SEL_END, Integer.toString(this.mSelectionEnd));
            hashMap.put(KEY_TOK_ESC, this.mTokenString);
            hashMap.put(KEY_XML_ATTR_NAME, this.mXmlAttributeName);
        }
        return hashMap;
    }

    public ExtractStringRefactoring(IFile iFile, IEditorPart iEditorPart, ITextSelection iTextSelection) {
        this.mMode = Mode.EDIT_SOURCE;
        this.mFile = iFile;
        this.mEditor = iEditorPart;
        this.mProject = iFile.getProject();
        this.mSelectionStart = iTextSelection.getOffset();
        this.mSelectionEnd = this.mSelectionStart + Math.max(0, iTextSelection.getLength() - 1);
    }

    public ExtractStringRefactoring(IProject iProject, boolean bl) {
        this.mMode = bl ? Mode.SELECT_NEW_ID : Mode.SELECT_ID;
        this.mFile = null;
        this.mEditor = null;
        this.mProject = iProject;
        this.mSelectionEnd = -1;
        this.mSelectionStart = -1;
    }

    public String getName() {
        if (this.mMode == Mode.SELECT_ID) {
            return "Create or USe Android String";
        }
        if (this.mMode == Mode.SELECT_NEW_ID) {
            return "Create New Android String";
        }
        return "Extract Android String";
    }

    public Mode getMode() {
        return this.mMode;
    }

    public String getTokenString() {
        return this.mTokenString;
    }

    public String getXmlStringId() {
        return this.mXmlStringId;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor var1_1) throws CoreException, OperationCanceledException {
        this.mUnit = null;
        this.mTokenString = null;
        var2_2 = new RefactoringStatus();
        try {
            block14: {
                var1_1.beginTask("Checking preconditions...", 6);
                if (this.mMode != Mode.EDIT_SOURCE) {
                    var1_1.worked(6);
                    var5_3 = var2_2;
                    return var5_3;
                }
                if (!this.checkSourceFile(this.mFile, var2_2, var1_1)) {
                    var5_4 = var2_2;
                    return var5_4;
                }
                this.mUnit = JavaCore.createCompilationUnitFrom((IFile)this.mFile);
                if (this.mUnit.isReadOnly()) {
                    var2_2.addFatalError("The file is read-only, please make it writeable first.");
                    var5_5 = var2_2;
                    return var5_5;
                }
                if (this.findSelectionInJavaUnit(this.mUnit, var2_2, var1_1)) ** GOTO lbl-1000
                var5_6 = var2_2;
                return var5_6;
lbl-1000:
                // 1 sources

                {
                    if (this.mUnit == null) break block14;
                    var1_1.worked(1);
                    var5_7 = var2_2;
                    return var5_7;
                }
            }
            if (this.mFile != null && "xml".equals(this.mFile.getFileExtension()) && (var3_9 = this.mFile.getFullPath()).segmentCount() == 4 && var3_9.segment(1).equalsIgnoreCase("res") && !this.findSelectionInXmlFile(this.mFile, var2_2, var1_1)) {
                var5_8 = var2_2;
                return var5_8;
            }
            if (var2_2.isOK() != false) return var2_2;
            var2_2.addFatalError("Selection must be inside a Java source or an Android Layout XML file.");
            return var2_2;
        }
        finally {
            var1_1.done();
        }
    }

    private boolean findSelectionInJavaUnit(ICompilationUnit iCompilationUnit, RefactoringStatus refactoringStatus, IProgressMonitor iProgressMonitor) {
        block17: {
            try {
                IBuffer iBuffer = iCompilationUnit.getBuffer();
                IScanner iScanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                iScanner.setSource(iBuffer.getCharacters());
                iProgressMonitor.worked(1);
                int n = iScanner.getNextToken();
                while (n != 158) {
                    if (iScanner.getCurrentTokenStartPosition() <= this.mSelectionStart && iScanner.getCurrentTokenEndPosition() >= this.mSelectionEnd) {
                        if (n == 45) {
                            this.mTokenString = new String(iScanner.getCurrentTokenSource());
                        }
                    } else if (iScanner.getCurrentTokenStartPosition() <= this.mSelectionEnd) {
                        n = iScanner.getNextToken();
                        continue;
                    }
                    break;
                }
            }
            catch (JavaModelException javaModelException) {
                iProgressMonitor.worked(1);
                break block17;
            }
            catch (InvalidInputException invalidInputException) {
                try {
                    break block17;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    iProgressMonitor.worked(1);
                }
            }
            iProgressMonitor.worked(1);
        }
        if (this.mTokenString != null) {
            int n = this.mTokenString.length();
            if (n > 0 && this.mTokenString.charAt(0) == '\"' && this.mTokenString.charAt(n - 1) == '\"') {
                this.mTokenString = this.mTokenString.substring(1, n - 1);
            }
            if (this.mTokenString.length() == 0) {
                this.mTokenString = null;
            }
        }
        if (this.mTokenString == null) {
            refactoringStatus.addFatalError("Please select a Java string literal.");
        }
        iProgressMonitor.worked(1);
        return refactoringStatus.isOK();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean findSelectionInXmlFile(IFile var1_1, RefactoringStatus var2_2, IProgressMonitor var3_3) {
        block34: {
            block33: {
                if (!(this.mEditor instanceof AndroidEditor)) {
                    var2_2.addFatalError("Only the Android XML Editor is currently supported.");
                    var23_4 = var2_2.isOK();
                    return var23_4;
                }
                var4_5 = (AndroidEditor)this.mEditor;
                var5_6 = null;
                var6_7 = null;
                var7_8 = null;
                var5_6 = var4_5.getModelForRead();
                if (var5_6 == null) return var2_2.isOK();
                var8_9 = this.mSelectionStart;
                while (var8_9 >= 0 && var6_7 == null) {
                    var6_7 = (Node)var5_6.getIndexedRegion(var8_9);
                    --var8_9;
                }
                if (var6_7 == null) {
                    var2_2.addFatalError("The selection does not match any element in the XML document.");
                    var21_11 = var2_2.isOK();
                    return var21_11;
                }
                if (var6_7.getNodeType() != 1) {
                    var2_2.addFatalError("The selection is not inside an actual XML element.");
                    var21_12 = var2_2.isOK();
                    return var21_12;
                }
                var8_10 = var5_6.getStructuredDocument();
                if (var8_10 != null && (var10_15 = var8_10.getRegionAtCharacterOffset(var9_13 = this.mSelectionStart)) != null && "XML_TAG_NAME".equals(var10_15.getType())) {
                    var11_16 = var9_13 - var10_15.getStartOffset();
                    var12_18 = var10_15.getNumberOfRegions();
                    var13_20 = var10_15.getRegions();
                    var14_23 = null;
                    var15_30 = 0;
                    while (var15_30 < var12_18) {
                        var16_32 /* !! */  = var13_20.get(var15_30);
                        var17_33 = var16_32 /* !! */ .getType();
                        if ("XML_TAG_ATTRIBUTE_NAME".equals(var17_33)) {
                            var7_8 = var10_15.getText(var16_32 /* !! */ );
                            if (var16_32 /* !! */ .getStart() <= var11_16 && var11_16 < var16_32 /* !! */ .getTextEnd() && var15_30 <= var12_18 - 3 && "XML_TAG_ATTRIBUTE_EQUALS".equals(var13_20.get(var15_30 + 1).getType()) && "XML_TAG_ATTRIBUTE_VALUE".equals(var17_33 = (var16_32 /* !! */  = var13_20.get(var15_30 + 2)).getType())) {
                                var14_25 = var10_15.getText(var16_32 /* !! */ );
                            }
                        } else if (var16_32 /* !! */ .getStart() <= var11_16 && var11_16 < var16_32 /* !! */ .getTextEnd() && "XML_TAG_ATTRIBUTE_VALUE".equals(var17_33)) {
                            var14_26 = var10_15.getText(var16_32 /* !! */ );
                        }
                        if (var14_24 != null) {
                            var18_34 = var14_24;
                            var19_35 = var18_34.length();
                            if (var19_35 >= 2 && var18_34.charAt(0) == '\"' && var18_34.charAt(var19_35 - 1) == '\"') {
                                var18_34 = var18_34.substring(1, var19_35 - 1);
                            } else if (var19_35 >= 2 && var18_34.charAt(0) == '\'' && var18_34.charAt(var19_35 - 1) == '\'') {
                                var18_34 = var18_34.substring(1, var19_35 - 1);
                            }
                            if (var18_34.length() <= 0 || var7_8 == null) break;
                            this.mTokenString = var18_34;
                            break;
                        }
                        ++var15_30;
                    }
                    if (this.mTokenString == null) {
                        var2_2.addFatalError("The selection is not inside an actual XML attribute value.");
                    }
                }
                if (this.mTokenString == null || var6_7 == null || var7_8 == null) break block33;
                var9_14 = var4_5.getUiRootNode();
                var10_15 = var9_14 == null ? null : var9_14.findXmlNode(var6_7);
                var11_17 = null;
                if (var10_15 == null) break block34;
                var12_19 = var7_8;
                var13_21 = var12_19.indexOf(58);
                if (var13_21 > 0 && var13_21 < var12_19.length() - 1) {
                    var12_19 = var12_19.substring(var13_21 + 1);
                }
                var15_31 = var10_15.getUiAttributes().iterator();
                if (true) ** GOTO lbl85
            }
            this.mTokenString = null;
            return var2_2.isOK();
            finally {
                if (var5_6 != null) {
                    var5_6.releaseFromRead();
                }
            }
            finally {
                var3_3.worked(1);
            }
            do {
                if (!(var14_28 = var15_31.next()).getDescriptor().getXmlLocalName().equals(var12_19)) continue;
                var16_32 /* !! */  = var14_28.getDescriptor();
                if (!(var16_32 /* !! */  instanceof ReferenceAttributeDescriptor)) break;
                var11_17 = (ReferenceAttributeDescriptor)var16_32 /* !! */ ;
                break;
lbl85:
                // 2 sources

            } while (var15_31.hasNext());
        }
        if (var11_17 != null && (var11_17.getResourceType() == null || var11_17.getResourceType() == ResourceType.STRING)) {
            if (this.mTokenString.startsWith("@")) {
                var12_18 = 0;
                if (this.mTokenString.length() > 1 && this.mTokenString.charAt(1) == '+') {
                    ++var12_18;
                }
                if ((var13_22 = this.mTokenString.indexOf(47)) > var12_18) {
                    var14_29 = this.mTokenString.substring(var12_18 + 1, var13_22);
                    this.mTokenString = null;
                    var2_2.addFatalError(String.format("The attribute %1$s already contains a %2$s reference.", new Object[]{var7_8, var14_29}));
                }
            }
            if (this.mTokenString == null) return var2_2.isOK();
            this.mXmlAttributeName = var7_8;
            return var2_2.isOK();
        }
        this.mTokenString = null;
        var2_2.addFatalError(String.format("The attribute %1$s does not accept a string reference.", new Object[]{var7_8}));
        return var2_2.isOK();
    }

    private boolean checkSourceFile(IFile iFile, RefactoringStatus refactoringStatus, IProgressMonitor iProgressMonitor) {
        if (!iFile.isSynchronized(0)) {
            refactoringStatus.addFatalError("The file is not synchronized. Please save it first.");
            return false;
        }
        iProgressMonitor.worked(1);
        ResourceAttributes resourceAttributes = iFile.getResourceAttributes();
        if (resourceAttributes == null || resourceAttributes.isReadOnly()) {
            refactoringStatus.addFatalError("The file is read-only, please make it writeable first.");
            return false;
        }
        iProgressMonitor.worked(1);
        return true;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        try {
            Object object;
            iProgressMonitor.beginTask("Checking post-conditions...", 3);
            if (this.mXmlStringId == null || this.mXmlStringId.length() <= 0) {
                refactoringStatus.addFatalError("Missing replacement string ID");
            } else if (this.mTargetXmlFileWsPath == null || this.mTargetXmlFileWsPath.length() <= 0) {
                refactoringStatus.addFatalError("Missing target xml file path");
            }
            iProgressMonitor.worked(1);
            IResource iResource = this.getTargetXmlResource(this.mTargetXmlFileWsPath);
            if (iResource != null) {
                if (iResource.getType() != 1) {
                    refactoringStatus.addFatalError(String.format("XML file '%1$s' is not a file.", this.mTargetXmlFileWsPath));
                } else {
                    object = iResource.getResourceAttributes();
                    if (object != null && object.isReadOnly()) {
                        refactoringStatus.addFatalError(String.format("XML file '%1$s' is read-only.", this.mTargetXmlFileWsPath));
                    }
                }
            }
            iProgressMonitor.worked(1);
            if (refactoringStatus.hasError()) {
                RefactoringStatus refactoringStatus2 = refactoringStatus;
                return refactoringStatus2;
            }
            this.mChanges = new ArrayList();
            if (this.mXmlHelper.valueOfStringId(this.mProject, this.mTargetXmlFileWsPath, this.mXmlStringId) == null && (object = this.createXmlChange((IFile)iResource, this.mXmlStringId, this.mXmlStringValue, refactoringStatus, SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)1))) != null) {
                this.mChanges.add((Change)object);
            }
            if (refactoringStatus.hasError()) {
                RefactoringStatus refactoringStatus3 = refactoringStatus;
                return refactoringStatus3;
            }
            if (this.mMode == Mode.EDIT_SOURCE) {
                object = null;
                object = this.mXmlAttributeName != null ? this.computeXmlSourceChanges(this.mFile, this.mXmlStringId, this.mTokenString, this.mXmlAttributeName, refactoringStatus, iProgressMonitor) : this.computeJavaChanges(this.mUnit, this.mXmlStringId, this.mTokenString, refactoringStatus, SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)1));
                if (object != null) {
                    this.mChanges.addAll((Collection<Change>)object);
                }
            }
            iProgressMonitor.worked(1);
        }
        finally {
            iProgressMonitor.done();
        }
        return refactoringStatus;
    }

    private Change createXmlChange(IFile iFile, String string, String string2, RefactoringStatus refactoringStatus, SubMonitor subMonitor) {
        TextFileChange textFileChange = new TextFileChange(this.getName(), iFile);
        textFileChange.setTextType("xml");
        InsertEdit insertEdit = null;
        TextEditGroup textEditGroup = null;
        if (!iFile.exists()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            stringBuilder.append("<resources>\n");
            stringBuilder.append("    <string name=\"").append(string).append("\">").append(string2).append("</string>\n");
            stringBuilder.append("</resources>\n");
            insertEdit = new InsertEdit(0, stringBuilder.toString());
            textEditGroup = new TextEditGroup("Create <string> in new XML file", (TextEdit)insertEdit);
        } else {
            try {
                int[] nArray = new int[2];
                if (this.findXmlOpeningTagPos(iFile.getContents(), "resources", nArray)) {
                    int n = nArray[0];
                    int n2 = nArray[1];
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(">\n");
                    stringBuilder.append("    <string name=\"").append(string).append("\">").append(string2).append("</string>");
                    if (n2 == 2) {
                        stringBuilder.append("\n</resources>");
                    }
                    insertEdit = new ReplaceEdit(n, n2, stringBuilder.toString());
                    textEditGroup = new TextEditGroup("Insert <string> in XML file", (TextEdit)insertEdit);
                }
            }
            catch (CoreException coreException) {}
        }
        if (insertEdit == null) {
            refactoringStatus.addFatalError(String.format("Failed to modify file %1$s", this.mTargetXmlFileWsPath));
            return null;
        }
        textFileChange.setEdit(insertEdit);
        textFileChange.addTextEditChangeGroup(new TextEditChangeGroup((TextChange)textFileChange, textEditGroup));
        subMonitor.worked(1);
        return textFileChange;
    }

    /*
     * Exception decompiling
     */
    private boolean findXmlOpeningTagPos(InputStream var1_1, String var2_2, int[] var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private List<Change> computeXmlSourceChanges(IFile var1_1, String var2_2, String var3_3, String var4_4, RefactoringStatus var5_5, IProgressMonitor var6_6) {
        block39: {
            if (!var1_1.exists()) {
                var5_5.addFatalError(String.format("XML file '%1$s' does not exist.", new Object[]{var1_1.getFullPath().toOSString()}));
                return null;
            }
            var7_7 = new HashSet<IFile>();
            var7_7.add(var1_1);
            if ("xml".equals(var1_1.getFileExtension()) && (var8_8 = var1_1.getFullPath()).segmentCount() == 4 && var8_8.segment(1).equals("res")) {
                var9_9 = var1_1.getProject();
                var10_10 /* !! */  = var8_8.segment(3);
                var11_13 = var8_8.segment(2);
                var12_14 = ResourceFolderType.getFolderType(var11_13);
                var13_15 = var1_1.getParent().getParent();
                if (var12_14 != null && var13_15 != null && var13_15.getType() == 2) {
                    try {
                        var17_16 /* !! */  = var13_15.members();
                        var16_17 = var17_16 /* !! */ .length;
                        var15_19 = 0;
                        while (var15_19 < var16_17) {
                            var14_21 = var17_16 /* !! */ [var15_19];
                            if (var14_21 != null && var14_21.getType() == 2 && !(var18_22 = var14_21.getName()).equals(var11_13) && var12_14.equals((Object)(var19_24 = ResourceFolderType.getFolderType(var18_22))) && (var21_28 = var9_9.findMember(var20_26 = var13_15.getProjectRelativePath().append(var18_22).append((String)var10_10 /* !! */ ))) != null && var21_28 instanceof IFile) {
                                var7_7.add((IFile)var21_28);
                            }
                            ++var15_19;
                        }
                    }
                    catch (CoreException v0) {}
                }
            }
            var8_8 = SubMonitor.convert((IProgressMonitor)var6_6, (int)Math.min(1, var7_7.size()));
            var9_9 = new ArrayList();
            try {
                var10_10 /* !! */  = StructuredModelManager.getModelManager();
                for (String var11_13 : var7_7) {
                    var13_15 = var10_10 /* !! */ .createStructuredDocumentFor((IFile)var11_13);
                    if (var13_15 == null) {
                        var5_5.addFatalError("XML structured document not found");
                        return null;
                    }
                    try {
                        block36: {
                            block38: {
                                block37: {
                                    var14_21 = new TextFileChange(this.getName(), (IFile)var11_13);
                                    var14_21.setTextType("xml");
                                    var15_20 = new MultiTextEdit();
                                    var16_18 = new ArrayList<TextEditGroup>();
                                    var17_16 /* !! */  = this.quotedAttrValue("@string/" + var2_2);
                                    try {
                                        try {
                                            var21_28 = var13_15.getStructuredDocumentRegions();
                                            var20_27 = ((IStructuredDocumentRegion[])var21_28).length;
                                            var19_25 = 0;
                                            while (var19_25 < var20_27) {
                                                var18_22 = var21_28[var19_25];
                                                if ("XML_TAG_NAME".equals(var18_22.getType())) {
                                                    var22_29 = var18_22.getNumberOfRegions();
                                                    var23_30 = var18_22.getRegions();
                                                    var24_31 = null;
                                                    var25_32 = 0;
                                                    while (var25_32 < var22_29) {
                                                        var26_33 = var23_30.get(var25_32);
                                                        var27_34 = var26_33.getType();
                                                        if ("XML_TAG_ATTRIBUTE_NAME".equals(var27_34)) {
                                                            var24_31 = var18_22.getText(var26_33);
                                                        } else if ("XML_TAG_ATTRIBUTE_VALUE".equals(var27_34)) {
                                                            var28_35 = var18_22.getText(var26_33);
                                                            var29_36 = var28_35.length();
                                                            if (var29_36 >= 2 && var28_35.charAt(0) == '\"' && var28_35.charAt(var29_36 - 1) == '\"') {
                                                                var28_35 = var28_35.substring(1, var29_36 - 1);
                                                            } else if (var29_36 >= 2 && var28_35.charAt(0) == '\'' && var28_35.charAt(var29_36 - 1) == '\'') {
                                                                var28_35 = var28_35.substring(1, var29_36 - 1);
                                                            }
                                                            if (var4_4.equals(var24_31) && var3_3.equals(var28_35)) {
                                                                var30_37 = new ReplaceEdit(var18_22.getStartOffset() + var26_33.getStart(), var26_33.getTextLength(), (String)var17_16 /* !! */ );
                                                                var31_38 = new TextEditGroup("Replace attribute string by ID", (TextEdit)var30_37);
                                                                var15_20.addChild((TextEdit)var30_37);
                                                                var16_18.add(var31_38);
                                                            }
                                                        }
                                                        ++var25_32;
                                                    }
                                                }
                                                ++var19_25;
                                            }
                                            break block36;
                                        }
                                        catch (Throwable var18_23) {
                                            var5_5.addFatalError(String.format("XML refactoring error: %1$s", new Object[]{var18_23.getMessage()}));
                                            if (!var15_20.hasChildren()) break block37;
                                            var14_21.setEdit((TextEdit)var15_20);
                                            ** for (var33_39 : var16_18)
                                        }
                                    }
                                    catch (Throwable var32_41) {
                                        if (!var15_20.hasChildren()) break block38;
                                        var14_21.setEdit((TextEdit)var15_20);
                                        ** for (var33_39 : var16_18)
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                        var14_21.addTextEditChangeGroup(new TextEditChangeGroup((TextChange)var14_21, var33_39));
                                        continue;
                                    }
lbl86:
                                    // 1 sources

                                    var9_9.add(var14_21);
                                }
                                var8_8.worked(1);
                                continue;
lbl-1000:
                                // 1 sources

                                {
                                    var14_21.addTextEditChangeGroup(new TextEditChangeGroup((TextChange)var14_21, var33_39));
                                    continue;
                                }
lbl97:
                                // 1 sources

                                var9_9.add(var14_21);
                            }
                            var8_8.worked(1);
                            throw var32_41;
                        }
                        if (var15_20.hasChildren()) {
                            var14_21.setEdit((TextEdit)var15_20);
                            for (TextEditGroup var33_39 : var16_18) {
                                var14_21.addTextEditChangeGroup(new TextEditChangeGroup((TextChange)var14_21, var33_39));
                            }
                            var9_9.add(var14_21);
                        }
                        var8_8.worked(1);
                    }
                    catch (IOException var10_11) {
                        var5_5.addFatalError(String.format("XML model IO error: %1$s.", new Object[]{var10_11.getMessage()}));
                        if (var9_9.size() > 0) {
                            return var9_9;
                        }
                        break;
                    }
                    catch (CoreException var10_12) {
                        var5_5.addFatalError(String.format("XML model core error: %1$s.", new Object[]{var10_12.getMessage()}));
                    }
                }
            }
            finally {
                if (var9_9.size() <= 0) break block39;
                return var9_9;
            }
        }
        return null;
    }

    private String quotedAttrValue(String string) {
        if (string.indexOf(34) == -1) {
            return String.valueOf('\"') + string + '\"';
        }
        if (string.indexOf(39) == -1) {
            return String.valueOf('\'') + string + '\'';
        }
        string = string.replace("\"", "&quot;");
        return String.valueOf('\"') + string + '\"';
    }

    private List<Change> computeJavaChanges(ICompilationUnit iCompilationUnit, String string, String string2, RefactoringStatus refactoringStatus, SubMonitor subMonitor) {
        Object object;
        String string3 = null;
        String string4 = null;
        IResource iResource = this.mProject.findMember("AndroidManifest.xml");
        if (iResource == null || iResource.getType() != 1) {
            string4 = "File not found";
        } else {
            try {
                object = AndroidManifestParser.parseForData((IFile)iResource);
                if (object == null) {
                    string4 = "Invalid content";
                } else {
                    string3 = ((AndroidManifestParser)object).getPackage();
                    if (string3 == null) {
                        string4 = "Missing package definition";
                    }
                }
            }
            catch (CoreException coreException) {
                string4 = coreException.getLocalizedMessage();
            }
        }
        if (string4 != null) {
            refactoringStatus.addFatalError(String.format("Failed to parse file %1$s: %2$s.", iResource == null ? "" : iResource.getFullPath(), string4));
            return null;
        }
        object = new ArrayList();
        TextFileChange textFileChange = new TextFileChange(this.getName(), (IFile)iCompilationUnit.getResource());
        textFileChange.setTextType("java");
        ASTParser aSTParser = ASTParser.newParser((int)3);
        aSTParser.setProject(iCompilationUnit.getJavaProject());
        aSTParser.setSource(iCompilationUnit);
        aSTParser.setResolveBindings(true);
        ASTNode aSTNode = aSTParser.createAST((IProgressMonitor)subMonitor.newChild(1));
        if (!(aSTNode instanceof CompilationUnit)) {
            refactoringStatus.addFatalError(String.format("Internal error: ASTNode class %s", aSTNode.getClass()));
            return null;
        }
        ImportRewrite importRewrite = ImportRewrite.create((CompilationUnit)((CompilationUnit)aSTNode), (boolean)true);
        String string5 = String.valueOf(string3) + ".R";
        string5 = importRewrite.addImport(string5);
        AST aST = aSTNode.getAST();
        ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
        ArrayList<TextEditGroup> arrayList = new ArrayList<TextEditGroup>();
        ReplaceStringsVisitor replaceStringsVisitor = new ReplaceStringsVisitor(aST, aSTRewrite, arrayList, string2, string5, string);
        aSTNode.accept((ASTVisitor)replaceStringsVisitor);
        try {
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            TextEdit textEdit = importRewrite.rewriteImports((IProgressMonitor)subMonitor.newChild(1));
            if (textEdit.hasChildren()) {
                multiTextEdit.addChild(textEdit);
            }
            if ((textEdit = aSTRewrite.rewriteAST()).hasChildren()) {
                multiTextEdit.addChild(textEdit);
            }
            if (multiTextEdit.hasChildren()) {
                textFileChange.setEdit((TextEdit)multiTextEdit);
                for (TextEditGroup textEditGroup : arrayList) {
                    textFileChange.addTextEditChangeGroup(new TextEditChangeGroup((TextChange)textFileChange, textEditGroup));
                }
                ((ArrayList)object).add(textFileChange);
            }
            subMonitor.worked(1);
            if (((ArrayList)object).size() > 0) {
                return object;
            }
        }
        catch (CoreException coreException) {
            refactoringStatus.addFatalError(coreException.getMessage());
        }
        return null;
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        try {
            iProgressMonitor.beginTask("Applying changes...", 1);
            CompositeChange compositeChange = new CompositeChange(this.getName(), this.mChanges.toArray(new Change[this.mChanges.size()])){

                public ChangeDescriptor getDescriptor() {
                    String string = String.format("Extracts string '%1$s' into R.string.%2$s", ExtractStringRefactoring.this.mTokenString, ExtractStringRefactoring.this.mXmlStringId);
                    ExtractStringDescriptor extractStringDescriptor = new ExtractStringDescriptor(ExtractStringRefactoring.this.mProject.getName(), string, string, ExtractStringRefactoring.this.createArgumentMap());
                    return new RefactoringChangeDescriptor((RefactoringDescriptor)extractStringDescriptor);
                }
            };
            iProgressMonitor.worked(1);
            CompositeChange compositeChange2 = compositeChange;
            return compositeChange2;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private IResource getTargetXmlResource(String string) {
        IFile iFile = this.mProject.getFile(string);
        return iFile;
    }

    public void setNewStringId(String string) {
        this.mXmlStringId = string;
    }

    public void setNewStringValue(String string) {
        this.mXmlStringValue = string;
    }

    public void setTargetFile(String string) {
        this.mTargetXmlFileWsPath = string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        EDIT_SOURCE,
        SELECT_ID,
        SELECT_NEW_ID;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ReplaceStringsVisitor
    extends ASTVisitor {
        private static final String CLASS_ANDROID_CONTEXT = "android.content.Context";
        private static final String CLASS_JAVA_CHAR_SEQUENCE = "java.lang.CharSequence";
        private static final String CLASS_JAVA_STRING = "java.lang.String";
        private final AST mAst;
        private final ASTRewrite mRewriter;
        private final String mOldString;
        private final String mRQualifier;
        private final String mXmlId;
        private final ArrayList<TextEditGroup> mEditGroups;

        public ReplaceStringsVisitor(AST aST, ASTRewrite aSTRewrite, ArrayList<TextEditGroup> arrayList, String string, String string2, String string3) {
            this.mAst = aST;
            this.mRewriter = aSTRewrite;
            this.mEditGroups = arrayList;
            this.mOldString = string;
            this.mRQualifier = string2;
            this.mXmlId = string3;
        }

        public boolean visit(StringLiteral stringLiteral) {
            if (stringLiteral.getLiteralValue().equals(this.mOldString)) {
                SimpleName simpleName;
                boolean bl = false;
                bl = this.examineVariableDeclaration(stringLiteral) || this.examineMethodInvocation(stringLiteral);
                Name name = this.mAst.newName(String.valueOf(this.mRQualifier) + ".string");
                SimpleName simpleName2 = this.mAst.newSimpleName(this.mXmlId);
                QualifiedName qualifiedName = this.mAst.newQualifiedName(name, simpleName2);
                String string = "Replace string by ID";
                if (bl) {
                    simpleName = this.methodHasContextArgument(stringLiteral);
                    if (simpleName == null && !this.isClassDerivedFromContext(stringLiteral) && (simpleName = this.findContextFieldOrMethod(stringLiteral)) == null) {
                        simpleName = this.mAst.newSimpleName("Context");
                    }
                    MethodInvocation methodInvocation = this.mAst.newMethodInvocation();
                    methodInvocation.setName(this.mAst.newSimpleName("getString"));
                    methodInvocation.setExpression((Expression)simpleName);
                    methodInvocation.arguments().add(qualifiedName);
                    qualifiedName = methodInvocation;
                    string = "Replace string by Context.getString(R.string...)";
                }
                simpleName = new TextEditGroup(string);
                this.mEditGroups.add((TextEditGroup)simpleName);
                this.mRewriter.replace((ASTNode)stringLiteral, (ASTNode)qualifiedName, (TextEditGroup)simpleName);
            }
            return super.visit(stringLiteral);
        }

        private boolean examineVariableDeclaration(StringLiteral stringLiteral) {
            VariableDeclarationFragment variableDeclarationFragment = this.findParentClass((ASTNode)stringLiteral, VariableDeclarationFragment.class);
            if (variableDeclarationFragment != null) {
                ASTNode aSTNode = variableDeclarationFragment.getParent();
                Type type = null;
                if (aSTNode instanceof VariableDeclarationStatement) {
                    type = ((VariableDeclarationStatement)aSTNode).getType();
                } else if (aSTNode instanceof VariableDeclarationExpression) {
                    type = ((VariableDeclarationExpression)aSTNode).getType();
                }
                if (type instanceof SimpleType) {
                    return this.isJavaString(type.resolveBinding());
                }
            }
            return false;
        }

        private boolean examineMethodInvocation(StringLiteral stringLiteral) {
            ClassInstanceCreation classInstanceCreation;
            MethodInvocation methodInvocation = null;
            List list = null;
            IMethodBinding iMethodBinding = null;
            MethodInvocation methodInvocation2 = this.findParentClass((ASTNode)stringLiteral, MethodInvocation.class);
            if (methodInvocation2 != null) {
                methodInvocation = methodInvocation2;
                list = methodInvocation2.arguments();
                iMethodBinding = methodInvocation2.resolveMethodBinding();
            } else {
                classInstanceCreation = this.findParentClass((ASTNode)stringLiteral, ClassInstanceCreation.class);
                if (classInstanceCreation != null) {
                    methodInvocation = classInstanceCreation;
                    list = classInstanceCreation.arguments();
                    iMethodBinding = classInstanceCreation.resolveConstructorBinding();
                }
            }
            if (methodInvocation != null && list != null && iMethodBinding != null) {
                Object object;
                classInstanceCreation = null;
                StringLiteral stringLiteral2 = stringLiteral;
                while (stringLiteral2 != methodInvocation) {
                    Object object2 = stringLiteral2.getParent();
                    if (object2 == methodInvocation) {
                        classInstanceCreation = stringLiteral2;
                        break;
                    }
                    stringLiteral2 = object2;
                }
                if (classInstanceCreation == null) {
                    return false;
                }
                int n = 0;
                for (Object object2 : list) {
                    if (object2 == classInstanceCreation) break;
                    ++n;
                }
                if (n == list.size()) {
                    return false;
                }
                boolean bl = false;
                ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
                if (n < iTypeBindingArray.length) {
                    object = iTypeBindingArray[n];
                    bl = this.isJavaString((ITypeBinding)object);
                }
                if (bl) {
                    object = iMethodBinding.getName();
                    ITypeBinding iTypeBinding = iMethodBinding.getDeclaringClass();
                    IMethodBinding[] iMethodBindingArray = iTypeBinding.getDeclaredMethods();
                    int n2 = iMethodBindingArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        block15: {
                            ITypeBinding[] iTypeBindingArray2;
                            int n4;
                            IMethodBinding iMethodBinding2 = iMethodBindingArray[n3];
                            if (iMethodBinding != iMethodBinding2 && iMethodBinding2.getName().equals(object) && iTypeBindingArray.length == (n4 = (iTypeBindingArray2 = iMethodBinding2.getParameterTypes()).length)) {
                                int n5 = 0;
                                while (n5 < n4) {
                                    ITypeBinding iTypeBinding2;
                                    if (!(n5 == n ? !"int".equals((iTypeBinding2 = iTypeBindingArray2[n5]).getQualifiedName()) : !iTypeBindingArray[n5].equals((Object)iTypeBindingArray2[n5]))) {
                                        ++n5;
                                        continue;
                                    }
                                    break block15;
                                }
                                bl = false;
                                break;
                            }
                        }
                        ++n3;
                    }
                }
                return bl;
            }
            return false;
        }

        private SimpleName methodHasContextArgument(StringLiteral stringLiteral) {
            MethodDeclaration methodDeclaration = this.findParentClass((ASTNode)stringLiteral, MethodDeclaration.class);
            if (methodDeclaration != null) {
                for (Object e : methodDeclaration.parameters()) {
                    SingleVariableDeclaration singleVariableDeclaration;
                    if (!(e instanceof SingleVariableDeclaration) || !this.isAndroidContext((singleVariableDeclaration = (SingleVariableDeclaration)e).getType())) continue;
                    return this.mAst.newSimpleName(singleVariableDeclaration.getName().getIdentifier());
                }
            }
            return null;
        }

        private boolean isClassDerivedFromContext(StringLiteral stringLiteral) {
            TypeDeclaration typeDeclaration = this.findParentClass((ASTNode)stringLiteral, TypeDeclaration.class);
            if (typeDeclaration != null) {
                return this.isAndroidContext(typeDeclaration.getSuperclassType());
            }
            return false;
        }

        private Expression findContextFieldOrMethod(StringLiteral stringLiteral) {
            TypeDeclaration typeDeclaration = this.findParentClass((ASTNode)stringLiteral, TypeDeclaration.class);
            ITypeBinding iTypeBinding = typeDeclaration == null ? null : typeDeclaration.resolveBinding();
            return this.findContextFieldOrMethod(iTypeBinding);
        }

        private Expression findContextFieldOrMethod(ITypeBinding iTypeBinding) {
            TreeMap<Integer, Expression> treeMap = new TreeMap<Integer, Expression>();
            this.findContextCandidates(treeMap, iTypeBinding, 0);
            if (treeMap.size() > 0) {
                Integer n = treeMap.keySet().iterator().next();
                return treeMap.get(n);
            }
            return null;
        }

        private void findContextCandidates(TreeMap<Integer, Expression> treeMap, ITypeBinding iTypeBinding, int n) {
            IMethodBinding iMethodBinding;
            IMethodBinding[] iMethodBindingArray = iTypeBinding.getDeclaredMethods();
            int n2 = iMethodBindingArray.length;
            int n3 = 0;
            while (n3 < n2) {
                iMethodBinding = iMethodBindingArray[n3];
                if ((n == 0 || !Modifier.isPrivate((int)iMethodBinding.getModifiers())) && this.isAndroidContext(iMethodBinding.getReturnType())) {
                    Object object;
                    int n4 = iMethodBinding.getParameterTypes().length;
                    if (n4 == 0) {
                        object = this.mAst.newMethodInvocation();
                        object.setName(this.mAst.newSimpleName(iMethodBinding.getName()));
                        treeMap.put(Integer.MIN_VALUE, (Expression)object);
                        return;
                    }
                    object = 10000 + 1000 * n + n4;
                    if (!treeMap.containsKey(object)) {
                        MethodInvocation methodInvocation = this.mAst.newMethodInvocation();
                        methodInvocation.setName(this.mAst.newSimpleName(iMethodBinding.getName()));
                        treeMap.put((Integer)object, (Expression)methodInvocation);
                    }
                }
                ++n3;
            }
            iMethodBindingArray = iTypeBinding.getDeclaredFields();
            n2 = iMethodBindingArray.length;
            n3 = 0;
            while (n3 < n2) {
                iMethodBinding = iMethodBindingArray[n3];
                if ((n == 0 || !Modifier.isPrivate((int)iMethodBinding.getModifiers())) && this.isAndroidContext(iMethodBinding.getType())) {
                    Integer n5 = n;
                    treeMap.put(n5, (Expression)this.mAst.newSimpleName(iMethodBinding.getName()));
                    break;
                }
                ++n3;
            }
            iTypeBinding = iTypeBinding.getSuperclass();
            if (iTypeBinding != null) {
                this.findContextCandidates(treeMap, iTypeBinding, n + 1);
            }
        }

        private <T extends ASTNode> T findParentClass(ASTNode aSTNode, Class<T> clazz) {
            aSTNode = aSTNode.getParent();
            while (aSTNode != null) {
                if (aSTNode.getClass().equals(clazz)) {
                    return (T)aSTNode;
                }
                aSTNode = aSTNode.getParent();
            }
            return null;
        }

        private boolean isAndroidContext(Type type) {
            if (type != null) {
                return this.isAndroidContext(type.resolveBinding());
            }
            return false;
        }

        private boolean isAndroidContext(ITypeBinding iTypeBinding) {
            while (iTypeBinding != null) {
                if (CLASS_ANDROID_CONTEXT.equals(iTypeBinding.getQualifiedName())) {
                    return true;
                }
                iTypeBinding = iTypeBinding.getSuperclass();
            }
            return false;
        }

        private boolean isJavaString(ITypeBinding iTypeBinding) {
            while (iTypeBinding != null) {
                if (CLASS_JAVA_STRING.equals(iTypeBinding.getQualifiedName()) || CLASS_JAVA_CHAR_SEQUENCE.equals(iTypeBinding.getQualifiedName())) {
                    return true;
                }
                iTypeBinding = iTypeBinding.getSuperclass();
            }
            return false;
        }
    }
}

