/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.preferences;

import com.android.sdkstats.SdkStatsService;
import java.io.IOException;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class UsagePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor mOptInCheckBox;

    public void init(IWorkbench iWorkbench) {
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(768));
        Link link = new Link(composite2, 64);
        GridData gridData = new GridData(768);
        gridData.widthHint = 200;
        link.setLayoutData((Object)gridData);
        link.setText("By choosing to send certain usage statistics to Google, you can help us improve the Android SDK.  These usage statistics let us measure things like active usage of the SDK and let us know things like which versions of the SDK are in use and which tools are the most popular with developers.  This limited data is not associated with personal information about you, is examined on an aggregate basis, and is maintained in accordance with the <a href=\"http://www.google.com/intl/en/privacy.html\">Google Privacy Policy</a>.");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SdkStatsService.openUrl((String)selectionEvent.text);
            }
        });
        this.mOptInCheckBox = new BooleanFieldEditor("pingOptIn", "Send usage statistics to Google.", composite2);
        this.mOptInCheckBox.setPage((DialogPage)this);
        this.mOptInCheckBox.setPreferenceStore((IPreferenceStore)SdkStatsService.getPreferenceStore());
        this.mOptInCheckBox.load();
        return composite2;
    }

    public boolean performCancel() {
        this.mOptInCheckBox.load();
        return super.performCancel();
    }

    protected void performDefaults() {
        this.mOptInCheckBox.loadDefault();
        super.performDefaults();
    }

    public boolean performOk() {
        this.save();
        return super.performOk();
    }

    protected void performApply() {
        this.save();
        super.performApply();
    }

    private void save() {
        try {
            PreferenceStore preferenceStore = SdkStatsService.getPreferenceStore();
            if (preferenceStore != null) {
                preferenceStore.setValue("pingOptIn", this.mOptInCheckBox.getBooleanValue());
                preferenceStore.save();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

