/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.launch;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.launch.AMReceiver;
import com.android.ide.eclipse.adt.internal.launch.DelayedLaunchInfo;
import com.android.ide.eclipse.adt.internal.launch.IAndroidLaunchAction;
import com.android.ide.eclipse.adt.internal.launch.ILaunchController;
import java.io.IOException;

public class ActivityLaunchAction
implements IAndroidLaunchAction {
    private final String mActivity;
    private final ILaunchController mLaunchController;

    public ActivityLaunchAction(String string, ILaunchController iLaunchController) {
        this.mActivity = string;
        this.mLaunchController = iLaunchController;
    }

    public boolean doLaunchAction(DelayedLaunchInfo delayedLaunchInfo, IDevice iDevice) {
        try {
            String string = String.format("Starting activity %1$s on device ", this.mActivity, iDevice);
            AdtPlugin.printToConsole(delayedLaunchInfo.getProject(), string);
            delayedLaunchInfo.incrementAttemptCount();
            iDevice.executeShellCommand("am start" + (delayedLaunchInfo.isDebugMode() ? " -D" : "") + " -n " + delayedLaunchInfo.getPackageName() + "/" + this.mActivity.replaceAll("\\$", "\\\\\\$"), (IShellOutputReceiver)new AMReceiver(delayedLaunchInfo, iDevice, this.mLaunchController));
            return delayedLaunchInfo.isDebugMode();
        }
        catch (IOException iOException) {
            AdtPlugin.printErrorToConsole(delayedLaunchInfo.getProject(), new Object[]{String.format("Launch error: %s", iOException.getMessage())});
            return false;
        }
    }

    public String getLaunchDescription() {
        return String.format("%1$s activity launch", this.mActivity);
    }
}

