/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.uimodel;

import com.android.ide.eclipse.adt.internal.editors.AndroidEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.DescriptorsUtils;
import com.android.ide.eclipse.adt.internal.editors.descriptors.TextAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.ui.SectionHelper;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiTextAttributeNode;
import com.android.ide.eclipse.adt.internal.resources.IResourceRepository;
import com.android.ide.eclipse.adt.internal.resources.ResourceItem;
import com.android.ide.eclipse.adt.internal.resources.ResourceType;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResources;
import com.android.ide.eclipse.adt.internal.resources.manager.ResourceManager;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.ide.eclipse.adt.internal.ui.ReferenceChooserDialog;
import com.android.ide.eclipse.adt.internal.ui.ResourceChooser;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class UiResourceAttributeNode
extends UiTextAttributeNode {
    private ResourceType mType;

    public UiResourceAttributeNode(ResourceType resourceType, AttributeDescriptor attributeDescriptor, UiElementNode uiElementNode) {
        super(attributeDescriptor, uiElementNode);
        this.mType = resourceType;
    }

    public void createUiControl(final Composite composite, IManagedForm iManagedForm) {
        this.setManagedForm(iManagedForm);
        FormToolkit formToolkit = iManagedForm.getToolkit();
        TextAttributeDescriptor textAttributeDescriptor = (TextAttributeDescriptor)this.getDescriptor();
        Label label = formToolkit.createLabel(composite, textAttributeDescriptor.getUiName());
        label.setLayoutData((Object)new TableWrapData(2, 32));
        SectionHelper.addControlTooltip((Control)label, DescriptorsUtils.formatTooltip(textAttributeDescriptor.getTooltip()));
        Composite composite2 = formToolkit.createComposite(composite);
        composite2.setLayoutData((Object)new TableWrapData(256, 32));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        formToolkit.paintBordersFor(composite2);
        final Text text = formToolkit.createText(composite2, this.getCurrentValue());
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 1;
        text.setLayoutData((Object)gridData);
        Button button = formToolkit.createButton(composite2, "Browse...", 8);
        this.setTextWidget(text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = UiResourceAttributeNode.this.showDialog(composite.getShell(), text.getText().trim());
                if (string != null) {
                    text.setText(string);
                }
            }
        });
    }

    public String showDialog(Shell shell, String string) {
        UiElementNode uiElementNode = this.getUiParent();
        AndroidEditor androidEditor = uiElementNode.getEditor();
        IProject iProject = androidEditor.getProject();
        if (iProject != null) {
            ProjectResources projectResources = ResourceManager.getInstance().getProjectResources(iProject);
            if (this.mType != null) {
                AndroidTargetData androidTargetData = androidEditor.getTargetData();
                IResourceRepository iResourceRepository = androidTargetData.getSystemResources();
                ResourceChooser resourceChooser = new ResourceChooser(iProject, this.mType, projectResources, iResourceRepository, shell);
                resourceChooser.setCurrentResource(string);
                if (resourceChooser.open() == 0) {
                    return resourceChooser.getCurrentResource();
                }
            } else {
                ReferenceChooserDialog referenceChooserDialog = new ReferenceChooserDialog(iProject, projectResources, shell);
                referenceChooserDialog.setCurrentResource(string);
                if (referenceChooserDialog.open() == 0) {
                    return referenceChooserDialog.getCurrentResource();
                }
            }
        }
        return null;
    }

    public String[] getPossibleValues(String string) {
        Object object;
        block10: {
            ResourceType resourceType;
            String string2;
            boolean bl;
            IResourceRepository iResourceRepository;
            block9: {
                Object object2;
                iResourceRepository = null;
                bl = false;
                UiElementNode uiElementNode = this.getUiParent();
                AndroidEditor androidEditor = uiElementNode.getEditor();
                if (string == null || string.indexOf("android:") < 0) {
                    object2 = androidEditor.getProject();
                    if (object2 != null) {
                        iResourceRepository = ResourceManager.getInstance().getProjectResources((IProject)object2);
                    }
                } else {
                    object2 = androidEditor.getTargetData();
                    iResourceRepository = ((AndroidTargetData)object2).getSystemResources();
                    bl = true;
                }
                object2 = iResourceRepository != null ? iResourceRepository.getAvailableResourceTypes() : ResourceType.values();
                string2 = null;
                if (string != null && ((Matcher)(object = Pattern.compile(".*?([a-z]+)/.*").matcher(string))).matches()) {
                    string2 = ((Matcher)object).group(1);
                }
                object = new ArrayList();
                if (string2 != null) break block9;
                Object object3 = object2;
                int n = ((Object)object3).length;
                int n2 = 0;
                while (n2 < n) {
                    Object object4 = object3[n2];
                    ((ArrayList)object).add("@" + ((ResourceType)((Object)object4)).getName() + "/");
                    if (object4 == ResourceType.ID) {
                        ((ArrayList)object).add("@+" + ((ResourceType)((Object)object4)).getName() + "/");
                    }
                    ++n2;
                }
                break block10;
            }
            if (iResourceRepository == null || (resourceType = ResourceType.getEnum(string2)) == null) break block10;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('@');
            if (string.indexOf(43) >= 0) {
                stringBuilder.append('+');
            }
            if (bl) {
                stringBuilder.append("android:");
            }
            stringBuilder.append(string2).append('/');
            String string3 = stringBuilder.toString();
            ResourceItem[] resourceItemArray = iResourceRepository.getResources(resourceType);
            int n = resourceItemArray.length;
            int n3 = 0;
            while (n3 < n) {
                ResourceItem resourceItem = resourceItemArray[n3];
                ((ArrayList)object).add(String.valueOf(string3) + resourceItem.getName());
                ++n3;
            }
        }
        return ((ArrayList)object).toArray(new String[((ArrayList)object).size()]);
    }
}

