/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.ui.tree;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.AndroidEditor;
import com.android.ide.eclipse.adt.internal.editors.IconFactory;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.ui.SectionHelper;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.CopyCutAction;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.ICommitXml;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.PasteAction;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.UiActions;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.UiElementDetail;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.UiModelTreeContentProvider;
import com.android.ide.eclipse.adt.internal.editors.ui.tree.UiModelTreeLabelProvider;
import com.android.ide.eclipse.adt.internal.editors.uimodel.IUiUpdateListener;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiDocumentNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UiTreeBlock
extends MasterDetailsBlock
implements ICommitXml {
    private static final int TREE_HEIGHT_HINT = 50;
    AndroidEditor mEditor;
    private UiElementNode mUiRootNode;
    private ElementDescriptor[] mDescriptorFilters;
    private String mTitle;
    private String mDescription;
    private SectionHelper.ManifestSectionPart mMasterPart;
    private TreeViewer mTreeViewer;
    private Button mAddButton;
    private Button mRemoveButton;
    private Button mUpButton;
    private Button mDownButton;
    private IManagedForm mManagedForm;
    private DetailsPart mDetailsPart;
    private Clipboard mClipboard;
    private IUiUpdateListener mUiRefreshListener;
    private IUiUpdateListener mUiEnableListener;
    private UiTreeActions mUiTreeActions;
    private final boolean mAutoCreateRoot;

    public UiTreeBlock(AndroidEditor androidEditor, UiElementNode uiElementNode, boolean bl, ElementDescriptor[] elementDescriptorArray, String string, String string2) {
        this.mEditor = androidEditor;
        this.mUiRootNode = uiElementNode;
        this.mAutoCreateRoot = bl;
        this.mDescriptorFilters = elementDescriptorArray;
        this.mTitle = string;
        this.mDescription = string2;
    }

    AndroidEditor getEditor() {
        return this.mEditor;
    }

    Clipboard getClipboard() {
        return this.mClipboard;
    }

    SectionHelper.ManifestSectionPart getMasterPart() {
        return this.mMasterPart;
    }

    public UiElementNode getRootNode() {
        return this.mUiRootNode;
    }

    protected void createMasterPart(IManagedForm iManagedForm, Composite composite) {
        FormToolkit formToolkit = iManagedForm.getToolkit();
        this.mManagedForm = iManagedForm;
        this.mMasterPart = new SectionHelper.ManifestSectionPart(composite, formToolkit);
        Section section = this.mMasterPart.getSection();
        section.setText(this.mTitle);
        section.setDescription(this.mDescription);
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(1808));
        Composite composite2 = SectionHelper.createGridLayout((Composite)section, formToolkit, 2);
        Tree tree = this.createTreeViewer(formToolkit, composite2, iManagedForm);
        this.createButtons(formToolkit, composite2);
        this.createTreeContextMenu(tree);
        this.createSectionActions(section, formToolkit);
    }

    private void createSectionActions(Section section, FormToolkit formToolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        toolBarManager.removeAll();
        ToolBar toolBar = toolBarManager.createControl((Composite)section);
        section.setTextClient((Control)toolBar);
        ElementDescriptor[] elementDescriptorArray = this.mDescriptorFilters;
        if (elementDescriptorArray == null && this.mUiRootNode != null) {
            elementDescriptorArray = this.mUiRootNode.getDescriptor().getChildren();
        }
        if (elementDescriptorArray != null && elementDescriptorArray.length > 1) {
            ElementDescriptor[] elementDescriptorArray2 = elementDescriptorArray;
            int n = elementDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                ElementDescriptor elementDescriptor = elementDescriptorArray2[n2];
                toolBarManager.add((IAction)new DescriptorFilterAction(elementDescriptor));
                ++n2;
            }
        }
        toolBarManager.add((IAction)new TreeSortAction());
        toolBarManager.update(true);
    }

    private Tree createTreeViewer(FormToolkit formToolkit, Composite composite, final IManagedForm iManagedForm) {
        Tree tree = formToolkit.createTree(composite, 2);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 50;
        gridData.heightHint = 50;
        tree.setLayoutData((Object)gridData);
        this.mTreeViewer = new TreeViewer(tree);
        this.mTreeViewer.setContentProvider((IContentProvider)new UiModelTreeContentProvider(this.mUiRootNode, this.mDescriptorFilters));
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)new UiModelTreeLabelProvider());
        this.mTreeViewer.setInput((Object)"unused");
        this.mTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                iManagedForm.fireSelectionChanged((IFormPart)UiTreeBlock.this.mMasterPart, selectionChangedEvent.getSelection());
                UiTreeBlock.this.adjustTreeButtons(selectionChangedEvent.getSelection());
            }
        });
        this.mUiRefreshListener = new IUiUpdateListener(){

            public void uiElementNodeUpdated(UiElementNode uiElementNode, IUiUpdateListener.UiUpdateState uiUpdateState) {
                UiTreeBlock.this.mTreeViewer.refresh();
            }
        };
        this.mUiEnableListener = new IUiUpdateListener(){

            public void uiElementNodeUpdated(UiElementNode uiElementNode, IUiUpdateListener.UiUpdateState uiUpdateState) {
                Section section;
                boolean bl;
                boolean bl2 = bl = UiTreeBlock.this.mAutoCreateRoot || uiElementNode.getXmlNode() != null;
                if (UiTreeBlock.this.mMasterPart != null && (section = UiTreeBlock.this.mMasterPart.getSection()).getEnabled() != bl) {
                    section.setEnabled(bl);
                    Control[] controlArray = section.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        control.setEnabled(bl);
                        ++n2;
                    }
                }
            }
        };
        final Sdk.ITargetChangeListener iTargetChangeListener = new Sdk.ITargetChangeListener(){

            public void onProjectTargetChange(IProject iProject) {
                if (iProject == UiTreeBlock.this.mEditor.getProject()) {
                    this.onTargetsLoaded();
                }
            }

            public void onTargetsLoaded() {
                if (UiTreeBlock.this.mDetailsPart != null) {
                    int n = UiTreeBlock.this.mDetailsPart.getPageLimit();
                    UiTreeBlock.this.mDetailsPart.setPageLimit(0);
                    UiTreeBlock.this.mDetailsPart.setPageLimit(n);
                }
                UiTreeBlock.this.mTreeViewer.refresh();
            }
        };
        this.changeRootAndDescriptors(this.mUiRootNode, this.mDescriptorFilters, false);
        AdtPlugin.getDefault().addTargetListener(iTargetChangeListener);
        tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                UiElementNode uiElementNode = UiTreeBlock.this.mUiRootNode.getUiParent() != null ? UiTreeBlock.this.mUiRootNode.getUiParent() : UiTreeBlock.this.mUiRootNode;
                uiElementNode.removeUpdateListener(UiTreeBlock.this.mUiRefreshListener);
                UiTreeBlock.this.mUiRootNode.removeUpdateListener(UiTreeBlock.this.mUiEnableListener);
                AdtPlugin.getDefault().removeTargetListener(iTargetChangeListener);
                if (UiTreeBlock.this.mClipboard != null) {
                    UiTreeBlock.this.mClipboard.dispose();
                    UiTreeBlock.this.mClipboard = null;
                }
            }
        });
        this.mClipboard = new Clipboard(tree.getDisplay());
        return tree;
    }

    public void changeRootAndDescriptors(UiElementNode uiElementNode, ElementDescriptor[] elementDescriptorArray, boolean bl) {
        UiElementNode uiElementNode2;
        if (this.mUiRootNode != null) {
            uiElementNode2 = this.mUiRootNode.getUiParent() != null ? this.mUiRootNode.getUiParent() : this.mUiRootNode;
            uiElementNode2.removeUpdateListener(this.mUiRefreshListener);
            this.mUiRootNode.removeUpdateListener(this.mUiEnableListener);
        }
        this.mUiRootNode = uiElementNode;
        this.mDescriptorFilters = elementDescriptorArray;
        this.mTreeViewer.setContentProvider((IContentProvider)new UiModelTreeContentProvider(this.mUiRootNode, this.mDescriptorFilters));
        uiElementNode2 = this.mUiRootNode.getUiParent() != null ? this.mUiRootNode.getUiParent() : this.mUiRootNode;
        uiElementNode2.addUpdateListener(this.mUiRefreshListener);
        this.mUiRootNode.addUpdateListener(this.mUiEnableListener);
        this.mUiEnableListener.uiElementNodeUpdated(this.mUiRootNode, null);
        if (bl) {
            this.mTreeViewer.refresh();
        }
        this.createSectionActions(this.mMasterPart.getSection(), this.mManagedForm.getToolkit());
    }

    private void createButtons(FormToolkit formToolkit, Composite composite) {
        this.mUiTreeActions = new UiTreeActions();
        Composite composite2 = SectionHelper.createGridLayout(composite, formToolkit, 1);
        composite2.setLayoutData((Object)new GridData(2));
        this.mAddButton = formToolkit.createButton(composite2, "Add...", 8);
        SectionHelper.addControlTooltip((Control)this.mAddButton, "Adds a new element.");
        this.mAddButton.setLayoutData((Object)new GridData(770));
        this.mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                UiTreeBlock.this.doTreeAdd();
            }
        });
        this.mRemoveButton = formToolkit.createButton(composite2, "Remove...", 8);
        SectionHelper.addControlTooltip((Control)this.mRemoveButton, "Removes an existing selected element.");
        this.mRemoveButton.setLayoutData((Object)new GridData(768));
        this.mRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                UiTreeBlock.this.doTreeRemove();
            }
        });
        this.mUpButton = formToolkit.createButton(composite2, "Up", 8);
        SectionHelper.addControlTooltip((Control)this.mRemoveButton, "Moves the selected element up.");
        this.mUpButton.setLayoutData((Object)new GridData(768));
        this.mUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                UiTreeBlock.this.doTreeUp();
            }
        });
        this.mDownButton = formToolkit.createButton(composite2, "Down", 8);
        SectionHelper.addControlTooltip((Control)this.mRemoveButton, "Moves the selected element down.");
        this.mDownButton.setLayoutData((Object)new GridData(768));
        this.mDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                UiTreeBlock.this.doTreeDown();
            }
        });
        this.adjustTreeButtons((ISelection)TreeSelection.EMPTY);
    }

    private void createTreeContextMenu(Tree tree) {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                ISelection iSelection = UiTreeBlock.this.mTreeViewer.getSelection();
                if (!iSelection.isEmpty() && iSelection instanceof ITreeSelection) {
                    ArrayList arrayList = UiTreeBlock.this.filterSelection((ITreeSelection)iSelection);
                    UiTreeBlock.this.doCreateMenuAction(iMenuManager, arrayList);
                    return;
                }
                UiTreeBlock.this.doCreateMenuAction(iMenuManager, null);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)tree);
        tree.setMenu(menu);
    }

    private void doCreateMenuAction(IMenuManager iMenuManager, ArrayList<UiElementNode> arrayList) {
        if (arrayList != null) {
            boolean bl = false;
            for (UiElementNode uiElementNode : arrayList) {
                if (uiElementNode.getXmlNode() == null) continue;
                bl = true;
                break;
            }
            if (bl) {
                UiElementNode uiElementNode;
                iMenuManager.add((IAction)new CopyCutAction(this.getEditor(), this.getClipboard(), null, arrayList, true));
                iMenuManager.add((IAction)new CopyCutAction(this.getEditor(), this.getClipboard(), null, arrayList, false));
                if (arrayList.size() <= 1 && ((uiElementNode = arrayList.get(0).getUiRoot()).getDescriptor().hasChildren() || !(uiElementNode.getUiParent() instanceof UiDocumentNode))) {
                    iMenuManager.add((IAction)new PasteAction(this.getEditor(), this.getClipboard(), arrayList.get(0)));
                }
                iMenuManager.add((IContributionItem)new Separator());
            }
        }
        IconFactory iconFactory = IconFactory.getInstance();
        if (arrayList == null || arrayList.size() <= 1) {
            iMenuManager.add((IAction)new Action("Add...", iconFactory.getImageDescriptor("add")){

                public void run() {
                    super.run();
                    UiTreeBlock.this.doTreeAdd();
                }
            });
        }
        if (arrayList != null) {
            if (arrayList != null) {
                iMenuManager.add((IAction)new Action("Remove", iconFactory.getImageDescriptor("delete")){

                    public void run() {
                        super.run();
                        UiTreeBlock.this.doTreeRemove();
                    }
                });
            }
            iMenuManager.add((IContributionItem)new Separator());
            iMenuManager.add((IAction)new Action("Up", iconFactory.getImageDescriptor("up")){

                public void run() {
                    super.run();
                    UiTreeBlock.this.doTreeUp();
                }
            });
            iMenuManager.add((IAction)new Action("Down", iconFactory.getImageDescriptor("down")){

                public void run() {
                    super.run();
                    UiTreeBlock.this.doTreeDown();
                }
            });
        }
    }

    private void adjustTreeButtons(ISelection iSelection) {
        this.mRemoveButton.setEnabled(!iSelection.isEmpty() && iSelection instanceof ITreeSelection);
        this.mUpButton.setEnabled(!iSelection.isEmpty() && iSelection instanceof ITreeSelection);
        this.mDownButton.setEnabled(!iSelection.isEmpty() && iSelection instanceof ITreeSelection);
    }

    private ArrayList<UiElementNode> filterSelection(ITreeSelection iTreeSelection) {
        ArrayList<UiElementNode> arrayList = new ArrayList<UiElementNode>();
        for (Object e : iTreeSelection) {
            if (!(e instanceof UiElementNode)) continue;
            arrayList.add((UiElementNode)e);
        }
        return arrayList.size() > 0 ? arrayList : null;
    }

    private void doTreeAdd() {
        ITreeSelection iTreeSelection;
        Object object;
        UiElementNode uiElementNode = this.mUiRootNode;
        ISelection iSelection = this.mTreeViewer.getSelection();
        if (!iSelection.isEmpty() && iSelection instanceof ITreeSelection && (object = (iTreeSelection = (ITreeSelection)iSelection).getFirstElement()) != null && object instanceof UiElementNode) {
            uiElementNode = (UiElementNode)object;
        }
        this.mUiTreeActions.doAdd(uiElementNode, this.mDescriptorFilters, this.mTreeViewer.getControl().getShell(), (ILabelProvider)this.mTreeViewer.getLabelProvider());
    }

    protected void doTreeRemove() {
        ISelection iSelection = this.mTreeViewer.getSelection();
        if (!iSelection.isEmpty() && iSelection instanceof ITreeSelection) {
            ArrayList<UiElementNode> arrayList = this.filterSelection((ITreeSelection)iSelection);
            this.mUiTreeActions.doRemove(arrayList, this.mTreeViewer.getControl().getShell());
        }
    }

    protected void doTreeUp() {
        ISelection iSelection = this.mTreeViewer.getSelection();
        if (!iSelection.isEmpty() && iSelection instanceof ITreeSelection) {
            ArrayList<UiElementNode> arrayList = this.filterSelection((ITreeSelection)iSelection);
            this.mUiTreeActions.doUp(arrayList);
        }
    }

    protected void doTreeDown() {
        ISelection iSelection = this.mTreeViewer.getSelection();
        if (!iSelection.isEmpty() && iSelection instanceof ITreeSelection) {
            ArrayList<UiElementNode> arrayList = this.filterSelection((ITreeSelection)iSelection);
            this.mUiTreeActions.doDown(arrayList);
        }
    }

    void commitManagedForm() {
        if (this.mManagedForm != null) {
            this.mManagedForm.commit(false);
        }
    }

    @Override
    public void commitPendingXmlChanges() {
        this.commitManagedForm();
    }

    protected void createToolBarActions(IManagedForm iManagedForm) {
    }

    protected void registerPages(DetailsPart detailsPart) {
        this.mDetailsPart = detailsPart;
        detailsPart.setPageLimit(5);
        final UiTreeBlock uiTreeBlock = this;
        detailsPart.setPageProvider(new IDetailsPageProvider(){

            public IDetailsPage getPage(Object object) {
                if (object instanceof UiElementNode) {
                    return new UiElementDetail(uiTreeBlock);
                }
                return null;
            }

            public Object getPageKey(Object object) {
                return object;
            }
        });
    }

    private class DescriptorFilterAction
    extends Action {
        private final ElementDescriptor mDescriptor;
        private ViewerFilter mFilter;

        public DescriptorFilterAction(ElementDescriptor elementDescriptor) {
            super(String.format("Displays only %1$s elements.", elementDescriptor.getUiName()), 2);
            this.mDescriptor = elementDescriptor;
            this.setImageDescriptor(elementDescriptor.getImageDescriptor());
        }

        public void run() {
            super.run();
            if (this.isChecked()) {
                if (this.mFilter == null) {
                    this.mFilter = new DescriptorFilter(this);
                }
                UiTreeBlock.this.mTreeViewer.addFilter(this.mFilter);
                ViewerFilter[] viewerFilterArray = UiTreeBlock.this.mTreeViewer.getFilters();
                int n = viewerFilterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ViewerFilter viewerFilter = viewerFilterArray[n2];
                    if (viewerFilter instanceof DescriptorFilter && viewerFilter != this.mFilter) {
                        DescriptorFilterAction descriptorFilterAction = ((DescriptorFilter)viewerFilter).getAction();
                        descriptorFilterAction.setChecked(false);
                        UiTreeBlock.this.mTreeViewer.removeFilter(viewerFilter);
                    }
                    ++n2;
                }
            } else if (this.mFilter != null) {
                UiTreeBlock.this.mTreeViewer.removeFilter(this.mFilter);
            }
        }

        private class DescriptorFilter
        extends ViewerFilter {
            private final DescriptorFilterAction mAction;

            public DescriptorFilter(DescriptorFilterAction descriptorFilterAction2) {
                this.mAction = descriptorFilterAction2;
            }

            public DescriptorFilterAction getAction() {
                return this.mAction;
            }

            public boolean select(Viewer viewer, Object object, Object object2) {
                while (object2 instanceof UiElementNode) {
                    UiElementNode uiElementNode = (UiElementNode)object2;
                    if (uiElementNode.getDescriptor() == DescriptorFilterAction.this.mDescriptor) {
                        return true;
                    }
                    object2 = uiElementNode.getUiParent();
                }
                return false;
            }
        }
    }

    private class TreeSortAction
    extends Action {
        private ViewerComparator mComparator;

        public TreeSortAction() {
            super("Sorts elements alphabetically.", 2);
            this.setImageDescriptor(IconFactory.getInstance().getImageDescriptor("az_sort"));
            if (UiTreeBlock.this.mTreeViewer != null) {
                boolean bl = UiTreeBlock.this.mTreeViewer.getComparator() != null;
                this.setChecked(bl);
            }
        }

        public void run() {
            if (UiTreeBlock.this.mTreeViewer == null) {
                this.notifyResult(false);
                return;
            }
            ViewerComparator viewerComparator = UiTreeBlock.this.mTreeViewer.getComparator();
            if (viewerComparator != null) {
                this.mComparator = viewerComparator;
                UiTreeBlock.this.mTreeViewer.setComparator(null);
            } else {
                if (this.mComparator == null) {
                    this.mComparator = new ViewerComparator();
                }
                UiTreeBlock.this.mTreeViewer.setComparator(this.mComparator);
            }
            this.notifyResult(true);
        }
    }

    private class UiTreeActions
    extends UiActions {
        private UiTreeActions() {
        }

        protected UiElementNode getRootNode() {
            return UiTreeBlock.this.mUiRootNode;
        }

        protected void selectUiNode(UiElementNode uiElementNode) {
            if (uiElementNode != null) {
                LinkedList<UiElementNode> linkedList = new LinkedList<UiElementNode>();
                UiElementNode uiElementNode2 = uiElementNode;
                while (uiElementNode2 != UiTreeBlock.this.mUiRootNode) {
                    linkedList.add(0, uiElementNode2);
                    uiElementNode2 = uiElementNode2.getUiParent();
                }
                if (linkedList.size() > 0) {
                    UiTreeBlock.this.mTreeViewer.setSelection((ISelection)new TreeSelection(new TreePath(linkedList.toArray())));
                } else {
                    UiTreeBlock.this.mTreeViewer.setSelection(null);
                }
            }
        }

        public void commitPendingXmlChanges() {
            UiTreeBlock.this.commitManagedForm();
        }
    }
}

