/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.menu;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.AndroidEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.ElementDescriptor;
import com.android.ide.eclipse.adt.internal.editors.menu.MenuTreePage;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.sdk.AndroidTargetData;
import com.android.sdklib.xml.AndroidXPathFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MenuEditor
extends AndroidEditor {
    public static final String ID = "com.android.ide.eclipse.editors.menu.MenuEditor";
    private UiElementNode mUiRootNode;

    public UiElementNode getUiRootNode() {
        return this.mUiRootNode;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void createFormPages() {
        try {
            this.addPage((IFormPage)new MenuTreePage(this));
        }
        catch (PartInitException partInitException) {
            AdtPlugin.log(partInitException, "Error creating nested page", new Object[0]);
        }
    }

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        if (iEditorInput instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)iEditorInput;
            IFile iFile = fileEditorInput.getFile();
            this.setPartName(String.format("%1$s", iFile.getName()));
        }
    }

    protected void xmlModelChanged(Document document) {
        this.initUiRootNode(false);
        this.mUiRootNode.setXmlDocument(document);
        if (document != null) {
            ElementDescriptor elementDescriptor = this.mUiRootNode.getDescriptor();
            try {
                XPath xPath = AndroidXPathFactory.newXPath();
                Node node = (Node)xPath.evaluate("/" + elementDescriptor.getXmlName(), document, XPathConstants.NODE);
                if (node == null && elementDescriptor.isMandatory()) {
                    node = this.mUiRootNode.createXmlNode();
                }
                this.mUiRootNode.loadFromXmlNode(node);
            }
            catch (XPathExpressionException xPathExpressionException) {
                AdtPlugin.log(xPathExpressionException, "XPath error when trying to find '%s' element in XML.", elementDescriptor.getXmlName());
            }
        }
        super.xmlModelChanged(document);
    }

    protected void initUiRootNode(boolean bl) {
        if (this.mUiRootNode == null || bl) {
            AndroidTargetData androidTargetData;
            Document document = null;
            if (this.mUiRootNode != null) {
                document = this.mUiRootNode.getXmlDocument();
            }
            ElementDescriptor elementDescriptor = (androidTargetData = this.getTargetData()) == null ? new ElementDescriptor("temp", null) : androidTargetData.getMenuDescriptors().getDescriptor();
            this.mUiRootNode = elementDescriptor.createUiNode();
            this.mUiRootNode.setEditor(this);
            this.onDescriptorsChanged(document);
        }
    }

    private void onDescriptorsChanged(Document document) {
        if (document != null) {
            this.mUiRootNode.loadFromXmlNode(document);
        } else {
            this.mUiRootNode.reloadFromXmlNode(this.mUiRootNode.getXmlNode());
        }
    }
}

