/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.manifest.model;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.editors.AndroidEditor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.AttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.descriptors.TextAttributeDescriptor;
import com.android.ide.eclipse.adt.internal.editors.ui.SectionHelper;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiElementNode;
import com.android.ide.eclipse.adt.internal.editors.uimodel.UiTextAttributeNode;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.OpenNewPackageWizardAction;
import org.eclipse.jdt.ui.actions.ShowInPackageViewAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class UiPackageAttributeNode
extends UiTextAttributeNode {
    public UiPackageAttributeNode(AttributeDescriptor attributeDescriptor, UiElementNode uiElementNode) {
        super(attributeDescriptor, uiElementNode);
    }

    public void createUiControl(Composite composite, IManagedForm iManagedForm) {
        this.setManagedForm(iManagedForm);
        FormToolkit formToolkit = iManagedForm.getToolkit();
        TextAttributeDescriptor textAttributeDescriptor = (TextAttributeDescriptor)this.getDescriptor();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<form><p><a href='unused'>");
        stringBuilder.append(textAttributeDescriptor.getUiName());
        stringBuilder.append("</a></p></form>");
        FormText formText = SectionHelper.createFormText(composite, formToolkit, true, stringBuilder.toString(), true);
        formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                super.linkActivated(hyperlinkEvent);
                UiPackageAttributeNode.this.doLabelClick();
            }
        });
        formText.setLayoutData((Object)new TableWrapData(2, 32));
        SectionHelper.addControlTooltip((Control)formText, textAttributeDescriptor.getTooltip());
        Composite composite2 = formToolkit.createComposite(composite);
        composite2.setLayoutData((Object)new TableWrapData(256, 32));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        formToolkit.paintBordersFor(composite2);
        Text text = formToolkit.createText(composite2, this.getCurrentValue());
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 1;
        text.setLayoutData((Object)gridData);
        this.setTextWidget(text);
        Button button = formToolkit.createButton(composite2, "Browse...", 8);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                UiPackageAttributeNode.this.doBrowseClick();
            }
        });
    }

    protected void onAddValidators(final Text text) {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = text.getText();
                if (string.indexOf(46) < 1) {
                    UiPackageAttributeNode.this.getManagedForm().getMessageManager().addMessage((Object)text, "Package name should contain at least two identifiers.", null, 3, (Control)text);
                } else {
                    UiPackageAttributeNode.this.getManagedForm().getMessageManager().removeMessage((Object)text, (Control)text);
                }
            }
        };
        text.addModifyListener(modifyListener);
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                UiPackageAttributeNode.this.getManagedForm().getMessageManager().removeMessage((Object)text, (Control)text);
            }
        });
        modifyListener.modifyText(null);
    }

    private void doBrowseClick() {
        Text text = this.getTextWidget();
        IProject iProject = this.getProject();
        if (iProject != null) {
            try {
                Object[] objectArray;
                SelectionDialog selectionDialog = JavaUI.createPackageDialog((Shell)text.getShell(), (IJavaProject)JavaCore.create((IProject)iProject), (int)0);
                selectionDialog.setTitle("Select Android Package");
                selectionDialog.setMessage("Select the package for the Android project.");
                SelectionDialog.setDefaultImage((Image)AdtPlugin.getAndroidLogo());
                if (selectionDialog.open() == 0 && (objectArray = selectionDialog.getResult()).length == 1) {
                    this.setPackageTextField((IPackageFragment)objectArray[0]);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private void doLabelClick() {
        String string = this.getTextWidget().getText().trim();
        if (string.length() == 0) {
            this.createNewPackage();
        } else {
            IProject iProject = this.getProject();
            if (iProject == null) {
                AdtPlugin.log(4, "Failed to get project for UiPackageAttribute", new Object[0]);
                return;
            }
            IWorkbenchPartSite iWorkbenchPartSite = this.getUiParent().getEditor().getSite();
            if (iWorkbenchPartSite == null) {
                AdtPlugin.log(4, "Failed to get editor site for UiPackageAttribute", new Object[0]);
                return;
            }
            IPackageFragmentRoot[] iPackageFragmentRootArray = this.getPackageFragmentRoots(iProject);
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n2];
                IPackageFragment iPackageFragment = iPackageFragmentRoot.getPackageFragment(string);
                if (iPackageFragment != null && iPackageFragment.exists()) {
                    ShowInPackageViewAction showInPackageViewAction = new ShowInPackageViewAction((IWorkbenchSite)iWorkbenchPartSite);
                    showInPackageViewAction.run((IJavaElement)iPackageFragment);
                    return;
                }
                ++n2;
            }
        }
    }

    private IProject getProject() {
        UiElementNode uiElementNode = this.getUiParent();
        AndroidEditor androidEditor = uiElementNode.getEditor();
        IEditorInput iEditorInput = androidEditor.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
            return iFile.getProject();
        }
        return null;
    }

    private IPackageFragmentRoot[] getPackageFragmentRoots(IProject iProject) {
        ArrayList<IPackageFragmentRoot> arrayList = new ArrayList<IPackageFragmentRoot>();
        try {
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
            int n = 0;
            while (n < iPackageFragmentRootArray.length) {
                IClasspathEntry iClasspathEntry = iPackageFragmentRootArray[n].getRawClasspathEntry();
                if (iClasspathEntry.getEntryKind() == 3) {
                    arrayList.add(iPackageFragmentRootArray[n]);
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {}
        return arrayList.toArray(new IPackageFragmentRoot[arrayList.size()]);
    }

    private void setPackageTextField(IPackageFragment iPackageFragment) {
        Text text = this.getTextWidget();
        String string = iPackageFragment.getElementName();
        text.setText(string);
    }

    private void createNewPackage() {
        OpenNewPackageWizardAction openNewPackageWizardAction = new OpenNewPackageWizardAction();
        IProject iProject = this.getProject();
        openNewPackageWizardAction.setSelection((IStructuredSelection)new StructuredSelection((Object)iProject));
        openNewPackageWizardAction.run();
        IJavaElement iJavaElement = openNewPackageWizardAction.getCreatedElement();
        if (iJavaElement != null && iJavaElement.exists() && iJavaElement.getElementType() == 4) {
            this.setPackageTextField((IPackageFragment)iJavaElement);
        }
    }

    public String[] getPossibleValues(String string) {
        return null;
    }
}

