/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.editors.layout;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestParser;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectClassLoader;
import com.android.ide.eclipse.adt.internal.resources.manager.ProjectResources;
import com.android.layoutlib.api.IProjectCallback;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectCallback
implements IProjectCallback {
    private final HashMap<String, Class<?>> mLoadedClasses = new HashMap();
    private final IProject mProject;
    private final ClassLoader mParentClassLoader;
    private final ProjectResources mProjectRes;
    private boolean mUsed = false;
    private String mNamespace;

    ProjectCallback(ClassLoader classLoader, ProjectResources projectResources, IProject iProject) {
        this.mParentClassLoader = classLoader;
        this.mProjectRes = projectResources;
        this.mProject = iProject;
    }

    public Object loadView(String string, Class[] classArray, Object[] objectArray) throws ClassNotFoundException, Exception {
        Class<?> clazz = this.mLoadedClasses.get(string);
        if (clazz != null) {
            return this.instantiateClass(clazz, classArray, objectArray);
        }
        ProjectClassLoader projectClassLoader = new ProjectClassLoader(this.mParentClassLoader, this.mProject);
        try {
            clazz = projectClassLoader.loadClass(string);
            if (clazz != null) {
                this.mUsed = true;
                this.mLoadedClasses.put(string, clazz);
                return this.instantiateClass(clazz, classArray, objectArray);
            }
        }
        catch (Error error) {
            AdtPlugin.log(error, "ProjectCallback.loadView failed to find class %1$s", string);
        }
        return null;
    }

    public String getNamespace() {
        if (this.mNamespace == null) {
            IFile iFile = AndroidManifestParser.getManifest(this.mProject);
            try {
                AndroidManifestParser androidManifestParser = AndroidManifestParser.parseForData(iFile);
                String string = androidManifestParser.getPackage();
                this.mNamespace = String.format("http://schemas.android.com/apk/res/%1$s", string);
            }
            catch (CoreException coreException) {}
        }
        return this.mNamespace;
    }

    public String[] resolveResourceValue(int n) {
        if (this.mProjectRes != null) {
            return this.mProjectRes.resolveResourceValue(n);
        }
        return null;
    }

    public String resolveResourceValue(int[] nArray) {
        if (this.mProjectRes != null) {
            return this.mProjectRes.resolveResourceValue(nArray);
        }
        return null;
    }

    public Integer getResourceValue(String string, String string2) {
        if (this.mProjectRes != null) {
            return this.mProjectRes.getResourceValue(string, string2);
        }
        return null;
    }

    boolean isUsed() {
        return this.mUsed;
    }

    private Object instantiateClass(Class<?> clazz, Class[] classArray, Object[] objectArray) throws Exception {
        Constructor<?> constructor = clazz.getConstructor(classArray);
        constructor.setAccessible(true);
        return constructor.newInstance(objectArray);
    }
}

