/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.newproject;

import com.android.ide.eclipse.adt.AdtPlugin;
import com.android.ide.eclipse.adt.internal.project.AndroidManifestParser;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.internal.wizards.newproject.NewTestProjectCreationPage;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdkuilib.internal.widgets.SdkTargetSelector;
import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class NewProjectCreationPage
extends WizardPage {
    private static final String MAIN_PAGE_NAME = "newAndroidProjectPage";
    private static final String INITIAL_NAME = "";
    private static final boolean INITIAL_CREATE_NEW_PROJECT = true;
    private static final boolean INITIAL_USE_DEFAULT_LOCATION = true;
    private static final boolean INITIAL_CREATE_ACTIVITY = true;
    private static final Pattern sProjectNamePattern = Pattern.compile("^[\\w][\\w. -]*$");
    private static String sCustomLocationOsPath = "";
    private static boolean sAutoComputeCustomLocation = true;
    private final int MSG_NONE = 0;
    private final int MSG_WARNING = 1;
    private final int MSG_ERROR = 2;
    private final MainInfo mInfo = new MainInfo();
    private NewTestProjectCreationPage.TestInfo mTestInfo;
    private String mUserPackageName = "";
    private String mUserActivityName = "";
    private boolean mUserCreateActivityCheck = true;
    private String mSourceFolder = "";
    private Text mProjectNameField;
    private Text mPackageNameField;
    private Text mActivityNameField;
    private Text mApplicationNameField;
    private Button mCreateNewProjectRadio;
    private Button mUseDefaultLocation;
    private Label mLocationLabel;
    private Text mLocationPathField;
    private Button mBrowseButton;
    private Button mCreateActivityCheck;
    private Text mMinSdkVersionField;
    private SdkTargetSelector mSdkTargetSelector;
    private Sdk.ITargetChangeListener mSdkTargetChangeListener;
    private boolean mInternalLocationPathUpdate;
    private boolean mInternalProjectNameUpdate;
    private boolean mInternalApplicationNameUpdate;
    private boolean mInternalCreateActivityUpdate;
    private boolean mInternalActivityNameUpdate;
    private boolean mProjectNameModifiedByUser;
    private boolean mApplicationNameModifiedByUser;
    private boolean mInternalMinSdkVersionUpdate;

    public NewProjectCreationPage() {
        super(MAIN_PAGE_NAME);
        this.setPageComplete(false);
        this.setTitle("New Android Project");
        this.setDescription("Creates a new Android Project resource.");
    }

    public IMainInfo getMainInfo() {
        return this.mInfo;
    }

    public void setTestInfo(NewTestProjectCreationPage.TestInfo testInfo) {
        this.mTestInfo = testInfo;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.mProjectNameField.setFocus();
            this.validatePageComplete();
        }
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        this.initializeDialogUnits((Control)composite);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(composite2);
        this.createLocationGroup(composite2);
        this.createTargetGroup(composite2);
        this.createPropertiesGroup(composite2);
        this.enableLocationWidgets();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite2);
        this.validatePageComplete();
    }

    public void dispose() {
        if (this.mSdkTargetChangeListener != null) {
            AdtPlugin.getDefault().removeTargetListener(this.mSdkTargetChangeListener);
            this.mSdkTargetChangeListener = null;
        }
        super.dispose();
    }

    private final void createProjectNameGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setText("Project name:");
        label.setFont(composite.getFont());
        label.setToolTipText("Name of the Eclipse project to create. It cannot be empty.");
        this.mProjectNameField = new Text(composite2, 2048);
        GridData gridData = new GridData(768);
        this.mProjectNameField.setToolTipText("Name of the Eclipse project to create. It cannot be empty.");
        this.mProjectNameField.setLayoutData((Object)gridData);
        this.mProjectNameField.setFont(composite.getFont());
        this.mProjectNameField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (!NewProjectCreationPage.this.mInternalProjectNameUpdate) {
                    NewProjectCreationPage.this.mProjectNameModifiedByUser = true;
                }
                NewProjectCreationPage.this.updateLocationPathField(null);
            }
        });
    }

    private final void createLocationGroup(Composite composite) {
        Group group = new Group(composite, 16);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        group.setFont(composite.getFont());
        group.setText("Contents");
        this.mCreateNewProjectRadio = new Button((Composite)group, 16);
        this.mCreateNewProjectRadio.setText("Create new project in workspace");
        this.mCreateNewProjectRadio.setSelection(true);
        Button button = new Button((Composite)group, 16);
        button.setText("Create project from existing source");
        button.setSelection(false);
        this.mUseDefaultLocation = new Button((Composite)group, 32);
        this.mUseDefaultLocation.setText("Use default location");
        this.mUseDefaultLocation.setSelection(true);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                NewProjectCreationPage.this.enableLocationWidgets();
                NewProjectCreationPage.this.extractNamesFromAndroidManifest();
                NewProjectCreationPage.this.validatePageComplete();
            }
        };
        this.mCreateNewProjectRadio.addSelectionListener((SelectionListener)selectionAdapter);
        button.addSelectionListener((SelectionListener)selectionAdapter);
        this.mUseDefaultLocation.addSelectionListener((SelectionListener)selectionAdapter);
        Composite composite2 = new Composite((Composite)group, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite2.setLayoutData((Object)new GridData(768));
        composite2.setFont(composite.getFont());
        this.mLocationLabel = new Label(composite2, 0);
        this.mLocationLabel.setText("Location:");
        this.mLocationPathField = new Text(composite2, 2048);
        GridData gridData = new GridData(4, 1, true, false, 1, 1);
        this.mLocationPathField.setLayoutData((Object)gridData);
        this.mLocationPathField.setFont(composite.getFont());
        this.mLocationPathField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewProjectCreationPage.this.onLocationPathFieldModified();
            }
        });
        this.mBrowseButton = new Button(composite2, 8);
        this.mBrowseButton.setText("Browse...");
        this.setButtonLayoutData(this.mBrowseButton);
        this.mBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewProjectCreationPage.this.onOpenDirectoryBrowser();
            }
        });
    }

    private void createTargetGroup(Composite composite) {
        Group group = new Group(composite, 16);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(1808));
        group.setFont(composite.getFont());
        group.setText("Build Target");
        this.mSdkTargetSelector = new SdkTargetSelector((Composite)group, null);
        this.mSdkTargetChangeListener = new Sdk.ITargetChangeListener(){

            public void onProjectTargetChange(IProject iProject) {
            }

            public void onTargetsLoaded() {
                IAndroidTarget[] iAndroidTargetArray = null;
                if (Sdk.getCurrent() != null) {
                    iAndroidTargetArray = Sdk.getCurrent().getTargets();
                }
                NewProjectCreationPage.this.mSdkTargetSelector.setTargets(iAndroidTargetArray);
                if (iAndroidTargetArray != null && iAndroidTargetArray.length == 1) {
                    NewProjectCreationPage.this.mSdkTargetSelector.setSelection(iAndroidTargetArray[0]);
                }
            }
        };
        AdtPlugin.getDefault().addTargetListener(this.mSdkTargetChangeListener);
        this.mSdkTargetChangeListener.onTargetsLoaded();
        this.mSdkTargetSelector.setSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewProjectCreationPage.this.onSdkTargetModified();
                NewProjectCreationPage.this.updateLocationPathField(null);
                NewProjectCreationPage.this.validatePageComplete();
            }
        });
    }

    private final void createPropertiesGroup(Composite composite) {
        Group group = new Group(composite, 16);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        group.setFont(composite.getFont());
        group.setText("Properties");
        Label label = new Label((Composite)group, 0);
        label.setText("Application name:");
        label.setFont(composite.getFont());
        label.setToolTipText("Name of the Application. This is a free string. It can be empty.");
        this.mApplicationNameField = new Text((Composite)group, 2048);
        GridData gridData = new GridData(768);
        this.mApplicationNameField.setToolTipText("Name of the Application. This is a free string. It can be empty.");
        this.mApplicationNameField.setLayoutData((Object)gridData);
        this.mApplicationNameField.setFont(composite.getFont());
        this.mApplicationNameField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (!NewProjectCreationPage.this.mInternalApplicationNameUpdate) {
                    NewProjectCreationPage.this.mApplicationNameModifiedByUser = true;
                }
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Package name:");
        label.setFont(composite.getFont());
        label.setToolTipText("Namespace of the Package to create. This must be a Java namespace with at least two components.");
        this.mPackageNameField = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        this.mPackageNameField.setToolTipText("Namespace of the Package to create. This must be a Java namespace with at least two components.");
        this.mPackageNameField.setLayoutData((Object)gridData);
        this.mPackageNameField.setFont(composite.getFont());
        this.mPackageNameField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewProjectCreationPage.this.onPackageNameFieldModified();
            }
        });
        this.mCreateActivityCheck = new Button((Composite)group, 32);
        this.mCreateActivityCheck.setText("Create Activity:");
        this.mCreateActivityCheck.setToolTipText("Specifies if you want to create a default Activity.");
        this.mCreateActivityCheck.setFont(composite.getFont());
        this.mCreateActivityCheck.setSelection(true);
        this.mCreateActivityCheck.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NewProjectCreationPage.this.onCreateActivityCheckModified();
                NewProjectCreationPage.this.enableLocationWidgets();
            }
        });
        this.mActivityNameField = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        this.mActivityNameField.setToolTipText("Name of the Activity class to create. Must be a valid Java identifier.");
        this.mActivityNameField.setLayoutData((Object)gridData);
        this.mActivityNameField.setFont(composite.getFont());
        this.mActivityNameField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewProjectCreationPage.this.onActivityNameFieldModified();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Min SDK Version:");
        label.setFont(composite.getFont());
        label.setToolTipText("The minimum SDK version number that the application requires. Must be an integer > 0. It can be empty.");
        this.mMinSdkVersionField = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        label.setToolTipText("The minimum SDK version number that the application requires. Must be an integer > 0. It can be empty.");
        this.mMinSdkVersionField.setLayoutData((Object)gridData);
        this.mMinSdkVersionField.setFont(composite.getFont());
        this.mMinSdkVersionField.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewProjectCreationPage.this.onMinSdkVersionFieldModified();
                NewProjectCreationPage.this.validatePageComplete();
            }
        });
    }

    private String getLocationPathFieldValue() {
        return this.mLocationPathField == null ? INITIAL_NAME : this.mLocationPathField.getText().trim();
    }

    private String getProjectLocation() {
        if (this.mInfo.isNewProject() && this.mInfo.useDefaultLocation()) {
            return Platform.getLocation().toString();
        }
        return this.getLocationPathFieldValue();
    }

    private IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.mInfo.getProjectName());
    }

    private void onOpenDirectoryBrowser() {
        File file;
        String string = this.getLocationPathFieldValue();
        if (string.length() == 0) {
            string = null;
        } else {
            file = new File(string);
            if (!file.exists()) {
                string = null;
            }
        }
        file = new DirectoryDialog(this.mLocationPathField.getShell());
        file.setMessage("Browse for folder");
        file.setFilterPath(string);
        String string2 = file.open();
        if (string2 != null) {
            this.updateLocationPathField(string2);
            this.extractNamesFromAndroidManifest();
            this.validatePageComplete();
        }
    }

    private void enableLocationWidgets() {
        boolean bl = this.mInfo.isNewProject();
        boolean bl2 = this.mInfo.useDefaultLocation();
        boolean bl3 = !bl || !bl2;
        boolean bl4 = this.mInfo.isCreateActivity();
        this.mUseDefaultLocation.setEnabled(bl);
        this.mLocationLabel.setEnabled(bl3);
        this.mLocationPathField.setEnabled(bl3);
        this.mBrowseButton.setEnabled(bl3);
        this.mPackageNameField.setEnabled(bl);
        this.mCreateActivityCheck.setEnabled(bl);
        this.mActivityNameField.setEnabled(bl & bl4);
        this.updateLocationPathField(null);
        this.updatePackageAndActivityFields();
    }

    private void updateLocationPathField(String string) {
        boolean bl;
        boolean bl2 = this.mInfo.isNewProject();
        boolean bl3 = this.mInfo.useDefaultLocation();
        boolean bl4 = bl = !bl2 || !bl3;
        if (!this.mInternalLocationPathUpdate) {
            this.mInternalLocationPathUpdate = true;
            if (bl) {
                if (string != null) {
                    sAutoComputeCustomLocation = sAutoComputeCustomLocation && string.equals(sCustomLocationOsPath);
                    sCustomLocationOsPath = TextProcessor.process((String)string);
                } else if (sAutoComputeCustomLocation || !bl2 && !new File(sCustomLocationOsPath).isDirectory()) {
                    IAndroidTarget iAndroidTarget = this.mInfo.getSdkTarget();
                    if (iAndroidTarget != null) {
                        sCustomLocationOsPath = iAndroidTarget.getPath(4);
                    }
                    if (sCustomLocationOsPath == null || sCustomLocationOsPath.length() == 0) {
                        sCustomLocationOsPath = Sdk.getCurrent() != null ? Sdk.getCurrent().getSdkLocation() : File.listRoots()[0].getAbsolutePath();
                    }
                }
                if (!this.mLocationPathField.getText().equals(sCustomLocationOsPath)) {
                    this.mLocationPathField.setText(sCustomLocationOsPath);
                }
            } else {
                String string2 = Platform.getLocation().append(this.mInfo.getProjectName()).toString();
                string2 = TextProcessor.process((String)string2);
                if (!this.mLocationPathField.getText().equals(string2)) {
                    this.mLocationPathField.setText(string2);
                }
            }
            this.validatePageComplete();
            this.mInternalLocationPathUpdate = false;
        }
    }

    private void onLocationPathFieldModified() {
        if (!this.mInternalLocationPathUpdate) {
            String string = this.getLocationPathFieldValue();
            sAutoComputeCustomLocation = sAutoComputeCustomLocation && string.equals(sCustomLocationOsPath);
            sCustomLocationOsPath = string;
            this.extractNamesFromAndroidManifest();
            this.validatePageComplete();
        }
    }

    private void onPackageNameFieldModified() {
        if (this.mInfo.isNewProject()) {
            this.mUserPackageName = this.mInfo.getPackageName();
            this.validatePageComplete();
        }
    }

    private void onCreateActivityCheckModified() {
        if (this.mInfo.isNewProject() && !this.mInternalCreateActivityUpdate) {
            this.mUserCreateActivityCheck = this.mInfo.isCreateActivity();
        }
        this.validatePageComplete();
    }

    private void onActivityNameFieldModified() {
        if (this.mInfo.isNewProject() && !this.mInternalActivityNameUpdate) {
            this.mUserActivityName = this.mInfo.getActivityName();
            this.validatePageComplete();
        }
    }

    private void onMinSdkVersionFieldModified() {
        if (this.mInternalMinSdkVersionUpdate) {
            return;
        }
        String string = this.mInfo.getMinSdkVersion();
        IAndroidTarget iAndroidTarget = this.mInfo.getSdkTarget();
        if (iAndroidTarget != null && iAndroidTarget.getVersion().equals((Object)string)) {
            return;
        }
        IAndroidTarget[] iAndroidTargetArray = this.mSdkTargetSelector.getTargets();
        int n = iAndroidTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAndroidTarget iAndroidTarget2 = iAndroidTargetArray[n2];
            if (iAndroidTarget2.getVersion().equals((Object)string)) {
                this.mSdkTargetSelector.setSelection(iAndroidTarget2);
                break;
            }
            ++n2;
        }
    }

    private void onSdkTargetModified() {
        IAndroidTarget iAndroidTarget = this.mInfo.getSdkTarget();
        if (iAndroidTarget != null) {
            this.mInternalMinSdkVersionUpdate = true;
            this.mMinSdkVersionField.setText(iAndroidTarget.getVersion().getApiString());
            this.mInternalMinSdkVersionUpdate = false;
        }
    }

    private void updatePackageAndActivityFields() {
        if (this.mInfo.isNewProject()) {
            if (this.mUserPackageName.length() > 0 && !this.mPackageNameField.getText().equals(this.mUserPackageName)) {
                this.mPackageNameField.setText(this.mUserPackageName);
            }
            if (this.mUserActivityName.length() > 0 && !this.mActivityNameField.getText().equals(this.mUserActivityName)) {
                this.mInternalActivityNameUpdate = true;
                this.mActivityNameField.setText(this.mUserActivityName);
                this.mInternalActivityNameUpdate = false;
            }
            if (this.mUserCreateActivityCheck != this.mCreateActivityCheck.getSelection()) {
                this.mInternalCreateActivityUpdate = true;
                this.mCreateActivityCheck.setSelection(this.mUserCreateActivityCheck);
                this.mInternalCreateActivityUpdate = false;
            }
        }
    }

    private void extractNamesFromAndroidManifest() {
        int n;
        IAndroidTarget[] iAndroidTargetArray;
        String string;
        Object[] objectArray;
        if (this.mInfo.isNewProject()) {
            return;
        }
        String string2 = this.getProjectLocation();
        File file = new File(string2);
        if (!file.isDirectory()) {
            return;
        }
        Path path = new Path(file.getPath());
        String string3 = path.append("AndroidManifest.xml").toOSString();
        AndroidManifestParser androidManifestParser = AndroidManifestParser.parseForData(string3);
        if (androidManifestParser == null) {
            return;
        }
        String string4 = null;
        AndroidManifestParser.Activity activity = null;
        Object object = null;
        String string5 = null;
        try {
            string4 = androidManifestParser.getPackage();
            string5 = androidManifestParser.getApiLevelRequirement();
            activity = androidManifestParser.getLauncherActivity();
            if (activity == null && (objectArray = androidManifestParser.getActivities()) != null && objectArray.length > 0) {
                activity = objectArray[0];
            }
        }
        catch (Exception exception) {}
        if (string4 != null && string4.length() > 0) {
            this.mPackageNameField.setText(string4);
        }
        if (activity != null) {
            object = AndroidManifestParser.extractActivityName(activity.getName(), string4);
        }
        if (object != null && ((String)object).length() > 0) {
            this.mInternalActivityNameUpdate = true;
            this.mInternalCreateActivityUpdate = true;
            this.mActivityNameField.setText((String)object);
            this.mCreateActivityCheck.setSelection(true);
            this.mInternalCreateActivityUpdate = false;
            this.mInternalActivityNameUpdate = false;
            if (((String)object).indexOf(46) != -1) {
                objectArray = ((String)object).split("\\.");
                object = objectArray[objectArray.length - 1];
            }
            if (this.mProjectNameField.getText().length() == 0 || !this.mProjectNameModifiedByUser) {
                this.mInternalProjectNameUpdate = true;
                this.mProjectNameField.setText((String)object);
                this.mInternalProjectNameUpdate = false;
            }
            if (this.mApplicationNameField.getText().length() == 0 || !this.mApplicationNameModifiedByUser) {
                this.mInternalApplicationNameUpdate = true;
                this.mApplicationNameField.setText((String)object);
                this.mInternalApplicationNameUpdate = false;
            }
        } else {
            this.mInternalActivityNameUpdate = true;
            this.mInternalCreateActivityUpdate = true;
            this.mActivityNameField.setText(INITIAL_NAME);
            this.mCreateActivityCheck.setSelection(false);
            this.mInternalCreateActivityUpdate = false;
            this.mInternalActivityNameUpdate = false;
            if (string4 != null && string4.length() > 0) {
                if (this.mApplicationNameField.getText().length() == 0 || !this.mApplicationNameModifiedByUser) {
                    this.mInternalApplicationNameUpdate = true;
                    this.mApplicationNameField.setText(string4);
                    this.mInternalApplicationNameUpdate = false;
                }
                string4 = string4.replace('.', '_');
                if (this.mProjectNameField.getText().length() == 0 || !this.mProjectNameModifiedByUser) {
                    this.mInternalProjectNameUpdate = true;
                    this.mProjectNameField.setText(string4);
                    this.mInternalProjectNameUpdate = false;
                }
            }
        }
        boolean bl = false;
        ProjectProperties projectProperties = ProjectProperties.create((String)string2, null);
        if (projectProperties != null) {
            projectProperties.merge(ProjectProperties.PropertyType.BUILD).merge(ProjectProperties.PropertyType.DEFAULT);
            string = projectProperties.getProperty("target");
            IAndroidTarget iAndroidTarget = Sdk.getCurrent().getTargetFromHashString(string);
            if (iAndroidTarget != null) {
                this.mSdkTargetSelector.setSelection(iAndroidTarget);
                bl = true;
            }
        }
        if (!bl && string5 != null) {
            iAndroidTargetArray = this.mSdkTargetSelector.getTargets();
            n = iAndroidTargetArray.length;
            int n2 = 0;
            while (n2 < n) {
                string = iAndroidTargetArray[n2];
                if (string.getVersion().equals((Object)string5)) {
                    this.mSdkTargetSelector.setSelection((IAndroidTarget)string);
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        if (!bl) {
            iAndroidTargetArray = this.mSdkTargetSelector.getTargets();
            n = iAndroidTargetArray.length;
            int n3 = 0;
            while (n3 < n) {
                string = iAndroidTargetArray[n3];
                if (string2.startsWith(string.getLocation())) {
                    this.mSdkTargetSelector.setSelection((IAndroidTarget)string);
                    bl = true;
                    break;
                }
                ++n3;
            }
        }
        if (!bl) {
            this.mInternalMinSdkVersionUpdate = true;
            if (string5 != null) {
                this.mMinSdkVersionField.setText(string5);
            }
            this.mInternalMinSdkVersionUpdate = false;
        }
    }

    private boolean validatePage() {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        int n = this.validateProjectField(iWorkspace);
        if ((n & 2) == 0) {
            n |= this.validateLocationPath(iWorkspace);
        }
        if ((n & 2) == 0) {
            n |= this.validateSdkTarget();
        }
        if ((n & 2) == 0) {
            n |= this.validatePackageField();
        }
        if ((n & 2) == 0) {
            n |= this.validateActivityField();
        }
        if ((n & 2) == 0) {
            n |= this.validateMinSdkVersionField();
        }
        if ((n & 2) == 0) {
            n |= this.validateSourceFolder();
        }
        if (n == 0) {
            this.setStatus(null, 0);
        }
        return (n & 2) == 0;
    }

    private void validatePageComplete() {
        this.setPageComplete(this.validatePage());
    }

    private int validateProjectField(IWorkspace iWorkspace) {
        String string = this.mInfo.getProjectName();
        if (string.length() == 0) {
            return this.setStatus("Project name must be specified", 2);
        }
        if (!sProjectNamePattern.matcher(string).matches()) {
            return this.setStatus("The project name must start with an alphanumeric characters, followed by one or more alphanumerics, digits, dots, dashes, underscores or spaces.", 2);
        }
        IStatus iStatus = iWorkspace.validateName(string, 4);
        if (!iStatus.isOK()) {
            return this.setStatus(iStatus.getMessage(), 2);
        }
        if (this.getProjectHandle().exists()) {
            return this.setStatus("A project with that name already exists in the workspace", 2);
        }
        if (this.mTestInfo != null && this.mTestInfo.getCreateTestProject() && string.equals(this.mTestInfo.getProjectName())) {
            return this.setStatus("The main project name and the test project name must be different.", 1);
        }
        return 0;
    }

    private int validateLocationPath(IWorkspace iWorkspace) {
        Path path = new Path(this.getProjectLocation());
        if (this.mInfo.isNewProject()) {
            if (!this.mInfo.useDefaultLocation()) {
                String[] stringArray;
                URI uRI = URIUtil.toURI((String)path.toOSString());
                IStatus iStatus = iWorkspace.validateProjectLocationURI(this.getProjectHandle(), uRI);
                if (!iStatus.isOK()) {
                    return this.setStatus(iStatus.getMessage(), 2);
                }
                File file = path.toFile();
                if (file.exists() && !file.isDirectory()) {
                    return this.setStatus("A directory name must be specified.", 2);
                }
                if (file.isDirectory() && (stringArray = file.list()).length != 0) {
                    return this.setStatus("The selected output directory is not empty.", 1);
                }
            } else {
                if (this.getProjectLocation().length() == 0) {
                    return this.setStatus("A directory name must be specified.", 2);
                }
                File file = path.append(this.mInfo.getProjectName()).toFile();
                if (file.exists()) {
                    return this.setStatus(String.format("There is already a file or directory named \"%1$s\" in the selected location.", this.mInfo.getProjectName()), 2);
                }
            }
        } else {
            File file = path.toFile();
            if (!file.isDirectory()) {
                return this.setStatus("An existing directory name must be specified.", 2);
            }
            String string = path.append("AndroidManifest.xml").toOSString();
            File file2 = new File(string);
            if (!file2.isFile()) {
                return this.setStatus(String.format("File %1$s not found in %2$s.", "AndroidManifest.xml", file.getName()), 2);
            }
            AndroidManifestParser androidManifestParser = AndroidManifestParser.parseForData(string);
            if (androidManifestParser == null) {
                return this.setStatus(String.format("File %1$s could not be parsed.", string), 2);
            }
            String string2 = androidManifestParser.getPackage();
            if (string2 == null || string2.length() == 0) {
                return this.setStatus(String.format("No package name defined in %1$s.", string), 2);
            }
            AndroidManifestParser.Activity[] activityArray = androidManifestParser.getActivities();
            if ((activityArray == null || activityArray.length == 0) && this.mInfo.isCreateActivity()) {
                return this.setStatus(String.format("No activity name defined in %1$s.", string), 2);
            }
            if (path.append(".project").toFile().exists()) {
                return this.setStatus("An Eclipse project already exists in this directory. Consider using File > Import > Existing Project instead.", 1);
            }
        }
        return 0;
    }

    private int validateSdkTarget() {
        if (this.mInfo.getSdkTarget() == null) {
            return this.setStatus("An SDK Target must be specified.", 2);
        }
        return 0;
    }

    private int validateMinSdkVersionField() {
        if (this.mInfo.getMinSdkVersion().length() == 0) {
            return 0;
        }
        if (this.mInfo.getSdkTarget() != null && !this.mInfo.getSdkTarget().getVersion().equals((Object)this.mInfo.getMinSdkVersion())) {
            return this.setStatus("The API level for the selected SDK target does not match the Min SDK version.", this.mInfo.getSdkTarget().getVersion().isPreview() ? 2 : 1);
        }
        return 0;
    }

    private int validateActivityField() {
        if (!this.mInfo.isCreateActivity()) {
            return 0;
        }
        String string = this.mInfo.getActivityName();
        if (string.length() == 0) {
            return this.setStatus("Activity name must be specified.", 2);
        }
        String string2 = INITIAL_NAME;
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string2 = string.substring(0, n);
            if (string2.startsWith(".")) {
                string2 = string2.substring(1);
            }
            string = string.substring(n + 1);
        }
        if (string.charAt(0) == '.') {
            string = string.substring(1);
        }
        int n2 = 0;
        IStatus iStatus = JavaConventions.validateTypeVariableName((String)string, (String)"1.5", (String)"1.5");
        if (!iStatus.isOK()) {
            n2 = this.setStatus(iStatus.getMessage(), iStatus.getSeverity() == 4 ? 2 : 1);
        }
        if (n2 != 2 && string2.length() > 0 && !(iStatus = JavaConventions.validatePackageName((String)string2, (String)"1.5", (String)"1.5")).isOK()) {
            n2 = this.setStatus(String.valueOf(iStatus.getMessage()) + " (in the activity name)", iStatus.getSeverity() == 4 ? 2 : 1);
        }
        return n2;
    }

    private int validatePackageField() {
        String string = this.mInfo.getPackageName();
        if (string.length() == 0) {
            return this.setStatus("Package name must be specified.", 2);
        }
        int n = 0;
        IStatus iStatus = JavaConventions.validatePackageName((String)string, (String)"1.5", (String)"1.5");
        if (!iStatus.isOK()) {
            n = this.setStatus(iStatus.getMessage(), iStatus.getSeverity() == 4 ? 2 : 1);
        }
        if (n != 2 && string.indexOf(46) == -1) {
            return this.setStatus("Package name must have at least two identifiers.", 2);
        }
        return n;
    }

    private int validateSourceFolder() {
        File[] fileArray;
        if (this.mInfo.isNewProject() || !this.mInfo.isCreateActivity()) {
            return 0;
        }
        String string = this.mInfo.getActivityName();
        if (string.indexOf(46) == -1) {
            string = String.valueOf(this.mInfo.getPackageName()) + File.separator + string;
        } else if (string.indexOf(46) == 0) {
            string = String.valueOf(this.mInfo.getPackageName()) + string;
        }
        string = String.valueOf(string.replace('.', File.separatorChar)) + ".java";
        String string2 = this.getProjectLocation();
        File file = new File(string2);
        File[] fileArray2 = fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray2[n2];
            Path path = new Path(file2.getAbsolutePath());
            File file3 = path.append(string).toFile();
            if (file3.isFile()) {
                this.mSourceFolder = file2.getName();
                return 0;
            }
            ++n2;
        }
        if (fileArray.length > 0) {
            return this.setStatus(String.format("%1$s can not be found under %2$s.", string, string2), 2);
        }
        return this.setStatus(String.format("No source folders can be found in %1$s.", string2), 2);
    }

    private int setStatus(String string, int n) {
        if (string == null) {
            this.setErrorMessage(null);
            this.setMessage(null);
        } else if (!string.equals(this.getMessage())) {
            this.setMessage(string, n == 1 ? 2 : 3);
        }
        return n;
    }

    public static interface IMainInfo {
        public IPath getLocationPath();

        public String getProjectName();

        public String getPackageName();

        public String getActivityName();

        public String getMinSdkVersion();

        public String getApplicationName();

        public boolean isNewProject();

        public boolean isCreateActivity();

        public boolean useDefaultLocation();

        public String getSourceFolder();

        public IAndroidTarget getSdkTarget();
    }

    public class MainInfo
    implements IMainInfo {
        public IPath getLocationPath() {
            return new Path(NewProjectCreationPage.this.getProjectLocation());
        }

        public String getProjectName() {
            return NewProjectCreationPage.this.mProjectNameField == null ? NewProjectCreationPage.INITIAL_NAME : NewProjectCreationPage.this.mProjectNameField.getText().trim();
        }

        public String getPackageName() {
            return NewProjectCreationPage.this.mPackageNameField == null ? NewProjectCreationPage.INITIAL_NAME : NewProjectCreationPage.this.mPackageNameField.getText().trim();
        }

        public String getActivityName() {
            return NewProjectCreationPage.this.mActivityNameField == null ? NewProjectCreationPage.INITIAL_NAME : NewProjectCreationPage.this.mActivityNameField.getText().trim();
        }

        public String getMinSdkVersion() {
            return NewProjectCreationPage.this.mMinSdkVersionField == null ? NewProjectCreationPage.INITIAL_NAME : NewProjectCreationPage.this.mMinSdkVersionField.getText().trim();
        }

        public String getApplicationName() {
            return NewProjectCreationPage.this.mApplicationNameField == null ? this.getActivityName() : NewProjectCreationPage.this.mApplicationNameField.getText().trim();
        }

        public boolean isNewProject() {
            return NewProjectCreationPage.this.mCreateNewProjectRadio == null ? true : NewProjectCreationPage.this.mCreateNewProjectRadio.getSelection();
        }

        public boolean isCreateActivity() {
            return NewProjectCreationPage.this.mCreateActivityCheck == null ? true : NewProjectCreationPage.this.mCreateActivityCheck.getSelection();
        }

        public boolean useDefaultLocation() {
            return NewProjectCreationPage.this.mUseDefaultLocation == null ? true : NewProjectCreationPage.this.mUseDefaultLocation.getSelection();
        }

        public String getSourceFolder() {
            if (this.isNewProject() || NewProjectCreationPage.this.mSourceFolder == null || NewProjectCreationPage.this.mSourceFolder.length() == 0) {
                return "src";
            }
            return NewProjectCreationPage.this.mSourceFolder;
        }

        public IAndroidTarget getSdkTarget() {
            return NewProjectCreationPage.this.mSdkTargetSelector == null ? null : NewProjectCreationPage.this.mSdkTargetSelector.getSelected();
        }
    }
}

