/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.export;

import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import com.android.ide.eclipse.adt.internal.wizards.export.ExportWizard;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

final class KeystoreSelectionPage
extends ExportWizard.ExportWizardPage {
    private final ExportWizard mWizard;
    private Button mUseExistingKeystore;
    private Button mCreateKeystore;
    private Text mKeystore;
    private Text mKeystorePassword;
    private Label mConfirmLabel;
    private Text mKeystorePassword2;
    private boolean mDisableOnChange = false;

    protected KeystoreSelectionPage(ExportWizard exportWizard, String string) {
        super(string);
        this.mWizard = exportWizard;
        this.setTitle("Keystore selection");
        this.setDescription("");
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout(3, false);
        composite2.setLayout((Layout)gridLayout);
        this.mUseExistingKeystore = new Button(composite2, 16);
        this.mUseExistingKeystore.setText("Use existing keystore");
        GridData gridData = new GridData(768);
        this.mUseExistingKeystore.setLayoutData((Object)gridData);
        gridData.horizontalSpan = 3;
        this.mUseExistingKeystore.setSelection(true);
        this.mCreateKeystore = new Button(composite2, 16);
        this.mCreateKeystore.setText("Create new keystore");
        gridData = new GridData(768);
        this.mCreateKeystore.setLayoutData((Object)gridData);
        gridData.horizontalSpan = 3;
        new Label(composite2, 0).setText("Location:");
        this.mKeystore = new Text(composite2, 2048);
        gridData = new GridData(768);
        this.mKeystore.setLayoutData((Object)gridData);
        final Button button = new Button(composite2, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog;
                if (KeystoreSelectionPage.this.mUseExistingKeystore.getSelection()) {
                    fileDialog = new FileDialog(button.getShell(), 4096);
                    fileDialog.setText("Load Keystore");
                } else {
                    fileDialog = new FileDialog(button.getShell(), 8192);
                    fileDialog.setText("Select Keystore Name");
                }
                String string = fileDialog.open();
                if (string != null) {
                    KeystoreSelectionPage.this.mKeystore.setText(string);
                }
            }
        });
        new Label(composite2, 0).setText("Password:");
        this.mKeystorePassword = new Text(composite2, 0x400800);
        gridData = new GridData(768);
        this.mKeystorePassword.setLayoutData((Object)gridData);
        this.mKeystorePassword.addVerifyListener(sPasswordVerifier);
        gridData = new GridData();
        new Composite(composite2, 0).setLayoutData((Object)gridData);
        gridData.widthHint = 0;
        gridData.heightHint = 0;
        this.mConfirmLabel = new Label(composite2, 0);
        this.mConfirmLabel.setText("Confirm:");
        this.mKeystorePassword2 = new Text(composite2, 0x400800);
        gridData = new GridData(768);
        this.mKeystorePassword2.setLayoutData((Object)gridData);
        this.mKeystorePassword2.addVerifyListener(sPasswordVerifier);
        gridData = new GridData();
        new Composite(composite2, 0).setLayoutData((Object)gridData);
        gridData.widthHint = 0;
        gridData.heightHint = 0;
        this.mKeystorePassword2.setEnabled(false);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite2);
        this.mUseExistingKeystore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = !KeystoreSelectionPage.this.mUseExistingKeystore.getSelection();
                KeystoreSelectionPage.this.mKeystorePassword2.setEnabled(bl);
                KeystoreSelectionPage.this.mConfirmLabel.setEnabled(bl);
                KeystoreSelectionPage.this.mWizard.setKeystoreCreationMode(bl);
                KeystoreSelectionPage.this.onChange();
            }
        });
        this.mKeystore.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                KeystoreSelectionPage.this.mWizard.setKeystore(KeystoreSelectionPage.this.mKeystore.getText().trim());
                KeystoreSelectionPage.this.onChange();
            }
        });
        this.mKeystorePassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                KeystoreSelectionPage.this.mWizard.setKeystorePassword(KeystoreSelectionPage.this.mKeystorePassword.getText());
                KeystoreSelectionPage.this.onChange();
            }
        });
        this.mKeystorePassword2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                KeystoreSelectionPage.this.onChange();
            }
        });
    }

    public IWizardPage getNextPage() {
        if (this.mUseExistingKeystore.getSelection()) {
            return this.mWizard.getKeySelectionPage();
        }
        return this.mWizard.getKeyCreationPage();
    }

    void onShow() {
        if ((this.mProjectDataChanged & 1) != 0) {
            IProject iProject = this.mWizard.getProject();
            this.mDisableOnChange = true;
            String string = ProjectHelper.loadStringProperty((IResource)iProject, "keystore");
            if (string != null) {
                this.mKeystore.setText(string);
            }
            this.mKeystorePassword.setText("");
            this.mKeystorePassword2.setText("");
            this.mDisableOnChange = false;
            this.onChange();
        }
    }

    private void onChange() {
        if (this.mDisableOnChange) {
            return;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        boolean bl = !this.mUseExistingKeystore.getSelection();
        String string = this.mKeystore.getText().trim();
        if (string.length() == 0) {
            this.setErrorMessage("Enter path to keystore.");
            this.setPageComplete(false);
            return;
        }
        Object object = new File(string);
        if (!((File)object).exists()) {
            if (!bl) {
                this.setErrorMessage("Keystore does not exist.");
                this.setPageComplete(false);
                return;
            }
        } else {
            if (((File)object).isDirectory()) {
                this.setErrorMessage("Keystore path is a directory.");
                this.setPageComplete(false);
                return;
            }
            if (((File)object).isFile() && bl) {
                this.setErrorMessage("File already exists.");
                this.setPageComplete(false);
                return;
            }
        }
        if (((String)(object = this.mKeystorePassword.getText())).length() == 0) {
            this.setErrorMessage("Enter keystore password.");
            this.setPageComplete(false);
            return;
        }
        if (bl && ((String)object).length() < 6) {
            this.setErrorMessage("Keystore password is too short - must be at least 6 characters.");
            this.setPageComplete(false);
            return;
        }
        if (bl) {
            if (this.mKeystorePassword2.getText().length() == 0) {
                this.setErrorMessage("Confirm keystore password.");
                this.setPageComplete(false);
                return;
            }
            if (!this.mKeystorePassword.getText().equals(this.mKeystorePassword2.getText())) {
                this.setErrorMessage("Keystore passwords do not match.");
                this.setPageComplete(false);
                return;
            }
        }
        this.setPageComplete(true);
    }
}

