/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.wizards.export;

import com.android.ide.eclipse.adt.internal.project.ProjectHelper;
import com.android.ide.eclipse.adt.internal.sdk.Sdk;
import com.android.ide.eclipse.adt.internal.wizards.export.ExportWizard;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class KeyCheckPage
extends ExportWizard.ExportWizardPage {
    private final ExportWizard mWizard;
    private PrivateKey mPrivateKey;
    private X509Certificate mCertificate;
    private Text mDestination;
    private boolean mFatalSigningError;
    private FormText mDetailText;
    private Map<String, String> mApkConfig;
    private ScrolledComposite mScrolledComposite;
    private String mKeyDetails;
    private String mDestinationDetails;

    protected KeyCheckPage(ExportWizard exportWizard, String string) {
        super(string);
        this.mWizard = exportWizard;
        this.setTitle("Destination and key/certificate checks");
        this.setDescription("");
    }

    public void createControl(Composite composite) {
        this.setErrorMessage(null);
        this.setMessage(null);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.verticalSpacing *= 3;
        composite2.setLayout((Layout)gridLayout);
        new Label(composite2, 0).setText("Destination APK file:");
        this.mDestination = new Text(composite2, 2048);
        GridData gridData = new GridData(768);
        this.mDestination.setLayoutData((Object)gridData);
        this.mDestination.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                KeyCheckPage.this.onDestinationChange(false);
            }
        });
        final Button button = new Button(composite2, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(button.getShell(), 8192);
                fileDialog.setText("Destination file name");
                String string = ProjectHelper.getApkFilename(KeyCheckPage.this.mWizard.getProject(), null);
                fileDialog.setFileName(string);
                String string2 = fileDialog.open();
                if (string2 != null) {
                    KeyCheckPage.this.mDestination.setText(string2);
                }
            }
        });
        this.mScrolledComposite = new ScrolledComposite(composite2, 512);
        gridData = new GridData(1808);
        this.mScrolledComposite.setLayoutData((Object)gridData);
        gridData.horizontalSpan = 3;
        this.mScrolledComposite.setExpandHorizontal(true);
        this.mScrolledComposite.setExpandVertical(true);
        this.mDetailText = new FormText((Composite)this.mScrolledComposite, 0);
        this.mScrolledComposite.setContent((Control)this.mDetailText);
        this.mScrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                KeyCheckPage.this.updateScrolling();
            }
        });
        this.setControl((Control)composite2);
    }

    @Override
    void onShow() {
        Object object;
        Object object2;
        Object object3;
        if ((this.mProjectDataChanged & 1) != 0) {
            object3 = this.mWizard.getProject();
            this.mApkConfig = Sdk.getCurrent().getProjectApkConfigs((IProject)object3);
            object2 = ProjectHelper.loadStringProperty((IResource)object3, "destination");
            object = ProjectHelper.loadStringProperty((IResource)object3, "baseFilename");
            if (object2 != null && object != null) {
                this.mDestination.setText(String.valueOf(object2) + File.separator + (String)object);
            }
        }
        if (this.mProjectDataChanged != 0) {
            this.mFatalSigningError = false;
            this.mWizard.setSigningInfo(null, null);
            this.mPrivateKey = null;
            this.mCertificate = null;
            this.mKeyDetails = null;
            if (this.mWizard.getKeystoreCreationMode() || this.mWizard.getKeyCreationMode()) {
                int n = this.mWizard.getValidity();
                object2 = new StringBuilder(String.format("<p>Certificate expires in %d years.</p>", n));
                if (n < 25) {
                    ((StringBuilder)object2).append("<p>Make sure the certificate is valid for the planned lifetime of the product.</p>");
                    ((StringBuilder)object2).append("<p>If the certificate expires, you will be forced to sign your application with a different one.</p>");
                    ((StringBuilder)object2).append("<p>Applications cannot be upgraded if their certificate changes from one version to another, ");
                    ((StringBuilder)object2).append("forcing a full uninstall/install, which will make the user lose his/her data.</p>");
                    ((StringBuilder)object2).append("<p>Android Market currently requires certificates to be valid until 2033.</p>");
                }
                this.mKeyDetails = ((StringBuilder)object2).toString();
            } else {
                try {
                    object3 = KeyStore.getInstance(KeyStore.getDefaultType());
                    object2 = new FileInputStream(this.mWizard.getKeystore());
                    ((KeyStore)object3).load((InputStream)object2, this.mWizard.getKeystorePassword().toCharArray());
                    ((FileInputStream)object2).close();
                    object = (KeyStore.PrivateKeyEntry)((KeyStore)object3).getEntry(this.mWizard.getKeyAlias(), new KeyStore.PasswordProtection(this.mWizard.getKeyPassword().toCharArray()));
                    if (object != null) {
                        this.mPrivateKey = ((KeyStore.PrivateKeyEntry)object).getPrivateKey();
                        this.mCertificate = (X509Certificate)((KeyStore.PrivateKeyEntry)object).getCertificate();
                    } else {
                        this.setErrorMessage("Unable to find key.");
                        this.setPageComplete(false);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.onException(fileNotFoundException);
                }
                catch (KeyStoreException keyStoreException) {
                    this.onException(keyStoreException);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    this.onException(noSuchAlgorithmException);
                }
                catch (UnrecoverableEntryException unrecoverableEntryException) {
                    this.onException(unrecoverableEntryException);
                }
                catch (CertificateException certificateException) {
                    this.onException(certificateException);
                }
                catch (IOException iOException) {
                    this.onException(iOException);
                }
                if (this.mPrivateKey != null && this.mCertificate != null) {
                    object3 = Calendar.getInstance();
                    ((Calendar)object3).setTime(this.mCertificate.getNotAfter());
                    object2 = Calendar.getInstance();
                    if (((Calendar)object3).before(object2)) {
                        this.mKeyDetails = String.format("<p>Certificate expired on %s</p>", this.mCertificate.getNotAfter().toString());
                        this.mFatalSigningError = true;
                        this.setErrorMessage("Certificate is expired.");
                        this.setPageComplete(false);
                    } else {
                        this.mWizard.setSigningInfo(this.mPrivateKey, this.mCertificate);
                        object = new StringBuilder(String.format("<p>Certificate expires on %s.</p>", this.mCertificate.getNotAfter().toString()));
                        int n = ((Calendar)object3).get(1);
                        int n2 = ((Calendar)object2).get(1);
                        if (n2 + 25 >= n) {
                            if (n == n2) {
                                ((StringBuilder)object).append("<p>The certificate expires this year.</p>");
                            } else {
                                int n3 = n - n2;
                                ((StringBuilder)object).append(String.format("<p>The Certificate expires in %1$s %2$s.</p>", n3, n3 == 1 ? "year" : "years"));
                            }
                            ((StringBuilder)object).append("<p>Make sure the certificate is valid for the planned lifetime of the product.</p>");
                            ((StringBuilder)object).append("<p>If the certificate expires, you will be forced to sign your application with a different one.</p>");
                            ((StringBuilder)object).append("<p>Applications cannot be upgraded if their certificate changes from one version to another, ");
                            ((StringBuilder)object).append("forcing a full uninstall/install, which will make the user lose his/her data.</p>");
                            ((StringBuilder)object).append("<p>Android Market currently requires certificates to be valid until 2033.</p>");
                        }
                        this.mKeyDetails = ((StringBuilder)object).toString();
                    }
                } else {
                    this.mFatalSigningError = true;
                }
            }
        }
        this.onDestinationChange(true);
    }

    private void onDestinationChange(boolean bl) {
        if (!this.mFatalSigningError) {
            this.setErrorMessage(null);
            this.setMessage(null);
            String string = this.mDestination.getText().trim();
            if (string.length() == 0) {
                this.setErrorMessage("Enter destination for the APK file.");
                this.mWizard.resetDestination();
                this.setPageComplete(false);
                return;
            }
            File file = new File(string);
            if (file.isDirectory()) {
                this.setErrorMessage("Destination is a directory.");
                this.mWizard.resetDestination();
                this.setPageComplete(false);
                return;
            }
            File file2 = file.getParentFile();
            if (file2 == null || !file2.isDirectory()) {
                this.setErrorMessage("Not a valid directory.");
                this.mWizard.resetDestination();
                this.setPageComplete(false);
                return;
            }
            Map<String, String[]> map = this.getApkFileMap(file);
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder(String.format("<p>This will create the following files:</p>", new Object[0]));
            Set<Map.Entry<String, String[]>> set = map.entrySet();
            for (Map.Entry<String, String[]> entry : set) {
                String[] stringArray = entry.getValue();
                String string2 = stringArray[1];
                File file3 = new File(file2, string2);
                if (file3.isFile()) {
                    bl2 = true;
                    stringBuilder.append(String.format("<li>%1$s (WARNING: already exists)</li>", string2));
                    continue;
                }
                if (file3.isDirectory()) {
                    this.setErrorMessage(String.format("%1$s is a directory.", string2));
                    this.mWizard.resetDestination();
                    this.setPageComplete(false);
                    return;
                }
                stringBuilder.append(String.format("<li>%1$s</li>", string2));
            }
            this.mDestinationDetails = stringBuilder.toString();
            this.mWizard.setDestination(file2, map);
            this.setPageComplete(true);
            if (bl2) {
                this.setMessage("A destination file already exists.", 2);
            }
            this.updateDetailText();
        } else if (bl) {
            this.updateDetailText();
        }
    }

    private void updateScrolling() {
        if (this.mDetailText != null) {
            Rectangle rectangle = this.mScrolledComposite.getClientArea();
            this.mScrolledComposite.setMinSize(this.mDetailText.computeSize(rectangle.width, -1));
            this.mScrolledComposite.layout();
        }
    }

    private void updateDetailText() {
        StringBuilder stringBuilder = new StringBuilder("<form>");
        if (this.mKeyDetails != null) {
            stringBuilder.append(this.mKeyDetails);
        }
        if (this.mDestinationDetails != null && !this.mFatalSigningError) {
            stringBuilder.append(this.mDestinationDetails);
        }
        stringBuilder.append("</form>");
        this.mDetailText.setText(stringBuilder.toString(), true, true);
        this.mDetailText.getParent().layout();
        this.updateScrolling();
    }

    private Map<String, String[]> getApkFileMap(File file) {
        String string = file.getName();
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        String[] stringArray = new String[]{ProjectHelper.getApkFilename(this.mWizard.getProject(), null), string};
        hashMap.put(null, stringArray);
        if (this.mApkConfig != null && this.mApkConfig.size() > 0) {
            int n = string.lastIndexOf(46);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n);
            Set<Map.Entry<String, String>> set = this.mApkConfig.entrySet();
            for (Map.Entry<String, String> entry : set) {
                stringArray = new String[]{ProjectHelper.getApkFilename(this.mWizard.getProject(), entry.getKey()), String.valueOf(string2) + "-" + entry.getKey() + string3};
                hashMap.put(entry.getKey(), stringArray);
            }
        }
        return hashMap;
    }

    @Override
    protected void onException(Throwable throwable) {
        super.onException(throwable);
        this.mKeyDetails = String.format("ERROR: %1$s", ExportWizard.getExceptionMessage(throwable));
    }
}

