/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.adt.internal.ui;

import com.android.ide.eclipse.adt.internal.refactorings.extractstring.ExtractStringRefactoring;
import com.android.ide.eclipse.adt.internal.refactorings.extractstring.ExtractStringWizard;
import com.android.ide.eclipse.adt.internal.resources.IResourceRepository;
import com.android.ide.eclipse.adt.internal.resources.ResourceItem;
import com.android.ide.eclipse.adt.internal.resources.ResourceType;
import com.android.ide.eclipse.adt.internal.ui.ResourceLabelProvider;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.AbstractElementListSelectionDialog;

public class ResourceChooser
extends AbstractElementListSelectionDialog {
    private Pattern mProjectResourcePattern;
    private ResourceType mResourceType;
    private IResourceRepository mProjectResources;
    private static final boolean SHOW_SYSTEM_RESOURCE = false;
    private Pattern mSystemResourcePattern;
    private IResourceRepository mSystemResources;
    private Button mProjectButton;
    private Button mSystemButton;
    private String mCurrentResource;
    private final IProject mProject;

    public ResourceChooser(IProject iProject, ResourceType resourceType, IResourceRepository iResourceRepository, IResourceRepository iResourceRepository2, Shell shell) {
        super(shell, (ILabelProvider)new ResourceLabelProvider());
        this.mProject = iProject;
        this.mResourceType = resourceType;
        this.mProjectResources = iResourceRepository;
        this.mProjectResourcePattern = Pattern.compile("@" + this.mResourceType.getName() + "/(.+)");
        this.setTitle("Resource Chooser");
        this.setMessage(String.format("Choose a %1$s resource", this.mResourceType.getDisplayName().toLowerCase()));
    }

    public void setCurrentResource(String string) {
        this.mCurrentResource = string;
    }

    public String getCurrentResource() {
        return this.mCurrentResource;
    }

    protected void computeResult() {
        Object[] objectArray = this.getSelectedElements();
        if (objectArray.length == 1 && objectArray[0] instanceof ResourceItem) {
            ResourceItem resourceItem = (ResourceItem)objectArray[0];
            this.mCurrentResource = this.mResourceType.getXmlString(resourceItem, false);
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createMessageArea(composite2);
        this.createButtons(composite2);
        this.createFilterText(composite2);
        this.createFilteredList(composite2);
        this.createNewResButtons(composite2);
        this.setupResourceList();
        this.selectResourceString(this.mCurrentResource);
        return composite2;
    }

    private void createButtons(Composite composite) {
    }

    private void createNewResButtons(Composite composite) {
        Button button = new Button(composite, 0);
        String string = String.format("New %1$s...", this.mResourceType.getDisplayName());
        button.setText(string);
        button.setEnabled(this.mResourceType == ResourceType.STRING);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                super.widgetSelected(selectionEvent);
                if (ResourceChooser.this.mResourceType == ResourceType.STRING) {
                    ResourceChooser.this.createNewString();
                }
            }
        });
    }

    private void createNewString() {
        ExtractStringRefactoring extractStringRefactoring = new ExtractStringRefactoring(this.mProject, true);
        ExtractStringWizard extractStringWizard = new ExtractStringWizard(extractStringRefactoring, this.mProject);
        RefactoringWizardOpenOperation refactoringWizardOpenOperation = new RefactoringWizardOpenOperation((RefactoringWizard)extractStringWizard);
        try {
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            if (refactoringWizardOpenOperation.run(iWorkbench.getDisplay().getActiveShell(), extractStringWizard.getDefaultPageTitle()) == 0) {
                this.setupResourceList();
                this.selectItemName(extractStringRefactoring.getXmlStringId());
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private IResourceRepository getCurrentRepository() {
        IResourceRepository iResourceRepository = this.mProjectResources;
        return iResourceRepository;
    }

    private void setupResourceList() {
        IResourceRepository iResourceRepository = this.getCurrentRepository();
        this.setListElements(iResourceRepository.getResources(this.mResourceType));
    }

    private void selectItemName(String string) {
        ResourceItem[] resourceItemArray;
        if (string == null) {
            return;
        }
        IResourceRepository iResourceRepository = this.getCurrentRepository();
        ResourceItem[] resourceItemArray2 = resourceItemArray = iResourceRepository.getResources(this.mResourceType);
        int n = resourceItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceItem resourceItem = resourceItemArray2[n2];
            if (string.equals(resourceItem.getName())) {
                this.setSelection(new Object[]{resourceItem});
                break;
            }
            ++n2;
        }
    }

    private void selectResourceString(String string) {
        Matcher matcher;
        boolean bl = false;
        String string2 = null;
        if (!bl && string2 == null && (matcher = this.mProjectResourcePattern.matcher(string)).matches()) {
            string2 = matcher.group(1);
        }
        this.setupResourceList();
        if (string2 != null) {
            this.selectItemName(string2);
        }
    }
}

